// Irrigation program 03/06/2016
// program author: Ronald Lewis

// Define the digital I/O pins
int PowerRelay1=6;
int PowerRelay2=7;
int led=13;

// Define the optical sensor analog input
int lightSensor=A0; 
// Storage variable for optical sensor
int SensorValue=0; 

void setup() {
  // Set up the outputs to turn on water valves
  // and set them to off...HIGH is OFF and LOW is ON 
  // HIGH sets up pull up resistor    

  //Only used to set up and read optical sensor
  //Serial.begin(9600);

  //Make the I/O pins outputs    
  pinMode(PowerRelay1, OUTPUT);
  pinMode(PowerRelay2, OUTPUT);

  pinMode(led, OUTPUT);

  digitalWrite(PowerRelay1, HIGH); 
  digitalWrite(PowerRelay2, HIGH);
} // end setup

void loop() {

  SensorValue=analogRead(lightSensor);

  // Night time condition - turn on power
  if(SensorValue < 100 ) {
    digitalWrite(PowerRelay1, LOW); 
    digitalWrite(PowerRelay2, LOW);  
  }

  // Daylight condition - turn off power
  if(SensorValue > 600 ) {
    digitalWrite(PowerRelay1, HIGH); 
    digitalWrite(PowerRelay2, HIGH); 
  } 

  //Only used to set up and read optical sensor
  //Serial.println(SensorValue); 

  //Arduino on board led blinks to show program is running
  digitalWrite(led, HIGH);       
  delay(300);  // time on
  digitalWrite(led, LOW);
  delay(700);  // time off .. program scan delay is 1 second

}  // end loop  

