// Irrigation2 program 07/14/2020
// This is a modification to the first version of this program.
// The first version would turn on both power relays to power up
// the vegetronic boards to both the north and south garden beds.

// The updated version 2 program alternates the power to each vegetronic board
// so that only one garden can be watered at a time. This reduces 
// water consumption and electrical load on the 24VAC valve transformer.
// Power up is alternated each night.
// program author: Ronald Lewis

// Define the digital I/O pins
int PowerRelay1=6;
int PowerRelay2=7;
int led=13;

// Define the optical sensor analog input
int lightSensor=A0; 
// Storage variable for optical sensor
int SensorValue=0; 

// Define the flags  
// On reset of power, will begin with North bed watering.
// and create latching logic for the photo sensor (photosensor_latch)
int TRUE = 1; int FALSE = 0;
bool ON = TRUE;
bool OFF = FALSE;
bool water_North_bed=FALSE; //flag to show or set an event 
bool water_South_bed=FALSE; //flag to show or set an event 
bool night_time_set = FALSE;
bool photosensor_latch  = FALSE;

void setup() {
  // Set up the outputs to turn on water valves
  // and set them to off...HIGH is OFF and LOW is ON 
  // HIGH sets up pull up resistor    

  //Only used to set up and read optical sensor
  Serial.begin(9600);

  //Make the I/O pins outputs    
  pinMode(PowerRelay1, OUTPUT);
  pinMode(PowerRelay2, OUTPUT);

  pinMode(led, OUTPUT);
  // HIGH is OFF and LOW is ON
  digitalWrite(PowerRelay1, HIGH); 
  digitalWrite(PowerRelay2, HIGH);
  // Start system by setting flag for North garden to 1 or ON
int water_North_bed = ON;

   
} // end setup

void loop() {

  SensorValue=analogRead(lightSensor);
  
  //toggle the latch off and water the north garden 
  if(SensorValue > 600 && photosensor_latch == OFF) { water_North_bed = ON; water_South_bed = OFF;}
  if(SensorValue < 100 && photosensor_latch == OFF) { night_time_set = TRUE; }
  if(SensorValue > 600 && night_time_set == TRUE) { photosensor_latch = ON; }
  
  //toggle the latch on and water the south garden
  if(SensorValue > 600 && photosensor_latch == ON) { water_South_bed = ON; water_North_bed = OFF;}
  if(SensorValue < 100 && photosensor_latch == ON) { night_time_set = FALSE; }
  if(SensorValue > 600 && night_time_set == FALSE) { photosensor_latch = OFF; }
  
  // Night time condition - turn on power
  // Water the garden bed set by the corrosponding flag
  if(SensorValue < 100 && water_North_bed == ON) {digitalWrite(PowerRelay1, LOW); digitalWrite(PowerRelay2, HIGH);} 
  if(SensorValue < 100 && water_South_bed == ON) {digitalWrite(PowerRelay2, LOW); digitalWrite(PowerRelay1, HIGH);} 
  
  // Daylight will turn off the two relays, turning off the soil
  // sensors and watering logic boards...HIGH sets the relay to OFF
  if(SensorValue > 600 ) {digitalWrite(PowerRelay1, HIGH); digitalWrite(PowerRelay2, HIGH); 
  
} 

  //Only used to set up and read optical sensor
  Serial.println(SensorValue); 

  //Arduino on board led blinks to show program is running
  digitalWrite(led, HIGH);       
  delay(300);  // time on
  digitalWrite(led, LOW);
  delay(700);  // time off .. program scan delay is 1 second

}  // end loop  
