/* EPA_studyguide.c...written by Ronald Lewis 2009 */
#include <vcstdio.h>
#define SESSIONWINID    101
#define OUTPUTWINID     102
#define EditQuestionWINID      103
#define EXITOBJID       201


/* listbox for subject areas to study */
	VCLBOXITEM Subjects[] =
   {
      " CORE ",NULL,
      " TYPE I QUESTIONS",NULL,
      " TYPE II QUESTIONS",NULL,
      " TYPE III QUESTIONS",NULL,
      NULL,NULL
   };

/* structure to hold a test question */
   struct QuestionStructure {
	  VCCOUNT answer;
	  VCCOUNT subject_number;
	  char Question_text[500];
	  char Explanation[500];
	  char Choice1[500];
	  char Choice2[500];
	  char Choice3[500];
	  char Choice4[500];

	 } Question;


/* ****************************************** */
/* global window pointers */
VCWIN *win, *help;

/* declare a file pointer */
FILE *fp, *qp;

char DATAFILE[] = "epadata "; 

/* declare some constants that cannot be changed */
const TRUE = 1, FALSE = 0;

const OUTP_WIN_WIDTH = 80;

/* declare variables */
VCCOUNT num1=1, record=1, SavedQuestionValue=0, Not_Completed = 1;
/* note that Not_Completed only allows setting of SavedQuestionValue to the
** value of record one time ONLY */
/* this is a pointer to SavedQuestionValue */


VCCOUNT file_error = 0, Total_questions_answered = 0, Total_questions_correct = 0;
VCCOUNT maximum_question_number = 306;
VCFLOAT Total_score = 0;

unsigned long record_length; /* this variable has to be able to hold very large numbers */

VCCOUNT button1 = 0, button2 = 0, button3 = 0, button4 = 0;

/* declare objects */
VCOBJ  *rb1_obj, *rb2_obj, *rb3_obj, *rb4_obj;
VCOBJ  *objQUESTIONTEXT, *objCHOICE1, *objCHOICE2, *objCHOICE3, *objCHOICE4, *objEXPLANATION;
VCOBJ  *objSUBJNUM, *objCORRECTANSWER;
/* end of global declarations */

void main(void)
{
  vcStart(VCCLRSCRN);
  win=vcWinOpenX(12,1,23,79,"",VCWF_VERTSB,30,76,
		 vcStdBorder(),vcColorFromID(1));

  win->id=OUTPUTWINID;

  MainControlForm();

  vcProcessEvents();

  vcEnd();

  clrscr();
}

VCCOUNT RedrawButtons1()
	{
	vcPostMsg(VCOBJDRAW, rb1_obj, 0L,0L,0L);
	vcPostMsg(VCOBJDRAW, rb2_obj, 0L,0L,0L);
	vcPostMsg(VCOBJDRAW, rb3_obj, 0L,0L,0L);
	vcPostMsg(VCOBJDRAW, rb4_obj, 0L,0L,0L);
	vcWinRefresh(win);
	return( VCSUCCESS );
	}

VCCOUNT MainControlForm()
{
  VCWIN *win;
  VCOBJ *obj;

  VCCOUNT Get_a_Question(), ResetScore(), DataExit(), DataInpFilter();
  VCCOUNT ResetChoice(), GetNextQuestion(), GetPrevQuestion(), AuthorInfo();
  VCCOUNT Grade_Question(), EditQuestion(VCOBJ *obj), GetLastQuestion(VCOBJ *obj);
  VCCOUNT GetFirstQuestion (VCOBJ *obj);


  if( (win=vcWinFromID(SESSIONWINID))!=NULL )
    return( vcSendMsg(VCWINSELECT,win,0L,0L,0L));

  win=vcCreateWin(NULL,0,0,11,79," EPA 608 Study Guide "
     ,0L,0,0,vcStdBorder(),vcColorFromID(4),SESSIONWINID,DataInpFilter);
  if( win == NULL )
     vcTerror("Unable to open DataEntry.  Aborting");

/* list box with study items */
  vcAtSay(0,6,"Study Subjects");
  vcListBoxX( win, 1, 1, 23, 3, Subjects, OBJGROUP|VCLB_SCROLLBAR,
    &num1, NULL, "Select the subject to study",
    "DATA_ENTRY", vcColorFromID(0), vcBorderFromID(1));

/* radio button information */
  rb1_obj = vcRadioBtn(2,30, "Choice 1 or A", NULL, OBJGROUP|VCRB_EXECDOWN, &button1);
  rb2_obj = vcRadioBtn(4,30, "Choice 2 or B", NULL, OBJGROUP|VCRB_EXECDOWN, &button2);
  rb3_obj = vcRadioBtn(6,30, "Choice 3 or C", NULL, OBJGROUP|VCRB_EXECDOWN, &button3);
  rb4_obj = vcRadioBtn(8,30, "Choice 4 or D", NULL, OBJGROUP|VCRB_EXECDOWN, &button4);

/* push button information */
 

  vcPushBtnX(win,0,31," Reset Choice ", ResetChoice,OBJGROUP|VCPB_EXECUP,NULL,
	     "Resets choice..select new choice and press Get/Grade","DATA_ENTRY",NULL);

/* when commented out - for use by user */
// button is removed for edit in CD version or completed versions
// of the specific test.
 vcPushBtnX(win,0,52," Edit Data ", EditQuestion,OBJGROUP|VCPB_EXECUP,NULL,
	     "Edit the contents of the current question","DATA_ENTRY",NULL);


  vcPushBtnX(win,0,64," Reset Score ", ResetScore,OBJGROUP|VCPB_EXECUP,NULL,
	     "Press to clear the currently displayed score","DATA_ENTRY",NULL);
  
  vcPushBtnX(win,7, 4," <PREV ", GetPrevQuestion,OBJGROUP|VCPB_EXECUP,NULL,
	     "Get previous question searched by selection in listbox","DATA_ENTRY",NULL);

  vcPushBtnX(win,7, 14," NEXT> ", GetNextQuestion,OBJGROUP|VCPB_EXECUP,NULL,
	     "Get next question searched by selection in listbox","DATA_ENTRY",NULL);

  vcPushBtnX(win,9, 4," < BOF ", GetFirstQuestion,OBJGROUP|VCPB_EXECUP,NULL,
	     "Move to the 1ST record of the data file","DATA_ENTRY",NULL);

  vcPushBtnX(win,9, 14," EOF > ", GetLastQuestion,OBJGROUP|VCPB_EXECUP,NULL,
	     "Move to the LAST record of the data file","DATA_ENTRY",NULL);
    
  vcPushBtnX(win,9,49," Get/Grade Question ", Grade_Question,OBJGROUP|VCPB_EXECUP,NULL,
	     "Retrieves or Grades the currently selected question","DATA_ENTRY",NULL);
  // I hide author info button when edit button is displayed
  //vcPushBtnX(win, 0, 49," Author Info ", AuthorInfo,
  //	       OBJGROUP|VCPB_EXECUP,NULL,
  //	       "Information about the author of this program","DATA_ENTRY",
  //	       NULL);
  
  
  
  obj=vcPushBtnX(win,9,70," Quit  ", DataExit,OBJGROUP|VCPB_EXECUP,NULL,
	     "End the program","DATA_ENTRY",NULL);

  obj->id=EXITOBJID;
  
  vcStatOpen(24,0,24,79,NULL,0,1,NULL);

  /* this function only executes on initial start 
   * and loads structure with items */
  Get_a_Question();
  
  vcStartForm(win,NULL);
  return(VCSUCCESS);
}


VCCOUNT DataInpFilter(VCCOUNT msg, VCVOID *to, VCULONG p1, VCULONG p2, VCULONG p3)
{
  VCWIN *win;
  VCOBJ *obj;
  VCCOUNT key;

 /* ESC Key filter */
  if( msg==KEYPRESS ) {
    key = p1 & 0xffff;
    if( key==VCLK_ABORT ) {
      obj=vcObjFromID( EXITOBJID );
      vcPostMsg(VCGETFOCUS,obj,1,0L,0L);
      return( vcPostMsg(VCDOOBJFUNC,obj,0L,0L,0L) );
      }
    //if mouse events and not to current window
    if( (msg == MOUB1DOWN ) &&
	(vcWinFromVoid(to) != wcurrent) ) {
	return (VCSUCCESS); //eat message
	}
      }
    return( vcDefaultWinFilter(msg, to, p1, p2, p3 ) );
   } /*end DataInpFilter */


VCCOUNT Get_a_Question( VCOBJ *obj )
{
  vcSendMsg( VCENDFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
   file_error = 0;
   if( (record >= 1) && (record <= maximum_question_number) ) {
     SavedQuestionValue = record; Not_Completed = TRUE;
     WriteToWindow(obj->win); }
     
  vcSendMsg( VCSTARTFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
 
  /* this prints the total questions answered stats for the 
   * first time to the main form */
     vcAtSay(1,52, "_______________________" );
     vcAtSay(2, 53, "Questions answered");
     vcAtSayNum(2, 72, &Total_questions_answered,"###",VCOF_INT|VCOF_SYSDFLT);
     /* print the total number of question answered for a session
     ** to the main form */
     vcAtSay(3, 65, "Points");
     vcAtSayNum(3, 72, &Total_questions_correct,"###",VCOF_INT|VCOF_SYSDFLT);
     /* calculate and print the total score */
     vcAtSay(4, 54, "Session Score >>>");
     vcAtSayNum(4, 72, &Total_score,"###",VCOF_FLOAT|VCOF_SYSDFLT);
     vcAtSay(5,52, "_______________________"); 
 
 return(VCSUCCESS);
}


VCCOUNT SearchForward()
 {
	vcAtSay(6, 3, "                        ");
	if(record >= maximum_question_number) { record = maximum_question_number; 
	  vcAtSay(6, 3, "No more questions found!");
	  return(VCSUCCESS); }
	for(  ;  record < maximum_question_number;   ) {
	   record=record + 1;

	   fp = fopen(DATAFILE,"rb"); // use r+b for reading and writing rb for read only
	   /* type casting for large byte values to properly
	      position record for writing and reading */
	   record_length = (unsigned long)record * (unsigned long)sizeof(struct QuestionStructure);
	   fseek(fp, record_length, SEEK_SET);
	   fread(&Question, sizeof(struct QuestionStructure),1,fp);
	   fclose(fp);

	   if( Question.subject_number == num1 ) {
	    vcAtSay(6, 3, "Question     found!");
	    vcAtSayNumX(win, 6, 12, &record, "999", VCOF_INT,
	     vc.brown|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);RedrawButtons1();
	    SavedQuestionValue = record;
	    return(VCSUCCESS); }
	else { if( record == maximum_question_number ) {
	    vcAtSay(6, 3, "No more questions found!");
	    SavedQuestionValue = record;
	    return(VCSUCCESS); } }

       } /* end for statement */
     return(VCSUCCESS);
 }

VCCOUNT SearchBackward()
 {
	vcAtSay(6, 3, "                        ");
	if(record <= 1 ) { record = 1 /* was maximum_question_number */;
	 vcAtSay(6, 3, "No more questions found!");
	 return(VCSUCCESS); }
	
	
	for(  ;  record > 1;   ) {
	   record=record - 1;
	   
	   fp = fopen(DATAFILE,"rb"); // use r+b for reading and writing rb for read only
	    /* type casting for large byte values to properly
	      position record for writing and reading */
	   record_length = (unsigned long)record * (unsigned long)sizeof(struct QuestionStructure);
	   fseek(fp, record_length, SEEK_SET);
	   fread(&Question, sizeof(struct QuestionStructure),1,fp);
	   fclose(fp);

	   if( Question.subject_number == num1 ) {
	    vcAtSay(6, 3, "Question     found!");
	    vcAtSayNumX(win, 6, 12, &record, "999", VCOF_INT,
	     vc.brown|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);RedrawButtons1();
	    SavedQuestionValue = record;
	    return(VCSUCCESS); }
        else { if( record == 1 ) {
	    vcAtSay(6, 3, "No more questions found!");
	    SavedQuestionValue = record;
	    return(VCSUCCESS); } }
       
       } /* end for statement */
     return(VCSUCCESS);
 }

VCCOUNT ResetChoice( VCOBJ *obj )
{
  vcSendMsg( VCENDFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
   button1 = 0; button2 = 0; button3 = 0; button4 = 0;
   RedrawButtons1();
  vcSendMsg( VCSTARTFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
 return(VCSUCCESS);
}



VCCOUNT ResetScore( VCOBJ *obj )
{
  vcSendMsg( VCENDFORM,(VCVOID *)obj->win, 0L, 0L, 0L );

  Total_questions_answered =0;
  Total_questions_correct = 0;
  Total_score = 0;

     /* print the total number of questions answered for a session
     ** to the main form */
     vcAtSay(1,52, "______________________" );
     vcAtSay(2, 53, "Questions answered");
     vcAtSayNum(2, 72, &Total_questions_answered,"###",VCOF_INT|VCOF_SYSDFLT);
     /* print the total number of question answered for a session
     ** to the main form */
     vcAtSay(3, 65, "Points");
     vcAtSayNum(3, 72, &Total_questions_correct,"###",VCOF_INT|VCOF_SYSDFLT);
     /* calculate and print the total score */
     vcAtSay(4, 54, "Session Score >>>");
     vcAtSayNum(4, 72, &Total_score,"###",VCOF_FLOAT|VCOF_SYSDFLT);
     vcAtSay(5,52, "______________________");

     /* do some cleanup items before exiting */
     button1=0; button2 = 0; button3 = 0; button4 = 0;
     RedrawButtons1();
     record = SavedQuestionValue;
  vcSendMsg( VCSTARTFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
 return(VCSUCCESS);
}

VCCOUNT ReadData()
  {

    vcWinErase( win,(vc.bg*vc.black) );
    /* this filter causes the program to send a
     ** missing file message and returns to form.
     ** To create a new data file change next line file mode to "wb"
     ** compile and run once, then change file mode back to "r+b" and
     ** recompile code.  Empty file will still get a "not a valid question" error
     ** but after entering your first question, that will go away. */
    if((fp = fopen(DATAFILE,"rb")) == NULL) {
	   // use r+b for reading and writing rb for read only
       vcWinAtSay(win, 2, 2, "Data file corrupt or missing...or can't run from CD.");
       vcUpdateVIO(); button1=0; button2 = 0; button3 = 0; button4 = 0;
       fclose(fp); return(-1); }

     /* type casting for large byte values to properly
	position record for writing and reading */
     record_length = (unsigned long)record * (unsigned long)sizeof(struct QuestionStructure);
     fseek(fp, record_length, SEEK_SET);

     /* by checking to see if read status is not zero we know that
     ** the record structure for the question exists. reset the
     ** radio buttons and clear the structure to hold the test question */
     if( (fread(&Question, sizeof(struct QuestionStructure),1,fp) ) == 0 ) {

       vcWinErase( win,(vc.bg*vc.black) );
       vcWinAtSay(win, 2, 2, "Not a valid question number!");
       vcWinAtSay(win, 3, 2, "Press the appropriate PREV or NEXT pushbutton");
       vcUpdateVIO(); button1=0; button2 = 0; button3 = 0; button4 = 0;
       strcpy(Question.Question_text, '\0'); strcpy(Question.Explanation, '\0');
       strcpy(Question.Choice1, '\0'); strcpy(Question.Choice2, '\0');
       strcpy(Question.Choice3, '\0'); strcpy(Question.Choice4, '\0');
       Question.answer = 0; Question.subject_number = 0;
       fclose(fp); vcAtSay(6, 6, "                  "); return(-1); }

     fclose(fp);

	 return(VCSUCCESS);
   }

VCCOUNT WriteToWindow()
  {
    
    win=vcWinFromID( OUTPUTWINID );
    vcWinErase( win,(vc.bg*vc.black) );
    PrintQuestion();
    RedrawButtons1();
    win=vcWinFromID( SESSIONWINID );
   /* count the quetions in this section and print to main
   * window before closing it */
   Count_Questions();
   
   return(VCSUCCESS);
  }


VCCOUNT GetNextQuestion( VCOBJ *obj )
{
  vcSendMsg( VCENDFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
   /* save question value to the first record selected
   *  but only do it one time */
   file_error = 0;
   if(Not_Completed==TRUE) {
     SavedQuestionValue = record; Not_Completed = FALSE; }

   if(record > maximum_question_number) {
    NextQuestionError(obj->win);
    RedrawButtons1();
    vcSendMsg( VCSTARTFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
    return(VCSUCCESS); }
    
    vcStatSay("                               Searching...", vc.white|vc.bold|vc.blue*vc.bg);
    SearchForward();

  WriteToWindow(obj->win);

  vcSendMsg( VCSTARTFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
  
 return(VCSUCCESS);
}


VCCOUNT GetLastQuestion( VCOBJ *obj ) /* gets last record in data file */
{
  vcSendMsg( VCENDFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
   /* save question value to the first record selected
   *  but only do it one time */
   file_error = 0;
   if(Not_Completed==TRUE) {
     SavedQuestionValue = maximum_question_number; Not_Completed = FALSE; }

    record = maximum_question_number;
    SearchForward();

  WriteToWindow(obj->win);

  vcSendMsg( VCSTARTFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
 return(VCSUCCESS);
}

VCCOUNT NextQuestionError()
{
    win=vcWinFromID( OUTPUTWINID );
    vcWinErase( win,(vc.bg*vc.black) );
    vcWinAtSay(win, 2, 2, "Can't move forward any further...press the PREV key to continue.");
    vcWinAtSay(win, 3, 2, "Or you may select a different catagory to study.");
    win=vcWinFromID( SESSIONWINID );

 return(VCSUCCESS);
}


VCCOUNT GetPrevQuestion( VCOBJ *obj )
{
  vcSendMsg( VCENDFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
   /* save question value to the first record selected
   *  but only do it one time */
   file_error = 0;
   if(Not_Completed==TRUE) {
     SavedQuestionValue = record; Not_Completed = FALSE; }

   if( record < 1) {
    PrevQuestionError(obj->win);
    RedrawButtons1();
    vcSendMsg( VCSTARTFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
    return(VCSUCCESS); }
    
    vcStatSay("                               Searching...", vc.white|vc.bold|vc.blue*vc.bg);
    SearchBackward();

  WriteToWindow(obj->win);

  vcSendMsg( VCSTARTFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
  
 return(VCSUCCESS);
}

VCCOUNT GetFirstQuestion( VCOBJ *obj ) /* gets first record in data file */
{
  vcSendMsg( VCENDFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
   /* save question value to the first record selected
   *  but only do it one time */
   file_error = 0;
   if(Not_Completed==TRUE) {
     SavedQuestionValue = 0; Not_Completed = FALSE; }

    record = 0;
    SearchBackward();

  WriteToWindow(obj->win);

  vcSendMsg( VCSTARTFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
  
 return(VCSUCCESS);
}


VCCOUNT Count_Questions ()
{
/* structure to tempararily hold a test question */
   struct tmp_QuestionStructure {
	  VCCOUNT answer;
	  VCCOUNT subject_number;
	  char Question_text[500];
	  char Explanation[500];
	  char Choice1[500];
	  char Choice2[500];
	  char Choice3[500];
	  char Choice4[500];

	 } tmp_Question;


/* print the number of questions in this section to the main form */
    int questions_sum = 0, count = 0;
    
    qp = fopen(DATAFILE,"rb"); // r+b for reading and writing rb for read only
    for( count = 0 ;  count < maximum_question_number; count++  ) {
	   /* type casting for large byte values to properly
	      position record for writing and reading */
	   record_length = (unsigned long)count * (unsigned long)sizeof(struct tmp_QuestionStructure);
	   fseek(qp, record_length, SEEK_SET);
	   fread(&tmp_Question, sizeof(struct tmp_QuestionStructure),1,qp);
	   if( tmp_Question.subject_number == num1 ) questions_sum = questions_sum + 1;
	  } /* end for loop */
    fclose(qp);
	/* vcWinAtSay works better than vcAtSay - ensures that sentance 
	 * gets written to window */
	vcWinAtSay(win,6,51, "This section contains");
	vcAtSayNumX(win, 6, 73, &questions_sum, "999", VCOF_INT,
	     vc.brown|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);RedrawButtons1();
	vcWinAtSay(win,7, 51, "questions!");

  return (VCSUCCESS);
  }


VCCOUNT PrevQuestionError()
{
    win=vcWinFromID( OUTPUTWINID );
    vcWinErase( win,(vc.bg*vc.black) );
    vcWinAtSay(win, 2, 2, "Can't move back any further...press any key to continue.");
    vcWinAtSay(win, 3, 2, "Returning to Question 1...Press \"Get\/Grade Question\"");
    win=vcWinFromID( SESSIONWINID );

 return(VCSUCCESS);
}


VCCOUNT get_a_key()
  {
    VCCOUNT key;
      while( ((key=vcGetOne(NULL)) == MOUMOVE)
	|| (key==MOUB1UP) || (key==MOUB1MOVE) );
    return(key);
   }

VCCOUNT DataExit( VCOBJ *obj )
{
  vcPostMsg(VCTERMINATE,obj,0L,0L,0L);
  return(VCSUCCESS);
}


VCCOUNT PrintQuestion()  {
     int row=0, rowtemp=0, buf=0;

     file_error=ReadData();

     /* abort the printing process if error in file read */
     if(file_error == -1)  return(VCSUCCESS);

     vcWinOff(win);
     vcWinAtSay(win, 1, 2, "Question");
     vcAtSayNumX(win, 1, 11, &record, "999", VCOF_INT, vc.white+(vc.bg*vc.black),VCOF_SYSDFLT);

     /* print the question and choices */
     vcWinAtSay(win, 3, 2, Question.Question_text);

     /*calculate the rows required for this text */
     rowtemp = strlen(Question.Question_text) / OUTP_WIN_WIDTH;
     buf=rowtemp;
     if(rowtemp < 1) rowtemp = 1;
     row = buf + rowtemp + 4;

     /* print the question at the proper row */
     vcWinAtSay(win, row, 2, Question.Choice1);

     /*calculate the rows required for this text */
     rowtemp = strlen(Question.Choice1) / OUTP_WIN_WIDTH;
     buf = rowtemp;
     if(rowtemp < 1) rowtemp = 1;
     row = row+buf+rowtemp;
     /* print the question at the proper row */
     vcWinAtSay(win, row, 2, Question.Choice2);

     /*calculate the rows required for this text */
     rowtemp = strlen(Question.Choice2) / OUTP_WIN_WIDTH;
     buf = rowtemp;
     if(rowtemp < 1) rowtemp = 1;
     row = row+buf+rowtemp;

     /* print the question at the proper row */
     vcWinAtSay(win, row, 2, Question.Choice3);

     /*calculate the rows required for this text */
     rowtemp = strlen(Question.Choice3) / OUTP_WIN_WIDTH;
     buf = rowtemp;
     if(rowtemp < 1) rowtemp = 1;
     row = row+buf+rowtemp;

     /* print the question at the proper row */
     vcWinAtSay(win, row, 2, Question.Choice4);

     if( (button1==0) && (button2==0) && (button3==0) && (button4==0) ) {
       /*calculate the rows required for this text */
       rowtemp = strlen(Question.Choice4) / OUTP_WIN_WIDTH;
       buf = rowtemp;
       if(rowtemp < 1) rowtemp = 1;
       row = row+buf+rowtemp;

       vcWinAtSay(win, row+1, 7, "* Click on the corrosponding \"Choice\"");
       vcWinAtSay(win, row+2, 9, "to select your answer - grade by pressing");
       vcWinAtSay(win, row+3, 9, "the \"Get\/Grade Question\" pushbutton.");
       vcWinAtSay(win, row+4, 7, "* You can redraw the question also by selecting");
       vcWinAtSay(win, row+5, 9, "\"Get\/Grade Question\" without selecting any choices."); }

/* move to the top of the window and refresh window */
     vcWinMovePort(win, -14,0);
     vcWinOn(win);
     vcUpdateVIO();

    return(VCSUCCESS);
   }


VCCOUNT Grade_Question( VCOBJ *obj ) {
int AnswerISwrong=FALSE;
  /* clear the search result before ending form */
  vcAtSay(6, 3, "                        ");
  
  vcSendMsg( VCENDFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
     win=vcWinFromID( OUTPUTWINID );

 /* exit function error reading data file */
 if(file_error) {  vcWinErase(win, VCDEFAULT);
     /* don't forget to do some cleanup items before exiting */
     button1=0; button2 = 0; button3 = 0; button4 = 0;
     RedrawButtons1();
     win=vcWinFromID( SESSIONWINID );
     vcSendMsg( VCSTARTFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
     return(VCSUCCESS); }

 /* exit if no choices were made */
 if ( (button1 == 0) && (button2 == 0) && (button3 == 0) &&
    (button4 == 0 ) ) {

     PrintQuestion();
     RedrawButtons1();
     win=vcWinFromID( SESSIONWINID );
     vcSendMsg( VCSTARTFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
     return(VCSUCCESS); }

 /* show the users choice */
     if(button1!=0) vcWinAtSay(win, 1, 16, "Choice 1 selected");
     if(button2!=0) vcWinAtSay(win, 1, 16, "Choice 2 selected");
     if(button3!=0) vcWinAtSay(win, 1, 16, "Choice 3 selected");
     if(button4!=0) vcWinAtSay(win, 1, 16, "Choice 4 selected");


     /* determine if the user correctly answered */
     if( (button1!=0) && (Question.answer==1) ) { Total_questions_answered++; Total_questions_correct++;
       vcWinAtSayX(win,1, 35,"Correct! Good Job!", vc.green|+(vc.bg*vc.black), VCOF_SYSDFLT); }
     if( (button2!=0) && (Question.answer==2) ) { Total_questions_answered++; Total_questions_correct++;
       vcWinAtSayX(win,1, 35,"Thats it! Great going!", vc.green|+(vc.bg*vc.black), VCOF_SYSDFLT); }
     if( (button3!=0) && (Question.answer==3) ) { Total_questions_answered++; Total_questions_correct++;
       vcWinAtSayX(win,1, 35,"You got this one right!", vc.green|+(vc.bg*vc.black), VCOF_SYSDFLT); }
     if( (button4!=0) && (Question.answer==4) ) { Total_questions_answered++; Total_questions_correct++;
       vcWinAtSayX(win,1, 35,"Very good! You're correct!", vc.green|+(vc.bg*vc.black), VCOF_SYSDFLT); }

     /* determin if the user incorrectly answered */
     if( (button1!=0) && (Question.answer!=1) )  { AnswerISwrong=TRUE; Total_questions_answered++;
       vcWinAtSayX(win,1, 35,"Sorry! Number one is incorrect.", vc.red|+(vc.bg*vc.black), VCOF_SYSDFLT); }
     if( (button2!=0) && (Question.answer!=2) )  { AnswerISwrong=TRUE; Total_questions_answered++;
       vcWinAtSayX(win,1, 35,"No, thats not quite right.", vc.red|+(vc.bg*vc.black), VCOF_SYSDFLT); }
     if( (button3!=0) && (Question.answer!=3) )  { AnswerISwrong=TRUE; Total_questions_answered++;
       vcWinAtSayX(win,1, 35,"Number 3 is wrong. Try again.", vc.red|+(vc.bg*vc.black), VCOF_SYSDFLT); }
     if( (button4!=0) && (Question.answer!=4) )  { AnswerISwrong=TRUE; Total_questions_answered++;
       vcWinAtSayX(win,1, 35,"I'm afraid number 4 is the wrong choice.", vc.red|+(vc.bg*vc.black), VCOF_SYSDFLT); }

     /* don't calculate score until a question has been answered
     ** otherwise program will fail */
     if( Total_questions_correct != 0 ) Total_score = ( (float)Total_questions_correct / (float)Total_questions_answered ) * 100;
     /* print the total number of questions answered for a session
     ** to the main form */
     vcAtSay(1,52, "_______________________" );
     vcAtSay(2, 53, "Questions answered");
     vcAtSayNum(2, 72, &Total_questions_answered,"###",VCOF_INT|VCOF_SYSDFLT);
     /* print the total number of question answered for a session
     ** to the main form */
     vcAtSay(3, 65, "Points");
     vcAtSayNum(3, 72, &Total_questions_correct,"###",VCOF_INT|VCOF_SYSDFLT);
     /* calculate and print the total score */
     vcAtSay(4, 54, "Session Score >>>");
     vcAtSayNum(4, 72, &Total_score,"###",VCOF_FLOAT|VCOF_SYSDFLT);
     vcAtSay(5,52, "_______________________");

     /* move to the top of the window and refresh window */
     vcWinMovePort(win, -14,0);
     vcWinOn(win);
     vcUpdateVIO();
     /* if answer is wrong */
     if(AnswerISwrong==TRUE) {
       vcWinAtSayX(win, 2, 35,"Press space bar to see explanation.",
	  vc.blue|vc.bold+(vc.bg*vc.black), VCOF_SYSDFLT);
       get_a_key();vcWinErase(win, VCDEFAULT);

     /* print the question at the proper row */
     vcWinAtSayX( win, 1, 2, Question.Explanation,
	  vc.cyan|vc.bold+(vc.bg*vc.black), VCOF_SYSDFLT); }

     get_a_key();
     vcWinErase(win, VCDEFAULT);
     /* do some cleanup items before exiting */
     button1=0; button2 = 0; button3 = 0; button4 = 0;
     RedrawButtons1();
     PrintQuestion();
    
     win=vcWinFromID( SESSIONWINID );

  vcSendMsg( VCSTARTFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
  return(VCSUCCESS);
}

VCCOUNT AuthorInfo()
  {
    help = vcWinOpenX(2,5,16,70," Information ",
		   VCWF_SHADOW,0,0,vcBorderFromID(1),vcColorFromID(2));
    vcAtSayX(0, 1,"You can contact the author at the address below:",
	     vc.white|vc.bold+(vc.bg*vc.cyan), VCOF_SYSDFLT);
    vcAtSayX(3, 5,"Ronald Lewis",vc.white|vc.bold+(vc.bg*vc.cyan), VCOF_SYSDFLT);
    vcAtSayX(4, 5,"5840 S. 18th Street",
	     vc.white|vc.bold+(vc.bg*vc.cyan), VCOF_SYSDFLT);
    vcAtSayX(5, 5,"Milwaukee, WI 53221",vc.white|vc.bold+(vc.bg*vc.cyan), VCOF_SYSDFLT);
    vcAtSayX(6, 5,"Phone: (815)-474-7036",
	     vc.white|vc.bold+(vc.bg*vc.cyan), VCOF_SYSDFLT);
    vcAtSayX(8, 5,"E-mail: rlewis.rlewis@gmail.com",
	     vc.white|vc.bold+(vc.bg*vc.cyan), VCOF_SYSDFLT);
    vcAtSayX(10, 1,"User hereby agrees to use \"EPA Test\" as is",
	     vc.brown|vc.bold+(vc.bg*vc.cyan), VCOF_SYSDFLT);
    vcAtSayX(11, 1,"without any warranties or guarantees.",
	     vc.brown|vc.bold+(vc.bg*vc.cyan), VCOF_SYSDFLT);
    get_a_key();
    vcWinClose(help);
    return( VCSUCCESS );
  }


VCCOUNT EditQuestion(VCOBJ *obj) {

    VCCOUNT SaveData_A(VCOBJ *obj), MainForm(VCOBJ *obj), Update(VCOBJ *obj);
    VCCOUNT ClearWorkSheet();
    char buf1[25];


	win = vcCreateWin( NULL, 0, 0, 23, 79," Edit Test ",
	  VCWF_CURSOR,NULL,NULL,vcBorderFromID(1),
	  vcColorFromID(4), EditQuestionWINID, DataInpFilter);

	/* draw the objects */

	vcAtSay(0,34,"Question number:");
	vcEntryFldX( win, 0, 51, &record, "999",OBJGROUP|VCEF_INT|VCEF_FLDBLANK,NULL,
	"Enter the question number to save to", NULL, NULL);

	vcAtSay(1,33,"Subject number:");
	objSUBJNUM = vcEntryFldX( win, 1, 50, &Question.subject_number, "99",OBJGROUP|VCEF_INT|VCEF_FLDBLANK,NULL,
	"Enter the subject number that this question applies to", NULL, NULL);

	sprintf(buf1,"%s",Subjects[Question.subject_number-1]);
	vcWinAtSayX( win, 1, 54, buf1,
	  vc.cyan+(vc.bg*vc.blue), VCOF_SYSDFLT);

	vcAtSay(0,55,"Correct Answer:");
	objCORRECTANSWER = vcEntryFldX( win, 0,71, &Question.answer, "9",OBJGROUP|VCEF_INT|VCEF_FLDBLANK,NULL,
	"Enter the correct answer number for this question", NULL, NULL);

	vcAtSay(2,7,"Question Text");
	objQUESTIONTEXT = vcTextEdX( win, 3, 6, 65, 2, Question.Question_text, 498, OBJGROUP, NULLFUNC,
	"Question text goes here..up to 498 characters",NULL,NULL, vcBorderFromID(0));

	vcAtSay(5,7,"Choice 1 or A");
	objCHOICE1 = vcTextEdX( win, 6, 6, 65, 2, Question.Choice1, 498, OBJGROUP, NULLFUNC,
	"Question text goes here..up to 498 characters",NULL, NULL, vcBorderFromID(0));

	vcAtSay(8,7,"Choice 2 or B");
	objCHOICE2 = vcTextEdX( win, 9, 6, 65, 2, Question.Choice2, 498, OBJGROUP, NULLFUNC,
	"Question text goes here..up to 498 characters",NULL, NULL, vcBorderFromID(0));

	vcAtSay(11,7,"Choice 3 or C");
	objCHOICE3 = vcTextEdX( win, 12, 6, 65, 2, Question.Choice3, 498, OBJGROUP, NULLFUNC,
	"Question text goes here..up to 498 characters",NULL, NULL, vcBorderFromID(0));

	vcAtSay(14,7,"Choice 4 or D");
	objCHOICE4 = vcTextEdX( win, 15, 6, 65, 2, Question.Choice4, 498, OBJGROUP, NULLFUNC,
	"Question text goes here..up to 498 characters",NULL, NULL, vcBorderFromID(0));

	vcAtSay(17,7,"Explanation");
	objEXPLANATION = vcTextEdX( win, 18, 6, 65, 2, Question.Explanation, 498, OBJGROUP, NULLFUNC,
	"Question text goes here..up to 498 characters",NULL, NULL, vcBorderFromID(0));


	vcPushBtnX( win, 0, 2," Finished ", MainForm,
	   OBJGROUP|VCPB_EXECUP,NULL,
	   "Leaves the edit question page",
	   NULL, vcColorFromID(14));

	vcPushBtnX( win, 0, 14, " Save  ", SaveData_A,
	   OBJGROUP|VCPB_EXECUP,NULL,
	   "Save this question to the data file",
	   NULL, vcColorFromID(14));

	vcPushBtnX( win, 0, 23, " Clear ", ClearWorkSheet,
	   OBJGROUP|VCPB_EXECUP,NULL,
	   "Clear this form to add a new question - check all entries before SAVING ",
	   NULL, vcColorFromID(14));



	vcAtSay(21,9,"Text boxes are limited to 499 characters including spaces");
      vcStartForm(win,NULL);

      vcEndForm(obj->win);
     return( VCSUCCESS );
    }



/* Used to return to the main form from the edit form*/
VCCOUNT MainForm(VCOBJ *obj) {
    vcSendMsg( VCWINCLOSE,(VCVOID *)obj->win, 0L, 0L, 0L );
	win=vcWinFromID( SESSIONWINID );
    vcSendMsg( VCSTARTFORM,( VCVOID * )win, 0l,0l,0l);
   return(VCSUCCESS);
  }


 VCCOUNT SaveData_A( VCOBJ *obj ) {
/* this step saves all of the objects in the form before writing*/
    vcSendMsg( VCENDFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
     SaveData_B();
    vcSendMsg( VCSTARTFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
   return(VCSUCCESS);
  }


VCCOUNT SaveData_B()  {
	/* type casting for large byte values to properly
	   position record for writing and reading */
	record_length = (unsigned long)record * (unsigned long)sizeof(struct QuestionStructure);
	fp = fopen(DATAFILE,"rb"); // use r+b for reading and writing rb for read only
	fseek(fp, record_length, SEEK_SET);
	fwrite(&Question, sizeof(struct QuestionStructure),1,fp);
	fclose(fp);

      return(VCSUCCESS);
    }


VCCOUNT ClearWorkSheet()  {

	VCWIN *clear;
	Question.answer = 0;

	vcEmpty(Question.Question_text, 498);
	vcEmpty(Question.Explanation, 498);
	vcEmpty(Question.Choice1, 498);
	vcEmpty(Question.Choice2, 498);
	vcEmpty(Question.Choice3, 498);
	vcEmpty(Question.Choice4, 498);

	clear = vcWinOpenX(4,10,15,65,"",VCWF_SHADOW,
		0,0,vcBorderFromID(1),vcColorFromID(3));
	vcAtSay(1,10,"Worksheet Cleared - Press any key");
	vcAtSay(3,9, "Then press FINISHED and then return");
	vcAtSay(4,17, "by selecting EDIT DATA");
	get_a_key();
	vcWinClose(clear);
	UpdateEditForm();

	return(VCSUCCESS);
	}

VCCOUNT UpdateEditForm() {

	vcPutFldBuf(objCORRECTANSWER, &Question.answer);
	vcPostMsg(VCOBJDRAW, objCORRECTANSWER,0L, 0L, 0L);

	vcPutFldBuf(objCHOICE2, Question.Choice2);
	vcPostMsg(VCOBJDRAW, objCHOICE2,0L, 0L, 0L);
	vcPutFldBuf(objQUESTIONTEXT, Question.Question_text);
	vcPostMsg(VCOBJDRAW, objQUESTIONTEXT,0L, 0L, 0L);
	vcPutFldBuf(objCHOICE1, Question.Choice1);
	vcPostMsg(VCOBJDRAW, objCHOICE1,0L, 0L, 0L);
    vcPutFldBuf(objCHOICE2, Question.Choice2);
	vcPostMsg(VCOBJDRAW, objCHOICE2,0L, 0L, 0L);
    vcPutFldBuf(objCHOICE3, Question.Choice3);
	vcPostMsg(VCOBJDRAW, objCHOICE3,0L, 0L, 0L);
    vcPutFldBuf(objCHOICE4, Question.Choice4);
	vcPostMsg(VCOBJDRAW, objCHOICE4,0L, 0L, 0L);
    vcPutFldBuf(objEXPLANATION, Question.Explanation);
	vcSendMsg(VCOBJDRAW, objEXPLANATION,0L, 0L, 0L);
    vcWinRefresh(win);
   return (VCSUCCESS);
   }
/* end */

