/* CG file manager program
   by Ronald Lewis 04/01/2003 
   * updated 12/5/2012 */

#include <vcstdio.h>
#include <conio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include <dos.h>
#include <bios.h>

 
#define SAVEDATAWINID 101
#define DATAENTRYWINID 102
#define EXITOBJID 201

/* Global Objects for fields */
VCOBJ *obj1, *obj2, *obj3, *obj4, *obj5;
VCOBJ *obj6, *obj7, *obj8;

/* object for Aircraft info file data entry field */
/* allows updating of this field */
VCOBJ *obj28;

/* define file structures */
/* holds cg data */
struct CGDataStructure {
   double maximum_weight;
   double minimum_weight;
   double selected_weight;
   double utility_maximum_weight;
   double utility_minimum_weight;
   double utility_forward_cg;
   double utility_rearward_cg;
   double forward_cg;
   double rearward_cg;
   char aircraft[31];
  } CG;

/* will hold zero's for pre-loading
   newly created file */
struct EMPTYDataStructure {
   double maximum_weight;
   double minimum_weight;
   double selected_weight;
   double utility_maximum_weight;
   double utility_minimum_weight;
   double utility_forward_cg;
   double utility_rearward_cg;
   double forward_cg;
   double rearward_cg;
   char aircraft[31];
  } EMPTY_CG;

/* structure for aircraft info file string */
    struct info_name {
      char info_name[70];
    } Info_Path;

/* structure to hold Aircraft information */
   struct AircraftStructure {
	  char ac_info_filename[13];
	  char name[31];
	  char a_file[13];
	  char b_file[13];
	  char n_file[13];
	  char d_file[13];
	  char cgd_file[13];
	  int is_complex; /* Complex airplane? */
	 } AircraftInfo;

/* declare variables */
VCWIN  *data;
int number1=1, number2=1; /* listbox pointer variables */
char buffer[20];
/* declare some constants that cannot be changed */
const TRUE = 1, FALSE = 0;
/* declare radio button items*/
VCCOUNT button1 = 0;
VCCOUNT record_length = 1;
/* variables for "key" function */
//int NotValid = -1;
//char *password = "SIWEL";

 

VCLBOXITEM weights[] =
  {
   "1100",NULL,"1125",NULL,"1150",NULL,"1175",NULL,
   "1200",NULL,"1225",NULL,"1250",NULL,"1275",NULL,"1300",NULL,
   "1325",NULL,"1350",NULL,"1375",NULL,"1400",NULL,"1425",NULL,
   "1450",NULL,"1475",NULL,"1500",NULL,"1525",NULL,"1550",NULL,
   "1575",NULL,"1600",NULL,"1625",NULL,"1650",NULL,"1675",NULL,
   "1700",NULL,"1725",NULL,"1750",NULL,"1775",NULL,"1800",NULL,
   "1825",NULL,"1850",NULL,"1875",NULL,"1900",NULL,"1925",NULL,
   "1950",NULL,"1975",NULL,"2000",NULL,"2025",NULL,"2050",NULL,
   "2075",NULL,"2100",NULL,"2125",NULL,"2150",NULL,"2175",NULL,
   "2200",NULL,"2225",NULL,"2250",NULL,"2275",NULL,"2300",NULL,
   "2325",NULL,"2350",NULL,"2375",NULL,"2400",NULL,"2425",NULL,
   "2450",NULL,"2475",NULL,"2500",NULL,"2525",NULL,"2550",NULL,
   "2575",NULL,"2600",NULL,"2625",NULL,"2650",NULL,"2675",NULL,
   "2700",NULL,"2725",NULL,"2750",NULL,"2775",NULL,"2800",NULL,
   "2825",NULL,"2850",NULL,"2875",NULL,"2900",NULL,"2925",NULL,
   "2950",NULL,"2975",NULL,"3000",NULL,"3025",NULL,"3050",NULL,
   "3075",NULL,"3100",NULL,"3125",NULL,"3150",NULL,"3175",NULL,
   "3200",NULL,"3225",NULL,"3250",NULL,"3275",NULL,"3300",NULL,
   "3325",NULL,"3350",NULL,"3375",NULL,"3400",NULL,"3425",NULL,
   "3450",NULL,"3475",NULL,"3500",NULL,"3525",NULL,"3550",NULL,
   "3575",NULL,"3600",NULL,"3625",NULL,"3650",NULL,"3675",NULL,
   "3700",NULL,"3725",NULL,"3750",NULL,"3775",NULL,"3800",NULL,
   "3825",NULL,"3850",NULL,"3875",NULL,"3900",NULL,"3925",NULL,
   "3950",NULL,"3975",NULL,"4000",NULL,"4025",NULL,"4050",NULL,
   "4075",NULL,"4100",NULL,"4125",NULL,"4150",NULL,"4175",NULL,
   "4200",NULL,"4225",NULL,"4250",NULL,"4275",NULL,"4300",NULL,
   "4325",NULL,"4350",NULL,"4375",NULL,"4400",NULL,"4425",NULL,
   "4450",NULL,"4475",NULL,"4500",NULL,"4525",NULL,"4550",NULL,
   "4575",NULL,"4600",NULL,"4625",NULL,"4650",NULL,"4675",NULL,
   "4700",NULL,"4725",NULL,"4750",NULL,"4775",NULL,"4800",NULL,
   "4825",NULL,"4850",NULL,"4875",NULL,"4900",NULL,"4925",NULL,
   "4950",NULL,"4975",NULL,"5000",NULL,"5025",NULL,"5050",NULL,
   "5075",NULL,"5100",NULL,"5125",NULL,"5150",NULL,"5175",NULL,
   "5200",NULL,"5225",NULL,"5250",NULL,"5275",NULL,"5300",NULL,
   "5325",NULL,"5350",NULL,"5375",NULL,"5400",NULL,"5425",NULL,
   "5450",NULL,"5475",NULL,"5500",NULL,"5525",NULL,"5550",NULL,
   "5575",NULL,"5600",NULL,"5625",NULL,"5650",NULL,"5675",NULL,
   "5700",NULL,"5725",NULL,"5750",NULL,"5775",NULL,"5800",NULL,
   "5825",NULL,"5850",NULL,"5875",NULL,"5900",NULL,"5925",NULL,
   "5950",NULL,"5975",NULL,"6000",NULL,NULL,NULL
  };

/* declare function prototypes */
VCCOUNT vcFillWinBg( VCWIN *win, VCCHAR ch, VCATTR attr);
VCCOUNT winfilter( VCCOUNT msg, VCVOID *to, VCULONG p1,
	    VCULONG p2, VCULONG p3 );
VCCOUNT Quit_Verify( int a );
VCCOUNT DataExit (VCOBJ *obj);
VCCOUNT SaveData( VCOBJ *obj);
VCCOUNT GetData( VCOBJ *obj);
 
VCCOUNT DataEntryFunc( VCVOID );
VCCOUNT get_a_key( VCVOID );
VCCOUNT WriteDBRecord( VCVOID );
VCCOUNT GetDBRecord( VCVOID );
VCCOUNT Updateform( VCVOID );
VCCOUNT Empty_CG_Data(VCVOID);

/* ----------------added for upgrade --------------------- */
	 VCCOUNT ReadAircraftFile( VCOBJ *obj );
     VCCOUNT Clear_airStructfile(VCVOID);
     VCCOUNT CheckForUseair( VCVOID );
     VCCOUNT UpdateAirInfoField(VCVOID);
	 VCCOUNT No_Fileget( VCVOID ); 
     VCCOUNT ManageAirFile(VCVOID);
     VCCOUNT not_found(VCVOID);
     VCCOUNT DisplayTheData(VCVOID);
 
/* ------------------------------------------------------- */

main()  {

  /* initialize file elements to zeros */

   CG.utility_maximum_weight=0;
   CG.utility_minimum_weight=0;
   CG.utility_forward_cg=0;
   CG.utility_rearward_cg=0;
   CG.maximum_weight=0;
   CG. minimum_weight=0;
   CG.selected_weight=0;
   CG.forward_cg=0;
   CG.rearward_cg=0;

  /* check for "key" */
//   NotValid=strcmp(argv[1], password);
//   if(NotValid) {
//     puts("Must be used with Flight Log Maker");
//     exit(0); }

   vcStart(VCCLRSCRN);
   
   /* open status line */
   vcStatOpen(0, 0, 0, 79, NULL, 0, 0, NULL);
   vcStatSay(" Flight Log Maker: CG File Manager 2.1      TAB = Select Fields        ESC=Quit ", vc.white|vc.bold|vc.green*vc.bg);
   data=vcWinOpenX(1,55,23,79,"",NULL,0,0,
		 vcBorderFromID(1),vcColorFromID(4));
   data->id=SAVEDATAWINID;
   DataEntryFunc();

   vcProcessEvents();
   
   /* delete the temporary user file */
   vcDelFile("useplane");
   
   vcEnd();
   clrscr();
   return (0);  }

VCCOUNT DataEntryFunc()  {
   VCWIN *win;
   VCOBJ *obj;
   /* reopen window if it exists */
   if(( win = vcWinFromID(DATAENTRYWINID)) != NULL) { return( vcSendMsg(VCWINSELECT, win, 0L,0L,0L)); }
   /* create if it doesn't */
   win = vcCreateWin(NULL,1,0,23,54," CG Data Entry",
	     VCWF_CURSOR,0, 0, vcStdBorder(), vcColorFromID(4),
	     DATAENTRYWINID, winfilter);

   vcMouSetCapture(win, 0);

   if( win == NULL)  { vcTerror("Unable to open DataEntry. Aborting"); }

/* before ending the form - clear line 20 aircraft info */ 
    vcAtSayX(7,2, "No aircraft loaded yet                  ",
    vc.brown|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);
   
   /* window objects */
   vcAtSay(0,2,"Aircraft");
   vcAtSay(1,2,"File:");
      obj28=vcEntryFldX(win, 1, 8, &AircraftInfo.ac_info_filename,
	   "XXXXXXXXXXXX",
	  OBJGROUP|VCEF_STRING|VCEF_FLDBLANK,NULL,
	   "8 characters Maximum plus \".air\"  Select \"Read\" to read an existing file",
	  NULL,NULL);
  
  obj=vcPushBtnX(win,3,2," Find  ", UpdateAirInfoField,
      OBJGROUP|VCPB_EXECUP,NULL,"find existing Aircraft information files",NULL,NULL); 
  obj=vcPushBtnX( win, 5, 2, " Read Aircraft File ", ReadAircraftFile,
	   OBJGROUP|VCPB_EXECUP,NULL,
	   "Enter Aircraft info file and \"read\" before anything else!",
	   NULL, vcColorFromID(12));
   
   vcAtSay( 3, 43, "Selected");
   vcAtSay( 4, 43, "Weight");
   vcListBoxX( win, 5, 44, 4, 8, weights, OBJGROUP| VCLB_SCROLLBAR,
       &number2, NULL, "Select the weight",
       NULL, vcColorFromID(17), vcBorderFromID(1));
   
   vcAtSay( 10, 2, "Normal Envelope");
   
   vcAtSay( 11, 2, "Forw. CG");
   obj1=vcEntryFldX( win, 12, 4, &CG.forward_cg, "###.#", OBJGROUP|VCEF_DOUBLE|VCEF_FLDBLANK|
       VCEF_ENDCAPS, NULLFUNC, "Enter the envelope forward CG for selected weight", NULL, NULL );
      
   vcAtSay( 11, 13, "Rear CG");
   obj2=vcEntryFldX( win, 12, 14, &CG.rearward_cg, "###.#", OBJGROUP|VCEF_DOUBLE|VCEF_FLDBLANK|
       VCEF_ENDCAPS, NULLFUNC, "Enter the envelope rearward CG for selected weight", NULL, NULL );
   
   vcAtSay( 11, 31, "Max. wt.");
   obj3=vcEntryFldX( win, 12, 33, &CG.maximum_weight, "####", OBJGROUP|VCEF_DOUBLE|VCEF_FLDBLANK|
       VCEF_ENDCAPS, NULLFUNC, "Enter the maximum gross weight of the aircraft (Top of CG envelope)", NULL, NULL );   
   
   vcAtSay( 11, 22, "Min. wt.");
   obj4=vcEntryFldX( win, 12, 24, &CG.minimum_weight, "####", OBJGROUP|VCEF_DOUBLE|VCEF_FLDBLANK|
       VCEF_ENDCAPS, NULLFUNC, "Enter the minimum weight of the aircraft (Bottom of CG envelope)", NULL, NULL );  
   
   
   vcAtSay( 14, 2, "Utility Envelope");
   
   vcAtSay( 15,31, "Max. wt.");
   obj5=vcEntryFldX( win, 16, 33, &CG.utility_maximum_weight, "####", OBJGROUP|VCEF_DOUBLE|VCEF_FLDBLANK|
       VCEF_ENDCAPS, NULLFUNC, "Enter the utility catagory maximum weight", NULL, NULL );
   
    vcAtSay( 15, 22, "Min. wt.");
   obj6=vcEntryFldX( win, 16, 24, &CG.utility_minimum_weight, "####", OBJGROUP|VCEF_DOUBLE|VCEF_FLDBLANK|
       VCEF_ENDCAPS, NULLFUNC, "Enter the utility catagory minimum weight", NULL, NULL );
   
   vcAtSay( 15, 2, "Forw. CG");
   obj7=vcEntryFldX( win, 16, 4, &CG.utility_forward_cg, "###.#", OBJGROUP|VCEF_DOUBLE|VCEF_FLDBLANK|
       VCEF_ENDCAPS, NULLFUNC, "Enter the utility catagory forward cg for selected weight", NULL, NULL );
   
   vcAtSay( 15, 13, "Rear CG");
   obj8=vcEntryFldX( win, 16, 14, &CG.utility_rearward_cg, "###.#", OBJGROUP|VCEF_DOUBLE|VCEF_FLDBLANK|
       VCEF_ENDCAPS, NULLFUNC, "Enter the utility catagory rearward cg for selected weight", NULL, NULL );
       
  
     
   
   
   
   obj = vcPushBtnX( win, 19, 2, " GET   ", GetData, OBJGROUP|VCPB_EXECUP,
	     NULL, "Get CG Data from disk",NULL, NULL);
   obj = vcPushBtnX( win, 20, 2, " INFO  ", GetData, OBJGROUP|VCPB_EXECUP,
	     NULL, "Get CG Data from disk",NULL, NULL);
   
   obj = vcPushBtnX( win, 19, 45, " SAVE  ", SaveData, OBJGROUP|VCPB_EXECUP,
	     NULL, "Save CG Data to disk",NULL, NULL);
   obj = vcPushBtnX( win, 20, 45, " INFO  ", SaveData, OBJGROUP|VCPB_EXECUP,
	     NULL, "Save CG Data to disk",NULL, NULL);

   
   
   obj = vcPushBtnX( win, 0, 46, "      ", DataExit, OBJGROUP|VCPB_EXECUP,
	     NULL, "Quit the CG Data manager",NULL, NULL);
   obj = vcPushBtnX( win, 1, 46, " EXIT ", DataExit, OBJGROUP|VCPB_EXECUP,
	     NULL, "Quit the CG Data manager",NULL, NULL);
   obj->id = EXITOBJID;

   vcStatOpen(24, 0, 24, 79, NULL, 0, 1, NULL);

   vcStartForm( win, NULL);
   return( VCSUCCESS );
  }

 /* universal keypress filter */
 VCCOUNT winfilter(VCCOUNT msg, VCVOID *to, VCULONG p1,
		   VCULONG p2, VCULONG p3)
     {
       int a=0;  // initialize to zero
		 // 0= don't quit and 1 means quit
       VCCOUNT key;
       if(msg==KEYPRESS)  //if keypress
	{
	  key=p1&0xffff;  //get key
	  if(key==ESC)    //if esc exit
	  //end processing
	  if (Quit_Verify(a)) { // verify user really wants to quit program
	    return(vcPostMsg(VCTERMINATE, to, p1, p2, p3) );
	   }
	  }
      //if mouse events and not to current window
      if( (msg == MOUB1DOWN )  &&
	  (vcWinFromVoid(to) != wcurrent) )
	  {
	   return (VCSUCCESS); //eat message
	  } 
      //allow other message on through system
      return( vcDefaultWinFilter(msg, to, p1, p2, p3 ) );
     }

 Quit_Verify( int a )  {
   char p;
   VCWIN *e;
   vcMouHide();
   e = vcWinOpenX(7, 20, 10, 60, "Warning", VCWF_SHADOW, 0, 0,
	  vcBorderFromID(1), vcColorFromID(9));
   vcAtSay(0,  5, "Are you Sure you want to quit");
   vcAtSay(1, 5, "The CG Manager? Press Y or N!");
   vcStatSay("Press Y to exit and N cancel quit. ",
      vc.white|vc.bold|vc.blink|vc.blue*vc.bg);
   vcUpdateVIO();
   p = getch();
      switch(p)  {
	case 'y' :
	case 'Y' : a = 1; break;
	case 'n' :
	case 'N' : a = 0; break;
	default  : a = 0; break;
      }
   vcMouShow();
   vcWinClose(e);
   return ( a );
  }

 
 get_a_key()  {
   VCCOUNT key;
   while( ( (key = vcGetOne(NULL)) == MOUMOVE) || (key == MOUB1MOVE) );
     return ( key );
  }

 DataExit (VCOBJ *obj)  {
   int a = 0;
   if (Quit_Verify(a))  {
     vcEndForm(obj->win);
     vcPostMsg(VCTERMINATE, obj->win, 0L, 0L, 0L);
     return ( VCTERMINATE );
     }
   else return ( VCSUCCESS );
  }

 WriteDBRecord()  {
   VCWIN *win; 

   FILE *fp;
   
   /* select and clear window */
   win = vcWinFromID( SAVEDATAWINID );
   vcWinErase( win, (vc.bg*vc.blue) );

/* convert string into a numeric value */
   sprintf( buffer, "%s", weights[number2-1]);
   CG.selected_weight = atoi( buffer );
   
   strcpy(CG.aircraft, AircraftInfo.name);

   /* convert number2 to its record number */
   number2 -= 1;

   /* open file for writing */
   if( ( fp = fopen( AircraftInfo.cgd_file, "r+b") ) == NULL ) {
     vcStatSay("CG File Open error", vc.brown|vc.bold|vc.blue*vc.bg);
     Empty_CG_Data(); Updateform();
     fclose(fp);
     vcUpdateVIO();
     return ( VCSUCCESS );
   } /* end fp */

   /* open file for write */
   if( ( fp = fopen( AircraftInfo.cgd_file, "r+b" ) ) == NULL )  {
     vcWinErase( win, (vc.bg*vc.blue) );
     vcWinAtSay( win, 11,1, "Can't update/open file");
     fclose( fp );
     vcUpdateVIO();
     return ( VCSUCCESS );
    }
   /* find the record */
   if( fseek( fp, (number2) * sizeof( struct CGDataStructure), SEEK_SET ) != 0 )  {
     vcWinErase( win, (vc.bg*vc.blue) );
     vcWinAtSay( win, 11,1, "Can't update/read CG record");
     vcUpdateVIO();
     return ( VCSUCCESS );
    }
   /* write to file */
   if( fwrite (&CG, sizeof( struct CGDataStructure ), 1, fp) != 1)  {
     vcWinErase( win, (vc.bg*vc.blue) );
     vcWinAtSay( win, 11,1, "Can't update/write CG file");
     vcUpdateVIO();
     return ( VCSUCCESS );
    }
    
   fclose(fp);
   
   DisplayTheData();
   vcWinAtSay( win, 20,4, "Record saved....");
   return ( VCSUCCESS );
  }
 
 CreateCGfile()  {
   VCWIN *win;
   VCWIN *create_notice;
   FILE *fp;
   int TotalRecords = 198, count = 0;
   /* select and clear window */
   win = vcWinFromID( SAVEDATAWINID );
   vcWinErase( win, (vc.bg*vc.blue) );

   /* initialize dummy data to zeros */
   EMPTY_CG.utility_maximum_weight=0;
   EMPTY_CG.utility_minimum_weight=0;
   EMPTY_CG.utility_forward_cg=0;
   EMPTY_CG.utility_rearward_cg=0;
   EMPTY_CG.maximum_weight = 0;
   EMPTY_CG.minimum_weight = 0;
   EMPTY_CG.selected_weight = 0;
   EMPTY_CG.forward_cg = 0;
   EMPTY_CG.rearward_cg = 0;

   /* create a CG file  */
   if ( ( fp = fopen( AircraftInfo.cgd_file, "wb" ) ) == NULL )  {
     vcStatSay("Can't create CG file!", vc.brown|vc.bold|
      vc.blue*vc.bg);
     vcWinErase( win, (vc.bg*vc.blue) );
     vcUpdateVIO();
    }
   /* write some zeros to the new file */
   for ( count = 1; count < TotalRecords; count++)  {
     fseek( fp, (count - 1) * sizeof( struct EMPTYDataStructure), SEEK_SET );
     fwrite( &EMPTY_CG, sizeof( struct EMPTYDataStructure), 1, fp );
    } /* end for loop */
   fclose( fp );

   DisplayTheData();
 

   /* notify user that new file was created and to press any key */
   create_notice = vcWinOpenX(8,25,11,53,"New file notice",NULL,
       0, 0, vcBorderFromID(7), vcStdColor(1));
   vcWinAtSay( create_notice, 1,1, "A new file was created.");
   vcWinAtSay( create_notice, 2,1, "Press any key to continue.");
   vcStatSay("Writing to file for the first time.", vc.white|vc.bold|vc.blue*vc.bg);
   vcUpdateVIO();
   get_a_key();
   vcWinClose( create_notice);
   return ( VCSUCCESS );
  }

 GetDBRecord()  {
   VCWIN *win;
   VCATTR attr;
   FILE *fp;
   /* select and clear window */
   win = vcWinFromID( SAVEDATAWINID );
   vcWinErase( win, (vc.bg*vc.blue) );
   
   /* convert string into a numeric value */
   sprintf( buffer, "%s", weights[number2-1]);
   CG.selected_weight = atoi( buffer );
   
   strcpy(CG.aircraft, AircraftInfo.name);

   /* convert number2 to its record number */
   number2 -= 1;
   
   
   
   
   /* open file for read */
   if( ( fp = fopen( AircraftInfo.cgd_file, "r+b" ) ) == NULL )  {
     vcWinErase( win, (vc.bg*vc.blue) );
     vcWinAtSay( win, 11,1, "Can't open file");
     Empty_CG_Data(); Updateform();
     fclose( fp );
     vcUpdateVIO();
     return ( VCSUCCESS );
    }
   /* find the record */
   if( fseek( fp, (number2) * sizeof( struct CGDataStructure), SEEK_SET ) != 0 )  {
     vcWinErase( win, (vc.bg*vc.blue) );
     vcWinAtSay( win, 11,1, "Can't read record");
     vcUpdateVIO();
     return ( VCSUCCESS );
    }
   /* read file */
   if( fread (&CG, sizeof( struct CGDataStructure ), 1, fp) != 1)  {
     vcWinErase( win, (vc.bg*vc.blue) );
     vcWinAtSay( win, 11,1, "Can't read file");
     vcUpdateVIO();
     return ( VCSUCCESS );
    }
   fclose( fp );

   DisplayTheData();
    
   return ( VCSUCCESS );
   }

 VCCOUNT Updateform()
     {
       vcPutFldBuf(obj1, &CG.forward_cg);
	  vcPostMsg(VCOBJDRAW, obj1,0L, 0L, 0L);
       vcPutFldBuf(obj2, &CG.rearward_cg);
	  vcPostMsg(VCOBJDRAW, obj2,0L, 0L, 0L);
       vcPutFldBuf(obj3, &CG.maximum_weight);
	  vcPostMsg(VCOBJDRAW, obj3,0L, 0L, 0L);
       vcPutFldBuf(obj4, &CG.minimum_weight);
	  vcPostMsg(VCOBJDRAW, obj4,0L, 0L, 0L);
       vcPutFldBuf(obj5, &CG.utility_maximum_weight);
	  vcPostMsg(VCOBJDRAW, obj5,0L, 0L, 0L);
       vcPutFldBuf(obj6, &CG.utility_minimum_weight);
	  vcPostMsg(VCOBJDRAW, obj6,0L, 0L, 0L);
       vcPutFldBuf(obj7, &CG.utility_forward_cg);
	  vcPostMsg(VCOBJDRAW, obj7,0L, 0L, 0L);
       vcPutFldBuf(obj8, &CG.utility_rearward_cg);
	  vcPostMsg(VCOBJDRAW, obj8,0L, 0L, 0L);
       vcUpdateVIO();
      return( VCSUCCESS );
     }

 SaveData( VCOBJ *obj )  {
   vcSendMsg( VCENDFORM, ( VCVOID * ) obj->win, 0L, 0L, 0L );
   WriteDBRecord();
   Updateform();
   vcSendMsg( VCSTARTFORM, ( VCVOID *)obj->win, 0L, 0L, 0L );
   return ( VCSUCCESS );
  }

 GetData( VCOBJ *obj )  {
   vcSendMsg( VCENDFORM, ( VCVOID * ) obj->win, 0L, 0L, 0L );
   GetDBRecord();
   Updateform();
   vcSendMsg( VCSTARTFORM, ( VCVOID *)obj->win, 0L, 0L, 0L );
   return ( VCSUCCESS );
  }

VCCOUNT UpdateAirInfoField()  {
    FILE *fp; /* temporary pointer to read ac tailnumber string from file */

// set message that aircraft hasn't been loaded yet 
    vcAtSayX(7,2, "No aircraft loaded yet                  ",
  	  vc.brown|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);
    vcUpdateVIO();    
    
    Clear_airStructfile(); 
    ManageAirFile();

/* open a file to get the aircraft tail number string */
       if((fp=fopen("useplane","r"))!=NULL)  {
	 fseek(fp,0 * sizeof(struct info_name),SEEK_SET);
	 fread(&Info_Path,sizeof(struct info_name),1,fp);
	 fclose(fp); }
       strncpy(AircraftInfo.ac_info_filename, Info_Path.info_name, 13);
       AircraftInfo.ac_info_filename[13] = '\0';
       vcPutFldBuf(obj28, &AircraftInfo.ac_info_filename);
	  vcPostMsg(VCOBJDRAW, obj28,0L, 0L, 0L);
      vcUpdateVIO();
       
      return( VCSUCCESS );
     }    
     
VCCOUNT No_Fileget()
     {
       VCWIN *n;
       
	 n = vcWinOpenX(8,5,16,65," Program \"FILEGET\" missing!  ",VCWF_SHADOW,
	    0,0,vcBorderFromID(1),vcColorFromID(9));
	 vcAtSay(1, 1,"Could not Find: \"fileget.EXE");
	 vcAtSay(2, 1,"This program and all supporting files");
	 vcAtSay(3, 1,"Must be in Flight Log Maker's Directory!");
	 vcAtSay(5, 1,"Press any keyboard key to continue...");
	 vcStatSay("                                    Error", vc.white|vc.bold|vc.blink|vc.blue*vc.bg);
	 vcUpdateVIO();
	 get_a_key();
	 vcWinClose(n);
       return( VCSUCCESS );
    }
    
VCCOUNT ReadAircraftFile( VCOBJ *obj ) {
   FILE *fp;

   VCWIN *win;
/* clear the data display window. */
   win=vcWinFromID( SAVEDATAWINID );
   vcWinErase( win,(vc.bg*vc.blue) );


    
    /* this step saves all of the objects in the form before reading */
    vcSendMsg( VCENDFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
	
	/* see if the filename exists, then open it if it does */
	/* use r+b for reading and writing rb for read only */
	if ((fp = fopen(AircraftInfo.ac_info_filename,"r+b")) != NULL)
	  {
	   fseek(fp, record_length, SEEK_SET);
	   fread(&AircraftInfo, sizeof(struct AircraftStructure),1,fp);
	   fclose(fp); }
	   else { not_found(); button1 = 0;
	   Clear_airStructfile();
	 
	   vcPutFldBuf(obj28, &AircraftInfo.ac_info_filename);
	   vcPostMsg(VCOBJDRAW, obj28,0L, 0L, 0L);
	   
	   vcSendMsg( VCSTARTFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
	   vcUpdateVIO(); 
	 return(VCSUCCESS); }

/* print the message */
    
    vcAtSayX(7,2, "                                               ",
	  vc.blue|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);
    vcAtSayX(7,2, "Loaded:",
	  vc.brown|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);
    vcAtSayX(7,10, AircraftInfo.name,
	  vc.brown|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);
                  
    button1 = 0;
    
    vcSendMsg( VCSTARTFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
   return(VCSUCCESS);
  }

/* error function: warns if file not found */
	VCCOUNT not_found()
	{
	VCWIN *e;
	VCWIN *win;
/* clear the data display window. */
win=vcWinFromID( SAVEDATAWINID );
vcWinErase( win,(vc.bg*vc.blue) );
	
	vcCurHide(vccrt);
	e = vcWinOpenX(7,10,13,70," Error with filename! ",
		 NULL,0,0,vcBorderFromID(5),
		 vcColorFromID(20));
	Clear_airStructfile();
	vcAtSay(1,15,"That file was not found.");
	vcAtSay(2,15,"Recheck the filename entered.");
	vcAtSay(3,15,"Aircraft Structure being cleared.");
	vcStatSay("Cannot find a file by the name used."
		 ,vc.brown|vc.bold|vc.blue*vc.bg);
	
	vcUpdateVIO();
	get_a_key();
	vcCurShow(vccrt);
	vcWinClose(e);
/* clear space in case previous message was here 
 * because some messages take of different amounts of space */
    vcAtSayX(7,2, "                                        ",
	  vc.brown|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);   
	vcAtSayX(7,2, "Aircraft not loaded                     ",
	  vc.brown|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);
 
	vcPutFldBuf(obj28, &AircraftInfo.ac_info_filename);
	   vcPostMsg(VCOBJDRAW, obj28,0L, 0L, 0L);
	   
	
	
	return(VCSUCCESS);
	}

VCCOUNT Clear_airStructfile()  {
   *AircraftInfo.ac_info_filename = NULL;
   *AircraftInfo.name = NULL;
   *AircraftInfo.a_file = NULL;
   *AircraftInfo.b_file = NULL;
   *AircraftInfo.n_file = NULL;
   *AircraftInfo.d_file = NULL;
   *AircraftInfo.cgd_file = NULL;
   AircraftInfo.is_complex = FALSE; 
 return (VCSUCCESS);
}

VCCOUNT CheckForUseair()
 {
  /* see if wb executable exists */
  VCCOUNT stat;
  FILE *exist;
       if((exist = fopen("fileget.exe","rb")) != NULL ) {
	      stat = 0;
	      fclose(exist);
	     }
	    else
	     stat = -1;
   return stat;
  }
  
VCCOUNT ManageAirFile()
{
  union REGS regs;
  struct SREGS s;
  VCCOUNT stat;
  VCTEXT *savebuf;
  VCTEXT *comspec;
  VCCOORD r,c;

  
/* See how much memory we need to save  */
  regs.x.ax = 21;
  int86( 0x33, &regs, &regs );
  savebuf = (VCVOID *)vcAlloc( 1, regs.x.bx );

  comspec = getenv("COMSPEC");

  if( savebuf != (VCTEXT *)0 && comspec != (VCTEXT *)0 )
    {
    /* save mouse state */
    regs.x.ax = 22;
    regs.x.dx = FP_OFF( savebuf );
    s.es = FP_SEG( savebuf );
    int86x( 0x33, &regs, &regs, &s );

    /* reset mouse for a polite exit */
    regs.x.ax = 33;
    int86( 0x33, &regs, &regs );
     vc_WinPut( vccrt->rw );
     vcUpdateVIO();
     vcAt( 0, 0 );
    /********** */
    /* check for program to list trip files */
    stat=CheckForUseair();
    if(stat == 0)  {
       vcUpdateVIO();
       vcAt( 0, 0 );
       system("fileget.exe ????????.air");  }  /* change to wb front page when created */
    
    if(stat < 0)
      No_Fileget();

    /* restore mouse state */
    regs.x.ax = 23;
    regs.x.dx = FP_OFF( savebuf );
    s.es = FP_SEG( savebuf );
    int86x( 0x33, &regs, &regs, &s );
    vcFree( savebuf );

    /* restore original Vitamin C display */
    vc_WinPut( vccrt->rw );
    vc_WinPutBranch( vccrt->rw );

  r = wcurrent->r;
  c = wcurrent->c;
  if( vccrt->cursor.hidden ||                    // if hidden
      (wcurrent->hidecnt)   ||                   // or hidecount
      !(wcurrent->flags & VCWF_CURSOR)  ||       // or cursorless
      vcObsPoint(wcurrent, &r, &c) == -1 )       // or obscured
    {
    vccrt->cursor.cswitch = VCOFF;
    vccrt->cursor.ctrans  = 1;
    }
  else
    {
    vccrt->cursor.cswitch = VCON;
    vccrt->cursor.ctrans  = 1;
    }
  if( vccrt->cursor.cfunc )
    (*vccrt->cursor.cfunc)(vccrt, r, c);
     vcMouSetPos(5,15);                   // prevents pushing button twice
     vcUpdateVIO();
    }
    else
	 vcBell();
 return( VCSUCCESS );
} 

Empty_CG_Data()  {
	/* clear data to zero's after error  */
   CG.utility_maximum_weight=0;
   CG.utility_minimum_weight=0;
   CG.utility_forward_cg=0;
   CG.utility_rearward_cg=0;
   CG.maximum_weight = 0;
   CG.minimum_weight = 0;
   CG.selected_weight = 0;
   CG.forward_cg = 0;
   CG.rearward_cg = 0;
   return(VCSUCCESS);
}

VCCOUNT DisplayTheData() {
   VCWIN *win;
   win = vcWinFromID( SAVEDATAWINID );
   /* display data in data window */
   vcWinAtSay( win, 0,1, "Aircraft CG file");
   vcWinAtSayX( win, 1,2, AircraftInfo.cgd_file,
     vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
   vcAtSayNumX( win, 1,13, &number2, "####", VCOF_INT,
     vc.green|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
   vcWinAtSay( win, 4,1, "Max. weight");
   vcAtSayNumX( win, 4,13, &CG.maximum_weight, "####", VCOF_DOUBLE,
     vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
   vcWinAtSay( win, 5,1, "Min. weight");
   vcAtSayNumX( win, 5,13, &CG.minimum_weight, "####", VCOF_DOUBLE,
     vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
   vcWinAtSay( win, 2,1, "  weight:");
   vcAtSayNumX( win, 2,13, &CG.selected_weight, "####", VCOF_DOUBLE,
     vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
   vcWinAtSay( win, 8,1, "Forward CG:");
   vcAtSayNumX( win, 8,13, &CG.forward_cg, "###.#", VCOF_DOUBLE,
     vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
   vcWinAtSay( win, 9,1, "Rear CG:");
   vcAtSayNumX( win, 9,13, &CG.rearward_cg, "###.#", VCOF_DOUBLE,
     vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
    vcWinAtSay( win, 11,1, "-----------------");
   vcWinAtSay( win, 12,1, " Utility Catagory");
   vcWinAtSay( win, 13,1, " Forward CG");
   vcAtSayNumX( win, 13,13, &CG.utility_forward_cg, "###.#", VCOF_DOUBLE,
     vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
   vcWinAtSay( win, 14,1, " Rear CG");
   vcAtSayNumX( win, 14,13, &CG.utility_rearward_cg, "###.#", VCOF_DOUBLE,
     vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
   vcWinAtSay( win, 16,1, " Weights");
   vcWinAtSay( win, 17,1, "    Max.    Min.");
   vcAtSayNumX( win, 18,5, &CG.utility_maximum_weight, "####", VCOF_DOUBLE,
     vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
   vcWinAtSay( win, 18,11, "/");
   vcAtSayNumX( win, 18,13, &CG.utility_minimum_weight, "####", VCOF_DOUBLE,
     vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
    
   return ( VCSUCCESS );
   }
