/* This is a program that creates/edits aircraft performance data 
 * for flight log maker.  Updated 4/11/2023 
** Author: Ron Lewis */

#include <vcstdio.h>
#include <conio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include <hprecord.h>

 
#define SAVEDATAWINID     101
#define DATAENTRYWINID    102

#define EXITOBJID         201
/* ---------------------------------- */
/* declare variables */
     /* hold filenames related to aircraft selected */
    char current_file[13], buf1[13];
    char atmosphere[20], filetype_performance[20];
    int num1=6, num2=1, num3=1; /*listbox pointer variables */
    int num4=1, num5=1, num6=2; /* listbox pointer variables */
    int hp_index=0;
    VCOBJ *entry_obj1, *entry_obj2, *entry_obj3, *entry_obj4, *entry_obj5;
    
/* object for aircraft information file field */
    VCOBJ *obj28;
 
/* declare some constants that cannot be changed */
const TRUE = 1, FALSE = 0, MATCH = 0, NOMATCH = 1;

/* declare radio button items*/
VCCOUNT button1 = 0;
VCCOUNT record_length = 1;
/* name of the aircraft information file */
char ac_info_filename[13];

/* variables added to make "key" for program */
//int NotValid = -1;
//char *password = "SIWEL";

/* structure for aircraft info file string */
    struct info_name {
      char info_name[70];
    } Info_Path;

/* structure to hold Aircraft information */
   struct AircraftStructure {
	  char ac_info_filename[13];
	  char name[31];
	  char a_file[13];
	  char b_file[13];
	  char n_file[13];
	  char d_file[13];
	  char cgd_file[13];
	  int is_complex; /* Complex airplane? */
	 } AircraftInfo;

/* define file structures and initialize */
struct fltdata {
       int tas;
       double fc;
       int rc;
       int cs;
       int bhp;
       int rpm;
       int mp;
      } perform;

 
VCLBOXITEM rpm[]=
  {
   "2000",NULL,"2100",NULL,"2200",NULL,
   "2300",NULL,"2400",NULL,"2500",NULL,
   "2600",NULL,"2700",NULL,NULL,NULL
  };
VCLBOXITEM cruise_alt[] =
   {
      "2000",NULL,"3000",NULL,"4000",NULL,"5000",NULL,"6000",NULL,
      "7000",NULL,"8000",NULL,"9000",NULL,"10000",NULL,"11000",NULL,
      "12000",NULL,NULL,NULL
   };
VCLBOXITEM mp[] =
   {
     "0",NULL,"16",NULL,"17",NULL,"18",NULL,"19",NULL,"20",NULL,"21",
     NULL,"22",NULL,"23",NULL,"24",NULL,"25",NULL,"26",NULL,"27",NULL,
     "28",NULL,"29",NULL,"30",NULL,"31",NULL,"32",NULL,"33",NULL,"34",
     NULL,"35",NULL,"36",NULL,"37",NULL,"38",NULL,"39",NULL, NULL,NULL
   };
VCLBOXITEM Aircraft_Complexity[] =
   { "REGULAR",NULL,"COMPLEX",NULL,NULL,NULL };
VCLBOXITEM AtmosphericData[] =
   { "ABOVE",NULL,"NORMAL",NULL,"BELOW",NULL,"DEFAULT",NULL,NULL,NULL };

/* declare function prototypes */
VCCOUNT WriteDBRecord(VCVOID);
VCCOUNT GetDefaultRecord( VCCOUNT altitude );
VCCOUNT GetNormalRecord( VCCOUNT altitude );
VCCOUNT GetHPRecord( VCCOUNT altitude );
VCCOUNT Calc_set_hp_array( VCVOID );
VCCOUNT NoRecord( VCVOID );
VCCOUNT RunProgram( VCVOID );
VCCOUNT DataEntryFunc( VCVOID );
VCCOUNT GetRecord( VCVOID );
VCCOUNT UpdateEntryForm( VCVOID );
VCCOUNT Clear_Edit_Fields(VCVOID);
VCCOUNT Quit_Verify( int a );
VCCOUNT get_a_key( VCVOID );
VCCOUNT winfilter( VCCOUNT msg, VCVOID *to, VCULONG p1,
		   VCULONG p2, VCULONG p3 );

/* ----------------added for upgrade --------------------- */
	 VCCOUNT ReadAircraftFile( VCOBJ *obj );
     VCCOUNT Clear_airStructfile(VCVOID);
     VCCOUNT CheckForUseair( VCVOID );
     VCCOUNT UpdateAirInfoField(VCVOID);
	 VCCOUNT No_Fileget( VCVOID ); 
     VCCOUNT ManageAirFile(VCVOID);
     VCCOUNT not_found(VCVOID);
     /* ------------------------------------------------------- */


 main()
   //int argc;
   //char *argv[];
   {
      /* initialize file elements to zeros */
      perform.tas = 0;
      perform.fc = 0;
      perform.rc = 0;
      perform.cs = 0;
      perform.bhp = 0;
      perform.rpm = 0;
      perform.mp = 0;

     /* code to make program key */
     //NotValid=strcmp(argv[1], password);
     //if(NotValid) {
     //  puts("Must be used with Flight Log Maker");
     //  exit(0);  }
     /* end key code */

     RunProgram();
     return (0);
   }

VCCOUNT RunProgram()
{
   VCWIN  *data;
   vcStart(VCCLRSCRN);



  /* open status line at top of page */
  vcStatOpen(0, 0, 0, 79, NULL, 0, 0, NULL);
   vcStatSay(" Performance File Manager 2           TAB=Select Fields                ESC=Quit ",vc.white|vc.bold|vc.green*vc.bg);

  data=vcWinOpenX(1,49,23,79,"",NULL,0,0,
		 vcStdBorder(),vcColorFromID(4));
  data->id=SAVEDATAWINID;

  /* set up high performance aircraft record number array */
  Calc_set_hp_array();

  DataEntryFunc();
  vcProcessEvents();
  
  /* delete these temporary files */
  system("del useplane");
  vcEnd();
  clrscr();
  return(VCSUCCESS);
}

VCCOUNT DataEntryFunc()
{
  VCWIN *win;
  VCOBJ *obj;
  VCFLAG flags;
  VCCOUNT SaveData(), DataExit(), GetData();
   
  VCCOUNT ReadOnly();

  /* reopen if it exists */
  if( (win=vcWinFromID(DATAENTRYWINID))!=NULL )
    return( vcSendMsg(VCWINSELECT,win,0L,0L,0L) );

  /* create window if it doesn't exist */
  win = vcCreateWin(NULL,1,0,23,48," Performance Data Entry",
	    VCWF_CURSOR,NULL,NULL,vcBorderFromID(1),vcColorFromID(4),
	    DATAENTRYWINID, winfilter);

  vcMouSetCapture(win,0);

// display that the aircraft is not loaded to start form 
    vcAtSayX(17,2, "No aircraft loaded yet                  ",
     vc.brown|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);

// make sure the complex / not complex status cleared also
    vcAtSayX(18,13, "                                        ",
	  vc.blue|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT); 
 
  if( win == NULL )
   vcTerror("Unable to open DataEntry.  Aborting");
 
/* Place file manager form objects here */
  flags=OBJGROUP|VCEF_INT|VCEF_ENDCAPS|VCEF_FLDBLANK;
  
  vcAtSay(3,2,"Aircraft");
  vcAtSay(4,2,"File:");
      obj28=vcEntryFldX(win, 5, 2, &AircraftInfo.ac_info_filename,
	   "XXXXXXXXXXXX",
	  OBJGROUP|VCEF_STRING|VCEF_FLDBLANK,NULL,
	   "8 characters Maximum plus \".air\"  Select \"Read\" to read an existing file",
	  NULL,NULL);
  
  obj=vcPushBtnX(win,7,2," Find  ", UpdateAirInfoField,
      OBJGROUP|VCPB_EXECUP,NULL,"find existing Aircraft information files",NULL,NULL); 
  
  obj=vcPushBtnX( win, 9, 2, " Read Aircraft File ", ReadAircraftFile,
	   OBJGROUP|VCPB_EXECUP,NULL,
	   "Enter Aircraft info file and \"read\" before anything else!",
	   NULL, vcColorFromID(12));
   
  vcListBoxX( win, 0, 15, 7, 4, AtmosphericData, OBJGROUP, &num6,
       NULL, "Enter the Atmospheric Conditions that Data represents",
       NULL, vcColorFromID(17), vcBorderFromID(1));
  vcAtSay(0,17, "FILE");
    
  vcListBoxX( win, 0, 24, 4, 8, rpm, OBJGROUP, &num2,
       NULL, "Select an RPM used for cruise",
       NULL, vcColorFromID(17), vcBorderFromID(1));
  vcAtSay(0,25,"RPM");

  vcListBoxX( win, 0, 31, 2, 8, mp, OBJGROUP|VCLB_SCROLLBAR, &num3,
       NULL, "MUST USE if aircraft has MANIFOLD PRESSURE GUAGE else leave at \"0\"",
       NULL, vcColorFromID(17), vcBorderFromID(1));
  vcAtSay(0,32,"MP");

  vcListBoxX( win, 0, 36, 5, 8, cruise_alt, OBJGROUP|VCLB_SCROLLBAR, &num4,
       NULL, "Select the Cruise Altitude for Data Entry",
       NULL, vcColorFromID(17), vcBorderFromID(1));
  vcAtSay(0,38,"ALT");

 
  
/* entry fields */

  vcAtSay(13,11,"TAS");
  entry_obj1=vcEntryFldX(win,13,16,(VCVOID *) &perform.tas,"###", flags, NULLFUNC,
      "Enter the True Airspeed for Selected Power Setting and Altitude",
       NULL, NULL);
  
  vcAtSay(15,11,"GPH");
  entry_obj2=vcEntryFldX(win,15,16, &perform.fc,"##.#",OBJGROUP|VCEF_DOUBLE|
	      VCEF_ENDCAPS|VCEF_FLDBLANK, NULLFUNC,
      "Enter the Fuel Consumption for Selected Power Setting and Altitude",
       NULL, NULL);
  
  vcAtSay(15,2,"BHP");
  entry_obj5=vcEntryFldX(win,15,6, &perform.bhp,"###", flags, NULLFUNC,
      "Enter the Brake Horse Power for Selected Power Setting and Altitude",
       NULL, NULL);
    
  vcAtSay(13,23,"ROC");
  entry_obj3=vcEntryFldX(win,13,28, &perform.rc,"####", flags,NULLFUNC,
      "Enter the Rate of Climb ( FPM ) for this Altitude",
       NULL, NULL);
   
  vcAtSay(15,24,"Vy");
  entry_obj4=vcEntryFldX(win,15,28, &perform.cs,"###", flags, NULLFUNC,
      "Enter the Best Rate of Climb Speed for this Altitude",
       NULL, NULL);
  

/* other push buttons */
  obj=vcPushBtnX(win,11,2," GET   ", GetData,OBJGROUP|VCPB_EXECUP,NULL,
	     "Select to get data from file - BE SURE TO UNLOCK FILE!",NULL,NULL);
  obj=vcPushBtnX(win,12,2," DATA  ", GetData,OBJGROUP|VCPB_EXECUP,NULL,
	     "Select to get data from file - BE SURE TO UNLOCK FILE!",NULL,NULL);
  
  obj=vcPushBtnX(win,11,37," SAVE  ", SaveData,
	OBJGROUP|VCPB_EXECUP,NULL,"Select to save data to file",NULL,NULL);
  obj=vcPushBtnX(win,12,37," DATA  ", SaveData,
	OBJGROUP|VCPB_EXECUP,NULL,"Select to save data to file",NULL,NULL);
 
  obj=vcPushBtnX(win,0,2,"       ", DataExit,OBJGROUP|VCPB_EXECUP,NULL,
	     "Return to Flight Log Maker",NULL,NULL);
  obj=vcPushBtnX(win,1,2," Exit  ", DataExit,OBJGROUP|VCPB_EXECUP,NULL,
	     "Return to Flight Log Maker",NULL,NULL);
  obj->id=EXITOBJID;
  vcStatOpen(24,0,24,79,NULL,0,1,NULL);
  vcStartForm(win,NULL);
  return(VCSUCCESS);
}

/* wait for keypress function */
 VCCOUNT get_a_key()
    {
	VCCOUNT key;
	  while( ((key=vcGetOne(NULL)) == MOUMOVE)
		|| (key==MOUB1UP) || (key==MOUB1MOVE) );
	  return(key);
     }
/* universal keypress filter */
 VCCOUNT winfilter(VCCOUNT msg, VCVOID *to, VCULONG p1,
		   VCULONG p2, VCULONG p3)
     {
       int a=0;  // initialize to zero
		 // 0= don't quit and 1 means quit
       VCCOUNT key;
       if(msg==KEYPRESS)  //if keypress
	{
	  key=p1&0xffff;  //get key
	  if(key==ESC)    //if esc exit
	  //end processing
	  if (Quit_Verify(a)) { // verify user really wants to quit program
	    return(vcPostMsg(VCTERMINATE, to, p1, p2, p3) );
	   }
	  }
      //if mouse events and not to current window
      if( (msg==MOUB1DOWN ) &&
	  (vcWinFromVoid(to) != wcurrent) )
	  {
	   return (VCSUCCESS); //eat message
	  }
      //allow other message on through system
      return( vcDefaultWinFilter(msg, to, p1, p2, p3 ) );
     }

/* ********************************************************* */
 VCCOUNT Quit_Verify( int a )
  {

    char p;
    VCWIN *e;
    vcMouHide();
    e = vcWinOpenX(7,20,10,60,"Warning!",
		     VCWF_CURSOR|VCWF_SHADOW,0,0,vcBorderFromID(1),
		     vcColorFromID(9));
    vcAtSay(0,  5, "Are you Sure you want to quit");
   vcAtSay(1, 5, "the file manager? Press Y or N!");
   vcStatSay("Press Y to exit and N cancel quit. ",
    vc.white|vc.bold|vc.blink|vc.blue*vc.bg);
    vcUpdateVIO();
	   p = getch();
	      switch (p)
		 {
		   case 'y' :
		   case 'Y' : a = 1;
			      break;
		   case 'n' :
		   case 'N' : a = 0;
			      break;
		   default  : a = 0;
			      break;
		 }
    vcMouShow();
    vcWinClose(e);
    return a;
  }

VCCOUNT UpdateEntryForm()
     {
       vcPutFldBuf(entry_obj1, &perform.tas);
	  vcPostMsg(VCOBJDRAW, entry_obj1,0L, 0L, 0L);
       vcPutFldBuf(entry_obj2, &perform.fc);
       vcPostMsg(VCOBJDRAW, entry_obj2,0L, 0L, 0L);
       vcPutFldBuf(entry_obj3, &perform.rc);
	  vcPostMsg(VCOBJDRAW, entry_obj3,0L, 0L, 0L);
       vcPutFldBuf(entry_obj4, &perform.cs);
	  vcPostMsg(VCOBJDRAW, entry_obj4,0L, 0L, 0L);
       vcPutFldBuf(entry_obj5, &perform.bhp);
	  vcPostMsg(VCOBJDRAW, entry_obj5,0L, 0L, 0L);

      vcUpdateVIO();
      return( VCSUCCESS );
     }

VCCOUNT Clear_Edit_Fields() {
	  perform.tas = 0;
      perform.fc = 0;
      perform.rc = 0;
      perform.cs = 0;
      perform.bhp = 0;
      perform.rpm = 0;
      perform.mp = 0;
  return(VCSUCCESS);
}    

/* This function is used to display the save information in the  */
/* data entry form. */
VCCOUNT SaveData( VCOBJ *obj )
{
 
  /* By ending a form, the form is marked NOT ACTIVE.  */
  /* The objects still exist in the form.              */
  vcSendMsg( VCENDFORM,(VCVOID *)obj->win, 0L, 0L, 0L );

  /* This is the point in which you could */
  /* write a record to a data base file.  */
  WriteDBRecord();

  /* A form can be reactivated by the following sent message. */
  vcSendMsg( VCSTARTFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
  return(VCSUCCESS);
}

VCCOUNT ReadOnly( VCOBJ *obj )
{
  VCWIN *win;
  
  VCCOUNT GetRecord();
  
  vcSendMsg( VCENDFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
  
  GetRecord();
  vcSendMsg( VCSTARTFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
  return(VCSUCCESS);
}

/* This function will get the data from the file */
VCCOUNT GetData( VCOBJ *obj )
{
  vcSendMsg( VCENDFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
  GetRecord();
  UpdateEntryForm();
  vcSendMsg( VCSTARTFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
  return(VCSUCCESS);
}

VCCOUNT WriteDBRecord()
{
  VCWIN *win;
  VCATTR attr;
  FILE *fp;
  int default_rec=0;
  int TestDefault, TestNormal, TestComplex;
  int LookAtNormal, LookAtAbove, LookAtBelow, LookAtDefault;

/* ********************************************** */
/* these were added to use in a loop to write zeros to a
   newly created file */
int Total_Records=0, temp_rec=0;
struct EMPTY_fltdata {
       int tas;
       double fc;
       int rc;
       int cs;
       int bhp;
       int rpm;
       int mp;
      } EMPTY_perform;
/* ********************************************** */
 
  
  int altitude=0, size, siz2;  /* saved from listbox */

/* select the display window for writing of all the
   information but erase anything that might be in
   it first */
win=vcWinFromID( SAVEDATAWINID );
vcWinErase( win,(vc.bg*vc.blue) );

/* initialize these comparison variables */
  LookAtNormal =1;
  LookAtAbove = 1;
  LookAtBelow = 1;
  LookAtDefault = 1;
  TestDefault = 1;
  TestNormal = 1;
  TestComplex = 1;

/* initialize dummy data to zeros */
  EMPTY_perform.tas=0;
  EMPTY_perform.fc=0;
  EMPTY_perform.rc=0;
  EMPTY_perform.cs=0;
  EMPTY_perform.bhp=0;
  EMPTY_perform.rpm=0;
  EMPTY_perform.mp=0;

/* save selections from listboxes */
 
  sprintf(buf1,"%s",rpm[num2-1]);
  perform.rpm=atoi(buf1);	     /* convert string to integer */
  sprintf(buf1,"%s",mp[num3-1]);
  perform.mp=atoi(buf1);
  sprintf(buf1,"%s",cruise_alt[num4-1]);
  (int)altitude=atoi(buf1);
  sprintf(buf1,"%s",AtmosphericData[num6-1]);
  strcpy(atmosphere,buf1);

/* calc record number */
  TestDefault = strcmp("DEFAULT", atmosphere);
 
  if (AircraftInfo.is_complex == 1 ) TestComplex = MATCH; /* zero value means complex */
    else TestNormal = MATCH ;
/* check for incorrect structure usage */
  if( ( perform.mp != 0 ) && ( TestNormal == MATCH ) &&
      ( TestDefault != MATCH) )  {
     NoRecord();
     return( VCSUCCESS );
    }


/* assign the record type to default_rec variable
* this will be used for calculating the number of
* records to be placed in the file and the formulas
* used to calculate the record number */

    if( TestDefault == MATCH ) {
      default_rec = GetDefaultRecord(altitude);
      }

      if( (TestNormal == MATCH ) && (TestDefault != MATCH ) ) {
      default_rec = GetNormalRecord( altitude );
      }

      if( (TestComplex == MATCH ) && (TestDefault != MATCH ) ) {
      default_rec = GetHPRecord( altitude );
      }
 
/* check for a bad record number when normal aircraft selected
** with complex file structure selected */
  if( !default_rec ) { NoRecord(); return(VCSUCCESS); }

  if( (AircraftInfo.is_complex == TRUE) && (perform.mp == 0) )
     { NoRecord(); return(VCSUCCESS); }
  if( (AircraftInfo.is_complex == FALSE) && (perform.mp != 0) )
     { NoRecord(); return(VCSUCCESS); }
 

/* test for normal record type */
  LookAtNormal = strcmp("NORMAL",atmosphere);
   if( LookAtNormal == MATCH ) {
      strcpy(current_file, AircraftInfo.n_file);
     }
  LookAtAbove = strcmp("ABOVE",atmosphere);
   if( LookAtAbove == MATCH ) {
      strcpy(current_file, AircraftInfo.a_file);
     }
  LookAtBelow = strcmp("BELOW",atmosphere);
   if( LookAtBelow == MATCH ) {
      strcpy(current_file, AircraftInfo.b_file);
      }
  LookAtDefault = strcmp("DEFAULT",atmosphere);
   if( LookAtDefault == MATCH ) {
      strcpy(current_file, AircraftInfo.d_file);
      }

/* see if the file exists */
  if((fp = fopen(current_file,"r+b")) == NULL) {
     vcStatSay("Creating file",vc.brown|vc.bold|vc.blue*vc.bg);
/* create it if it does not */
     if((fp = fopen(current_file,"wb")) == NULL) {
       vcStatSay("Can't open any more files!",vc.brown|vc.bold|vc.blue*vc.bg);
       vcWinErase( win,(vc.bg*vc.blue) );
       vcUpdateVIO();
      }
/* new file is still open for "wb" so do test to get the proper number of
   records to write and write some zeros to each record */
     if( TestDefault == MATCH) Total_Records = 12;
     if( (TestNormal == MATCH) && ( TestDefault != MATCH) ) Total_Records = 109;
     if( (TestComplex == MATCH) && ( TestDefault != MATCH) ) Total_Records = 2201;
  
  for (temp_rec = 1; temp_rec < Total_Records; temp_rec++) {
	fseek(fp, (temp_rec-1) * sizeof(struct EMPTY_fltdata), SEEK_SET);
	fwrite(&EMPTY_perform, sizeof(struct EMPTY_fltdata),1,fp);
       } /* end for loop */
     } /* end fp = fopen r + b... */
   fclose(fp);

/* print selections to other window */
   if(LookAtNormal == MATCH) {
     vcWinAtSay(win,3,1,"Temperature:");
     vcWinAtSayX(win,4,1, atmosphere,
     vc.green|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
    }
   if(LookAtAbove == MATCH) {
     vcWinAtSay(win,3,1,"Temperature:");
     vcWinAtSayX(win,4,1, atmosphere,
     vc.red|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
    }
    if(LookAtBelow == MATCH) {
     vcWinAtSay(win,3,1,"Temperature:");
     vcWinAtSayX(win,4,1, atmosphere,
     vc.blue|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
    }
    if(LookAtDefault == MATCH) {
     vcWinAtSay(win,3,1,"Temperature:");
     vcWinAtSayX(win,4,1, atmosphere,
     vc.magenta|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
    }
 
  
  /* ------------------------------------------ */
   if(AircraftInfo.is_complex == TRUE) {
      vcWinAtSay(win,5,1,"File Type:");
      vcWinAtSayX(win,6,1, "COMPLEX",
      vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     }  else  { vcWinAtSay(win,5,1,"File Type:");
      vcWinAtSayX(win,6,1, "REGULAR",
      vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT); }
    
    if( (AircraftInfo.is_complex == TRUE) && (TestDefault == MATCH) ){
      vcWinAtSay(win,5,1,"File Type:");
      vcWinAtSayX(win,6,1, "COMPLEX/DEFAULT",
      vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     }  
    if( (AircraftInfo.is_complex == FALSE) && (TestDefault == MATCH) ){
      vcWinAtSay(win,5,1,"File Type:");
      vcWinAtSayX(win,6,1, "REGULAR/DEFAULT",
      vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     } 
  
 /* ------------------------------------------ */  
  vcWinAtSay(win,7,1,"True Airspeed:");
  vcAtSayNumX(win,8,1,(VCVOID *)&perform.tas,"###",VCOF_INT,
   vc.green|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);
  vcWinAtSay(win,9,1,"Fuel Consumption:");
  vcAtSayNumX(win,10,1, &perform.fc,"##.#",VCOF_DOUBLE,
   vc.green|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);
  vcWinAtSay(win,11,1,"Rate of Climb:");
  vcAtSayNumX(win,12,1, &perform.rc,"####",VCOF_INT,
   vc.green|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);
  vcWinAtSay(win,13,1,"Climb Speed (Vy):");
  vcAtSayNumX(win,14,1, &perform.cs,"###",VCOF_INT,
   vc.green|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);
  vcWinAtSay(win,15,1,"Brake Horspower:");
  vcAtSayNumX(win,16,1, &perform.bhp,"###",VCOF_INT,
   vc.green|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);
  vcWinAtSay(win,17,1,"Rpm    MP     Alt");
  vcAtSayNumX(win,18,1, &perform.rpm,"####",VCOF_INT,
   vc.green|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);
  vcWinAtSay(win,18,6,"/");
  vcAtSayNumX(win,18,8, &perform.mp,"##",VCOF_INT,
   vc.green|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);
  vcWinAtSay(win,18,11,"/");
  vcAtSayNumX(win,18,13, &altitude,"#####",VCOF_INT,
   vc.green|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);
  vcWinAtSayX(win,2,1, current_file,
   vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
  vcWinAtSay(win,1,1,"Record #:");
  vcAtSayNumX(win,1,10, &default_rec,"####",VCOF_INT,
   vc.red|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);


/* if complex airplane  - open file for writing this way */
    if( TestComplex == MATCH) {
       if((fp = fopen(current_file,"r+b")) == NULL) {
	   vcWinErase( win,(vc.bg*vc.blue) );
	   vcWinAtSay(win,11,1,"Can't open file");
	   fclose(fp);
	   vcUpdateVIO();
	 return( VCSUCCESS );
	}
/* find the complex file record */
       if(fseek(fp, (default_rec-1) * sizeof(struct fltdata), SEEK_SET)!=0) {
	 vcWinErase( win,(vc.bg*vc.blue) );
	 vcWinAtSay(win,11,1,"Can't read record");
	 fclose(fp);
	 vcUpdateVIO();
	 return( VCSUCCESS );
	}
/* write to the complex file */
       if(fwrite(&perform, sizeof(struct fltdata), 1, fp)!=1) {
	 vcWinErase( win,(vc.bg*vc.blue) );
	 vcWinAtSay(win,11,1,"Can't write file");
	 fclose(fp);
	 vcUpdateVIO();
	 return( VCSUCCESS );
	}
       fclose(fp);
   }  /* if testcomplex == match */

/* if normal airplane  - open file for writing this way */
    if( TestNormal == MATCH ) {
	if((fp = fopen(current_file,"r+b")) == NULL) {
	 vcWinErase( win,(vc.bg*vc.blue) );
	 vcWinAtSay(win,11,1,"Can't open file");
	 fclose(fp);
	 vcUpdateVIO();
	 return( VCSUCCESS );
	}
/* find the record */
       if(fseek(fp, (default_rec-1) * sizeof(struct fltdata), SEEK_SET)!=0) {
	 vcWinErase( win,(vc.bg*vc.blue) );
	 vcWinAtSay(win,11,1,"Can't find record");
	 fclose(fp);
	 vcUpdateVIO();
	 return( VCSUCCESS );
	}
/* write to the normal file */
       if(fwrite(&perform, sizeof(struct fltdata), 1, fp)!=1) {
	 vcWinErase( win,(vc.bg*vc.blue) );
	 vcWinAtSay(win,11,1,"Can't write file");
	 fclose(fp);
	 vcUpdateVIO();
	 return( VCSUCCESS );
	}
      fclose(fp);
     }

/* if default airplane  - open file for writing this way */
     if( TestDefault == MATCH ) {
       if((fp = fopen(current_file,"r+b")) == NULL) {
       vcWinErase( win,(vc.bg*vc.blue) );
       vcWinAtSay(win,11,1,"Can't open file");
       fclose(fp);
       vcUpdateVIO();
       return( VCSUCCESS );
      }
/* find the record */
      if(fseek(fp, (default_rec-1) * sizeof(struct fltdata), SEEK_SET) != 0) {
       vcWinErase( win,(vc.bg*vc.blue) );
       vcWinAtSay(win,11,1,"Can't find record");
       fclose(fp);
       vcUpdateVIO();
       return( VCSUCCESS );
      }
/* write to the default file */
      if(fwrite(&perform, sizeof(struct fltdata), 1, fp) != 1) {
       vcWinErase( win,(vc.bg*vc.blue) );
       vcWinAtSay(win,11,1,"Can't write file");
       fclose(fp);
       vcUpdateVIO();
       return( VCSUCCESS );
      }
    fclose(fp);
   }

   vcWinAtSay(win,1,17,"Saved...");

/* reset some items now to prevent the same size file from being
   opened all the time while still working within program */
   TestDefault = 1; TestNormal = 1; TestComplex = 1; Total_Records = 0;
  return(VCSUCCESS);
}

VCCOUNT GetRecord() {

 VCWIN *win;
 VCATTR attr;
 FILE *fp;
int default_rec = 0;
int TestDefault, TestNormal, TestComplex;
int LookAtNormal, LookAtAbove, LookAtBelow, LookAtDefault;

int altitude;  /* saved from listbox */

/* change to the data display window for writing */
win=vcWinFromID( SAVEDATAWINID );
vcWinErase( win,(vc.bg*vc.blue) );

/* reset selections from listboxes */
 
  LookAtNormal =1;
  LookAtAbove = 1;
  LookAtBelow = 1;
  LookAtDefault = 1;
  TestDefault = 1;
  TestNormal = 1;
  TestComplex = 1;

 /* save listbox selections */
  sprintf(buf1,"%s",rpm[num2-1]);
  perform.rpm=atoi(buf1);	     /* convert string to integer */
  sprintf(buf1,"%s",mp[num3-1]);
  perform.mp=atoi(buf1);
  sprintf(buf1,"%s",cruise_alt[num4-1]);
  (int)altitude=atoi(buf1);
  sprintf(buf1,"%s",AtmosphericData[num6-1]);
  strcpy(atmosphere,buf1);


/* calc record number */
  TestDefault = strcmp("DEFAULT", atmosphere);
 
  if (AircraftInfo.is_complex == TRUE ) TestComplex = MATCH; /* zero value means complex */
    else { TestComplex = NOMATCH ; TestNormal = MATCH ; }

/* assign the record type to default_rec variable
* this will be used for calculating the number of
* records to be placed in the file and the formulas
* used to calculate the record number */

    if( TestDefault == MATCH ) {
      default_rec = GetDefaultRecord(altitude);
      }

      if( (TestNormal == MATCH ) && (TestDefault != MATCH ) ) {
      default_rec = GetNormalRecord( altitude );
      }

      if( (TestComplex == MATCH ) && (TestDefault != MATCH ) ) {
      default_rec = GetHPRecord( altitude );
      }
 

/* check for a bad record number when normal aircraft selected
** with complex file structure selected */
  if( !default_rec ) { NoRecord(); Clear_Edit_Fields(); return(VCSUCCESS); }

  if( (AircraftInfo.is_complex == TRUE) && (perform.mp == 0) )
     { NoRecord(); Clear_Edit_Fields();	return(VCSUCCESS); }
  if( (AircraftInfo.is_complex == FALSE) && (perform.mp != 0) )
     { NoRecord(); Clear_Edit_Fields(); return(VCSUCCESS); }

 
/* assign current file the filename to use */
  LookAtNormal = strcmp("NORMAL",atmosphere);
   if( LookAtNormal == MATCH ) {
      strcpy(current_file, AircraftInfo.n_file);
     }
  LookAtAbove = strcmp("ABOVE",atmosphere);
   if( LookAtAbove == MATCH ) {
      strcpy(current_file, AircraftInfo.a_file);
     }
  LookAtBelow = strcmp("BELOW",atmosphere);
   if( LookAtBelow == MATCH ) {
      strcpy(current_file, AircraftInfo.b_file);
      }
  LookAtDefault = strcmp("DEFAULT",atmosphere);
   if( LookAtDefault == MATCH ) {
      strcpy(current_file,AircraftInfo.d_file);
     }

/* open complex file for reading */
    if( TestComplex == MATCH ) {
	 if((fp = fopen(current_file,"r+b")) == NULL) {
	 vcWinErase( win,(vc.bg*vc.blue) );
	 vcWinAtSay(win,11,1,"Can't open H.P. File");
	 vcWinAtSay(win,12,1, current_file);
	 fclose(fp);
	 Clear_Edit_Fields();
	 vcUpdateVIO();
	 return( VCSUCCESS );
	}
/* find the record */
       if(fseek(fp, (default_rec-1) * sizeof(struct fltdata), SEEK_SET)!=0) {
	 vcWinErase( win,(vc.bg*vc.blue) );
	 vcWinAtSay(win,11,1,"Can't find record");
	 fclose(fp);
	 vcUpdateVIO();
	 return( VCSUCCESS );
	}
/* read the file */
       if(fread(&perform, sizeof(struct fltdata), 1, fp)!=1) {
	 vcWinErase( win,(vc.bg*vc.blue) );
	 vcWinAtSay(win,11,1,"Error reading file");
	 fclose(fp);
	 vcUpdateVIO();
	 return( VCSUCCESS );
	}
       fclose(fp);
      }

/* open the normal airplane file for reading */
    if( TestNormal == MATCH ) {
	if((fp = fopen(current_file,"r+b")) == NULL) {
	 vcWinErase( win,(vc.bg*vc.blue) );
	 vcWinAtSay(win,11,1,"Can't open normal file");
	 fclose(fp);
	 Clear_Edit_Fields();
	 vcUpdateVIO();
	 return( VCSUCCESS );
	}
/* find the record */
       if(fseek(fp, (default_rec-1) * sizeof(struct fltdata), SEEK_SET)!=0) {
	vcWinErase( win,(vc.bg*vc.blue) );
	vcWinAtSay(win,11,1,"Can't find record");
	fclose(fp);
	vcUpdateVIO();
	return( VCSUCCESS );
	}
/* read the normal airplane file */
       if(fread(&perform, sizeof(struct fltdata), 1, fp)!=1) {
	 vcWinErase( win,(vc.bg*vc.blue) );
	 vcWinAtSay(win,11,1,"Can't read record");
	 fclose(fp);
	 vcUpdateVIO();
	 return( VCSUCCESS );
	}
      fclose(fp);
     }

/* open the default file for reading */
    if( TestDefault == MATCH ) {
       if((fp = fopen(current_file,"r+b")) == NULL) {
       vcWinErase( win,(vc.bg*vc.blue) );
       vcWinAtSay(win,11,1,"Can't open default file");
       vcWinAtSay(win,12,1, current_file);
       fclose(fp);
       Clear_Edit_Fields();
       vcUpdateVIO();
       return( VCSUCCESS );
      }
/* find the record */
      if(fseek(fp, (default_rec-1) * sizeof(struct fltdata), SEEK_SET) != 0) {
       vcWinErase( win,(vc.bg*vc.blue) );
       vcWinAtSay(win,11,1,"Can't find record");
       fclose(fp);
       vcUpdateVIO();
       return( VCSUCCESS );
      }
/* read the default file */
      if(fread(&perform, sizeof(struct fltdata), 1, fp) != 1) {
       vcWinErase( win,(vc.bg*vc.blue) );
       vcWinAtSay(win,11,1,"Can't read record");
       fclose(fp);
       vcUpdateVIO();
       return( VCSUCCESS );
      }
    fclose(fp);
    vcWinErase( win,(vc.bg*vc.blue) );
    vcUpdateVIO();
   }

/* print findings to data display window */
if(LookAtNormal == MATCH) {
     vcWinAtSay(win,3,1,"Temperature:");
     vcWinAtSayX(win,4,1, atmosphere,
     vc.green|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
    }
   if(LookAtAbove == MATCH) {
     vcWinAtSay(win,3,1,"Temperature:");
     vcWinAtSayX(win,4,1, atmosphere,
     vc.red|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
    }
    if(LookAtBelow == MATCH) {
     vcWinAtSay(win,3,1,"Temperature:");
     vcWinAtSayX(win,4,1, atmosphere,
     vc.blue|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
    }
    if(LookAtDefault == MATCH) {
     vcWinAtSay(win,3,1,"Temperature:");
     vcWinAtSayX(win,4,1, atmosphere,
     vc.magenta|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
    }
    if(AircraftInfo.is_complex == TRUE) {
      vcWinAtSay(win,5,1,"File Type:");
      vcWinAtSayX(win,6,1, "COMPLEX",
      vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     }  else  { vcWinAtSay(win,5,1,"File Type:");
      vcWinAtSayX(win,6,1, "REGULAR",
      vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT); }
    
    if( (AircraftInfo.is_complex == TRUE) && (TestDefault == MATCH) ){
      vcWinAtSay(win,5,1,"File Type:");
      vcWinAtSayX(win,6,1, "COMPLEX/DEFAULT",
      vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     }  
    if( (AircraftInfo.is_complex == FALSE) && (TestDefault == MATCH) ){
      vcWinAtSay(win,5,1,"File Type:");
      vcWinAtSayX(win,6,1, "REGULAR/DEFAULT",
      vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     }  
  
  
  
  vcWinAtSay(win,7,1,"True Airspeed:");
  vcAtSayNumX(win,8,1, &perform.tas,"###",VCOF_INT,
   vc.green|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);
  vcWinAtSay(win,9,1,"Fuel Consumption:");
  vcAtSayNumX(win,10,1, &perform.fc,"##.#",VCOF_DOUBLE,
   vc.green|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);
  vcWinAtSay(win,11,1,"Rate of Climb:");
  vcAtSayNumX(win,12,1, &perform.rc,"####",VCOF_INT,
   vc.green|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);
  vcWinAtSay(win,13,1,"Climb Speed (Vy):");
  vcAtSayNumX(win,14,1, &perform.cs,"###",VCOF_INT,
   vc.green|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);
  vcWinAtSay(win,15,1,"Brake Horspower:");
  vcAtSayNumX(win,16,1, &perform.bhp,"###",VCOF_INT,
   vc.green|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);
  vcWinAtSay(win,17,1,"Rpm    MP     Alt");
  vcAtSayNumX(win,18,1, &perform.rpm,"####",VCOF_INT,
   vc.green|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);
  vcWinAtSay(win,18,6,"/");
  vcAtSayNumX(win,18,8, &perform.mp,"##",VCOF_INT,
   vc.green|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);
  vcWinAtSay(win,18,11,"/");
  vcAtSayNumX(win,18,13, &altitude,"#####",VCOF_INT,
   vc.green|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);
  vcWinAtSayX(win,2,1, current_file,
   vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
  vcWinAtSay(win,1,1,"Record #:");
  vcAtSayNumX(win,1,10, &default_rec,"####",VCOF_INT,
   vc.red|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);
  return(VCSUCCESS);
 }

/* exits program */
VCCOUNT DataExit( VCOBJ *obj )
   {
      int a=0; // zero equals don't quit program
	       // one quits the program
      if (Quit_Verify(a)) {
      vcEndForm(obj->win);
      vcDelFile("trip");
      vcPostMsg(VCTERMINATE,obj->win,0L,0L,0L);
      return(VCTERMINATE);
     }
     else return(VCSUCCESS);
   }

/* my error functions */

VCCOUNT NoRecord()
  {
    VCWIN *e;
    VCWIN *win;
/* clear the data display window. */
win=vcWinFromID( SAVEDATAWINID );
vcWinErase( win,(vc.bg*vc.blue) );
    
    e = vcWinOpenX(5,6,13,59," Error! ",
		     NULL,0,0,vcBorderFromID(5),
		     vcColorFromID(20));
    vcCurHide(vccrt);
    vcAtSay(0,2,"Aircraft not loaded or aircraft loaded does not");
    vcAtSay(1,2,"match the selections made for saving" );
    vcAtSay(2,2,"the file properly!  Use MP value of 0 for");
    vcAtSay(3,2,"regular aircraft and a valid MP value for ");
    vcAtSay(4,2,"complex aircraft.  Press any key then adjust");
    vcAtSay(5,2,"your selection or re-load aircraft info. file.");
    vcStatSay("error with aircraft info file or power selection! "
		     ,vc.white|vc.bold|vc.blink|vc.blue*vc.bg);
    
    vcUpdateVIO();
    get_a_key();
    vcCurShow(vccrt);
    vcWinClose(e);
    return(VCSUCCESS);
  }

/* function to get Default Record */
VCCOUNT GetDefaultRecord( int altitude) {
  int record_num;
  record_num = (((int)altitude / 1000) - 1);
  return  record_num;
 }

/* function to get normal record */
VCCOUNT GetNormalRecord( int altitude ) {
	 int regular_rec;
	 int a, r;
	 a = altitude;
	 r = (int)perform.rpm;
	 a /= 100;
	 r /= 100;
	 regular_rec = (a + r) - 39;
	 return regular_rec;
      }

/* function to get high performance aircraft record */
VCCOUNT GetHPRecord( int altitude ) {
	 hp_index = altitude + (int)perform.rpm + (int)perform.mp;
	 highperf_record=performance[hp_index];
	return (int)highperf_record;
      }

VCCOUNT ReadAircraftFile( VCOBJ *obj ) {
FILE *fp;

VCWIN *win;
/* clear the data display window. */
win=vcWinFromID( SAVEDATAWINID );
vcWinErase( win,(vc.bg*vc.blue) );

/* this step saves all of the objects in the form before reading */
    vcSendMsg( VCENDFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
	
	/* see if the filename exists, then open it if it does */
	/* use r+b for reading and writing rb for read only */
	if ((fp = fopen(AircraftInfo.ac_info_filename,"r+b")) != NULL)
	  {
	   fseek(fp, record_length, SEEK_SET);
	   fread(&AircraftInfo, sizeof(struct AircraftStructure),1,fp);
	   fclose(fp); 
	   Clear_Edit_Fields(); UpdateEntryForm(); }
	   else { not_found(); button1 = 0;
	   Clear_Edit_Fields(); Clear_airStructfile();
	   UpdateEntryForm();
	   
	   vcSendMsg( VCSTARTFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
	    
	    vcUpdateVIO(); /* just added */
	    return(VCSUCCESS); }

/* print the message */
// clear the line before printing aircraft that is loaded    
    vcAtSayX(17,2, "                                               ",
	  vc.blue|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);
    
    vcAtSayX(17,2, "Loaded:",
	  vc.brown|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);
    
    vcAtSayX(17,10, AircraftInfo.name,
	  vc.brown|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);
    if(AircraftInfo.is_complex == TRUE) vcAtSayX(19,2, "This aircraft is complex.",
	  vc.brown|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);

    if(AircraftInfo.is_complex == FALSE) vcAtSayX(19,2, "This aircraft is regular.",
	  vc.brown|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);
                 
    button1 = 0;
    
    vcSendMsg( VCSTARTFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
   return(VCSUCCESS);
  }

/* error function: warns if file not found */
	VCCOUNT not_found()
	{
	VCWIN *e;
	VCWIN *win;
/* clear the data display window. */
win=vcWinFromID( SAVEDATAWINID );
vcWinErase( win,(vc.bg*vc.blue) );
	
	vcCurHide(vccrt);
	e = vcWinOpenX(7,10,13,70," Error with filename! ",
		 NULL,0,0,vcBorderFromID(5),
		 vcColorFromID(20));
	Clear_airStructfile();
	vcAtSay(1,15,"That file was not found.");
	vcAtSay(2,15,"Recheck the filename entered.");
	vcAtSay(3,15,"Aircraft Structure being cleared.");
	vcStatSay("Cannot find a file by the name used."
		 ,vc.brown|vc.bold|vc.blue*vc.bg);
	
	vcUpdateVIO();
	get_a_key();
	vcCurShow(vccrt);
	vcWinClose(e);
 // clear any previous message and set message to below
    vcAtSayX(17,2, "                                      ",
	  vc.brown|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);   
    vcAtSayX(17,2, "No aircraft loaded                      ",
	  vc.brown|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);    
 
	return(VCSUCCESS);
	}

VCCOUNT Clear_airStructfile()  {
   *AircraftInfo.ac_info_filename = NULL;
   *AircraftInfo.name = NULL;
   *AircraftInfo.a_file = NULL;
   *AircraftInfo.b_file = NULL;
   *AircraftInfo.n_file = NULL;
   *AircraftInfo.d_file = NULL;
   *AircraftInfo.cgd_file = NULL;
   AircraftInfo.is_complex = FALSE; 
 return (VCSUCCESS);
}

VCCOUNT CheckForUseair()
 {
  /* see if wb executable exists */
  VCCOUNT stat;
  FILE *exist;
       if((exist = fopen("fileget.exe","rb")) != NULL ) {
	      stat = 0;
	      fclose(exist);
	     }
	    else
	     stat = -1;
   return stat;
  }

VCCOUNT ManageAirFile()
{
  union REGS regs;
  struct SREGS s;
  VCCOUNT stat;
  VCTEXT *savebuf;
  VCTEXT *comspec;
  VCCOORD r,c;

  
/* See how much memory we need to save  */
  regs.x.ax = 21;
  int86( 0x33, &regs, &regs );
  savebuf = (VCVOID *)vcAlloc( 1, regs.x.bx );

  comspec = getenv("COMSPEC");

  if( savebuf != (VCTEXT *)0 && comspec != (VCTEXT *)0 )
    {
    /* save mouse state */
    regs.x.ax = 22;
    regs.x.dx = FP_OFF( savebuf );
    s.es =      FP_SEG( savebuf );
    int86x( 0x33, &regs, &regs, &s );

    /* reset mouse for a polite exit */
    regs.x.ax = 33;
    int86( 0x33, &regs, &regs );
     vc_WinPut( vccrt->rw );
     vcUpdateVIO();
     vcAt( 0, 0 );
    /********** */
    /* check for program to list trip files */
    stat=CheckForUseair();
    if(stat == 0)             {
       vcUpdateVIO();
       vcAt( 0, 0 );
        
       system("fileget.exe ????????.air");  }  /* change to wb front page when created */
    if(stat < 0)
      No_Fileget();

    /* restore mouse state */
    regs.x.ax = 23;
    regs.x.dx = FP_OFF( savebuf );
    s.es =      FP_SEG( savebuf );
    int86x( 0x33, &regs, &regs, &s );
    vcFree( savebuf );

    /* restore original Vitamin C display */
    vc_WinPut( vccrt->rw );
    vc_WinPutBranch( vccrt->rw );

  r = wcurrent->r;
  c = wcurrent->c;
  if( vccrt->cursor.hidden ||                    // if hidden
      (wcurrent->hidecnt)   ||                   // or hidecount
      !(wcurrent->flags & VCWF_CURSOR)  ||       // or cursorless
      vcObsPoint(wcurrent, &r, &c) == -1 )       // or obscured
    {
    vccrt->cursor.cswitch = VCOFF;
    vccrt->cursor.ctrans  = 1;
    }
  else
    {
    vccrt->cursor.cswitch = VCON;
    vccrt->cursor.ctrans  = 1;
    }
  if( vccrt->cursor.cfunc )
    (*vccrt->cursor.cfunc)(vccrt, r, c);
      vcMouSetPos(9,15);                   // prevents pushing button twice
     vcUpdateVIO();
    }
  else
    vcBell();
return( VCSUCCESS );
}  

VCCOUNT UpdateAirInfoField()  {
   FILE *fp; /* temporary pointer to read ac tailnumber string from file */
 
 /* clear space in case previous message was here
  * because some messages take of different amounts of space */
    vcAtSayX(17,2, "                                      ",
	  vc.blue|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);

// set message that aircraft hasn't been loaded yet 
    vcAtSayX(17,2, "No aircraft loaded yet                  ",
  	  vc.brown|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);
      
// clear info about not complex / complex engine    
    vcAtSayX(19,2, "                                      ",
	  vc.blue|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT); 
    vcUpdateVIO(); 
    
    Clear_airStructfile();
    
    ManageAirFile();

/* open a file to get the aircraft tail number string */
       if((fp=fopen("useplane","r"))!=NULL)  {
	 fseek(fp,0 * sizeof(struct info_name),SEEK_SET);
	 fread(&Info_Path,sizeof(struct info_name),1,fp);
	 fclose(fp); }
       strncpy(AircraftInfo.ac_info_filename, Info_Path.info_name, 13);
       AircraftInfo.ac_info_filename[13] = '\0';
       vcPutFldBuf(obj28, &AircraftInfo.ac_info_filename);
	  vcPostMsg(VCOBJDRAW, obj28,0L, 0L, 0L);
      vcUpdateVIO();
       
      return( VCSUCCESS );
     }    
     
VCCOUNT No_Fileget()
     {
       VCWIN *n;
       
	 n = vcWinOpenX(8,5,16,65," Program \"FILEGET\" missing!  ",VCWF_SHADOW,
	    0,0,vcBorderFromID(1),vcColorFromID(9));
	 vcAtSay(1, 1,"Could not Find: \"fileget.EXE");
	 vcAtSay(2, 1,"This program and all supporting files");
	 vcAtSay(3, 1,"Must be in Flight Log Maker's Directory!");
	 vcAtSay(5, 1,"Press any keyboard key to continue...");
	 vcStatSay("                                    Error", vc.white|vc.bold|vc.blink|vc.blue*vc.bg);
	 vcUpdateVIO();
	 get_a_key();
	 vcWinClose(n);
       return( VCSUCCESS );
    }
      
 
 /* end */
