/* New_AC.c...Program to add new aircraft to use
 * with Flight Log Maker program.  Written by Ronald Lewis 2012 */
#include <vcstdio.h>
#define SESSIONWINID    101
#define OUTPUTWINID     102
#define SAVEDATAWINID   103
#define EditQuestionWINID   104
#define EXITOBJID       201

/* structure to hold Aircraft information in the
 * aircraft information file */
struct AircraftStructure
{
    char ac_info_filename[13];
    char name[31];
    char a_file[13];
    char b_file[13];
    char n_file[13];
    char d_file[13];
    char cgd_file[13];
    int is_complex; /* Complex airplane? */
    float ac_fuelcapacity; /* Added on 2/2016 */
} AircraftInfo;

/* structure for aircraft info file name string */
struct info_name
{
    char info_name[70];
} Info_Path;

/* function prototypes */
VCCOUNT Is_file_already_in_use( VCVOID );
VCCOUNT ManageFM( VCVOID );
VCCOUNT CheckForFM( VCVOID );
VCCOUNT NoFM( VCVOID );
VCCOUNT ManageCG( VCVOID );
VCCOUNT CheckForCGMAN( VCVOID );
VCCOUNT No_CGMAN(VCVOID);
VCCOUNT Set_RadioButtonComplex( VCOBJ *obj );
VCCOUNT Reset_RadioButtonComplex( VCOBJ *obj );

/* ----------------------------- */
VCCOUNT No_Fileget( VCVOID );
VCCOUNT CheckForUseair( VCVOID );
VCCOUNT UpdateAirInfoField( VCVOID );
VCCOUNT ClearFormFirst( VCVOID );

/* global window pointers */
VCWIN *win, *help;

/* declare a file pointer */
FILE *fp;

/* declare some constants that cannot be changed */
const TRUE = 1, FALSE = 0;

VCCOUNT button1 = 0;

VCCOUNT record_length = 1;


/* entry field objects - for clearing function */
VCOBJ  *obj0, *obj1, *obj2, *obj3, *obj4, *obj5, *obj6, *obj28;

void main(void)
{
    vcStart(VCCLRSCRN);
    win=vcWinOpenX(12,1,23,79,"",VCWF_VERTSB,30,76,
                   vcStdBorder(),vcColorFromID(1));

    win->id=OUTPUTWINID;

    MainControlForm();

    vcProcessEvents();
    system("del useplane");
    vcEnd();

    clrscr();
}



VCCOUNT MainControlForm()
{
    VCWIN *win;
    VCOBJ *obj;



    VCCOUNT SaveData(VCOBJ *obj), ReadData(VCOBJ *obj);
    VCCOUNT DataExit( VCOBJ *obj );
    VCCOUNT DataInpFilter(VCCOUNT msg, VCVOID *to, VCULONG p1, VCULONG p2, VCULONG p3);

    if( (win=vcWinFromID(SESSIONWINID))!= NULL )
        return( vcSendMsg(VCWINSELECT,win,0L,0L,0L));

    /* open status line at top of page */
    vcStatOpen(0, 0, 0, 79, NULL, 0, 0, NULL);
    vcStatSay(" Flight Log Maker 5 Aircraft Creator    Tab=Select Fields              ESC=Quit  ",vc.white|vc.bold|vc.green*vc.bg);
    win = vcCreateWin( NULL, 1, 0, 23, 79," Aircraft Information Panel ",
                       VCWF_CURSOR,NULL,NULL,vcBorderFromID(1),
                       vcColorFromID(4), EditQuestionWINID, DataInpFilter);


    /* draw the objects */

    vcAtSay(1,5,"Aircraft Name");
    obj0 = vcEntryFldX(win, 1, 19, &AircraftInfo.name,
                       "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
                       OBJGROUP|VCEF_STRING|VCEF_FLDBLANK,NULL,
                       "Type in the Name of the Aircraft",
                       NULL,NULL);

    vcAtSay(13,2,"Aircraft");
    vcAtSay(14,2,"File:");
    obj28=vcEntryFldX(win, 14, 9, &AircraftInfo.ac_info_filename,
                      "XXXXXXXXXXXX",
                      OBJGROUP|VCEF_STRING|VCEF_FLDBLANK,NULL,
                      "8 characters Maximum plus \".air\"  Select \"Read\" to read an existing file",
                      NULL,NULL);

    obj=vcPushBtnX(win,16,9," Find  ", UpdateAirInfoField,
                   OBJGROUP|VCPB_EXECUP,NULL,"find existing Aircraft information files",NULL,NULL);

    vcAtSay(2,51,"Performance Tags");
    vcPushBtnX(win,3,46," Complex/High Performance ", Set_RadioButtonComplex,OBJGROUP|VCPB_EXECUP,NULL,
               "Sets the aircraft as a high performance or complex airplane","DATA_ENTRY",NULL);

    vcPushBtnX(win,5,46," Not Complex/High Performance ", Reset_RadioButtonComplex,OBJGROUP|VCPB_EXECUP,NULL,
               "Resets the aircraft to non complex or non high performance","DATA_ENTRY",NULL);

    vcAtSay(3,5,"Above Standard Data File");
    obj1 = vcEntryFldX(win, 3, 30, &AircraftInfo.a_file,
                       "XXXXXXXXXXXX",
                       OBJGROUP|VCEF_STRING|VCEF_FLDBLANK,NULL,
                       "8 characters Maximum plus \".dat\"",
                       NULL,NULL);

    vcAtSay(5,5,"Below Standard Data File");
    obj2 = vcEntryFldX(win, 5, 31, &AircraftInfo.b_file,
                       "XXXXXXXXXXXX",
                       OBJGROUP|VCEF_STRING|VCEF_FLDBLANK,NULL,
                       "8 characters Maximum plus \".dat\"",
                       NULL,NULL);

    vcAtSay(7,5,"Normal/Standard Data File");
    obj3 = vcEntryFldX(win, 7, 32, &AircraftInfo.n_file,
                       "XXXXXXXXXXXX",
                       OBJGROUP|VCEF_STRING|VCEF_FLDBLANK,NULL,
                       "8 characters Maximum plus \".dat\"",
                       NULL,NULL);

    vcAtSay(9,5,"Default Data File");
    obj4 = vcEntryFldX(win, 9, 24, &AircraftInfo.d_file,
                       "XXXXXXXXXXXX",
                       OBJGROUP|VCEF_STRING|VCEF_FLDBLANK,NULL,
                       "8 characters Maximum plus \".dat\"",
                       NULL,NULL);

    vcAtSay(11,5,"Weight and Balance Center of Gravity Data File");
    obj5 = vcEntryFldX(win, 11, 53, &AircraftInfo.cgd_file,
                       "XXXXXXXXXXXX",
                       OBJGROUP|VCEF_STRING|VCEF_FLDBLANK,NULL,
                       "8 characters Maximum plus \".cgd\"",
		       NULL,NULL);
    vcAtSay(7,47,"Total Usable Fuel");
    obj6 = vcEntryFldX(win, 7, 65, &AircraftInfo.ac_fuelcapacity,
		       "999.9",
		       OBJGROUP|VCOF_FLOAT|VCEF_FLDBLANK,NULL,
		       "includes main\(s\) and or auxiliary fuel tanks",
               NULL,NULL);

    //vcPushBtnX(win, 17, 51," Performance File Manager ",ManageFM,OBJGROUP|VCPB_EXECUP,NULL,
    //           " Create/View/Edit aircraft performance data files",
    //           NULL, vcColorFromID(14));
    //
    //vcPushBtnX(win,15,60," Manage CG files ", ManageCG,
    //           OBJGROUP|VCPB_EXECUP,NULL,"Create or Edit the CG data files",NULL,vcColorFromID(14));

    vcPushBtnX( win, 16, 28, "  Save  ", SaveData,
                OBJGROUP|VCPB_EXECUP,NULL,
                "Save the information to Aircraft Information File",
                NULL, vcColorFromID(14));
    vcPushBtnX( win, 16, 18, "  Read  ", ReadData,
                OBJGROUP|VCPB_EXECUP,NULL,
                "Read the information from the Aircraft Information File",
                NULL, vcColorFromID(14));
    
    obj=vcPushBtnX(win,18,69,"        ", DataExit,OBJGROUP|VCPB_EXECUP,NULL,
                   "End the program","DATA_ENTRY",NULL);
    obj=vcPushBtnX(win,19,69,"  Exit  ", DataExit,OBJGROUP|VCPB_EXECUP,NULL,
                   "End the program","DATA_ENTRY",NULL);

    obj->id=EXITOBJID;

    vcStatOpen(24,0,24,79,NULL,0,1,NULL);

    /* this function only executes on initial start
     * and loads structure with items */

    vcStartForm(win,NULL);
    return(VCSUCCESS);
}


VCCOUNT DataInpFilter(VCCOUNT msg, VCVOID *to, VCULONG p1, VCULONG p2, VCULONG p3)
{
    VCWIN *win;
    VCOBJ *obj;
    VCCOUNT key;

    {
        int a=0;  // initialize to zero
        // 0= don't quit and 1 means quit
        VCCOUNT key;
        if(msg==KEYPRESS)  //if keypress
        {
            key=p1&0xffff;  //get key
            if(key==ESC)    //if esc exit
                //end processing
                if (Quit_Verify(a))   // verify user really wants to quit program
                {
                    return(vcPostMsg(VCTERMINATE, to, p1, p2, p3) );
                }
        }
        //if mouse events and not to current window
        if( (msg == MOUB1DOWN )  &&
                (vcWinFromVoid(to) != wcurrent) )
        {
            return (VCSUCCESS); //eat message
        }
        //allow other message on through system
        return( vcDefaultWinFilter(msg, to, p1, p2, p3 ) );
    }
}
VCCOUNT Quit_Verify(int a )
{
    char p;
    VCWIN *e;
    vcMouHide();
    e = vcWinOpenX(7, 20, 10, 60, "Warning", VCWF_SHADOW, 0, 0,
                   vcBorderFromID(1), vcColorFromID(9));
    vcAtSay(0,  5, "Are you Sure you want to quit");
    vcAtSay(1, 5, "aircraft create? Press Y or N!");
    vcStatSay("Press Y to exit and N cancel quit. ",
              vc.white|vc.bold|vc.blink|vc.blue*vc.bg);
    vcUpdateVIO();
    p = getch();
    switch(p)
    {
    case 'y' :
    case 'Y' :
        a = 1;
        break;
    case 'n' :
    case 'N' :
        a = 0;
        break;
    default  :
        a = 0;
        break;
    }
    vcMouShow();
    vcWinClose(e);
    return ( a );
}



VCCOUNT get_a_key()
{
    VCCOUNT key;
    while( ((key=vcGetOne(NULL)) == MOUMOVE)
            || (key==MOUB1UP) || (key==MOUB1MOVE) );
    return(key);
}

VCCOUNT DataExit( VCOBJ *obj )
{
    vcPostMsg(VCTERMINATE,obj,0L,0L,0L);
    return(VCSUCCESS);
}

VCCOUNT SaveData( VCOBJ *obj )
{
    int flag;
    /* sets the complex airplane to true 1 or false 0*/
    if(button1 == 1)
    {
        AircraftInfo.is_complex = 1;
    }

    else AircraftInfo.is_complex = 0;


    /* this step saves all of the objects in the form before writing*/
    vcSendMsg( VCENDFORM,(VCVOID *)obj->win, 0L, 0L, 0L );


    /* does structure being created contain file names
     * that already exist */
    flag = Is_file_already_in_use();

    if(flag)
    {
        button1 = 0;
        //vcAtSay(19,30, "                         "); // reset "complex" message.

        vcSendMsg( VCSTARTFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
        return(VCSUCCESS);
    }

    // only write if any of structure files not created
    // use r+b for reading and writing rb for read only
    // if the file is found then write to it.
    fp = fopen(AircraftInfo.ac_info_filename,"w+b");
    fseek(fp, record_length, SEEK_SET);
    fwrite(&AircraftInfo, sizeof(struct AircraftStructure),1,fp);
    fclose(fp);
    button1 = 0;

    vcAtSay(20,35, "File Saved...  ");


    vcSendMsg( VCSTARTFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
    return(VCSUCCESS);
}

VCCOUNT ReadData( VCOBJ *obj )
{
    /* this step saves all of the objects in the form before reading */
    vcSendMsg( VCENDFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
    vcAtSay(20,35, "               ");
    
    vcAtSayX(20,2, "                                        ",
	  vc.blue|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);   
    /* see if the filename exists, then open it if it does */
    /* use r+b for reading and writing rb for read only */
    if ((fp = fopen(AircraftInfo.ac_info_filename,"r+b")) != NULL)
    {
        fseek(fp, record_length, SEEK_SET);
        fread(&AircraftInfo, sizeof(struct AircraftStructure),1,fp);
        fclose(fp);
    }
// ------------------------------------------------------------
      else {
		  // clear bottom loaded aircraft and update form  
        vcAtSayX(20,2, "No aircraft loaded yet                  ",
  	     vc.brown|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);
        vcAtSayX(9,46, "                         ",
  	     vc.brown|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);
       vcSendMsg( VCSTARTFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
       vcUpdateVIO();
       return(VCSUCCESS);
      }
// ------------------------------------------------------------    
    
    if(AircraftInfo.is_complex == FALSE)
    {
        button1 = 0;
         
        vcAtSayX(9,46, "Tag: Set to Non-complex  ",
  	     vc.brown|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);
        
//        vcAtSay(9,46, "                         ");
//        vcAtSay(9,46, "Tag: Set to Non-complex  ");

        vcSendMsg( VCSTARTFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
        UpdateEntryForm();
        return(VCSUCCESS);
    }


    if(AircraftInfo.is_complex == TRUE)
    {
                 
        vcAtSayX(9,46, "Tag: Set Complex         ",
  	     vc.brown|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);
//        vcAtSay(9,46, "                         ");
//        vcAtSay(9,46, "Tag: Set Complex         ");

        vcSendMsg( VCSTARTFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
        button1 = 1;
        UpdateEntryForm();
        return(VCSUCCESS);
    }

    return(VCSUCCESS);
}


/* error function: warns if file not found */
VCCOUNT not_found()
{
    VCWIN *e;

    vcCurHide(vccrt);
    e = vcWinOpenX(7,10,13,70," Error with filename! ",
                   NULL,0,0,vcBorderFromID(5),
                   vcColorFromID(20));
    vcAtSay(1,15,"That file was not found.");
    vcAtSay(2,15,"Recheck the filename entered.");
    vcStatSay("Cannot find a file by the name used."
              ,vc.brown|vc.bold|vc.blue*vc.bg);
    vcUpdateVIO();
    get_a_key();
    vcCurShow(vccrt);
    vcWinClose(e);

    return(VCSUCCESS);
}

/* error function: warns if a file already in use */
VCCOUNT Is_file_already_in_use()
{
    int flag = 0;
    char error[13];  // holds filename in error
    VCWIN *e;
    vcCurHide(vccrt);

    /* check for duplicate names before writing */
    if(!flag)
    {
        if((fp = fopen(AircraftInfo.a_file,"r")) != NULL)
        {
            flag = 1;
            fclose(fp);
            strcpy(error, AircraftInfo.a_file);
        }
    }
    if(!flag)
    {
        if((fp = fopen(AircraftInfo.b_file,"r")) != NULL)
        {
            flag = 1;
            fclose(fp);
            strcpy(error, AircraftInfo.b_file);
        }
    }
    if(!flag)
    {
        if((fp = fopen(AircraftInfo.n_file,"r")) != NULL)
        {
            flag = 1;
            fclose(fp);
            strcpy(error, AircraftInfo.n_file);
        }
    }
    if(!flag)
    {
        if((fp = fopen(AircraftInfo.d_file,"r")) != NULL)
        {
            flag = 1;
            fclose(fp);
            strcpy(error, AircraftInfo.d_file);
        }
    }
    if(!flag)
    {
        if((fp = fopen(AircraftInfo.cgd_file,"r")) != NULL)
        {
            flag = 1;
            fclose(fp);
            strcpy(error, AircraftInfo.cgd_file);
        }
    }



    if(flag)
    {
        e = vcWinOpenX(7,10,15,70," A Filename already in use! ",
                       NULL,0,0,vcBorderFromID(4),
                       vcColorFromID(20));
        vcAtSay(1,2,"File              is already in use.");
        vcAtSay(1,7, error);
        vcAtSay(2,2,"You must change one of the performance file names.");
        vcAtSay(3,2,"to something else.  Once the files are created by the");
        vcAtSay(4,2,"file manager program, you cannot create a new structure");
        vcAtSay(5,2,"with a file name that has already been created.");
        vcStatSay("To create a new file name for use - it cannot already exist."
                  ,vc.brown|vc.bold|vc.blue*vc.bg);
        vcUpdateVIO();
        get_a_key();

        vcCurShow(vccrt);
        vcWinClose(e);
    }
    return(flag);
}

VCCOUNT ClearFormFirst()
{
    char *strEmpty = "            ";
    strcpy(AircraftInfo.name,strEmpty);
    strcpy(AircraftInfo.a_file, strEmpty);
    strcpy(AircraftInfo.b_file, strEmpty);
    strcpy(AircraftInfo.n_file, strEmpty);
    strcpy(AircraftInfo.d_file, strEmpty);
    strcpy(AircraftInfo.cgd_file, strEmpty);
    AircraftInfo.ac_fuelcapacity = 0;
    vcAtSay(19,30, "                         ");
    vcPutFldBuf(obj0, & AircraftInfo.name);
    vcPostMsg(VCOBJDRAW, obj0,0L, 0L, 0L);
    vcPutFldBuf(obj1, &AircraftInfo.a_file);
    vcPostMsg(VCOBJDRAW, obj1,0L, 0L, 0L);
    vcPutFldBuf(obj2, &AircraftInfo.b_file);
    vcPostMsg(VCOBJDRAW, obj2,0L, 0L, 0L);
    vcPutFldBuf(obj3, &AircraftInfo.n_file);
    vcPostMsg(VCOBJDRAW, obj3,0L, 0L, 0L);
    vcPutFldBuf(obj4, &AircraftInfo.d_file);
    vcPostMsg(VCOBJDRAW, obj4,0L, 0L, 0L);
    vcPutFldBuf(obj5, &AircraftInfo.cgd_file);
    vcPostMsg(VCOBJDRAW, obj5,0L, 0L, 0L);
    vcPutFldBuf(obj6, &AircraftInfo.ac_fuelcapacity);
    vcPostMsg(VCOBJDRAW, obj6,0L, 0L, 0L);
    vcUpdateVIO();
    return( VCSUCCESS );
}

VCCOUNT UpdateEntryForm()
{
    vcPutFldBuf(obj0, &AircraftInfo.name);
    vcPostMsg(VCOBJDRAW, obj0,0L, 0L, 0L);
    vcPutFldBuf(obj1, &AircraftInfo.a_file);
    vcPostMsg(VCOBJDRAW, obj1,0L, 0L, 0L);
    vcPutFldBuf(obj2, &AircraftInfo.b_file);
    vcPostMsg(VCOBJDRAW, obj2,0L, 0L, 0L);
    vcPutFldBuf(obj3, &AircraftInfo.n_file);
    vcPostMsg(VCOBJDRAW, obj3,0L, 0L, 0L);
    vcPutFldBuf(obj4, &AircraftInfo.d_file);
    vcPostMsg(VCOBJDRAW, obj4,0L, 0L, 0L);
    vcPutFldBuf(obj5, &AircraftInfo.cgd_file);
    vcPostMsg(VCOBJDRAW, obj5,0L, 0L, 0L);
    vcPutFldBuf(obj6, &AircraftInfo.ac_fuelcapacity);
    vcPostMsg(VCOBJDRAW, obj6,0L, 0L, 0L);
    vcUpdateVIO();
    return( VCSUCCESS );
}




VCCOUNT Reset_RadioButtonComplex( VCOBJ *obj )
{
    vcSendMsg( VCENDFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
    button1 = 0;
    vcAtSay(9,46, "                         ");
    vcAtSay(9,46, "Tag: Set to Non-complex  ");
    vcSendMsg( VCSTARTFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
    return(VCSUCCESS);
}

VCCOUNT Set_RadioButtonComplex( VCOBJ *obj )
{
    vcSendMsg( VCENDFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
    button1 = 1;
    vcAtSay(9,46, "                         ");
    vcAtSay(9,46, "Tag: Set Complex         ");
    vcSendMsg( VCSTARTFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
    return(VCSUCCESS);
}

VCCOUNT ManageFM()
{
    union REGS regs;
    struct SREGS s;
    VCCOUNT stat;
    VCTEXT *savebuf;
    VCTEXT *comspec;
    VCCOORD r,c;

    /* See how much memory we need to save  */
    regs.x.ax = 21;
    int86( 0x33, &regs, &regs );
    savebuf = (VCVOID *)vcAlloc( 1, regs.x.bx );

    comspec = getenv("COMSPEC");

    if( savebuf != (VCTEXT *)0 && comspec != (VCTEXT *)0 )
    {
        /* save mouse state */
        regs.x.ax = 22;
        regs.x.dx = FP_OFF( savebuf );
        s.es = FP_SEG( savebuf );
        int86x( 0x33, &regs, &regs, &s );

        /* reset mouse for a polite exit */
        regs.x.ax = 33;
        int86( 0x33, &regs, &regs );
        vc_WinPut( vccrt->rw );
        vcUpdateVIO();
        vcAt( 0, 0 );
        /********** */
        /* check for program to list trip files */
        stat=CheckForFM();
        if(stat == 0)
        {
            vcUpdateVIO();
            vcAt( 0, 0 );
            system("fm_new.exe SIWEL");
        } /* Run the findtrip program using password*/
        if(stat < 0)                  /* Program will create file  */
            NoFM();                    /* containing selected NAV file */

        /* restore mouse state */
        regs.x.ax = 23;
        regs.x.dx = FP_OFF( savebuf );
        s.es = FP_SEG( savebuf );
        int86x( 0x33, &regs, &regs, &s );
        vcFree( savebuf );

        /* restore original Vitamin C display */
        vc_WinPut( vccrt->rw );
        vc_WinPutBranch( vccrt->rw );

        r = wcurrent->r;
        c = wcurrent->c;
        if( vccrt->cursor.hidden ||                    // if hidden
                (wcurrent->hidecnt)   ||                   // or hidecount
                !(wcurrent->flags & VCWF_CURSOR)  ||       // or cursorless
                vcObsPoint(wcurrent, &r, &c) == -1 )       // or obscured
        {
            vccrt->cursor.cswitch = VCOFF;
            vccrt->cursor.ctrans  = 1;
        }
        else
        {
            vccrt->cursor.cswitch = VCON;
            vccrt->cursor.ctrans  = 1;
        }
        if( vccrt->cursor.cfunc )
            (*vccrt->cursor.cfunc)(vccrt, r, c);
         vcMouSetPos(16,42);                   // prevents pushing button twice
         vcUpdateVIO();
        }
         else
	      vcBell();
    return( VCSUCCESS );
}

VCCOUNT CheckForFM()
{
    /* see if findtrip executable exists */
    VCCOUNT stat;
    FILE *exist;
    if((exist = fopen("fm_new.exe","rb")) != NULL)
    {
        stat = 0;
        fclose(exist);
    }
    else
        stat = -1;
    return stat;
}

VCCOUNT NoFM()
{
    VCWIN *n;

    n = vcWinOpenX(8,10,14,70," Program \"FM_NEW.EXE\" missing! ",VCWF_SHADOW,
                   0,0,vcBorderFromID(1),vcColorFromID(9));
    vcAtSay(0, 1,"             Could not Find: \"FM_NEW.EXE\"");
    vcAtSay(1, 1,"      ...This program and all supporting files");
    vcAtSay(2, 1,"      Must be in Flight Log Maker's Directory! Use the");
    vcAtSay(3, 1,"   \"System\" Push Button to make changes. Then type Exit.");
    vcAtSay(4, 1,"           Press any keyboard key to continue...");
    vcStatSay("                                    Error", vc.white|vc.bold|vc.blink|vc.blue*vc.bg);
    vcUpdateVIO();
    get_a_key();
    vcWinClose(n);
    return( VCSUCCESS );
}

VCCOUNT ManageCG()
{
    union REGS regs;
    struct SREGS s;
    VCCOUNT stat;
    VCTEXT *savebuf;
    VCTEXT *comspec;
    VCCOORD r,c;

    /* See how much memory we need to save  */
    regs.x.ax = 21;
    int86( 0x33, &regs, &regs );
    savebuf = (VCVOID *)vcAlloc( 1, regs.x.bx );

    comspec = getenv("COMSPEC");

    if( savebuf != (VCTEXT *)0 && comspec != (VCTEXT *)0 )
    {
        /* save mouse state */
        regs.x.ax = 22;
        regs.x.dx = FP_OFF( savebuf );
        s.es =      FP_SEG( savebuf );
        int86x( 0x33, &regs, &regs, &s );

        /* reset mouse for a polite exit */
        regs.x.ax = 33;
        int86( 0x33, &regs, &regs );
        vc_WinPut( vccrt->rw );
        vcUpdateVIO();
        vcAt( 0, 0 );
        /********** */
        /* check for program to list trip files */
        stat=CheckForCGMAN();
        if(stat == 0)
        {
            vcUpdateVIO();
            vcAt( 0, 0 );
            system("cgman.exe SIWEL");
        }  /* change to wb front page when created */
        if(stat < 0)                   /* this is only a test for now */
            No_CGMAN();

        /* restore mouse state */
        regs.x.ax = 23;
        regs.x.dx = FP_OFF( savebuf );
        s.es = FP_SEG( savebuf );
        int86x( 0x33, &regs, &regs, &s );
        vcFree( savebuf );

        /* restore original Vitamin C display */
        vc_WinPut( vccrt->rw );
        vc_WinPutBranch( vccrt->rw );

        r = wcurrent->r;
        c = wcurrent->c;
        if( vccrt->cursor.hidden ||                    // if hidden
                (wcurrent->hidecnt)   ||                   // or hidecount
                !(wcurrent->flags & VCWF_CURSOR)  ||       // or cursorless
                vcObsPoint(wcurrent, &r, &c) == -1 )       // or obscured
        {
            vccrt->cursor.cswitch = VCOFF;
            vccrt->cursor.ctrans  = 1;
        }
        else
        {
            vccrt->cursor.cswitch = VCON;
            vccrt->cursor.ctrans  = 1;
        }
        if( vccrt->cursor.cfunc )
            (*vccrt->cursor.cfunc)(vccrt, r, c);
         vcMouSetPos(16,42);                   // prevents pushing button twice
         vcUpdateVIO();
    }
    else
     vcBell();
 return( VCSUCCESS );
}

VCCOUNT CheckForCGMAN()
{
    /* see if wb executable exists */
    VCCOUNT stat;
    FILE *exist;
    if((exist = fopen("cgman.exe","rb")) != NULL )
    {
        stat = 0;
        fclose(exist);
    }
    else
        stat = -1;
    return stat;
}

VCCOUNT No_CGMAN()
{
    VCWIN *n;

    n = vcWinOpenX(8,5,16,65," Program \"CGMAN.EXE\" missing! ",VCWF_SHADOW,
                   0,0,vcBorderFromID(1),vcColorFromID(9));
    vcAtSay(1, 1,"Could not Find: CGMAN.EXE");
    vcAtSay(2, 1,"This program and all supporting files");
    vcAtSay(3, 1,"Must be in Flight Log Maker's Directory!");
    vcAtSay(5, 1,"Press any keyboard key to continue...");
    vcStatSay("                                    Error", vc.white|vc.bold|vc.blink|vc.blue*vc.bg);
    vcUpdateVIO();
    get_a_key();
    vcWinClose(n);
    return( VCSUCCESS );
}


VCCOUNT UpdateAirInfoField()
{
    FILE *fp; /* temporary pointer to read ac tailnumber string from file */
    /* clear fields and file saved notice from window */
    ClearFormFirst();
    //vcAtSay(7,60, "               ");
    vcAtSay(9,46, "                         ");
    UpdateEntryForm();

 // clear bottom loaded aircraft and update form  
  vcAtSayX(20,2, "No aircraft loaded yet                  ",
  	  vc.brown|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);
    vcUpdateVIO();   
    
    
    
    
    ManageAirFile();

    /* open a file to get the aircraft tail number string */
    if((fp=fopen("useplane","r"))!=NULL)
    {
        fseek(fp,0 * sizeof(struct info_name),SEEK_SET);
        fread(&Info_Path,sizeof(struct info_name),1,fp);
        fclose(fp);
    }
    strncpy(AircraftInfo.ac_info_filename, Info_Path.info_name, 13);
    AircraftInfo.ac_info_filename[13] = '\0';
    vcPutFldBuf(obj28, &AircraftInfo.ac_info_filename);
    vcPostMsg(VCOBJDRAW, obj28,0L, 0L, 0L);
    vcUpdateVIO();

    return( VCSUCCESS );
}

VCCOUNT ManageAirFile()
{
    union REGS regs;
    struct SREGS s;
    VCCOUNT stat;
    VCTEXT *savebuf;
    VCTEXT *comspec;
    VCCOORD r,c;


    /* See how much memory we need to save  */
    regs.x.ax = 21;
    int86( 0x33, &regs, &regs );
    savebuf = (VCVOID *)vcAlloc( 1, regs.x.bx );

    comspec = getenv("COMSPEC");

    if( savebuf != (VCTEXT *)0 && comspec != (VCTEXT *)0 )
    {
        /* save mouse state */
        regs.x.ax = 22;
        regs.x.dx = FP_OFF( savebuf );
        s.es = FP_SEG( savebuf );
        int86x( 0x33, &regs, &regs, &s );

        /* reset mouse for a polite exit */
        regs.x.ax = 33;
        int86( 0x33, &regs, &regs );
        vc_WinPut( vccrt->rw );
        vcUpdateVIO();
        vcAt( 0, 0 );
        /********** */
        /* check for program to list trip files */
        stat=CheckForUseair();
        if(stat == 0)
        {
            vcUpdateVIO();
            vcAt( 0, 0 );
            system("fileget.exe ????????.air");
        }  /* change to wb front page when created */

        if(stat < 0)
            No_Fileget();

        /* restore mouse state */
        regs.x.ax = 23;
        regs.x.dx = FP_OFF( savebuf );
        s.es = FP_SEG( savebuf );
        int86x( 0x33, &regs, &regs, &s );
        vcFree( savebuf );

        /* restore original Vitamin C display */
        vc_WinPut( vccrt->rw );
        vc_WinPutBranch( vccrt->rw );

        r = wcurrent->r;
        c = wcurrent->c;
        if( vccrt->cursor.hidden ||                    // if hidden
                (wcurrent->hidecnt)   ||                   // or hidecount
                !(wcurrent->flags & VCWF_CURSOR)  ||       // or cursorless
                vcObsPoint(wcurrent, &r, &c) == -1 )       // or obscured
        {
            vccrt->cursor.cswitch = VCOFF;
            vccrt->cursor.ctrans  = 1;
        }
        else
        {
            vccrt->cursor.cswitch = VCON;
            vccrt->cursor.ctrans  = 1;
        }
        if( vccrt->cursor.cfunc )
            (*vccrt->cursor.cfunc)(vccrt, r, c);
         vcMouSetPos(16,42);                   // prevents pushing button twice
         vcUpdateVIO();
     }
    else
	 vcBell();
  return( VCSUCCESS );
}

VCCOUNT No_Fileget()
{
    VCWIN *n;

    n = vcWinOpenX(8,5,16,65," Program \"FILEGET\" missing!  ",VCWF_SHADOW,
                   0,0,vcBorderFromID(1),vcColorFromID(9));
    vcAtSay(1, 1,"Could not Find: \"fileget.EXE");
    vcAtSay(2, 1,"This program and all supporting files");
    vcAtSay(3, 1,"Must be in Flight Log Maker's Directory!");
    vcAtSay(5, 1,"Press any keyboard key to continue...");
    vcStatSay("                                    Error", vc.white|vc.bold|vc.blink|vc.blue*vc.bg);
    vcUpdateVIO();
    get_a_key();
    vcWinClose(n);
    return( VCSUCCESS );
}

VCCOUNT CheckForUseair()
{
    /* see if wb executable exists */
    VCCOUNT stat;
    FILE *exist;
    if((exist = fopen("fileget.exe","rb")) != NULL )
    {
        stat = 0;
        fclose(exist);
    }
    else
        stat = -1;
    return stat;
}




/* end */

