/* Weight and balance creator 
** Author: Ron Lewis  Updated: Apr. 2023 
** to version 3.1 */

#include <vcstdio.h>
#include <conio.h>
#include <string.h>

#define SAVEDATAWINID 101
#define DATAENTRYWINID 102
#define EXITOBJID 201

/* declare some constants that cannot be changed */
const YES = 1;
const NO = 0;
const MAX = 197;
const TRUE = 1, FALSE = 0;

/* declare structures */

/* structure for ac tail number string */
struct name {
   char fname[70];
   } Tail_number;

/* structure for aircraft info file string */
struct info_name {
   char info_name[70];
   } Info_Path;

struct WB_data_structure {
       char AC_TYPE[31];
       double BEW_W;
       double BEW_A;
       double MFUEL_W;
       double MFUEL_A;
       double AFUEL_W;
       double AFUEL_A;
       double PILOT_SEAT_W;
       double PILOT_SEAT_A;
       double FORW_SEAT_W;
       double FORW_SEAT_A;
       double RSEATS_1_W;
       double RSEATS_1_A;
       double RSEATS_2_W;
       double RSEATS_2_A;
       double FBAGS_W;
       double FBAGS_A;
       double RBAGS_W;
       double RBAGS_A;
       double RBAGS2_W;
       double RBAGS2_A;
       double TAXFUEL_W;
       double TAXFUEL_A;
       double FBURN_W;
       double FBURN_A;
       double FBURN2_W;
       double FBURN2_A;
      } WB;

/* holds cg data */
struct CGDataStructure {
   double maximum_weight;
   double minimum_weight;
   double selected_weight;
   double utility_maximum_weight;
   double utility_minimum_weight;
   double utility_forward_cg;
   double utility_rearward_cg;
   double forward_cg;
   double rearward_cg;
   char aircraft[31];
  } CG;

/* structure that was in disk_write_data */
/* holds cg data for landing */
struct Landing_CG_Structure {
   double landing_max_weight;
   double landing_min_weight;
   double landing_selected_weight;
   double landing_utility_max_weight;
   double landing_utility_min_weight;
   double landing_utility_forward_cg;
   double landing_utility_rearward_cg;
   double landing_forward_cg;
   double landing_rearward_cg;
   char landing_aircraft[31];
  } Landing_CG;

/* structure to hold Aircraft information */
   struct AircraftStructure {
    char ac_info_filename[13];
    char name[31];
    char a_file[13];
    char b_file[13];
    char n_file[13];
    char d_file[13];
    char cgd_file[13];
    int is_complex; /* Complex airplane? */
    float ac_fuelcapacity; /* Added on 2/2016 */
} AircraftInfo; 


 /* weights to be used when searching cg data */
double weights[] = { 1100,1125,1150,1175,1200,1225,1250,
   1275,1300,1325,1350,1375,1400,1425,1450,1475,1500,1525,
   1550,1575,1600,1625,1650,1675,1700,1725,1750,1775,1800,
   1825,1850,1875,1900,1925,1950,1975,2000,2025,2050,2075,
   2100,2125,2150,2175,2200,2225,2250,2275,2300,2325,2350,
   2375,2400,2425,2450,2475,2500,2525,2550,2575,2600,2625,
   2650,2675,2700,2725,2750,2775,2800,2825,2850,2875,2900,
   2925,2950,2975,3000,3025,3050,3075,3100,3125,3150,3175,
   3200,3225,3250,3275,3300,3325,3350,3375,3400,3425,3450,
   3475,3500,3525,3550,3575,3600,3625,3650,3675,3700,3725,
   3750,3775,3800,3825,3850,3875,3900,3925,3950,3975,4000,
   4025,4050,4075,4100,4125,4150,4175,4200,4225,4250,4275,
   4300,4325,4350,4375,4400,4425,4450,4475,4500,4525,4550,
   4575,4600,4625,4650,4675,4700,4725,4750,4775,4800,4825,
   4850,4875,4900,4925,4950,4975,5000,5025,5050,5075,5100,
   5125,5150,5175,5200,5225,5250,5275,5300,5325,5350,5375,
   5400,5425,5450,5475,5500,5525,5550,5575,5600,5625,5650,
   5675,5700,5725,5750,5775,5800,5825,5850,5875,5900,5925,
   5950,5975,6000 };

/* declare variables */
VCWIN *background, *data, *help_win;

/* variables for calc and disk write routines */
double takeoff_weight, ramp_weight, landing_weight, takeoff_CG, landing_moment, takeoff_moment;
double moments[13]; /* includes items 0-12 */
double zero_fuel_weight, zero_fuel_arm, zero_fuel_moment;
double after_fuel_burn_weight, after_fuel_burn_CG, after_fuel_burn_moment;
double landing_forward_CG, landing_rear_CG;
double FUELWT = 6.0; /* AVGAS fuel @ 6 lbs/gal. */

int count, record;
int CG_after_record;
int number1=1;
int match, file_open_error;
char aircraft[31], previous_aircraft[31], AC_TAIL[7], buffer[31];

/* variable for the AC record file */
VCCOUNT button1 = 0;
VCCOUNT record_length = 1;
 
/* variables for "key" function */
//int NotValid = -1;
//char *password = "SIWEL";

/* Global Objects for fields */
VCOBJ *obj1, *obj2, *obj3, *obj4, *obj5;
VCOBJ *obj6, *obj7, *obj8, *obj9, *obj10, *obj11, *obj12, *obj13, *obj14;
VCOBJ *obj15, *obj16, *obj17, *obj18, *obj19, *obj20, *obj21, *obj22;
VCOBJ *obj23, *obj24, *obj25, *obj26, *obj27, *obj28;

/* declare function prototypes */
VCCOUNT vcFillWinBg( VCWIN *win, VCCHAR ch, VCATTR attr);
VCCOUNT winfilter( VCCOUNT msg, VCVOID *to, VCULONG p1,
	    VCULONG p2, VCULONG p3 );
VCCOUNT Quit_Verify( int a );
VCCOUNT DataExit( VCOBJ *obj );
VCCOUNT DataEntryFunc( VCVOID );
VCCOUNT DataExit (VCOBJ *obj );
VCCOUNT GetData( VCOBJ *obj );
VCCOUNT SaveData( VCOBJ *obj );
VCCOUNT get_a_key( VCVOID );
VCCOUNT ReadOnly( VCOBJ *obj );
VCCOUNT ManageCG( VCVOID );

VCCOUNT ManageTail( VCVOID );
VCCOUNT UpdateTailField( VCVOID );
VCCOUNT Aircraft_Loaded( VCVOID );

VCCOUNT NoMatch( VCVOID );
VCCOUNT UpdateNavForm( VCVOID );
VCCOUNT New_WriteDBRecord( VCVOID );
VCCOUNT DoCalc( VCOBJ *obj );
VCCOUNT no_file( VCVOID );
VCCOUNT no_cg_file( VCVOID );
VCCOUNT FileSaved_message( VCVOID );
VCCOUNT Data_Retrieved_message( VCVOID );
VCCOUNT Aircraft_has_changed( VCVOID );
VCCOUNT Disk_write_data( VCVOID );
VCCOUNT HelpWindow1( VCVOID );
VCCOUNT Calc( VCVOID );
VCCOUNT Show_after_fuel_burn_data( VCVOID );
VCCOUNT Show_Takeoff_Landing_Data( VCVOID );
 

int WriteDBRecord( void );
int GetDBRecord( void );

VCCOUNT Erase_fields( VCVOID );
VCCOUNT Clear_airStructfile(VCVOID);
VCCOUNT ReadAircraftFile( VCOBJ *obj );
VCCOUNT Clear_Out_data_fields( VCVOID ); 
VCCOUNT UpdateAirInfoField( VCVOID );
VCCOUNT ManageAirFile( VCVOID );
VCCOUNT CheckForUseair( VCVOID );
VCCOUNT No_Fileget( VCVOID );
VCCOUNT NoBasicData(VCVOID);

/* ------------------------------------------------------------ */

 main(/*int argc, char *argv[]*/) {

   /* initialize variables */
   number1 =1;

//   /* check for "key" */
//   NotValid=strcmp(argv[1], password);
//   if(NotValid) {
//     puts("Must be used with Flight Log Maker");
//     exit(0); }


   /* assign pointers to array elements */
   vcStart(VCCLRSCRN);
 

  /* open status line at top of page */
  vcStatOpen(0, 0, 0, 79, NULL, 0, 0, NULL);
  vcStatSay(" Weight & Balance  Version 3.1           TAB=Select Fields             ESC=Quit ",vc.white|vc.bold|vc.blue*vc.bg);

  DataEntryFunc();
  vcProcessEvents();
  /* delete these temporary files */
 system("del useplane");
 
  vcEnd();
  clrscr();
  return(VCSUCCESS);
 }

VCCOUNT DataEntryFunc()
{
  VCWIN *win;
  VCOBJ *obj;
  VCFLAG flags;
  VCCOUNT SaveData(), DataExit(), GetData();
  VCCOUNT ReadOnly(), Calc(),CreateData();

  /* reopen if it exists */
  if( (win=vcWinFromID(DATAENTRYWINID))!=NULL )
    return( vcSendMsg(VCWINSELECT,win,0L,0L,0L) );

  /* create window if it doesn't exist */
  win = vcCreateWin(NULL,2,0,24,79,"", VCWF_CURSOR,
	    0,0,vcBorderFromID(1),vcColorFromID(4),
	    DATAENTRYWINID, winfilter);

  vcMouSetCapture(win,0);

  if( win == NULL )
   vcTerror("Unable to open DataEntry.  Aborting");

/* Place file manager form objects here */
  flags=OBJGROUP|VCEF_DOUBLE|VCEF_ENDCAPS|VCEF_FLDBLANK;
  
  vcAtSay(5,44,"Aircraft");
  vcAtSay(6,44,"Information File:");
      obj28 = vcEntryFldX(win, 7, 44, &AircraftInfo.ac_info_filename,
	   "XXXXXXXXXXXX",
	  OBJGROUP|VCEF_STRING|VCEF_FLDBLANK,NULL,
	   "Use \"Find AIF and Read AIF\" to find and load an existing file",
	  NULL,NULL);
  
  vcAtSayX(13,44, "To print your W & B: send",
	  vc.white|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);
  vcAtSayX(14,44, "results.wbl to notepad or other",
	  vc.white|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);
  vcAtSayX(15,44, "word processor and select print",
	  vc.white|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);
  
  vcAtSayX(20,2, "No CG or airplane Tail number loaded yet",
	  vc.brown|vc.blink|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);
  
  
  
  obj=vcPushBtnX(win,9, 44," Find ", UpdateAirInfoField,
      OBJGROUP|VCPB_EXECUP,NULL,"Loads an aircraft information file",NULL,NULL);
  obj=vcPushBtnX( win, 11, 44, " Read Aircraft file ", ReadAircraftFile,
	   OBJGROUP|VCPB_EXECUP,NULL,
	   "Enter Aircraft info file and \"read\" before anything else!",
	   NULL, vcColorFromID(12));

  vcAtSay(0,44,"Tail number:");
  obj27=vcEntryFldX(win,0,57, &AC_TAIL,"XXXXXX", OBJGROUP|VCEF_STRING|VCEF_FLDBLANK,
       NULLFUNC, "Type in Aircraft tail number or select Find", NULL, NULL);

  obj=vcPushBtnX(win,8,61,"  Create/edit  ", CreateData,
      OBJGROUP|VCPB_EXECUP,NULL,"Associate the airplane to aircraft type loaded",NULL,NULL);
  obj=vcPushBtnX(win,9,61,"  Association  ", CreateData,
      OBJGROUP|VCPB_EXECUP,NULL,"Associate the airplane to aircraft type loaded",NULL,NULL);

  vcAtSay(0,23," Weight    Arm");
  vcAtSay(1,1,"Basic empty weight--->");

  obj1=vcEntryFldX(win,1,24, &WB.BEW_W,"####.#", flags, NULLFUNC,
      "Basic empty weight",
       NULL, NULL);
  obj2=vcEntryFldX(win,1,32, &WB.BEW_A,"####.#",flags, NULLFUNC,
      "Aircraft basic empty arm",
       NULL, NULL);
  vcAtSay(3,1,"Forw. Baggage/Oil---->");
  obj3=vcEntryFldX(win,3,24, &WB.FBAGS_W,"####.#", flags, NULLFUNC,
      "Forward baggage or engine oil...leave blank if not used",
       NULL, NULL);
  obj4=vcEntryFldX(win,3,32, &WB.FBAGS_A,"####.#",flags, NULLFUNC,
      "Forward bags Arm and/or oil. Combine if needed...leave blank if not used",
       NULL, NULL);
  vcAtSay(4,1,"Pilots seat---------->");
  obj5=vcEntryFldX(win,4,24, &WB.PILOT_SEAT_W,"####.#", flags, NULLFUNC,
      "Weight for front seats",
       NULL, NULL);
  obj6=vcEntryFldX(win,4,32, &WB.PILOT_SEAT_A,"####.#", flags, NULLFUNC,
      "Arm for front seats",
       NULL, NULL);
  vcAtSay(5,1,"Front Passenger seat->");
  obj23=vcEntryFldX(win,5,24, &WB.FORW_SEAT_W,"####.#", flags, NULLFUNC,
      "Weight for front seats",
       NULL, NULL);
  obj24=vcEntryFldX(win,5,32, &WB.FORW_SEAT_A,"####.#", flags, NULLFUNC,
      "Arm for front seats",
       NULL, NULL);
  vcAtSay(7,1,"Fuel (Main Tanks)---->");
  obj7=vcEntryFldX(win,7,24, &WB.MFUEL_W,"####.#", flags, NULLFUNC,
      "Weight for main fuel tanks",
       NULL, NULL);
  obj8=vcEntryFldX(win,7,32, &WB.MFUEL_A,"####.#", flags, NULLFUNC,
      "Arm for main fuel tanks",
       NULL, NULL);
  vcAtSay(8,1,"Fuel (Aux. Tanks)---->");
  obj9=vcEntryFldX(win,8,24, &WB.AFUEL_W,"####.#", flags, NULLFUNC,
      "Weight for auxiliary fuel tanks..leave blank if not used",
       NULL, NULL);
  obj10=vcEntryFldX(win,8,32, &WB.AFUEL_A,"####.#", flags, NULLFUNC,
      "Arm for auxiliary fuel tanks..leave blank if not used",
       NULL, NULL);
  vcAtSay(10,1,"Rear seats----------->");
  obj11=vcEntryFldX(win,10,24, &WB.RSEATS_1_W,"####.#", flags, NULLFUNC,
      "Weight for 1st row of rear seats..leave blank if not used",
       NULL, NULL);
  obj12=vcEntryFldX(win,10,32, &WB.RSEATS_1_A,"####.#", flags, NULLFUNC,
      "Arm for 1st row of rear seats..leave blank if not used",
       NULL, NULL);
  vcAtSay(11,1,"Rear seats----------->");
  obj13=vcEntryFldX(win,11,24, &WB.RSEATS_2_W,"####.#", flags, NULLFUNC,
      "Weight for 2nd row of rear seats..leave blank if not used",
       NULL, NULL);
  obj14=vcEntryFldX(win,11,32, &WB.RSEATS_2_A,"####.#", flags, NULLFUNC,
      "Arm for 2nd row of rear seats..leave blank if not used",
       NULL, NULL);
  vcAtSay(13,1,"Rear Baggage--------->");
  obj15=vcEntryFldX(win,13,24, &WB.RBAGS_W,"####.#", flags, NULLFUNC,
      "Weight for rear baggage..leave blank if not used",
       NULL, NULL);
  obj16=vcEntryFldX(win,13,32, &WB.RBAGS_A,"####.#", flags, NULLFUNC,
      "Arm for rear baggage..leave blank if not used",
       NULL, NULL);
  vcAtSay(14,1,"Rear Baggage--------->");
  obj17=vcEntryFldX(win,14,24, &WB.RBAGS2_W,"####.#", flags, NULLFUNC,
      "Weight for more rear baggage..leave blank if not used",
       NULL, NULL);
  obj18=vcEntryFldX(win,14,32, &WB.RBAGS2_A,"####.#", flags, NULLFUNC,
      "Arm for more rear baggage..leave blank if not used",
       NULL, NULL);
  vcAtSay(16,1,"Taxi/run-up fuel----->");
  vcWinAtSayX( win, 16,40, "(-)", vc.red|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
  obj19=vcEntryFldX(win,16,24, &WB.TAXFUEL_W,"####.#", flags, NULLFUNC,
      "Weight for taxi fuel burn...PLEASE USE A NEGATIVE WEIGHT HERE",
       NULL, NULL);
  obj20=vcEntryFldX(win,16,32, &WB.TAXFUEL_A,"####.#", flags, NULLFUNC,
      "Arm for taxi fuel burn",
       NULL, NULL);
  vcAtSay(17,1,"Fuel burn------------>");
  vcWinAtSayX( win, 17,40, "(-)", vc.red|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
  obj21=vcEntryFldX(win,17,24, &WB.FBURN_W,"####.#", flags, NULLFUNC,
      "Fuel used from main tank(s)...PLEASE USE A NEGATIVE WEIGHT HERE",
       NULL, NULL);
  obj22=vcEntryFldX(win,17,32, &WB.FBURN_A,"####.#", flags, NULLFUNC,
      "Arm for main fuel tanks",
       NULL, NULL);
  vcAtSay(18,1,"Fuel burn------------>");
  vcWinAtSayX( win, 18,40, "(-)", vc.red|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
  obj25=vcEntryFldX(win,18,24, &WB.FBURN2_W,"####.#", flags, NULLFUNC,
      "Fuel used from aux. tank(s)...PLEASE USE A NEGATIVE WEIGHT HERE",
       NULL, NULL);
  obj26=vcEntryFldX(win,18,32, &WB.FBURN2_A,"####.#", flags, NULLFUNC,
      "Arm for auxilliary fuel tanks",
       NULL, NULL);




  obj=vcPushBtnX(win,0,68,"  Help  ", HelpWindow1,
      OBJGROUP|VCPB_EXECUP,NULL,"Help on using the this program",NULL,NULL);

  obj=vcPushBtnX(win,2,68,"GrabData", GetData,
      OBJGROUP|VCPB_EXECUP,NULL,"Select to get weight and balance data from loaded \"N\" number",NULL,NULL);

  obj=vcPushBtnX(win,4,68,"  Calc  ", DoCalc,
	       OBJGROUP|VCPB_EXECUP,NULL,
	       "Calculate the weight and balance for this aircraft",
	       NULL, NULL);

  obj=vcPushBtnX(win,6,68,"  Save  ", SaveData,
      OBJGROUP|VCPB_EXECUP,NULL,"Select to save ALREADY EXISTING aircraft weight and balance data",NULL,NULL);

  obj=vcPushBtnX(win,1,45,"  Find  ", UpdateTailField,
      OBJGROUP|VCPB_EXECUP,NULL,"Loads a saved aircraft tail number - Load info file first",NULL,NULL);
  
  obj=vcPushBtnX(win,19,68,"        ", DataExit,OBJGROUP|VCPB_EXECUP,NULL,
	     "Quit this application",NULL,NULL);
  obj=vcPushBtnX(win,20,68,"  Exit  ", DataExit,OBJGROUP|VCPB_EXECUP,NULL,
	     "Quit this application",NULL,NULL);

  obj->id=EXITOBJID;
  vcStatOpen(1,0,1,79,NULL,0,4,NULL); /* 4 is start 4 spaces right of */
  vcStartForm(win,NULL);
  return(VCSUCCESS);
}

 /* wait for keypress function */
VCCOUNT get_a_key()
    {
	VCCOUNT key;
	  while( ((key=vcGetOne(NULL)) == MOUMOVE)
		|| (key==MOUB1UP) || (key==MOUB1MOVE) );
	  return(key);
     }

/* universal keypress filter */
 VCCOUNT winfilter(VCCOUNT msg, VCVOID *to, VCULONG p1,
		   VCULONG p2, VCULONG p3)
     {
       int a=0;  // initialize to zero
		 // 0= don't quit and 1 means quit
       VCCOUNT key;
       if(msg==KEYPRESS)  //if keypress
	{
	  key=p1&0xffff;  //get key
	  if(key==ESC)    //if esc exit
	  //end processing
	  if (Quit_Verify(a)) { // verify user really wants to quit program
	    return(vcPostMsg(VCTERMINATE, to, p1, p2, p3) );
	   }
	  }
//if mouse events and not to current window
      if( (msg == MOUB1DOWN )  &&
	  (vcWinFromVoid(to) != wcurrent) )
	  {
	   return (VCSUCCESS); //eat message
	  }
      //allow other message on through system
      return( vcDefaultWinFilter(msg, to, p1, p2, p3 ) );
     }

 
/* routine that lets you back out of quit if you change your mind */
 VCCOUNT Quit_Verify( int a )
  {
    char p;
    VCWIN *e;
    vcMouHide();
    e = vcWinOpenX(7,20,10,60,"Warning!",
		     VCWF_CURSOR|VCWF_SHADOW,0,0,vcBorderFromID(1),
		     vcColorFromID(9));
    vcAtSay(0,  5, "Are you Sure you want to quit");
   vcAtSay(1, 5, "weight and balance? Press Y or N!");
   vcStatSay("Press Y to exit and N cancel quit. ",
     vc.white|vc.bold|vc.blink|vc.blue*vc.bg);
    vcUpdateVIO();
	   p = getch();
	      switch (p)
		 {
		   case 'y' :
		   case 'Y' : a = 1;
			      break;
		   case 'n' :
		   case 'N' : a = 0;
			      break;
		   default  : a = 0;
			      break;
		 }
    vcMouShow();
    vcWinClose(e);
    return a;
  }


 /* exits program */
 DataExit( VCOBJ *obj )
   {
      int a=0; // zero equals don't quit program
	       // one quits the program
      if (Quit_Verify(a)) {
      vcEndForm(obj->win);
      vcPostMsg(VCTERMINATE,obj->win,0L,0L,0L);
      return(VCTERMINATE);
     }
     else return(VCSUCCESS);
   }

/* calculate CG */
 Calc( )  {
   FILE *fp, *cg_TO_fp, *cg_LND_fp;
   /* reset these values because of errors */
   takeoff_moment = 0; landing_moment = 0;

   takeoff_weight = 0; landing_weight = 0;
   takeoff_CG = 0;
   after_fuel_burn_CG = 0;

   /* calculate moments */
   moments[0] = WB.BEW_W * WB.BEW_A;
   moments[1] = WB.MFUEL_W * WB.MFUEL_A;
   moments[2] = WB.AFUEL_W * WB.AFUEL_A;
   moments[3] = WB.PILOT_SEAT_W * WB.PILOT_SEAT_A;
   moments[4] = WB.FORW_SEAT_W * WB.FORW_SEAT_A;
   moments[5] = WB.RSEATS_1_W * WB.RSEATS_1_A;
   moments[6] = WB.RSEATS_2_W * WB.RSEATS_2_A;
   moments[7] = WB.FBAGS_W * WB.FBAGS_A;
   moments[8] = WB.RBAGS_W * WB.RBAGS_A;
   moments[9] = WB.RBAGS2_W * WB.RBAGS2_A;
   moments[10] = WB.TAXFUEL_W * WB.TAXFUEL_A;
   moments[11] = WB.FBURN_W * WB.FBURN_A;
   moments[12] = WB.FBURN2_W * WB.FBURN2_A;

   /* convert tail number to a file name */
   /* if tail number wasn't changed ...GetDBRecord() sets */
   /* the previous_aircraft */
   if( strcmp( previous_aircraft, aircraft ) == 0) {
   sprintf(buffer,"%s",AC_TAIL);
   strcpy(aircraft,buffer);
   strcat(aircraft,".wbd"); }

   /* verify that tail number matches aircraft type selected */
   /* in case tail number gets changed */
   if( strcmp( previous_aircraft, aircraft ) != 0)
     { Clear_Out_data_fields(); Aircraft_has_changed(); return( VCSUCCESS ); }

   

   /* check to see if this association exists */
   if((fp=fopen(aircraft, "r+b")) == NULL )
     { no_file(); file_open_error = YES; return (VCSUCCESS);}
     else fclose(fp);

   /* if associations match, write to the file */
   if( strcmp( WB.AC_TYPE, AircraftInfo.name ) != 0)
     { match = NO; NoMatch(); return( VCSUCCESS ); }


   /* add weights and moments*/

   for ( count=0; count <= 10; count++ ) {
     takeoff_moment += moments[count];
     }


   for ( count=0; count <= 12; count++ ) {
     landing_moment += moments[count];
     }



   takeoff_weight = WB.BEW_W + WB.MFUEL_W + WB.AFUEL_W +
     WB.PILOT_SEAT_W + WB.FORW_SEAT_W + WB.RSEATS_1_W +
     WB.RSEATS_2_W + WB.FBAGS_W + WB.RBAGS_W +
     WB.RBAGS2_W + WB.TAXFUEL_W;
   
   landing_weight = WB.BEW_W + WB.MFUEL_W + WB.AFUEL_W +
     WB.PILOT_SEAT_W + WB.FORW_SEAT_W + WB.RSEATS_1_W +
     WB.RSEATS_2_W + WB.FBAGS_W + WB.RBAGS_W +
     WB.RBAGS2_W + WB.FBURN_W + WB.FBURN2_W + WB.TAXFUEL_W;
     
   /* actual CG */
   takeoff_CG = takeoff_moment / takeoff_weight;

   for ( record = 0; record <= MAX; record++ )  {
     if ( takeoff_weight < weights[record]) { break; }
     } /* end for index */

   /* this converts the record so record 0 is the first */
   record -= 1;

   /* round off record number for more accuracy */
   if(takeoff_weight >= ( weights[record]+13 ) ){ record +=1; }

   /* end of pre take off calculations */

   /* do some additional calculations */
    zero_fuel_weight = (WB.BEW_W + WB.PILOT_SEAT_W + WB.FORW_SEAT_W + WB.RSEATS_1_W + WB.RSEATS_2_W +
		       WB.FBAGS_W + WB.RBAGS_W + WB.RBAGS2_W );
    /* moments[10] and moments[11] are negative so they are added */
    zero_fuel_moment = ( moments[0] + moments[3] + moments[4] + moments[5] + moments[6] +
		       moments[7] + moments[8] + moments[9] );
    zero_fuel_arm = zero_fuel_moment / zero_fuel_weight;

    /* after fuel burn calculations */
    after_fuel_burn_weight = landing_weight;
    after_fuel_burn_moment = landing_moment;
    after_fuel_burn_CG = after_fuel_burn_moment / after_fuel_burn_weight;

    for ( CG_after_record = 0; CG_after_record <= MAX; CG_after_record++ )  {
     if ( after_fuel_burn_weight < weights[CG_after_record]) { break; }
     } /* end for index */

    CG_after_record -=1;
    /* round off record number for more accuracy */
    if(after_fuel_burn_weight >= ( weights[CG_after_record]+13 ) ){ CG_after_record +=1; }

    /* check to see if this association exists */
    if( (cg_TO_fp=fopen(AircraftInfo.cgd_file, "r+b")) == NULL )
     { no_cg_file(); return (VCSUCCESS);}
     else fclose(cg_TO_fp);

    /* open CG file for takeoff read */
    cg_TO_fp = fopen( AircraftInfo.cgd_file, "r+b" );
    fseek( cg_TO_fp, (record) * sizeof( struct CGDataStructure ), SEEK_SET );
    fread (&CG, sizeof( struct CGDataStructure ), 1, cg_TO_fp);
    fclose( cg_TO_fp );

    /* open CG file for landing read */
    cg_LND_fp = fopen( AircraftInfo.cgd_file, "r+b" );
    fseek( cg_LND_fp, (CG_after_record) * sizeof( struct Landing_CG_Structure ), SEEK_SET );
    fread (&Landing_CG, sizeof( struct Landing_CG_Structure ), 1, cg_LND_fp);
    fclose( cg_LND_fp );
 
    /* print the data to the screen */
    /* if fuel burn input - show takeoff and landing data */
    Show_Takeoff_Landing_Data();
   return ( VCSUCCESS );
 }

 
 Show_Takeoff_Landing_Data() {
   VCWIN *data;

   data = vcWinOpenX(3,20,22,69,"Data Window", VCWF_SHADOW,0, 0,
       vcStdBorder(), vcColorFromID(5));
   vcWinErase( data, (vc.bg*vc.blue) );

  /* Do some error checking with the fuel loading */
  
  /* checks that fuel placed on aircraft does not exceed total fuel capacity of selected aircraft */
  if( (WB.MFUEL_W + WB.AFUEL_W) / FUELWT > AircraftInfo.ac_fuelcapacity) {
  vcWinErase( data, (vc.bg*vc.blue) );
  vcWinAtSayX( data, 6,3, "Error in Fuel:", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
  vcWinAtSayX( data, 7,2, "Total fuel exceeds", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
  vcWinAtSayX( data, 8,4, "maximum fuel of", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
  vcAtSayNumX( data, 9,2, &AircraftInfo.ac_fuelcapacity, "####.#", VCOF_FLOAT,
     vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
  vcWinAtSayX( data, 9,9, "gallons.", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT); 
  get_a_key();
  vcWinClose(data);
  return(VCSUCCESS);
  }
  
  /* checks that fuel on board is not accidentally input as negative number */
  if( (WB.MFUEL_W < 0) || (WB.AFUEL_W < 0) ) {
  vcWinErase( data, (vc.bg*vc.blue) );
  vcWinAtSayX( data, 6,3, "Error in Fuel:", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
  vcWinAtSayX( data, 7,2, "Fuel on board", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
  vcWinAtSayX( data, 8,4, "is <= zero.", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT); 
  vcWinAtSayX( data, 9,1, "Must be positive.", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT); 
  get_a_key();
  vcWinClose(data);
  return(VCSUCCESS);
  }  

   /* display the pre takeoff data */

   vcWinAtSay( data, 3,3, "Normal Catagory");
   vcWinAtSayX( data, 0,2, "CG Data:", vc.white|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
   vcWinAtSayX( data, 0,11, AircraftInfo.cgd_file, vc.white|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
   
   
   vcWinAtSayX( data, 0,25, "Gross WT:", vc.white|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
   vcAtSayNumX( data, 0,39, &CG.maximum_weight, "#####", VCOF_DOUBLE,
     vc.white|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
   
   /* change display if CG.maximum weight is zero */
   if(CG.maximum_weight <= 0)  vcWinAtSayX( data, 0,35, "no weight", 
     vc.white|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     
   
   vcWinAtSay( data, 1,3, "Take off weight");
   vcAtSayNumX( data, 2,8, &takeoff_weight, "####", VCOF_DOUBLE,
     vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);

   
   if( ( takeoff_CG < CG.rearward_cg ) && ( takeoff_CG > CG.forward_cg )
     && ( takeoff_weight <= CG.maximum_weight) ) {
     vcWinAtSay( data, 6,4, "F");
     vcWinAtSayX( data, 7,4, "|", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcWinAtSayX( data, 8,4, "v", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcAtSayNumX( data, 9,3, &CG.forward_cg, "##.#", VCOF_DOUBLE,
     vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);

     vcWinAtSay( data, 6,9, "CG");
     vcWinAtSayX( data, 7,10, "|", vc.green|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcWinAtSayX( data, 8,10, "v", vc.green|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcAtSayNumX( data, 9,9, &takeoff_CG, "##.#", VCOF_DOUBLE,
     vc.green|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);

     vcWinAtSay( data, 6,16, "R");
     vcWinAtSayX( data, 7,16, "|", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcWinAtSayX( data, 8,16, "v", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcAtSayNumX( data, 9,15, &CG.rearward_cg, "##.#", VCOF_DOUBLE,
     vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);

    }

   if( ( takeoff_CG > CG.rearward_cg ) && ( takeoff_weight <= CG.maximum_weight) ) {
     vcWinAtSay( data, 6,4, "F");
     vcWinAtSayX( data, 7,4, "|", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcWinAtSayX( data, 8,4, "v", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcAtSayNumX( data, 9,3, &CG.forward_cg, "##.#", VCOF_DOUBLE,
     vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);

     vcWinAtSay( data, 6,10, "R");
     vcWinAtSayX( data, 7,10, "|", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcWinAtSayX( data, 8,10, "v", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcAtSayNumX( data, 9,9, &CG.rearward_cg, "##.#", VCOF_DOUBLE,
     vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);

     vcWinAtSay( data, 6,15, "CG");
     vcWinAtSayX( data, 7,16, "|", vc.red|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcWinAtSayX( data, 8,16, "v", vc.red|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcAtSayNumX( data, 9,15, &takeoff_CG, "##.#", VCOF_DOUBLE,
     vc.red|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);

    }

   if( ( takeoff_CG < CG.forward_cg ) && ( takeoff_weight <= CG.maximum_weight) ) {
     vcWinAtSay( data, 6,3, "CG");
     vcWinAtSayX( data, 7,4, "|", vc.red|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcWinAtSayX( data, 8,4, "v", vc.red|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcAtSayNumX( data, 9,3, &takeoff_CG, "##.#", VCOF_DOUBLE,
     vc.red|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);

     vcWinAtSay( data, 6,10, "F");
     vcWinAtSayX( data, 7,10, "|", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcWinAtSayX( data, 8,10, "v", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcAtSayNumX( data, 9,9, &CG.forward_cg, "##.#", VCOF_DOUBLE,
     vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);

     vcWinAtSay( data, 6,16, "R");
     vcWinAtSayX( data, 7,16, "|", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcWinAtSayX( data, 8,16, "v", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcAtSayNumX( data, 9,15, &CG.rearward_cg, "##.#", VCOF_DOUBLE,
     vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);

    }


   if( ( CG.maximum_weight == 0) || ( takeoff_weight >= CG.maximum_weight ) ) {
    vcWinAtSayX( data, 5,1, "You are beyond the", vc.red|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
    vcWinAtSayX( data, 6,1, "  NORMAL WEIGHT", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
    vcWinAtSayX( data, 7,1, "     limits", vc.red|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
    vcWinAtSayX( data, 8,1, "for this aircraft!", vc.red|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
    vcWinAtSayX( data, 9,1, "                      ", vc.blue+(vc.bg*vc.blue), VCOF_SYSDFLT);
   }
   
 /* --------------------------- */
   vcWinAtSayX( data, 11,2, "Utility Catagory", vc.cyan|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
   
   if( takeoff_weight < CG.utility_maximum_weight )  {
   if( ( takeoff_CG < CG.utility_rearward_cg ) && ( takeoff_CG > CG.utility_forward_cg )
     && ( takeoff_weight <= CG.maximum_weight) ) {
     vcWinAtSay( data, 14,4, "F");
     vcWinAtSayX( data, 15,4, "|", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcWinAtSayX( data, 16,4, "v", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcAtSayNumX( data, 17,3, &CG.utility_forward_cg, "##.#", VCOF_DOUBLE,
     vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);

     vcWinAtSay( data, 14,9, "CG");
     vcWinAtSayX( data, 15,10, "|", vc.green|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcWinAtSayX( data, 16,10, "v", vc.green|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcAtSayNumX( data, 17,9, &takeoff_CG, "##.#", VCOF_DOUBLE,
     vc.green|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);

     vcWinAtSay( data, 14,16, "R");
     vcWinAtSayX( data, 15,16, "|", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcWinAtSayX( data, 16,16, "v", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcAtSayNumX( data, 17,15, &CG.utility_rearward_cg, "##.#", VCOF_DOUBLE,
     vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);

    }

   if( ( takeoff_CG > CG.utility_rearward_cg ) && ( takeoff_weight <= CG.utility_maximum_weight) ) {

     vcWinAtSay( data, 14,4, "F");
     vcWinAtSayX( data, 15,4, "|", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcWinAtSayX( data, 16,4, "v", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcAtSayNumX( data, 17,3, &CG.utility_forward_cg, "##.#", VCOF_DOUBLE,
     vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);

     vcWinAtSay( data, 14,10, "R");
     vcWinAtSayX( data, 15,10, "|", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcWinAtSayX( data, 16,10, "v", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcAtSayNumX( data, 17,9, &CG.utility_rearward_cg, "##.#", VCOF_DOUBLE,
     vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);

     vcWinAtSay( data, 14,15, "CG");
     vcWinAtSayX( data, 15,16, "|", vc.red|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcWinAtSayX( data, 16,16, "v", vc.red|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcAtSayNumX( data, 17,15, &takeoff_CG, "##.#", VCOF_DOUBLE,
     vc.red|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);

    }

   if( ( takeoff_CG < CG.utility_forward_cg ) && ( takeoff_weight <= CG.utility_maximum_weight) ) {

     vcWinAtSay( data, 14,3, "CG");
     vcWinAtSayX( data, 15,4, "|", vc.red|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcWinAtSayX( data, 16,4, "v", vc.red|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcAtSayNumX( data, 17,3, &takeoff_CG, "##.#", VCOF_DOUBLE,
     vc.red|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);

     vcWinAtSay( data, 14,10, "F");
     vcWinAtSayX( data, 15,10, "|", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcWinAtSayX( data, 16,10, "v", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcAtSayNumX( data, 17,9, &CG.utility_forward_cg, "##.#", VCOF_DOUBLE,
     vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);

     vcWinAtSay( data, 14,16, "R");
     vcWinAtSayX( data, 15,16, "|", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcWinAtSayX( data, 16,16, "v", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcAtSayNumX( data, 17,15, &CG.utility_rearward_cg, "##.#", VCOF_DOUBLE,
     vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);

    }
   } /* if takeoff_weight < CG.utility_maximum_weight */

   if( ( CG.utility_maximum_weight == 0) || ( takeoff_weight >= CG.utility_maximum_weight ) ) {

    vcWinAtSayX( data, 13,1, "You are beyond the", vc.red|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
    vcWinAtSayX( data, 14,1, "  UTILITY WEIGHT", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
    vcWinAtSayX( data, 15,1, "     limits", vc.red|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
    vcWinAtSayX( data, 16,1, "for this aircraft!", vc.red|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
    vcWinAtSayX( data, 17,1, "                      ", vc.blue+(vc.bg*vc.blue), VCOF_SYSDFLT);
    vcStatSay("Weight is beyond limits for either or both normal or utility catagories",vc.white|vc.bold|vc.red*vc.bg);
    vcUpdateVIO();

   }
   else {
    vcWinAtSayX( data, 12,2, "Max. weight:", vc.cyan|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
    vcAtSayNumX( data, 12,13, &CG.utility_maximum_weight, "#####", VCOF_DOUBLE,
     vc.cyan|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
    }

  Disk_write_data();
 

 /* print after fuel burn data to screen window */
 
 
  /* checks that fuel placed on aircraft does not exceed total fuel capacity of selected aircraft */
  if( (WB.MFUEL_W + WB.AFUEL_W) / FUELWT > AircraftInfo.ac_fuelcapacity) {
  vcWinErase( data, (vc.bg*vc.blue) );
  vcWinAtSayX( data, 6,3, "Error in Fuel:", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
  vcWinAtSayX( data, 7,2, "Total fuel exceeds", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
  vcWinAtSayX( data, 8,4, "maximum fuel of", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT); 
  vcAtSayNumX( data, 9,2, &AircraftInfo.ac_fuelcapacity, "####.#", VCOF_FLOAT,
     vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
  vcWinAtSayX( data, 9,9, "gallons.", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT); 
  get_a_key();
  vcWinClose(data);
  return(VCSUCCESS);
  }  
  
  /* checks that fuel on board is not accidentally input as negative number */
  if( (WB.MFUEL_W < 0) || (WB.AFUEL_W < 0) ) {
  vcWinErase( data, (vc.bg*vc.blue) );
  vcWinAtSayX( data, 6,3, "Error in Fuel:", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
  vcWinAtSayX( data, 7,2, "Fuel on board", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
  vcWinAtSayX( data, 8,4, "is <= zero.", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT); 
  vcWinAtSayX( data, 9,1, "Must be positive.", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT); 
  get_a_key();
  vcWinClose(data);
  return(VCSUCCESS);
  }  
  
  /* fuel burn must be entered as a negative number and this is the check for that */
  if( ( WB.FBURN_W > 0 ) || ( WB.TAXFUEL_W > 0) || ( WB.FBURN2_W > 0 ) ) {
  vcWinErase( data, (vc.bg*vc.blue) );
  vcWinAtSayX( data, 7,3, "Error in Fuel:", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
  vcWinAtSayX( data, 8,4, "Burn weight", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
  vcWinAtSayX( data, 9,1, "cannot be positive", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT); 
  get_a_key();
  vcWinClose(data);
  return(VCSUCCESS);
  }
  
  /* checks if fuel burn is greater than fuel placed on aircraft */
  if( ( abs(WB.FBURN_W + WB.FBURN2_W + WB.TAXFUEL_W)) >= (WB.MFUEL_W + WB.AFUEL_W) ) {
  vcWinErase( data, (vc.bg*vc.blue) );
  vcWinAtSayX( data, 7,3, "Error in Fuel:", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
  vcWinAtSayX( data, 8,2, "Burn weight is", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
  vcWinAtSayX( data, 9,3, ">= the total", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT); 
  vcWinAtSayX( data, 10,2, "fuel on board.", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT); 
  get_a_key();
  vcWinClose(data);
  return(VCSUCCESS);
  } 
  
  /* print after fuel burn data to screen window */ 
   if( (WB.FBURN_W < 0 ) || (WB.FBURN2_W < 0) ) {

   
   vcWinAtSay( data, 1,29, "Landing weight");
   vcWinAtSay( data, 3,29, "Normal Catagory");
   vcAtSayNumX( data, 2,35, &after_fuel_burn_weight, "####", VCOF_DOUBLE,
     vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);

   if( ( after_fuel_burn_CG < Landing_CG.landing_rearward_cg ) && ( after_fuel_burn_CG > Landing_CG.landing_forward_cg )
     && ( after_fuel_burn_weight <= Landing_CG.landing_max_weight) ) {
     vcWinAtSay( data, 6,30, "F");
     vcWinAtSayX( data, 7,30, "|", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcWinAtSayX( data, 8,30, "v", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcAtSayNumX( data, 9,29, &Landing_CG.landing_forward_cg, "##.#", VCOF_DOUBLE,
     vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);

     vcWinAtSay( data, 6,35, "CG");
     vcWinAtSayX( data, 7,36, "|", vc.green|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcWinAtSayX( data, 8,36, "v", vc.green|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcAtSayNumX( data, 9,35, &after_fuel_burn_CG, "##.#", VCOF_DOUBLE,
     vc.green|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);

     vcWinAtSay( data, 6,42, "R");
     vcWinAtSayX( data, 7,42, "|", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcWinAtSayX( data, 8,42, "v", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcAtSayNumX( data, 9,41, &Landing_CG.landing_rearward_cg, "##.#", VCOF_DOUBLE,
     vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);

    }

   if( ( after_fuel_burn_CG > Landing_CG.landing_rearward_cg ) && ( after_fuel_burn_weight <= Landing_CG.landing_max_weight) ) {
     vcWinAtSay( data, 6,30, "F");
     vcWinAtSayX( data, 7,30, "|", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcWinAtSayX( data, 8,30, "v", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcAtSayNumX( data, 9,29, &Landing_CG.landing_forward_cg, "##.#", VCOF_DOUBLE,
     vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);

     vcWinAtSay( data, 6,36, "R");
     vcWinAtSayX( data, 7,36, "|", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcWinAtSayX( data, 8,36, "v", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcAtSayNumX( data, 9,35, &Landing_CG.landing_rearward_cg, "##.#", VCOF_DOUBLE,
     vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);

     vcWinAtSay( data, 6,41, "CG");
     vcWinAtSayX( data, 7,42, "|", vc.red|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcWinAtSayX( data, 8,42, "v", vc.red|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcAtSayNumX( data, 9,41, &after_fuel_burn_CG, "##.#", VCOF_DOUBLE,
     vc.red|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);

    }

   if( ( after_fuel_burn_CG < Landing_CG.landing_forward_cg ) && ( after_fuel_burn_weight <= Landing_CG.landing_max_weight) ) {
     vcWinAtSay( data, 6,29, "CG");
     vcWinAtSayX( data, 7,30, "|", vc.red|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcWinAtSayX( data, 8,30, "v", vc.red|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcAtSayNumX( data, 9,29, &after_fuel_burn_CG, "##.#", VCOF_DOUBLE,
     vc.red|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);

     vcWinAtSay( data, 6,36, "F");
     vcWinAtSayX( data, 7,36, "|", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcWinAtSayX( data, 8,36, "v", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcAtSayNumX( data, 9,35, &Landing_CG.landing_forward_cg, "##.#", VCOF_DOUBLE,
     vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);

     vcWinAtSay( data, 6,42, "R");
     vcWinAtSayX( data, 7,42, "|", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcWinAtSayX( data, 8,42, "v", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcAtSayNumX( data, 9,41, &Landing_CG.landing_rearward_cg, "##.#", VCOF_DOUBLE,
     vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);

    }


   if( ( Landing_CG.landing_max_weight == 0) || ( after_fuel_burn_weight >= Landing_CG.landing_max_weight ) ) {
    vcWinAtSayX( data, 5,28, "You are beyond the", vc.red|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
    vcWinAtSayX( data, 6,28, "  NORMAL WEIGHT", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
    vcWinAtSayX( data, 7,28, "     limits", vc.red|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
    vcWinAtSayX( data, 8,28, "for this aircraft!", vc.red|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
    vcWinAtSayX( data, 9,28, "                      ", vc.blue+(vc.bg*vc.blue), VCOF_SYSDFLT);
   }
    
 /* --------------------------- */
   vcWinAtSayX( data, 11,29, "Utility Catagory", vc.cyan|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
   
   if( after_fuel_burn_weight < Landing_CG.landing_utility_max_weight )  {
   if( ( after_fuel_burn_CG < Landing_CG.landing_utility_rearward_cg ) && ( after_fuel_burn_CG > Landing_CG.landing_utility_forward_cg )
     && ( after_fuel_burn_weight <= Landing_CG.landing_max_weight) ) {
     vcWinAtSay( data, 14,30, "F");
     vcWinAtSayX( data, 15,30, "|", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcWinAtSayX( data, 16,30, "v", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcAtSayNumX( data, 17,29, &Landing_CG.landing_utility_forward_cg, "##.#", VCOF_DOUBLE,
     vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);

     vcWinAtSay( data, 14,35, "CG");
     vcWinAtSayX( data, 15,36, "|", vc.green|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcWinAtSayX( data, 16,36, "v", vc.green|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcAtSayNumX( data, 17,35, &after_fuel_burn_CG, "##.#", VCOF_DOUBLE,
     vc.green|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);

     vcWinAtSay( data, 14,42, "R");
     vcWinAtSayX( data, 15,42, "|", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcWinAtSayX( data, 16,42, "v", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcAtSayNumX( data, 17,41, &Landing_CG.landing_utility_rearward_cg, "##.#", VCOF_DOUBLE,
     vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);

    }

   if( ( after_fuel_burn_CG > Landing_CG.landing_utility_rearward_cg ) && ( after_fuel_burn_weight <= Landing_CG.landing_utility_max_weight) ) {

     vcWinAtSay( data, 14,30, "F");
     vcWinAtSayX( data, 15,30, "|", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcWinAtSayX( data, 16,30, "v", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcAtSayNumX( data, 17,29, &Landing_CG.landing_utility_forward_cg, "##.#", VCOF_DOUBLE,
     vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);

     vcWinAtSay( data, 14,36, "R");
     vcWinAtSayX( data, 15,36, "|", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcWinAtSayX( data, 16,36, "v", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcAtSayNumX( data, 17,35, &Landing_CG.landing_utility_rearward_cg, "##.#", VCOF_DOUBLE,
     vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);

     vcWinAtSay( data, 14,41, "CG");
     vcWinAtSayX( data, 15,42, "|", vc.red|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcWinAtSayX( data, 16,42, "v", vc.red|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcAtSayNumX( data, 17,41, &after_fuel_burn_CG, "##.#", VCOF_DOUBLE,
     vc.red|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);

    }

   if( ( after_fuel_burn_CG < Landing_CG.landing_utility_forward_cg ) && ( after_fuel_burn_weight <= Landing_CG.landing_utility_max_weight) ) {

     vcWinAtSay( data, 14,29, "CG");
     vcWinAtSayX( data, 15,30, "|", vc.red|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcWinAtSayX( data, 16,30, "v", vc.red|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcAtSayNumX( data, 17,29, &after_fuel_burn_CG, "##.#", VCOF_DOUBLE,
     vc.red|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);

     vcWinAtSay( data, 14,36, "F");
     vcWinAtSayX( data, 15,36, "|", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcWinAtSayX( data, 16,36, "v", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcAtSayNumX( data, 17,35, &Landing_CG.landing_utility_forward_cg, "##.#", VCOF_DOUBLE,
     vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);

     vcWinAtSay( data, 14,42, "R");
     vcWinAtSayX( data, 15,42, "|", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcWinAtSayX( data, 16,42, "v", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
     vcAtSayNumX( data, 17,41, &Landing_CG.landing_utility_rearward_cg, "##.#", VCOF_DOUBLE,
     vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);

    }
   } /* if landing_weight < CG.utility_maximum_weight */


   if( ( Landing_CG.landing_utility_max_weight == 0) || ( after_fuel_burn_weight >= Landing_CG.landing_utility_max_weight ) ) {

    vcWinAtSayX( data, 13,28, "You are beyond the", vc.red|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
    vcWinAtSayX( data, 14,28, "  UTILITY WEIGHT", vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
    vcWinAtSayX( data, 15,28, "     limits", vc.red|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
    vcWinAtSayX( data, 16,28, "for this aircraft!", vc.red|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
    vcWinAtSayX( data, 17,28, "                      ", vc.blue+(vc.bg*vc.blue), VCOF_SYSDFLT);
    vcStatSay("Weight is beyond limits for either or both normal or utility catagories",vc.white|vc.bold|vc.red*vc.bg);
    vcUpdateVIO();

   }
   else {
    vcWinAtSayX( data, 12,29, "Max. weight:", vc.cyan|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
    vcAtSayNumX( data, 12,40, &Landing_CG.landing_utility_max_weight, "#####", VCOF_DOUBLE,
     vc.cyan|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
    }
  } /* if WB.FBURN_W < 0 ... SHOWS A FUEL BURN */
  
  if (CG.maximum_weight <= 0 )  { vcStatSay("Takeoff weight is invalid."
		     ,vc.white|vc.bold|vc.blink|vc.red*vc.bg);
     vcUpdateVIO(); }
  
  Disk_write_data();
  get_a_key();
  vcWinClose(data);

  return (VCSUCCESS);
 } /* end of Show_after_fuel_burn_data() */

 
 WriteDBRecord()  {
   FILE *fp;

   if( strcmp( previous_aircraft, aircraft ) == 0) {
   sprintf(buffer,"%s",AC_TAIL);
   strcpy(aircraft,buffer);
   strcat(aircraft,".wbd"); }

   /* check to see if this association exists */
   if((fp=fopen(aircraft, "r+b")) == NULL )
     { no_file(); file_open_error = YES; return (VCSUCCESS); }
     else fclose(fp);

   /* if associations match, write to the file */
    if( strcmp( WB.AC_TYPE, AircraftInfo.name ) != 0)
     { match = NO; NoMatch(); return( VCSUCCESS ); }
    /* does aircraft have at least basic empty weight and arm */
    if((WB.BEW_W <= 0) || (WB.BEW_A <= 0)) {
      NoBasicData(); return (VCSUCCESS); }
   
   if (match == YES ) {
     fp = fopen( aircraft, "r+b" );
     fseek( fp, 1 * sizeof( struct WB_data_structure), SEEK_SET );
     fwrite (&WB, sizeof( struct WB_data_structure ), 1, fp);
     fclose( fp );
     FileSaved_message();
    }/* end if match == YES */

   return ( VCSUCCESS );
  }

 New_WriteDBRecord()  {
   FILE *fp;
   /* int a is for verifying Association change */
   int a;
   VCWIN *create_notice;
   /* convert strings .wbd file name */
   sprintf(buffer,"%s",AC_TAIL);
   strcpy(aircraft,buffer);
   strcat(aircraft,".wbd");

   /* be sure to write the type of aircraft to file */
    strcpy(WB.AC_TYPE, AircraftInfo.name);

    /* does aircraft have at least basic empty weight and arm */
    if((WB.BEW_W <= 0) || (WB.BEW_A <= 0)) {
      NoBasicData(); return (VCSUCCESS); }
   
   /* Verify before association, if no then exit */
	a = VerifyAssociation();
	if(!a) {
	 return( VCSUCCESS );
	 }
   
   fp=fopen(aircraft, "w+b" );
   fseek( fp, 1 * sizeof( struct WB_data_structure ), SEEK_SET );
   fwrite (&WB, sizeof( struct WB_data_structure ), 1, fp);
   fclose( fp );

   /* notify user that new file was created and to press any key */
   create_notice = vcWinOpenX(7,11,17,70,"Notice",NULL,
       0, 0, vcBorderFromID(4), vcStdColor(1));
   vcWinAtSay( create_notice, 1,6, "Association newly created or changed!");
   vcWinAtSay( create_notice, 3,1, "Your aircraft ");
   vcWinAtSayX( create_notice, 3,15, AC_TAIL, vc.green|vc.bold+(vc.bg*vc.black),VCOF_SYSDFLT);
   vcWinAtSay( create_notice, 3,22, "has been associated with");
   vcWinAtSay( create_notice, 4,4, "the CG window for a");
   vcWinAtSayX( create_notice, 4,24, AircraftInfo.name, vc.green|vc.bold+(vc.bg*vc.black),VCOF_SYSDFLT);
   vcWinAtSay( create_notice, 7,11, "Press any key to continue.");
   vcStatSay("You have created a new or have changed the existing association", vc.white|vc.bold|vc.blue*vc.bg);
   vcUpdateVIO();
   get_a_key();
   vcWinClose( create_notice);

   return ( VCSUCCESS );
  }
/* ********************************************************** */
	VCCOUNT VerifyAssociation()
	{
	int a;
	char p;
	VCWIN *e;
	vcMouHide();
	e = vcWinOpenX(3,3,8,55," Verify Operation! ",
		 VCWF_CURSOR|VCWF_SHADOW,0,0,vcBorderFromID(1),
		 vcColorFromID(8));
	vcAtSay(1,10,"You are about to change aircraft");
	vcAtSay(2,5,"association! To cancel, press the N key");
	vcAtSay(3,18,"or Y to proceed.");
	
	vcUpdateVIO();
	p = getch();
	  switch (p)
	 {
	   case 'y' :
	   case 'Y' : a = 1;
			  break;
	   case 'n' :
	   case 'N' : a = 0;
			  break;
	   default  : a = 0;
			  break;
	 }
	vcMouShow();
	vcWinClose(e);
	return a;
	}
	
	/* ******************************************************** */


 GetDBRecord()  {
   FILE *fp;

   /* convert tail number to a file name */
   sprintf(buffer,"%s",AC_TAIL);
   strcpy(aircraft,buffer);
   strcat(aircraft,".wbd");

   /* set the previous aircraft value now */
   strcpy ( previous_aircraft, aircraft);

   /* check to see if this association exists */
   if((fp=fopen(aircraft, "r+b")) == NULL )
     { no_file(); Clear_Out_data_fields(); file_open_error = YES; return (VCSUCCESS);}
    else fclose(fp);

   /* open file for read */
   fp = fopen( aircraft, "r+b" );
   fseek( fp, 1 * sizeof( struct WB_data_structure ), SEEK_SET );
   fread (&WB, sizeof( struct WB_data_structure ), 1, fp);
   fclose( fp );
   if(WB.BEW_W > 0) { Data_Retrieved_message(); return (VCSUCCESS); }
   
   /* If there isn't a match then run the NoMatch function */
   NoMatch();
   
   return ( VCSUCCESS );
   }

/* my error functions */
VCCOUNT NoMatch()
  {
    VCWIN *e;
    
    e = vcWinOpenX(6,4,19,76,"Error!",	NULL,0,0,vcBorderFromID(5),
	vcColorFromID(20));
    vcCurHide(vccrt);
    /* display data in data window */
   vcWinAtSay( e, 1,2, "Aircraft CG File selected:");
   vcWinAtSayX( e, 1,32, AircraftInfo.name,
     vc.white|vc.bold+(vc.bg*vc.red), VCOF_SYSDFLT);
   vcWinAtSay( e, 3,2,"Tail number is associated to:");
   vcWinAtSayX( e, 3,32, WB.AC_TYPE,
     vc.white|vc.bold+(vc.bg*vc.red), VCOF_SYSDFLT);
   vcWinAtSay(e, 5,2,"Please select correct aircraft information file...");
   vcWinAtSay(e, 6,2,"Current data does not associate with the selected aircraft!");
   vcWinAtSay(e, 7,2,"You can change the association using create/edit");
   vcWinAtSay(e, 8,2,"If you are loading a tail number then press grab data");
   vcWinAtSay(e, 10,2,"          Press any key to return...");
   vcStatSay("Information file must match tail number association."
		     ,vc.white|vc.bold|vc.red*vc.bg);
   vcUpdateVIO();
   get_a_key();
   vcCurShow(vccrt);
   vcWinClose(e);
   return(VCSUCCESS);
  }

 VCCOUNT Aircraft_has_changed()
  {
    VCWIN *e;
    
    e = vcWinOpenX(7,7,15,70,"Error!",	NULL,0,0,vcBorderFromID(1),
	vcColorFromID(4));
    vcCurHide(vccrt);
    /* display data in data window */
   vcWinAtSay(e, 1,7,"     You changed the \"TAIL\" number!");
   vcWinAtSay(e, 2,7,"Please re-use the \"GrabData\" key to re-load data,");
   vcWinAtSay(e, 3,7,"make your changes, and proceed from there.");
   vcWinAtSay(e, 5,7,"       Press any key to return...");
   vcStatSay("Set \"TAIL\" number and select \"GET\" then edit data!"
		     ,vc.white|vc.bold|vc.red*vc.bg);
   vcUpdateVIO();
   get_a_key();
   vcCurShow(vccrt);
   vcWinClose(e);
   return(VCSUCCESS);
  }

 VCCOUNT no_file()
  {
    VCWIN *e;
    
    vcCurHide(vccrt);
    e = vcWinOpenX(10,8,19,67,"error!",
		     NULL,0,0,vcBorderFromID(1),
		     vcColorFromID(4));
    vcAtSay(1,4,"Please check your aircraft selection.");
    vcAtSay(2,4,"The \"tail\" number you entered does");
    vcAtSay(3,4,"not exist. If you wish to save this aircraft,");
    vcAtSay(4,4,"use the Create/edit button to associate the");
    vcAtSay(5,4,"information to the correct aircraft in the list");
    vcAtSay(7,4,"               Press any key...");
    vcStatSay("Use the create/edit button after setting fields to create the association!"
		     ,vc.white|vc.bold|vc.red*vc.bg);
    vcUpdateVIO();
    get_a_key();
    vcCurShow(vccrt);
    vcWinClose(e);
    return(VCSUCCESS);
  }

 VCCOUNT no_cg_file()
  {
    VCWIN *e;
    
    vcCurHide(vccrt);
    e = vcWinOpenX(10,8,19,67,"error!",
		     NULL,0,0,vcBorderFromID(1),
		     vcColorFromID(4));
    vcAtSay(1,4,"Please check your aircraft selection.");
    vcAtSay(2,4,"The \"tail\" number you entered does");
    vcAtSay(3,4,"not have an existing CG window file.");
    vcAtSay(4,4,"Use the CGMAN button to create the CG");
    vcAtSay(5,4,"data window for the aircraft type used.");
    vcAtSay(7,4,"         Press any key...");
    vcStatSay("Please verify that you have a CG window created for this aircraft model!"
		     ,vc.white|vc.bold|vc.red*vc.bg);
    vcUpdateVIO();
    get_a_key();
    vcCurShow(vccrt);
    vcWinClose(e);
    return(VCSUCCESS);
  }

 VCCOUNT FileSaved_message()
  {
    VCWIN *e;
    vcCurHide(vccrt);
    e = vcWinOpenX(10,11,19,65,"Message",
		     NULL,0,0,vcBorderFromID(1),
		     vcColorFromID(4));
    vcAtSay(1,4,"Your aircraft Data has been");
    vcAtSay(2,4,"saved successfully.  Press the Calc WB button");
    vcAtSay(3,4,"if you want the CG location. ");
    vcAtSay(4,4,"");
    vcAtSay(5,4,"       Press any key...");
    vcStatSay("The aircraft data has been saved!"
		     ,vc.white|vc.bold|vc.blue*vc.bg);
    vcUpdateVIO();
    get_a_key();
    vcCurShow(vccrt);
    vcWinClose(e);
    return(VCSUCCESS);
  }

 VCCOUNT Data_Retrieved_message()

  {
    VCWIN *e;
    vcCurHide(vccrt);
    e = vcWinOpenX(10,9,19,66,"Message",
		     NULL,0,0,vcBorderFromID(1),
		     vcColorFromID(4));
    vcAtSay(1,4,"Data retrieved for this aircraft.");
    vcAtSay(2,4,"Make changes and press Calc WB to find");
    vcAtSay(3,4,"the new CG location.  Data not automatically saved.");
    vcAtSay(4,4,"To do so, you must press the \"SAVE\" button");
    vcAtSay(5,4,"                Press any key...");
    vcStatSay("Data retrieved for this specific aircraft!"
		     ,vc.white|vc.bold|vc.blue*vc.bg);
    vcUpdateVIO();
    get_a_key();
    vcCurShow(vccrt);
    vcWinClose(e);
    return(VCSUCCESS);
  }

VCCOUNT ManageTail()
{
  union REGS regs;
  struct SREGS s;
  VCCOUNT stat;
  VCTEXT *savebuf;
  VCTEXT *comspec;
  VCCOORD r,c;

  
/* See how much memory we need to save  */
  regs.x.ax = 21;
  int86( 0x33, &regs, &regs );
  savebuf = (VCVOID *)vcAlloc( 1, regs.x.bx );

  comspec = getenv("COMSPEC");

  if( savebuf != (VCTEXT *)0 && comspec != (VCTEXT *)0 )
    {
    /* save mouse state */
    regs.x.ax = 22;
    regs.x.dx = FP_OFF( savebuf );
    s.es =      FP_SEG( savebuf );
    int86x( 0x33, &regs, &regs, &s );

    /* reset mouse for a polite exit */
    regs.x.ax = 33;
    int86( 0x33, &regs, &regs );
     vc_WinPut( vccrt->rw );
     vcUpdateVIO();
     vcAt( 0, 0 );
    /********** */
    /* check for program to list trip files */
    stat=CheckForUseair();
    if(stat == 0)             {
       vcUpdateVIO();
       vcAt( 0, 0 );
        
       system("fileget.exe ????????.wbd");  }  /* change to wb front page when created */
    if(stat < 0)
      No_Fileget();

    /* restore mouse state */
    regs.x.ax = 23;
    regs.x.dx = FP_OFF( savebuf );
    s.es =      FP_SEG( savebuf );
    int86x( 0x33, &regs, &regs, &s );
    vcFree( savebuf );

    /* restore original Vitamin C display */
    vc_WinPut( vccrt->rw );
    vc_WinPutBranch( vccrt->rw );

  r = wcurrent->r;
  c = wcurrent->c;
  if( vccrt->cursor.hidden ||                    // if hidden
      (wcurrent->hidecnt)   ||                   // or hidecount
      !(wcurrent->flags & VCWF_CURSOR)  ||       // or cursorless
      vcObsPoint(wcurrent, &r, &c) == -1 )       // or obscured
    {
    vccrt->cursor.cswitch = VCOFF;
    vccrt->cursor.ctrans  = 1;
    }
  else
    {
    vccrt->cursor.cswitch = VCON;
    vccrt->cursor.ctrans  = 1;
    }
  if( vccrt->cursor.cfunc )
    (*vccrt->cursor.cfunc)(vccrt, r, c);
     vcMouSetPos(6,56);                   // prevents pushing button twice
     vcUpdateVIO();
    }
  else
	vcBell();
return( VCSUCCESS );
}

VCCOUNT ManageAirFile()
{
  union REGS regs;
  struct SREGS s;
  VCCOUNT stat;
  VCTEXT *savebuf;
  VCTEXT *comspec;
  VCCOORD r,c;

  
/* See how much memory we need to save  */
  regs.x.ax = 21;
  int86( 0x33, &regs, &regs );
  savebuf = (VCVOID *)vcAlloc( 1, regs.x.bx );

  comspec = getenv("COMSPEC");

  if( savebuf != (VCTEXT *)0 && comspec != (VCTEXT *)0 )
    {
    /* save mouse state */
    regs.x.ax = 22;
    regs.x.dx = FP_OFF( savebuf );
    s.es =      FP_SEG( savebuf );
    int86x( 0x33, &regs, &regs, &s );

    /* reset mouse for a polite exit */
    regs.x.ax = 33;
    int86( 0x33, &regs, &regs );
     vc_WinPut( vccrt->rw );
     vcUpdateVIO();
     vcAt( 0, 0 );
    /********** */
    /* check for program to list trip files */
    stat=CheckForUseair();
    if(stat == 0)             {
       vcUpdateVIO();
       vcAt( 0, 0 );
        
       system("fileget.exe ????????.air");  }  /* change to wb front page when created */
    if(stat < 0)
      No_Fileget();

    /* restore mouse state */
    regs.x.ax = 23;
    regs.x.dx = FP_OFF( savebuf );
    s.es =      FP_SEG( savebuf );
    int86x( 0x33, &regs, &regs, &s );
    vcFree( savebuf );

    /* restore original Vitamin C display */
    vc_WinPut( vccrt->rw );
    vc_WinPutBranch( vccrt->rw );

  r = wcurrent->r;
  c = wcurrent->c;
  if( vccrt->cursor.hidden ||                    // if hidden
      (wcurrent->hidecnt)   ||                   // or hidecount
      !(wcurrent->flags & VCWF_CURSOR)  ||       // or cursorless
      vcObsPoint(wcurrent, &r, &c) == -1 )       // or obscured
    {
    vccrt->cursor.cswitch = VCOFF;
    vccrt->cursor.ctrans  = 1;
    }
  else
    {
    vccrt->cursor.cswitch = VCON;
    vccrt->cursor.ctrans  = 1;
    }
  if( vccrt->cursor.cfunc )
    (*vccrt->cursor.cfunc)(vccrt, r, c);
     vcMouSetPos(6,56);                   // prevents pushing button twice
     vcUpdateVIO();
    }
  else
	vcBell();
 return( VCSUCCESS );
}

VCCOUNT CheckForUseair()
 {
  /* see if wb executable exists */
  VCCOUNT stat;
  FILE *exist;
       if((exist = fopen("fileget.exe","rb")) != NULL ) {
	      stat = 0;
	      fclose(exist);
	     }
	    else
	     stat = -1;
   return stat;
  }


VCCOUNT No_Fileget()
     {
       VCWIN *n;
       
	 n = vcWinOpenX(8,5,16,65," Oops! ",VCWF_SHADOW,
	    0,0,vcBorderFromID(1),vcColorFromID(9));
	 vcAtSay(1, 1,"Could not Find: \"fileget.EXE");
	 vcAtSay(2, 1,"This program and all supporting files");
	 vcAtSay(3, 1,"Must be in Flight Log Maker's Directory!");
	 vcAtSay(5, 1,"Press any keyboard key to continue...");
	 vcStatSay("                                    Error", vc.white|vc.bold|vc.blink|vc.blue*vc.bg);
	 vcUpdateVIO();
	 get_a_key();
	 vcWinClose(n);
       return( VCSUCCESS );
    }



VCCOUNT Aircraft_Loaded()
     {
       VCWIN *n;
	 n = vcWinOpenX(9,11,13,61," Info! ",VCWF_SHADOW,
	    0,0,vcBorderFromID(1),vcColorFromID(4));
	 vcWinAtSay( n, 1,6, "Aircraft Selected:");
	 vcWinAtSayX( n, 1,31, AC_TAIL,
	   vc.white|vc.bold+(vc.bg*vc.red), VCOF_SYSDFLT);

	 vcStatSay("Press GrabData key to update the form", vc.white|vc.bold|vc.blink+(vc.blue*vc.bg));
	 vcUpdateVIO();
	 get_a_key();
	 vcWinClose(n);
       return( VCSUCCESS );
    }

VCCOUNT UpdateNavForm()
     {
       vcPutFldBuf(obj1, &WB.BEW_W);
	  vcPostMsg(VCOBJDRAW, obj1,0L, 0L, 0L);
       vcPutFldBuf(obj2, &WB.BEW_A);
	  vcPostMsg(VCOBJDRAW, obj2,0L, 0L, 0L);
       vcPutFldBuf(obj3, &WB.FBAGS_W);
	  vcPostMsg(VCOBJDRAW, obj3,0L, 0L, 0L);
       vcPutFldBuf(obj4, &WB.FBAGS_A);
	  vcPostMsg(VCOBJDRAW, obj4,0L, 0L, 0L);
       vcPutFldBuf(obj5, &WB.PILOT_SEAT_W);
	  vcPostMsg(VCOBJDRAW, obj5,0L, 0L, 0L);
       vcPutFldBuf(obj6, &WB.PILOT_SEAT_A);
	  vcPostMsg(VCOBJDRAW, obj6,0L, 0L, 0L);
       vcPutFldBuf(obj23, &WB.FORW_SEAT_W);
	  vcPostMsg(VCOBJDRAW, obj23,0L, 0L, 0L);
       vcPutFldBuf(obj24, &WB.FORW_SEAT_A);
	  vcPostMsg(VCOBJDRAW, obj24,0L, 0L, 0L);
       vcPutFldBuf(obj7, &WB.MFUEL_W);
	  vcPostMsg(VCOBJDRAW, obj7,0L, 0L, 0L);
       vcPutFldBuf(obj8, &WB.MFUEL_A);
	  vcPostMsg(VCOBJDRAW, obj8,0L, 0L, 0L);
       vcPutFldBuf(obj9, &WB.AFUEL_W);
	  vcPostMsg(VCOBJDRAW, obj9,0L, 0L, 0L);
       vcPutFldBuf(obj10, &WB.AFUEL_A);
	  vcPostMsg(VCOBJDRAW, obj10,0L, 0L, 0L);
       vcPutFldBuf(obj11, &WB.RSEATS_1_W);
	  vcPostMsg(VCOBJDRAW, obj11,0L, 0L, 0L);
       vcPutFldBuf(obj12, &WB.RSEATS_1_A);
	  vcPostMsg(VCOBJDRAW, obj12,0L, 0L, 0L);
       vcPutFldBuf(obj13, &WB.RSEATS_2_W);
	  vcPostMsg(VCOBJDRAW, obj13,0L, 0L, 0L);
       vcPutFldBuf(obj14, &WB.RSEATS_2_A);
	  vcPostMsg(VCOBJDRAW, obj14,0L, 0L, 0L);
       vcPutFldBuf(obj15, &WB.RBAGS_W);
	  vcPostMsg(VCOBJDRAW, obj15,0L, 0L, 0L);
       vcPutFldBuf(obj16, &WB.RBAGS_A);
	  vcPostMsg(VCOBJDRAW, obj16,0L, 0L, 0L);
       vcPutFldBuf(obj17, &WB.RBAGS2_W);
	  vcPostMsg(VCOBJDRAW, obj17,0L, 0L, 0L);
       vcPutFldBuf(obj18, &WB.RBAGS2_A);
	  vcPostMsg(VCOBJDRAW, obj18,0L, 0L, 0L);
       vcPutFldBuf(obj19, &WB.TAXFUEL_W);
	  vcPostMsg(VCOBJDRAW, obj19,0L, 0L, 0L);
       vcPutFldBuf(obj20, &WB.TAXFUEL_A);
	  vcPostMsg(VCOBJDRAW, obj20,0L, 0L, 0L);
       vcPutFldBuf(obj21, &WB.FBURN_W);
	  vcPostMsg(VCOBJDRAW, obj21,0L, 0L, 0L);
       vcPutFldBuf(obj22, &WB.FBURN_A);
	  vcPostMsg(VCOBJDRAW, obj22,0L, 0L, 0L);
       vcPutFldBuf(obj25, &WB.FBURN2_W);
	  vcPostMsg(VCOBJDRAW, obj25,0L, 0L, 0L);
       vcPutFldBuf(obj26, &WB.FBURN2_A);
	  vcPostMsg(VCOBJDRAW, obj26,0L, 0L, 0L);
       vcPutFldBuf(obj27, &AC_TAIL);
	  vcPostMsg(VCOBJDRAW, obj27,0L, 0L, 0L);      
    vcPutFldBuf(obj28, &AircraftInfo.ac_info_filename);
	  vcPostMsg(VCOBJDRAW, obj28,0L, 0L, 0L);
vcUpdateVIO();
      return( VCSUCCESS );
     }

VCCOUNT HelpWindow1() {


   help_win = vcWinOpenX(0,2,16,70," Help ",VCWF_SHADOW,
     0,0,vcBorderFromID(1),vcColorFromID(4));

   vcWinAtSayX( help_win, 0,1, "Load aircraft CG info file before typing in the tail number",
     vc.white|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
   vcWinAtSayX( help_win, 1,1, "of your aircraft.  Fill in all necessary data.  Press the",
     vc.white|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
   vcWinAtSayX( help_win, 2,1, "CREATE/EDIT push button.  The data is saved and the aircraft",
     vc.white|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
   vcWinAtSayX( help_win, 3,1, "is associated with the loaded aircraft info file.",
     vc.white|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
   vcWinAtSayX( help_win, 5,1, "The create/edit button will not be required until you create",
     vc.white|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
   vcWinAtSayX( help_win, 6,1, "another airplane to use. ",
     vc.white|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
   vcWinAtSayX( help_win, 8,1, "The save and calculate buttons only work if the tail number",
     vc.white|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
   vcWinAtSayX( help_win, 9,1, "matches the aircraft CG information file loaded.",
     vc.white|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
   
   vcWinAtSayX( help_win, 14,23, "Press any key to exit",
     vc.green|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);

   vcUpdateVIO();
   get_a_key();
   vcWinClose(help_win);
   return( VCSUCCESS );
  }

 

VCCOUNT Disk_write_data()  {
    FILE *media;

    /* open text file to write the data */
    media = fopen("results.wbl","w");

    /* data to print */
    fprintf(media,"\nFlight Log Maker Weight and Balance v3.1");
    fprintf(media,"    Aircraft: \"%s\"\n",AC_TAIL);
    fprintf(media,"Type: %s \n\n", AircraftInfo.name);
    /* if not errors in fuel burn weights */
    if( ( WB.FBURN_W > 0 ) || ( WB.TAXFUEL_W > 0) || (WB.FBURN2_W > 0 ) ||
	(WB.MFUEL_W + WB.AFUEL_W) / FUELWT > AircraftInfo.ac_fuelcapacity ||
	( abs(WB.FBURN_W + WB.FBURN2_W + WB.TAXFUEL_W)) >= (WB.MFUEL_W + WB.AFUEL_W)
      ) {
     fprintf(media, "There are errors in Taxi fuel or trip fuel burns.\n");
     fprintf(media, "or with total fuel placed on the aircraft.\n");
     fprintf(media, "Recheck values and re-calculate!\n");
     
     fclose(media);
    return(VCSUCCESS);
   }
     

    fprintf(media,"                        Weight                Arm                Moment\n");
    fprintf(media,"-----------------------------------------------------------------------\n");
    fprintf(media,"B.E.W                 %8.1f           %8.1f              %8.1f \n", WB.BEW_W, WB.BEW_A, moments[0] );
    if ( WB.BEW_W != 0 ) { fprintf(media,"Pilot seat            %8.1f           %8.1f              %8.1f \n", WB.PILOT_SEAT_W, WB.PILOT_SEAT_A, moments[3] ); }
    if ( WB.FORW_SEAT_W != 0 ) { fprintf(media,"Front seat            %8.1f           %8.1f              %8.1f \n", WB.FORW_SEAT_W, WB.FORW_SEAT_A, moments[4] ); }
    if ( WB.RSEATS_1_W != 0 ) { fprintf(media,"Rear seat             %8.1f           %8.1f              %8.1f \n", WB.RSEATS_1_W, WB.RSEATS_1_A, moments[5] ); }
    if ( WB.RSEATS_2_W != 0 ) { fprintf(media,"Rear seat             %8.1f           %8.1f              %8.1f \n", WB.RSEATS_2_W, WB.RSEATS_2_A, moments[6] ); }
    if ( WB.FBAGS_W != 0 ) { fprintf(media,"Forw. baggage/Oil     %8.1f           %8.1f              %8.1f \n", WB.FBAGS_W, WB.FBAGS_A, moments[7] ); }
    if ( WB.RBAGS_W != 0 ) { fprintf(media,"Rear baggage Area     %8.1f           %8.1f              %8.1f \n", WB.RBAGS_W, WB.RBAGS_A, moments[8] ); }
    if ( WB.RBAGS2_W != 0 ) { fprintf(media,"Rear baggage Area     %8.1f           %8.1f              %8.1f \n", WB.RBAGS2_W, WB.RBAGS2_A, moments[9] ); }
    fprintf(media,"-----------------------------------------------------------------------\n");
    fprintf(media,"Zero fuel weight      %8.1f           %8.1f              %8.1f \n", zero_fuel_weight, zero_fuel_arm, zero_fuel_moment );
    fprintf( media,"\n");
    fprintf(media,"Main fuel area        %8.1f           %8.1f              %8.1f \n", WB.MFUEL_W, WB.MFUEL_A, moments[1] );
    if ( WB.AFUEL_W > 0 ) { fprintf(media,"Auxiliary fuel area   %8.1f           %8.1f              %8.1f \n", WB.AFUEL_W, WB.AFUEL_A, moments[2] ); }
    fprintf(media,"-----------------------------------------------------------------------\n");
    fprintf(media,"Takeoff Weight        %8.1f           %8.1f              %8.1f  \nTaxi fuel calculated\n", takeoff_weight, takeoff_CG, takeoff_moment );

    /* print statements regarding CG limits */
    if( ( takeoff_CG < CG.rearward_cg )/* && ( takeoff_CG > CG.forward_cg ) */
      && ( takeoff_weight <= CG.maximum_weight) )
      { fprintf(media, "\nTake off CG is within normal CG limits\n"); }
      else fprintf(media, "\nTake off CG IS NOT WITHIN NORMAL CG LIMITS!\n");
    if( ( takeoff_CG < CG.utility_rearward_cg ) && ( takeoff_CG > CG.utility_forward_cg )
      && ( takeoff_weight <= CG.utility_maximum_weight) )
      { fprintf(media, "Take off CG is within the Utility CG limits\n"); }
      else fprintf(media, "Take off CG IS NOT WITHIN UTILITY CG LIMITS!\n");



    if( ( WB.FBURN_W < 0 ) || ( WB.FBURN2_W < 0 ) ){
       fprintf( media,"\n");
       fprintf(media,"Start, taxi fuel used %8.1f           %8.1f              %8.1f \n", WB.TAXFUEL_W, WB.TAXFUEL_A, moments[10] );
       fprintf(media,"Main fuel used        %8.1f           %8.1f              %8.1f \n", WB.FBURN_W, WB.FBURN_A, moments[11] );
       fprintf(media,"Aux. fuel used        %8.1f           %8.1f              %8.1f \n", WB.FBURN2_W, WB.FBURN2_A, moments[12] );
       fprintf(media,"------------------------------------------------------------------------\n");
       fprintf(media,"Landing               %8.1f           %8.1f              %8.1f \n", after_fuel_burn_weight, after_fuel_burn_CG, after_fuel_burn_moment);


    /* landing limits messages */
    if( ( after_fuel_burn_CG < Landing_CG.landing_rearward_cg ) && ( after_fuel_burn_CG > Landing_CG.landing_forward_cg )
        && ( after_fuel_burn_weight <= Landing_CG.landing_max_weight)   )
      { fprintf(media, "\nLanding CG is within normal CG limits\n"); }
	 else { fprintf(media, "\nLanding CG IS NOT WITHIN NORMAL CG LIMITS!\n"); }
    if( ( after_fuel_burn_CG  < Landing_CG.landing_utility_rearward_cg ) && ( after_fuel_burn_CG > Landing_CG.landing_utility_forward_cg )
      && ( after_fuel_burn_weight <= Landing_CG.landing_utility_max_weight) )
      { fprintf(media, "Landing CG is within the Utility CG limits\n"); }
      else { fprintf(media, "Landing CG IS NOT WITHIN UTILITY CG LIMITS!\n"); } }

    /* newline and eject page */
    fprintf(media,"\n");
    fprintf(media,"\f");
    fclose(media);
    return(VCSUCCESS);
   }

/* ------------------------------------------------------------ */
 CreateData( VCOBJ *obj )  {
   vcSendMsg( VCENDFORM, ( VCVOID * ) obj->win, 0L, 0L, 0L );
   New_WriteDBRecord();
   match = YES;
   vcSendMsg( VCSTARTFORM, ( VCVOID *)obj->win, 0L, 0L, 0L );
   return ( VCSUCCESS );
  }


 SaveData( VCOBJ *obj )  {
   vcSendMsg( VCENDFORM, ( VCVOID * ) obj->win, 0L, 0L, 0L );
   WriteDBRecord();
   /* reset these two switches */
   match = YES;
   file_open_error = NO;

   vcSendMsg( VCSTARTFORM, ( VCVOID *)obj->win, 0L, 0L, 0L );
   return ( VCSUCCESS );
  }

 GetData( VCOBJ *obj )  {
   vcSendMsg( VCENDFORM, ( VCVOID * ) obj->win, 0L, 0L, 0L );
   GetDBRecord();
   /* reset this switch */
   match = YES;
   file_open_error = NO;

   UpdateNavForm();
   vcSendMsg( VCSTARTFORM, ( VCVOID *)obj->win, 0L, 0L, 0L );
   return ( VCSUCCESS );
  }

 DoCalc( VCOBJ *obj ) {
   vcSendMsg( VCENDFORM, ( VCVOID * ) obj->win, 0L, 0L, 0L );
   /* only if match is zero */
    if( ( match == YES ) && ( file_open_error == NO ) ){
    Calc( );
    }
   /* reset these two switches */
   match = YES;
   file_open_error = NO;
   UpdateNavForm();
   vcSendMsg( VCSTARTFORM, ( VCVOID *)obj->win, 0L, 0L, 0L );
   return ( VCSUCCESS );
  }

VCCOUNT UpdateTailField()
     {
       FILE *fp; /* temporary pointer to read ac tailnumber string from file */

/* need to clear all the entry fields before grabbing new data */
  Clear_Out_data_fields();

  ManageTail();

/* open a file to get the aircraft tail number string */
       if((fp=fopen("useplane","r"))!=NULL)  {
	 fseek(fp,0 * sizeof(struct name),SEEK_SET);
	 fread(&Tail_number,sizeof(struct name),1,fp);
	 fclose(fp); }
       strncpy(AC_TAIL, Tail_number.fname,6);       
       AC_TAIL[6] = '\0';
       Aircraft_Loaded();
       UpdateNavForm();
       vcUpdateVIO();
      return( VCSUCCESS );
     }
     
     
VCCOUNT UpdateAirInfoField()  {
    FILE *fp; /* temporary pointer to read ac tailnumber string from file */
      
 /* clear space in case previous message was here
  * because some messages take of different amounts of space */

// clear bottom loaded aircraft and update form  
  vcAtSayX(20,2, "No aircraft loaded yet                  ",
  	  vc.brown|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);
    vcUpdateVIO();

/* need to clear all the entry fields before grabbing new data */
  Clear_Out_data_fields();
  Clear_airStructfile();
  ManageAirFile();

/* open a file to get the aircraft tail number string */
       if((fp=fopen("useplane","r"))!=NULL)  {
	 fseek(fp,0 * sizeof(struct info_name),SEEK_SET);
	 fread(&Info_Path,sizeof(struct info_name),1,fp);
	 fclose(fp); }
       strncpy(AircraftInfo.ac_info_filename, Info_Path.info_name, 13);
       AircraftInfo.ac_info_filename[13] = '\0';
       UpdateNavForm();
       vcUpdateVIO();
     
      return( VCSUCCESS );
     }     

VCCOUNT ReadAircraftFile( VCOBJ *obj ) {
FILE *fp;

VCWIN *win;
/* before ending the form - clear line 20 aircraft info */ 
   vcAtSayX(20,2, "                                        ",
    vc.blue|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);

/* this step saves all of the objects in the form before reading */
    vcSendMsg( VCENDFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
	
	/* see if the filename exists, then open it if it does */
	/* use r+b for reading and writing rb for read only */
	if ((fp = fopen(AircraftInfo.ac_info_filename,"r+b")) != NULL)
	  {
	   fseek(fp, record_length, SEEK_SET);
	   fread(&AircraftInfo, sizeof(struct AircraftStructure),1,fp);
	   fclose(fp); }
	   else { not_found(); button1 = 0;
	   Clear_airStructfile();
	     
	   vcSendMsg( VCSTARTFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
	    
	    vcUpdateVIO(); /* just added */
	    return(VCSUCCESS); }

/* print the message */
    vcAtSayX(20,2, "Loaded:",
	  vc.brown|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);
    vcAtSayX(20,10, AircraftInfo.name,
	  vc.brown|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);
 
    button1 = 0;
    
    vcSendMsg( VCSTARTFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
   return(VCSUCCESS);
  }

VCCOUNT Clear_airStructfile()  {
   *AircraftInfo.ac_info_filename = NULL;
   *AircraftInfo.name = NULL;
   *AircraftInfo.a_file = NULL;
   *AircraftInfo.b_file = NULL;
   *AircraftInfo.n_file = NULL;
   *AircraftInfo.d_file = NULL;
   *AircraftInfo.cgd_file = NULL;
   AircraftInfo.is_complex = FALSE; 
 return (VCSUCCESS);
}

/* error function: warns if file not found */
	VCCOUNT not_found()
	{
	VCWIN *e;
	 
 
	vcCurHide(vccrt);
	e = vcWinOpenX(7,10,13,70," Error with filename! ",
		 NULL,0,0,vcBorderFromID(5),
		 vcColorFromID(20));
	Clear_airStructfile();
	vcAtSay(1,15,"That file was not found.");
	vcAtSay(2,15,"Recheck the filename entered.");
	vcAtSay(3,15,"Aircraft Structure being cleared.");
	vcStatSay("Cannot find a file by the name used."
		 ,vc.brown|vc.bold|vc.blue*vc.bg);
	
	vcUpdateVIO();
	get_a_key();
	vcCurShow(vccrt);
	vcWinClose(e);
/* clear space in case previous message was here 
 * because some messages take of different amounts of space */
/* this statement moved down one line in wb program to 
 * better fit the window */
    
    vcAtSayX(20,2, "                                        ",
	  vc.blue|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);   
    vcAtSayX(20,2, "No aircraft CG loaded                   ",
	vc.brown|vc.blink|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);
     
	return(VCSUCCESS); }

Clear_Out_data_fields( ) {
  Erase_fields(); 
  UpdateNavForm();
 return ( VCSUCCESS ); }

Erase_fields() {
	strcpy(WB.AC_TYPE, "not loaded.....               "); WB.BEW_W = 0; WB.BEW_A = 0;
    WB.MFUEL_W = 0; WB.MFUEL_A = 0; WB.AFUEL_W = 0;
    WB.AFUEL_A = 0; WB.PILOT_SEAT_W = 0; WB.PILOT_SEAT_A = 0;
    WB.FORW_SEAT_W = 0; WB.FORW_SEAT_A = 0; WB.RSEATS_1_W = 0;
    WB.RSEATS_1_A = 0; WB.RSEATS_2_W = 0; WB.RSEATS_2_A = 0;
    WB.FBAGS_W = 0; WB.FBAGS_A = 0; WB.RBAGS_W = 0;
    WB.RBAGS_A = 0; WB.RBAGS2_W = 0; WB.RBAGS2_A = 0;
    WB.TAXFUEL_W = 0; WB.TAXFUEL_A = 0; WB.FBURN_W = 0;
    WB.FBURN_A = 0; WB.FBURN2_W = 0; WB.FBURN2_A = 0;
    return (0); }

VCCOUNT NoBasicData()
  {
    VCWIN *e;
    
    e = vcWinOpenX(6,4,19,51,"Error!",	NULL,0,0,vcBorderFromID(1),
	vcColorFromID(4));
    vcCurHide(vccrt);
    /* display data in data window */
   vcWinAtSay( e, 1,2, "Bad Basic Empty Weight or Arm entered.");
   vcWinAtSay( e, 4,2,"Zero or negative numbers are invalid!");
    vcWinAtSay( e, 6,2,"        File was not saved..."); 
   vcWinAtSay(e, 9,2,"       Press any key to return...");
   vcStatSay("At the minimum - Basic Empty Weight and Arm must be entered."
		     ,vc.white|vc.bold|vc.red*vc.bg);
   vcUpdateVIO(); 
   get_a_key();
   vcCurShow(vccrt);
   vcWinClose(e);
   return(VCSUCCESS);
  }
/* end */



