	// New Flight Log Maker Version 5.3 to 5.3.1 program file.
	// Date of latest update: 10/05/2024
	// By: Ron Lewis

	#include <vcstdio.h>
	#include <process.h>
	#include <conio.h>
	#include <string.h>
	#include <math.h>
	#include <stdlib.h>
	#include <stat.h>
	#include <time.h>
    #include <hprecord.h>

	#define STATUS 2
	#define ERROR 1
	#define SET 1
	#define OFF 0
	#define MINALTITUDE 2000
	#define MAXALTITUDE 12000
	#define AR 1.745329E-02   /* radians to degrees */
	#define RA 57.29578       /* degrees to radians */
	//#define RD 500	          /* average rate of descent small aircrft */

	/*window id's */
	#define DATAENTRYWINID 101
	#define NAVWINID 102
	#define OUTPUTWINID 103
/* --------------added for newflt upgrade ------------------ */

   /* structure to hold Aircraft information */
   struct AircraftStructure {
    char ac_info_filename[13];
    char name[31];
    char a_file[13];
    char b_file[13];
    char n_file[13];
    char d_file[13];
    char cgd_file[13];
    int is_complex; /* Complex airplane? */
    float ac_fuelcapacity; /* Added on 2/2016 */
} AircraftInfo; 
/* ---------------------------------------------------------- */
   /* data structure: navigation segments */
	struct nav {
	char name[31];
	int distc;
	int magnetic_crs;
	int wind_dir;
	int wind_spd;
	} segment[10];

	/* make a pointer to nav structure */
	struct nav *ptr2nav[10];

	/* data structure: regular data file */
	struct fltdata {
	int tas;
	double fc;
	int rc;
	int cs;
	int bhp;
	int rpm;
	int mp;
	} perform;

	/* data structure: default data file */
	struct pwr_settings {
	int tas;
	double fc;
	int rc;
	int cs;
	int bhp;
	int rpm;
	int mp;
	} defaults;

	/* array to contain high performance record numbers */
	static int performance[14740];

	/* data structure: airport data */
	struct airports {
	int d_elevation;
	int a_elevation;
	double d_atis;
	double a_atis;
	double d_clrcdeliv;
	double a_clrcdeliv;
	double d_ground;
	double a_ground;
	double d_tower;
	double a_tower;
	double departcnt;
	double arrivalcnt;
	double d_fss;
	double a_fss;
	double d_unicom;
	double a_unicom;
	}  AirportData;

	/* structure for trip path and filename */
	struct name {
	  char fname[7];
	} Path;

    /* structure for aircraft info file string */
    struct info_name {
      char info_name[70];
    } Info_Path;


	/* Global file pointer */
	FILE *fp, *exist, *media;
/* ------------added for newflt.c upgrade --------- */
	VCOBJ *obj;
/* ------------------------------------------------ */
	char msgstring[] = "Log sent to: ";
    char bad_name[] = "";  // file name should not be blank
	char bad_name2[] = "      .log"; //same as above

	/* structure for date time: used in print/file routine */
	time_t t;

	/* Global functions */
	VCCOUNT choosefile(int temp_difference);
	VCVOID density_alt(VCCOUNT temp, VCCOUNT pa, VCCOUNT elev, VCCOUNT *da,
	 VCCOUNT *stand_temp, VCCOUNT *temp_difference);
	VCVOID windmath(struct nav ptr2nav[], VCCOUNT cruise_tas, VCCOUNT groundspeed[],
	 VCFLOAT crosswind[], VCLONG *avspeedmoment);
	VCCOUNT wind_correction(struct nav ptr2nav[], VCFLOAT crosswind,
	 VCCOUNT course[], VCCOUNT groundspeed, VCFLOAT correction[], char add_or_subtract[] );
	VCVOID fuel_time(struct nav ptr2nav[], VCCOUNT groundspeed,
	 VCDOUBLE cruise_fc, VCFLOAT legtime[], VCFLOAT legfuel[], VCFLOAT runningfueltotal[],
	 VCFLOAT *totalfuel, VCFLOAT *totaltime,
	 VCCOUNT *totaldistance, VCFLOAT leghours[], VCFLOAT legminutes[],
	 VCCOUNT *totalhours, VCFLOAT *totalminutes);

	 /* ----------------added for upgrade --------------------- */
	 VCCOUNT ReadAircraftFile( VCOBJ *obj );
     VCCOUNT Clear_airStructfile( VCVOID );
     VCCOUNT CheckForUseair( VCVOID );
     VCCOUNT UpdateAirInfoField( VCVOID );
	 VCCOUNT No_Fileget( VCVOID );
     VCCOUNT ManageAirFile( VCVOID );
     VCCOUNT ManageWB( VCVOID );
     VCCOUNT not_found( VCVOID );
     VCCOUNT ManageCG( VCVOID );  //new pb on performance page
     VCCOUNT CheckForCGMAN( VCVOID );
     VCCOUNT No_CGMAN( VCVOID );
     VCCOUNT ManageNewAC(VCVOID);
     VCCOUNT CheckForNewAC(VCVOID);
     VCCOUNT No_NewAC(VCVOID);
     VCCOUNT ResetForm( VCVOID );

     VCCOUNT Calc_Rental_Costs ( VCVOID );
    /* ------------------------------------------------------- */

	/* function prototypes for Dos Shell */
	VCCOUNT pbSystem(VCOBJ *obj);

	/* used in main() */
	VCCOUNT SaveData(),cont3(),myEnd(),winfilter();
	VCCOUNT pbshell(), ManageFM();
	/* used throughout program */
	VCCOUNT file_error();

	VCCOUNT Calc();

	/* used within the calc() function */
	VCCOUNT Calc_set_hp_array();
	VCCOUNT Calc_save_listbox_selections();
	VCCOUNT Calc_reset_variables();

	VCCOUNT Calc_takeoff_set_files_used();
	VCCOUNT Calc_Open_HIGHP_file_takeoff();
	VCCOUNT Calc_Open_NORMP_file_takeoff();
	VCCOUNT Calc_Open_DEFLT_file_t_off();
	VCCOUNT Calc_Save_DEPART_data();

	VCCOUNT Calc_Cruise_set_files_used();
	VCCOUNT Calc_Open_HIGHP_file_cruise();
	VCCOUNT Calc_Open_NORMP_file_cruise();
	VCCOUNT Calc_Open_DEFLT_file_cruise();
	VCCOUNT Calc_Save_CRUISE_data();

	VCCOUNT Calc_Create_Nav_segment_pointers();
	VCCOUNT Calc_Check_Nav_validity();
	VCCOUNT Calc_Calculate_all_segments();
	VCCOUNT Calc_TotalsAndRemainingFuelTimeDistance();
	VCCOUNT Calc_Print_results_to_Flightlog_page();

	/* global window pointer */
	VCWIN  *win, *help, *agreewin;

	/* Global variable declarations */
	int takeoff_stand_temp, cruise_stand_temp;
	int pressure_alt_takeoff, pressure_alt_cruise;
	int m_p, cruise_density_alt, temp_surface, temp_cruise;
	int record_hp, record_normal, temp_difference_cruise;
	int depart_rc, depart_cs, takeoff_density_alt, temp_difference_takeoff;
	int cruise_rc, cruise_cs, cruise_tas, cruise_bhp, climb_average_speed,climb_average_roc;
	int depart_gs, cruise_gs;
	int index, value, limit, count, departure_default_rc, departure_default_cs;

	int retry_departure_settings_flag = OFF, departure_power_settings_changed = OFF;
	int retry_cruise_settings_flag = OFF, cruise_power_settings_changed = OFF;
	float local_pressure;
	float RATE_wet, RATE_dry, RATE_fuelcost, Cost_fuel, Cost_wet, Cost_dry,Time_tenths, DRY_total;
	double cruise_fc, stt_fc;
	float totalfuel, legfuel[8], runningfueltotal[8], legtime[8];

    char current_file[13];
	char takeoffile[13], default_file[13];

	int j, d, f, totaldistance, c, climbdefault;
	VCCOUNT totalhours;
	VCFLOAT totalminutes;
	float leghours[9], legminutes[9], totaltime=0;
	float climb_distance, climb_time;
	float descent_distance, milpermin_c, milpermin_d;
	float rem_time, rem_hours[9], rem_minutes[9];
	int rdistc, rem_distc[9];
	float diff_c, diff_d, rate;
	int groundspeed[9], course[9];
	char add_or_subtract[9];
	char *plus = "+", *minus = "-", *blank = " ";
	float crosswind[9], correction[9];
	long avspeedmoment, totlmoment;
	long grdspeedavg;
	int  number, calcounter=0;
	int file_error_flag = OFF, no_mp_flag = OFF, no_airp_flag = OFF;
	int milage_bad_flag = OFF, nav_error = OFF, altitude_error_flag = OFF;
	float FuelOnBoard=0;
	int RD;



	/* Global Variables for DATAENTRYWIN */
	VCCOUNT count; /* for segment loop */
	VCCOUNT num1=1, num2=4, num3=1, num4=2, num5=11, num6=9, num9=95;
	VCCOUNT num7=18, num8=11, num10=11, port=1;
	VCCOUNT num11=1;
	VCCOUNT rpm_value=0, m_pressr=0, crz_alt=0, dtemps=0, ctemps=0;
	VCCOUNT new_depart_elev=0;
	VCCOUNT seg;
	VCTEXT  Tfilename[7], device[5];
	VCTEXT buf1[20];
    VCFLOAT altimeter=0;

    /* -------------added for upgrade ------------------- */
    /* for aircraft information file */
    VCCOUNT record_length = 1;
	/* --------------------------------------------------*/

	/*Listbox items for DATAENTRYWIN */
	VCLBOXITEM rpm[]=
	{
	"2000",NULL,"2100",NULL,"2200",NULL,
	"2300",NULL,"2400",NULL,"2500",NULL,
	"2600",NULL,"2700",NULL,NULL,NULL
	};

	VCLBOXITEM cruise_alt[] =
	{
	"2000",NULL,"3000",NULL,"4000",NULL,"5000",NULL,"6000",NULL,
	"7000",NULL,"8000",NULL,"9000",NULL,"10000",NULL,"11000",NULL,
	"12000",NULL,NULL,NULL
	};

	VCLBOXITEM start_taxi_takeoff[] =
	{
	".5",NULL,".6",NULL,".7",NULL,".8",NULL,".9",NULL,
	"1.0",NULL,"1.1",NULL,"1.2",NULL,"1.3",NULL,"1.4",NULL,
	"1.5",NULL,"1.6",NULL,"1.7",NULL,"1.8",NULL,"1.9",NULL,
	"2.0",NULL,"2.1",NULL,"2.2",NULL,"2.3",NULL,"2.4",NULL,
	"2.5",NULL,"2.6",NULL,"2.7",NULL,"2.8",NULL,"2.9",NULL,
	"3.0",NULL,"3.1",NULL,"3.2",NULL,"3.3",NULL,"3.4",NULL,
	"3.5",NULL,"3.6",NULL,"3.7",NULL,"3.8",NULL,"3.9",NULL,
	"4.0",NULL,"4.1",NULL,"4.2",NULL,"4.3",NULL,"4.4",NULL,
	"4.5",NULL,"4.6",NULL,"4.7",NULL,"4.8",NULL,"4.9",NULL,
	"5.0",NULL,"5.1",NULL,"5.2",NULL,"5.3",NULL,"5.4",NULL,
	"5.5",NULL,"5.6",NULL,"5.7",NULL,"5.8",NULL,"5.9",NULL,
	"6.0",NULL,NULL,NULL
	};

	VCLBOXITEM tmps[] =
	{
	"-30/-34",NULL,"-20/-29",NULL,"-10/-23",NULL,"  0/-18",NULL," 10/-12",NULL," 20/-7",
	NULL," 30/-1",NULL," 40/ 4",NULL," 50/10",NULL," 60/16",NULL," 70/21",
	NULL," 80/27",NULL," 90/32",NULL,"100/38",NULL,"110/43",NULL,"120/49",
	NULL,NULL,NULL
	};

	VCLBOXITEM mp[] =
	{
	"0",NULL,"16",NULL,"17",NULL,"18",NULL,"19",NULL,"20",NULL,"21",
	NULL,"22",NULL,"23",NULL,"24",NULL,"25",NULL,"26",NULL,"28",NULL,
	"29",NULL,"30",NULL,"31",NULL,"32",NULL,"33",NULL,"34",NULL,"35",
	NULL,"36",NULL,"37",NULL,"38",NULL,"39",NULL,NULL,NULL
	}; /* "40" removed to fix file # calculation error */

	VCLBOXITEM printer_ports[] =
	{"LPT1",NULL,"LPT2",NULL,"COM1",NULL,"COM2",NULL,NULL,NULL};

	VCLBOXITEM altim[] =
	{
	"28.97",NULL,"28.98",NULL,"28.99",NULL,"29.00",NULL,"29.01",NULL,
	"29.02",NULL,"29.03",NULL,"29.04",NULL,"29.05",NULL,"29.06",NULL,
	"29.07",NULL,"29.08",NULL,"29.09",NULL,"29.10",NULL,"29.11",NULL,
	"29.12",NULL,"29.13",NULL,"29.14",NULL,"29.15",NULL,"29.16",NULL,
	"29.17",NULL,"29.18",NULL,"29.19",NULL,"29.20",NULL,"29.21",NULL,
	"29.22",NULL,"29.23",NULL,"29.24",NULL,"29.25",NULL,"29.26",NULL,
	"29.27",NULL,"29.28",NULL,"29.30",NULL,"29.31",NULL,"29.32",NULL,
	"29.33",NULL,"29.34",NULL,"29.35",NULL,"29.36",NULL,"29.37",NULL,
	"29.38",NULL,"29.39",NULL,"29.40",NULL,"29.41",NULL,"29.42",NULL,
	"29.43",NULL,"29.44",NULL,"29.45",NULL,"29.46",NULL,"29.47",NULL,
	"29.48",NULL,"29.49",NULL,"29.50",NULL,"29.51",NULL,"29.52",NULL,
	"29.53",NULL,"29.54",NULL,"29.55",NULL,"29.56",NULL,"29.57",NULL,
	"29.58",NULL,"29.59",NULL,"29.60",NULL,"29.61",NULL,"29.62",NULL,
	"29.63",NULL,"29.64",NULL,"29.65",NULL,"29.66",NULL,"29.67",NULL,
	"29.68",NULL,"29.69",NULL,"29.70",NULL,"29.71",NULL,"29.72",NULL,
	"29.73",NULL,"29.74",NULL,"29.75",NULL,"29.76",NULL,"29.77",NULL,
	"29.78",NULL,"29.79",NULL,"29.80",NULL,"29.81",NULL,"29.82",NULL,
	"29.83",NULL,"29.84",NULL,"29.85",NULL,"29.86",NULL,"29.87",NULL,
	"29.88",NULL,"29.89",NULL,"29.90",NULL,"29.91",NULL,"29.92",NULL,
	"29.93",NULL,"29.94",NULL,"29.95",NULL,"29.96",NULL,"29.97",NULL,
	"29.98",NULL,"29.99",NULL,"30.00",NULL,"30.01",NULL,"30.02",NULL,
	"30.03",NULL,"30.04",NULL,"30.05",NULL,"30.06",NULL,"30.07",NULL,
	"30.08",NULL,"30.09",NULL,"30.10",NULL,"30.11",NULL,"30.12",NULL,
	"30.13",NULL,"30.14",NULL,"30.15",NULL,"30.16",NULL,"30.17",NULL,
	"30.18",NULL,"30.19",NULL,"30.20",NULL,"30.21",NULL,"30.22",NULL,
	"30.23",NULL,"30.24",NULL,"30.25",NULL,"30.26",NULL,"30.27",NULL,
	"30.28",NULL,"30.29",NULL,"30.30",NULL,"30.31",NULL,"30.32",NULL,
	"30.33",NULL,"30.34",NULL,"30.35",NULL,"30.36",NULL,"30.37",NULL,
	"30.38",NULL,"30.39",NULL,"30.40",NULL,"30.41",NULL,"30.42",NULL,
	"30.43",NULL,"30.44",NULL,"30.45",NULL,"30.46",NULL,"30.47",NULL,
	"30.48",NULL,"30.49",NULL,"30.50",NULL,"30.51",NULL,"30.52",NULL,
	"30.53",NULL,"30.54",NULL,"30.55",NULL,"30.56",NULL,"30.57",NULL,
	"30.58",NULL,"30.59",NULL,"30.60",NULL,"30.61",NULL,"30.62",NULL,
	"30.63",NULL,"30.64",NULL,"30.65",NULL,"30.66",NULL,"30.67",NULL,
	"30.68",NULL,"30.69",NULL,"30.70",NULL,"30.71",NULL,"30.72",NULL,
	"30.73",NULL,"30.74",NULL,"30.75",NULL,NULL,NULL
	};

	VCLBOXITEM DescentRate[] =
	{"500",NULL,"600",NULL,"700",NULL,"800",NULL,"900",NULL,
	 "1000",NULL,"1100",NULL,"1200",NULL,NULL,NULL};

	/* Global Objects for NAVWINID */
	VCOBJ *obj1[15], *obj2[15], *obj3[15], *obj4[15], *obj5[15];
	VCOBJ *obj6, *obj7, *obj8, *obj9, *obj10, *obj11, *obj12, *obj13, *obj14;
	VCOBJ *obj15, *obj16, *obj17, *obj18, *obj19, *obj20, *obj21, *obj23;

	/* Global object for Tfilename */
	VCOBJ *obj22;
    /* Get aircraft information field object */
    VCOBJ *obj28;
	/* Global objects for last window pushbuttons */
	VCOBJ *save_trip_button, *exit_last_window, *newff3_button;
	VCOBJ *calculate_button, *print_button, *navff3_button;
	VCOBJ *save_log_button;
	//VCOB  *wbff3_button;  //commented out for now
	/*End of Declarations */


	VCCOUNT AboutFLM()
	{
	help = vcWinOpenX(2,5,12,70," Information ",
	   VCWF_SHADOW,0,0,vcBorderFromID(1),vcColorFromID(8));
	vcAtSayX(0, 1,"You can contact the author at the address below for more",
	 vc.white|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
	vcAtSayX(1, 1,"aircraft data files or to get technical support.",
	 vc.white|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
	 
	vcAtSayX(3, 1,"E-mail: rlewis.rlewis@gmail.com",
	 vc.white|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
	vcAtSayX(4, 1,"I will try to respond within a day if not",
	 vc.white|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
	vcAtSayX(5, 1,"sooner to any problem or questions you have.",
	 vc.white|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
	 
	 
	get_a_key();
	vcWinClose(help);
	return( VCSUCCESS );
	}

	VCCOUNT HelpWindow1()
	{
	help = vcWinOpenX(2,1,16,73," Help ",
	   VCWF_SHADOW,0,0,vcBorderFromID(1),vcColorFromID(8));
    vcAtSayX(0, 1,"                ***** Performance Data Help *****",
	 vc.magenta|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
	vcAtSayX(2, 1,"Continue - ",vc.red|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
	vcAtSayX(2, 13,"Opens the Navigation data page.  From there, user",
	 vc.white|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
	vcAtSayX(3, 13,"can fill out the form or load a saved flight plan.",
	 vc.white|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
	vcAtSayX(5, 1,"*CG Files - ",vc.red|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
	vcAtSayX(5, 13,"Opens the CG management program.",
	 vc.white|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
	vcAtSayX(7, 1,"*Performance Files - ",vc.red|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
	vcAtSayX(7, 22,"Opens the performance management program.",
	 vc.white|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
	
	vcAtSayX(9, 1,"ESC KEY - ",vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
	vcAtSayX(9, 12,"Prompts user to terminate program from any window.",
	 vc.white|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
	
    vcAtSayX(11, 1,"Exit - ",vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
	vcAtSayX(11, 9,"Ends the flight log maker session.",
	 vc.white|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
	
	vcAtSayX(12, 1,"* - These push buttons are dissabled in this version.",vc.red|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
	
	get_a_key();
	vcWinClose(help);
	return( VCSUCCESS );
	}
	/* ********************************************************* */
	VCCOUNT HelpWindow2()
	{
	help = vcWinOpenX(3,5,20,70," Help ",
	   VCWF_SHADOW,0,0,vcBorderFromID(1),vcColorFromID(8));
	vcAtSayX(0, 1,"                ***** Navigation Data Help *****",
	 vc.magenta|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
	vcAtSayX(2, 1,"NEXT",vc.red|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
	vcAtSayX(2, 6,"- To calculate the flight plan go to FLIGHT LOG page",
	 vc.white|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
	vcAtSayX(3, 8,"and press the calculate push button.",
	 vc.white|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
	vcAtSayX(5, 1,"BACK",vc.red|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
	vcAtSayX(5, 6,"- Lets you return to the performance data form.",
	 vc.white|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
	vcAtSayX(7, 1,"Get Trip",vc.red|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
	vcAtSayX(7, 10,"- Browse and select trip data files.",
	 vc.white|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
	vcAtSayX(9, 1,"Load Trip",vc.red|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
	vcAtSayX(9, 11,"- Loads selected trip file data into form.",
	 vc.white|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
	vcAtSayX(11, 1,"Save Trip",vc.red|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
	vcAtSayX(11, 11,"- Saves the flight plan data.",
	 vc.white|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);	
	vcAtSayX(13, 1,"ESC KEY - ",vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
	vcAtSayX(13, 12,"Prompts user to terminate program from any window.",
	 vc.white|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
	
    
	 
	get_a_key();
	vcWinClose(help);
	return( VCSUCCESS );
	}
	/* ********************************************************* */
	VCCOUNT LicenseAgreement()
	{

	agreewin = vcWinOpenX(4,11,14,73," Flight Log Maker User Agreement",
	   VCWF_SHADOW,0,0,vcBorderFromID(2),vcColorFromID(2));

	/* Say the User agreement */
	vcAtSay(0,4,"The User hereby agrees to use Flight Log Maker");
	vcAtSay(1,4,"as is, without any warranties or guarantees.");
	vcAtSay(2,4,"Proper flight planning is the users responsibility!");
	vcAtSay(3,4,"Author has written program and databases to the best");
	vcAtSay(4,4,"of his ability but user should verify accuracy by");
	vcAtSay(5,4,"planning a trip and comparing with program results.");
	vcAtSay(6,4,"All suggestions for improvement are welcome!");
	vcAtSay(8,20,"Enjoy the program....");
	vcUpdateVIO();
	get_a_key();
	vcWinClose(agreewin);
	return(VCSUCCESS);
	}

	/* ********************************************************* */
	/* hide other windows and reopen data entry window */
	VCCOUNT SaveData(VCOBJ *obj)
	{
	vcSendMsg( VCENDFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
		
	strcpy(device,"     ");
	port=1; calcounter = 0;       // must recalculate if you go back to new
	 
	win=vcWinFromID( DATAENTRYWINID );
	vcSendMsg( VCSTARTFORM,( VCVOID * )win, 0l,0l,0l);
	vcUpdateVIO();
	return(VCSUCCESS);
	}

	/* ********************************************************* */
	/* function to calculate pressure altitude */
	/* takes an integer for field elevation and takes
	** a floating point value for local pressure and
	** returns the pressure altitude */

	int pressure_alt(int elev, float local_pressure)
	{
	float p_altitude;
	p_altitude = ((29.92 - local_pressure) * 1000) + elev;
	return p_altitude;
	}
	/* ********************************************************* */
	/* function to calculate standard temperature and density altitude
	** for departure and for cruise
	** This function uses the temperature, the pressure altitude
	** the elevation or real altitude, and the addresses for
	** the density altitude, and the standard temparature....returns the
	** density altitude and standard temperature for the given elevation */

	void density_alt(int temp, int pa, int elev, int *da,
	 int *stand_temp, int *temp_difference)
	{
	int temp_celcius, temp2;
	temp_celcius = (temp - 32) * .5556;
	*stand_temp = ((pa / 1000) * 2) - 15;
	if(*stand_temp > 0)
	  /* reverse the sign to a negative */
	  temp2 = *stand_temp - (*stand_temp * 2);
	if(*stand_temp < 0)
	  /* reverse the sign to a positive */
	  temp2 = *stand_temp + abs(*stand_temp * 2);
	*stand_temp = temp2;
	*temp_difference = temp_celcius - *stand_temp;
	/* density altitude calculation */
	*da = elev + ((temp_celcius - *stand_temp) * 121);  //old multiplier setting more conservative @ 127
	}
	/* ********************************************************* */
	/* function to format the cruise altitude and field elevation
	** One of the numbers the program will use to open a data record
	** this number will be rounded off to the nearest 1000 ft
	** and will be converted to the minimum or maximum value if the number
	** entered for field elevation is not within the program parameters */

	int elevation(int elev)
	{
	int rawnumber;
	rawnumber = elev;

	elev /= 1000;
	elev *= 1000;

	if(rawnumber > (elev + 500))
	 elev += 1000;
	if(elev >= MAXALTITUDE)
	 elev = MAXALTITUDE;
	if(elev <= MINALTITUDE)
	 elev = MINALTITUDE;
	return elev;
	}
	/* ********************************************************* */
	/* function to calculate high performance record to search */

	VCCOUNT get_hp_record( VCCOUNT rpm, VCCOUNT mp, VCCOUNT elev)
	{
	  highperf_record = elev + rpm + mp;
	  return highperf_record; /* highperf_record defined in hprecord.h */
	}
	/* ********************************************************* */
	/* function to calculate regular performance record to search */

	VCCOUNT get_normal_record(VCCOUNT rpm,VCCOUNT elev)
	{
	VCCOUNT regular_rec;
	elev /= 100;
	rpm /= 100;
	regular_rec = (elev + rpm) - 39;
	return regular_rec;
	}
	/* ********************************************************* */
	/* function to calculate the record number for
	** the default file */

	VCCOUNT default_record(VCCOUNT altitude)
	{
	VCCOUNT record_num;
	record_num = ((altitude / 1000) - 1);
	return record_num;
	}
	/* ************************************************************ */
 

/* --------modified choosefile() for updated program --------- */
	/* *****************RE WRITTEN FUNCTION FOR UPGRADE*********** */
	/* this function will take the 3 files associated with a
	** selected aircraft and choose one of the three to use
	** depending on the air temperature and comparing it to
	** the value that was calculated for standard temperature */
	VCCOUNT choosefile(int temp_difference)	{
	const TRUE = 1, FALSE = 0;
	
	/* check if power setting is appropriate to files being used */
	if( AircraftInfo.is_complex == FALSE )
	  if( m_pressr )  {
	    no_airp_flag = SET; nav_error=ERROR; 
	   return(VCSUCCESS); } 
	if(AircraftInfo.is_complex == TRUE )
	  if( !m_pressr ) {
	   no_mp_flag = SET; nav_error=ERROR;
	   return(VCSUCCESS); } 
	
	if(temp_difference >= 19)
	strcpy(current_file, AircraftInfo.a_file);
	if(temp_difference <= -19)
	strcpy(current_file, AircraftInfo.b_file);
	if((temp_difference > -19) && (temp_difference < 19))
	strcpy(current_file, AircraftInfo.n_file);
	/* assign the default file - this is new code */
	strcpy(default_file, AircraftInfo.d_file);

    return (VCSUCCESS);	
	}

	/* ************************************************************* */
	/* decides if correction should be added or subtracted */
	int wind_correction(struct nav *ptr2nav, float crosswind, int course[],
		 int groundspeed, float correction[], char add_or_subtract[] )
	{
	if( (ptr2nav->magnetic_crs > 360 ) || (ptr2nav->magnetic_crs <= 0 ) ) {
	course_err();
	nav_error=ERROR;
	return(VCSUCCESS);
	}
	if( (ptr2nav->wind_dir > 360 ) || (ptr2nav->wind_dir < 0 ) ||
	(ptr2nav->wind_spd < 0 ) ) {
	course_err();
	nav_error=ERROR;
	return(VCSUCCESS);
	}
	
	*correction = ( crosswind / (float)groundspeed ) * RA;
	
	if(ptr2nav->magnetic_crs > ptr2nav->wind_dir) {
	*course = ptr2nav->magnetic_crs + (int)*correction;
	strcpy(add_or_subtract, plus);
	}
	if(ptr2nav->magnetic_crs < ptr2nav->wind_dir) {
	*course = ptr2nav->magnetic_crs - (int)*correction;
	strcpy(add_or_subtract, minus);
	}
	if((ptr2nav->wind_dir - ptr2nav->magnetic_crs > 0) &&
	(ptr2nav->wind_dir - ptr2nav->magnetic_crs <= 180))  {
	*course = ptr2nav->magnetic_crs + (int)*correction;
	strcpy(add_or_subtract, plus);
	}
	if((ptr2nav->wind_dir - ptr2nav->magnetic_crs < 0) &&
	(ptr2nav->wind_dir - ptr2nav->magnetic_crs >= -180))  {
	*course = ptr2nav->magnetic_crs - (int)*correction;
	strcpy(add_or_subtract, minus);
	}
	if((int)*correction == 0)  {
	*course = ptr2nav->magnetic_crs;
	strcpy(add_or_subtract, blank);
	}
	if(*course > 360 ) {
	*course -= 360;
	}
	if(*course < 0 ) {
	*course += 360;
	}
		 
	return(VCSUCCESS);
	}
	/* ************************************************************* */
	/* added this function 8/30/96 to calculate the groundspeed used
	** when in the climb for calculation of distance required for climb */
	int Groundspeed4Climb(int climbTAS, struct nav *ptr2nav) {
	double radians2degrees, degrees_difference, headwind;
	int direction_multiplier = -1, climbGS;
	/* is wind in front or behind aircraft */
	degrees_difference = abs(ptr2nav->wind_dir - ptr2nav->magnetic_crs);
	if(degrees_difference > 90)  {
	degrees_difference = 180 - degrees_difference;
	direction_multiplier = 1;
	}
	radians2degrees = degrees_difference * AR;  /* conversion */
	headwind = ptr2nav->wind_spd * cos(radians2degrees) * direction_multiplier;
	climbGS = climbTAS + headwind;
	return climbGS;
	}

	/* ************************************************************* */
	/* calculates crosswind, headwind, groundspeed, and
	** wind correction */
	void windmath(struct nav *ptr2nav, int tas, int groundspeed[],
	  float crosswind[], long *speedmoment)
	{
	float convert;
	double radians2degrees, headwind, degrees_difference;
	int direction_multiplier = -1;
	degrees_difference = abs(ptr2nav->wind_dir - ptr2nav->magnetic_crs);
	if(abs(degrees_difference) > 90)  {
	degrees_difference = 180 - degrees_difference;
	direction_multiplier = 1;
	}
	
	radians2degrees = degrees_difference * AR;
	headwind = ptr2nav->wind_spd * cos(radians2degrees) * direction_multiplier;
	*crosswind = abs(headwind * tan(radians2degrees));
	*groundspeed = tas + headwind;
	convert = ptr2nav->distc; /* conversion to float */
	*speedmoment = convert * *groundspeed;
	}
	/* ************************************************************* */
	/* function to calculate the fuel burn and time to fly
	** segment */
	void fuel_time(struct nav *ptr2nav, int groundspeed,
	double cruise_fc, float legtime[], float legfuel[], float runningfueltotal[],
	float *totalfuel, float *totaltime, int *totaldistance,
	float leghours[], float legminutes[], int *totalhours,
	float *totalminutes)
	{
	float hours=0, totals=0;

	*legtime = ptr2nav->distc / (float)groundspeed * 60;
	*legfuel = (float) cruise_fc * (*legtime / 60);
	
	*totalfuel += *legfuel;
	
	//added next line for color change on fuel legs
	//this reflects the fuel used before stt_fc and cruise_fc
	//are added in for totalfuel which gets done before calculating
	//the flight
	*runningfueltotal += *totalfuel;
	
	*totaltime += *legtime;
	*totaldistance += ptr2nav->distc;
	hours = *legtime;
	totals = *totaltime;
	*leghours =  hours / 60;
	if(*leghours < 1)
	*leghours = 0;
	*legminutes=  (int)hours % 60;
	*totalhours = totals / 60;
	*totalminutes = (int)totals % 60;
	if(*totalminutes < 1)
	*totalminutes = 0;
	}
	/* ************************************************************* */
	/* error function: warns when manifold pressure was set to zero */
	VCCOUNT no_mp()
	{
	VCWIN *e;
	calcounter = OFF;
	vcCurHide(vccrt);
	ClearOldData();
	e = vcWinOpenX(7,10,13,70," Complex airplane error! ",
		 NULL,0,0,vcBorderFromID(5),
		 vcColorFromID(20));
	vcAtSay(0,2,"Please check the manifold pressure setting.");
	vcAtSay(1,2,"You must use a manifold pressure");
	vcAtSay(2,2,"other than zero for this aircraft.");
	vcAtSay(4,2,"Press any key then select NEW to change setting.");
	vcStatSay("Error! - Press any key to reset then NEW to correct!"
		 ,vc.red|vc.bold|vc.blue*vc.bg);
	vcUpdateVIO();
	get_a_key();
	vcCurShow(vccrt);
	vcWinClose(e);
	RedrawButtons();
	return(VCSUCCESS);
	}
	
	/* ************************************************************** */
	/* error function: aircraft selection doesn't use manifold
	** pressure */
	VCCOUNT no_airp()
	{
	VCWIN *e;
	calcounter = OFF;
	vcCurHide(vccrt);
	ClearOldData();
	e = vcWinOpenX(7,10,13,70," Regular Aircraft error! ",
		 NULL,0,0,vcBorderFromID(5),
		 vcColorFromID(20));
	vcAtSay(0,2,"Please check your aircraft selection.");
	vcAtSay(1,2,"You must select a manifold pressure setting of zero");
	vcAtSay(2,2,"if you wish to use this aircraft.");
	vcAtSay(4,2,"Press any key then select NEW to change setting.");
	vcStatSay("Error! - Press any key to reset then NEW to correct!"
		 ,vc.red|vc.bold|vc.blue*vc.bg);
	vcUpdateVIO();
	get_a_key();
	vcCurShow(vccrt);
	vcWinClose(e);
	RedrawButtons();
	return(VCSUCCESS);
	}
	
	/* ************************************************************** */
	/* error function: this function warns when errors in wind
	** direction, or course selection are made */
	VCCOUNT course_err()
	{
	VCWIN *e;
	calcounter = OFF;
	vcCurHide(vccrt);
	ClearOldData();
	e = vcWinOpenX(7,4,13,74," Flight Planning error! ",
		 NULL,0,0,vcBorderFromID(5),
		 vcColorFromID(20));
	vcAtSay(0,2,"Please check your wind direction and/or speed and magnetic");
	vcAtSay(1,2,"course settings.  You must use a wind direction and magnetic");
	vcAtSay(2,2,"course between 1 - 360.  No zero's or negative numbers please!");
	vcAtSay(4,2,"Press any key then select NAV to change setting.");
	vcStatSay("Error! - Press any key to reset then NAV to correct!"
		 ,vc.red|vc.bold|vc.blue*vc.bg);
	vcUpdateVIO();
	get_a_key();
	vcCurShow(vccrt);
	vcWinClose(e);
	RedrawButtons();
	return(VCSUCCESS);
	}

	int main()
	{

	vcStart(VCCLRSCRN);

    ReadAorB();
    
    /* top status line */
	vcStatOpen(0, 0, 0, 79, NULL, 0, 0, NULL);
	vcStatSay(" Flight Log Maker Version: 5.3.1b              TAB=Select Fields       ESC=Quit ",vc.white|vc.bold|vc.green*vc.bg);

	/* create bottom status bar */
	vcStatOpen(24, 0, 24, 79,NULL, 0, 0, NULL);


	/* create performance data window */
	win = vcCreateWin(win,1,0,23,79," Performance Data Page",
	VCWF_CURSOR,0,0,vcBorderFromID(1),
	vcColorFromID(4), DATAENTRYWINID, winfilter);
	vcMouSetCapture(win,0);
	/* make sure the lower message area states no aircr loaded */
	vcAtSayX(20,5, "                                        ",
	  vc.blue|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT); 
	
	vcAtSay(2,2,"Aircraft");
    vcAtSay(3,2,"Information File:");
      obj28 = vcEntryFldX(win, 4, 2, &AircraftInfo.ac_info_filename,
	   "XXXXXXXXXXXX",
	  OBJGROUP|VCEF_STRING|VCEF_FLDBLANK,NULL,
	   "type name of the aircraft information file..must have \".air\" extension",
	  NULL,NULL);
      
      vcAtSayX(10,28, "No aircraft loaded yet                  ",
	  vc.brown|vc.blink|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);
      obj=vcPushBtnX(win,6,2," Find  ", UpdateAirInfoField,
      OBJGROUP|VCPB_EXECUP,NULL,"find existing Aircraft information files",
      NULL,vcColorFromID(10)); 
            
      obj=vcPushBtnX( win, 8, 2, " Read Aircraft File ", ReadAircraftFile,
	   OBJGROUP|VCPB_EXECUP,NULL,
	   "this loads the file into the flight planner for use",
	   NULL, vcColorFromID(10));
      
      //obj=vcPushBtnX( win, 10, 2, " Make New Aircraft File ", ManageNewAC,
	  // OBJGROUP|VCPB_EXECUP,NULL,
	  // "create a new aircraft information file or view files with existing aircraft",
	  // NULL, vcColorFromID(12));
    vcAtSay(0,27,"Power"); 

    vcAtSay(1,25,"Rpm");
	vcListBoxX( win, 2, 24, 4, 4, rpm, OBJGROUP|VCLB_SCROLLBAR, &num2,
	NULL, " select an rpm used for cruise",
	NULL, vcColorFromID(17), vcBorderFromID(1));
	

	/* cost planning */
	vcAtSay (8,28, "Wet Rate");
	vcAtSay (9,35, "$/HR");
	vcEntryFldX(win, 9,28, &RATE_wet,"999.99",
	  OBJGROUP|VCEF_FLOAT|VCEF_FLDBLANK,NULL,
	   "enter the WET rental rate if applicable",
	  NULL,NULL);
	vcAtSay (8,41, "Dry Rate");
	vcAtSay (9,48, "$/HR");
	vcEntryFldX(win, 9,41, &RATE_dry,"999.99",
	  OBJGROUP|VCEF_FLOAT|VCEF_FLDBLANK,NULL,
	   "enter the DRY rental rate if applicable",
	  NULL,NULL);
	vcAtSay (8,54, "Fuel Cost");
	vcAtSay (9,60,"$/Gallon");
	vcEntryFldX(win, 9,54, &RATE_fuelcost,"99.99",
	  OBJGROUP|VCEF_FLOAT|VCEF_FLDBLANK,NULL,
	   "if you want the estimated fuel cost for the trip enter the price per gallon",
	  NULL,NULL);
	
	
	
	vcAtSay(1,31,"Mp");
	vcListBoxX( win, 2, 30, 2, 4, mp, OBJGROUP|VCLB_SCROLLBAR, &num3,
	NULL, " set the manifold pressure if aircraft is complex",
	NULL, vcColorFromID(17), vcBorderFromID(1));
	
	vcAtSay(0,40,"Crz");
	vcAtSay(1,40,"Alt");
	vcListBoxX( win, 2, 38, 5, 4, cruise_alt, OBJGROUP|VCLB_SCROLLBAR, &num4,
	NULL, " round off your cruise altitude",
	NULL, vcColorFromID(17), vcBorderFromID(1));
	
	
	vcAtSay(0,56,"Temps");
	vcAtSay(1,54,"Dep");
	vcAtSay(1,64,"Crz");
	vcListBoxX( win, 2, 51, 8, 4, tmps, OBJGROUP|VCLB_SCROLLBAR, &num5,
	NULL, " enter the fahrenheit/celcius temperature at the departure airport",
	NULL, vcColorFromID(17), vcBorderFromID(1));
	
	vcAtSay(0,62,"F/C");
	vcListBoxX( win, 2, 61, 8, 4, tmps, OBJGROUP|VCLB_SCROLLBAR, &num6,
	NULL, " enter the fahrenheit/celcius temperature at cruise altitude",
	NULL, vcColorFromID(17), vcBorderFromID(1));
	
	/* old trip field was here */

	vcAtSay(12,8,"<-------------------------- Departure Airport Altimeter");
	vcListBoxX(win, 12, 1, 5, 5, altim, OBJGROUP|VCLB_SCROLLBAR, &num9,
	NULL, " enter altimeter setting at departure airport",
	NULL, vcColorFromID(17), vcBorderFromID(1));
	vcAtSay(13,16,"<------------------ Printer Port");
	vcListBoxX( win, 13, 10, 4, 3, printer_ports, OBJGROUP|VCLB_SCROLLBAR,
	&port,NULL, " select port to send data to...not sure?...select LPT1",
	NULL, vcColorFromID(17), vcBorderFromID(1));
	vcAtSay(14,24,"<---------- Start,Taxi,Take-Off Fuel");
	vcListBoxX( win, 14, 18, 4, 3, start_taxi_takeoff, OBJGROUP|VCLB_SCROLLBAR, &num10,
	NULL, " enter the fuel required for start, taxi, takeoff",
	NULL, vcColorFromID(17), vcBorderFromID(1));
	vcAtSay(15,32,"<-- Descent Rate");
	vcListBoxX( win, 15, 26, 4, 3, DescentRate, OBJGROUP|VCLB_SCROLLBAR, &num11,
	NULL, " select the desired descent rate from cruise altitude",
	NULL, vcColorFromID(17), vcBorderFromID(1));
   
	vcPushBtnX(win, 0, 1," Help  ", HelpWindow1,
	OBJGROUP|VCPB_EXECUP,NULL,
	" Help with this worksheet",
	NULL, vcColorFromID(14));
	
	vcPushBtnX(win, 0, 9," About ", AboutFLM,
	OBJGROUP|VCPB_EXECUP,NULL,
	" For information on flight log maker",
	NULL, vcColorFromID(14));
	
	 
	//vcAtSay(17,35,"File managers ------->");
	
	//vcPushBtnX(win,16,58,"          CG files ", ManageCG,
    //  OBJGROUP|VCPB_EXECUP,NULL,
    //" Create/View/Edit aircraft CG data files",
    //NULL,vcColorFromID(14));

	//vcPushBtnX(win, 18, 58," Performance Files ",ManageFM,
	//  OBJGROUP|VCPB_EXECUP,NULL,
	//" Create/View/Edit aircraft performance data files",
	//NULL, vcColorFromID(14));
	
	vcPushBtnX(win, 20, 58,"      Continue --> ",cont3,OBJGROUP|VCPB_EXECUP,NULL,
	" Move on to the navigation worksheet",
	NULL, vcColorFromID(12));
	
	vcPushBtnX(win, 20, 42,"     Exit      ",myEnd,OBJGROUP|VCPB_EXECUP,
	NULL," Quit program",
	NULL, vcColorFromID(7));
	
	vcStartForm(win,NULL);

	/* set up the array to hold the high performance
	 record numbers */
	Calc_set_hp_array();

	/* Show user agreement */
	LicenseAgreement();

	vcProcessEvents();
	 
	vcDelFile("useplane");
	vcDelFile("trip.pln");
	vcEnd();
	clrscr();
	return(0);
	}

	/* *************************************************** */
	/* exit pushbutton function */
	VCCOUNT myEnd(VCOBJ *obj)
	{
	int a=0; // zero equals don't quit program
	         // one quits the program
	if (Quit_Verify(a)) {
	vcEndForm(obj->win);
	vcDelFile("trip.pln");
	vcPostMsg(VCTERMINATE,obj->win,0L,0L,0L);
	return(VCTERMINATE);
	}
	else return(VCSUCCESS);
	}
	
	/* ************************************************** */
	/* wait for keypress function */
	VCCOUNT get_a_key()
	{
	VCCOUNT key;
	while( ((key=vcGetOne(NULL)) == MOUMOVE)
	|| (key==MOUB1UP) || (key==MOUB1MOVE) );
	return(key);
	}

	/* ************************************************** */
	VCCOUNT winfilter(VCCOUNT msg, VCVOID *to, VCULONG p1,
	   VCULONG p2, VCULONG p3)
	{
	int a=0;  // initialize to zero
	 // 0= don't quit and 1 means quit
	VCCOUNT key;
	if(msg==KEYPRESS)  //if keypress
	{
	key=p1&0xffff;  //get key
	if(key==ESC)    //if esc exit
	//end processing
	if (Quit_Verify(a)) { // verify user really wants to quit program
	return(vcPostMsg(VCTERMINATE, to, p1, p2, p3) );
	}
	}

	//allow other messages on through system
	return( vcDefaultWinFilter(msg, to, p1, p2, p3 ) );
	}

	/* *************************************************** */
	VCCOUNT Quit_Verify( int a )
	{
	char p;
	VCWIN *e;
	vcMouHide();
	e = vcWinOpenX(7,20,10,60,"Warning!",
		 VCWF_CURSOR|VCWF_SHADOW,0,0,vcBorderFromID(1),
		 vcColorFromID(9));
	vcAtSay(0, 5, "Are you Sure you want to quit");
   vcAtSay(1, 5, "flight log maker 5? Press Y or N!");
   vcStatSay("Press Y to exit and N cancel quit. ",
	 vc.white|vc.bold|vc.blink|vc.blue*vc.bg);
	vcUpdateVIO();
	p = getch();
	  switch (p)
	 {
	   case 'y' :
	   case 'Y' : a = 1;
			  break;
	   case 'n' :
	   case 'N' : a = 0;
			  break;
	   default  : a = 0;
			  break;
	 }
	if(a==1) vcDelFile("trip.pln");
	vcMouShow();
	vcWinClose(e);
	return a;
	}

	/* ************************************************ */
	VCCOUNT SaveTrip(VCOBJ *obj)
	{
	VCWIN *sav;
	FILE *exist;
	VCCOUNT a, file_n;
	char datafile[]="            ";
	char ext[] = ".ADA";
    /* close the form to save information */
    vcSendMsg( VCENDFORM,(VCVOID *)obj->win, 0L, 0L, 0L );

	/* abort process if trip filename is blank */
	/* create a file name if its not blank */
	if( ( !strcmpi(Tfilename, bad_name)) || (!strcmpi(Tfilename, bad_name2)) )  {
	  sav = vcWinOpenX(9,10,14,62,"",VCWF_SHADOW,
		0,0,vcBorderFromID(1),vcColorFromID(9));
	  vcAtSay(0,2,"The trip file is blank!");
	  vcAtSay(1,2,"Reload trip or go to NAVIGATION page");
	  vcAtSay(2,2,"and type (2) 3 letter aiprort codes");
	  vcAtSay(3,2,"in the field provided.");
	  get_a_key(); /* stop process so user can see window */
	  vcWinClose(sav);
	  vcSendMsg( VCSTARTFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
	return( VCSUCCESS ); }

	/* check for existing filename */
	if((exist = fopen(Tfilename,"rb")) != NULL)  {
	  a = AlreadyExists((char *)&Tfilename);
	  fclose(exist);
	if(!a) {
	  vcSendMsg( VCSTARTFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
	 return( VCSUCCESS ); }	}

	if((fp=fopen(Tfilename,"wb"))==NULL) {
	  sav = vcWinOpenX(9,10,14,62,"",VCWF_SHADOW,
		0,0,vcBorderFromID(1),vcColorFromID(9));
	  vcAtSay(0,2,"Please Verify trip Name!");
	  vcAtSay(1,2,"Reload trip or go to NAVIGATION page");
	  vcAtSay(2,2,"and type (2) 3 letter aiprort codes");
	  vcAtSay(3,2,"in the field provided.");
	  vcEmpty(Tfilename, 7);
	  //vcEmpty(Path.fname, 7);
	 
	  vcDelFile("trip.pln");
	  get_a_key();
	  vcWinClose(sav);
	  vcSendMsg( VCSTARTFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
	return( VCSUCCESS ); }

	/* write the file */
	for(seg = 0, file_n = 0; file_n <= 7; seg++, file_n++)  {
	  fseek(fp,(file_n) * sizeof(struct nav),SEEK_SET);
	  fwrite(&segment[file_n], sizeof(struct nav),1,fp);
	 }

	/* writes 8th segment */
	fwrite(&segment[file_n], sizeof(struct nav),1,fp);
	fclose(fp);

	/* Create .ada file extension for Airport Data file */
	strcpy(datafile, Tfilename);
	strcat(datafile, ext);

	/* open Airport Data file */
	if((fp=fopen(datafile,"wb"))==NULL) {
	  sav = vcWinOpenX(9,10,14,62,"",VCWF_SHADOW,
		0,0,vcBorderFromID(1),vcColorFromID(9));
	  vcAtSay(0,2,"Please Verify trip Name!");
	  vcAtSay(1,2,"You can do this on the NAVIGATION page.");
	  vcAtSay(2,2,"Type (2) 3 letter aiprort codes");
	  vcAtSay(3,2,"in the field provided.");
	  vcEmpty(Tfilename, 7);
	  //vcEmpty(Path.fname, 7);
	 
	  vcDelFile("trip.pln");
	  get_a_key();
	  vcWinClose(sav);
      vcSendMsg( VCSTARTFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
	 return( VCSUCCESS ); }
	
	/* everything OK - write to file */
	fseek(fp,0 * sizeof(struct airports),SEEK_SET);
	fwrite(&AirportData, sizeof(struct airports),1,fp);
	fclose(fp);

	/* print status to window */
	sav = vcWinOpenX(9,10,14,52,"",VCWF_SHADOW,
		0,0,vcBorderFromID(1),vcColorFromID(2));
	vcAtSay(1,2,"Trip        Saved...press any key");
	vcAtSayX(1,7,Tfilename,vc.white+(vc.bg*vc.blue), VCOF_SYSDFLT);
	get_a_key();
	vcWinClose(sav);
	vcSendMsg( VCSTARTFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
   return( VCSUCCESS );
  }

 	/* ******************************************* */
	/* Function to save the listbox settings
	...part of Calc() rewrite */
	VCCOUNT Calc_save_listbox_selections() {
	
	sprintf(buf1,"%s",printer_ports[port-1]);
	strcpy(device,buf1);
	/* convert these strings to integers */
	sprintf(buf1,"%s",rpm[num2-1]);
	rpm_value=atoi(buf1);
	sprintf(buf1,"%s",mp[num3-1]);
	m_pressr=atoi(buf1);
	sprintf(buf1,"%s",cruise_alt[num4-1]);
	crz_alt=atoi(buf1);
	sprintf(buf1,"%s",tmps[num5-1]);
	dtemps=atoi(buf1);
	sprintf(buf1,"%s",tmps[num6-1]);
	ctemps=atoi(buf1);
	/* convert these strings to floating point variables */
	sprintf(buf1,"%s",altim[num9-1]);
	altimeter=atof(buf1);
	sprintf(buf1,"%s",start_taxi_takeoff[num10-1]);
	stt_fc=atof(buf1);
	/* adjustable descent rate */
	sprintf(buf1,"%s",DescentRate[num11-1]);
	RD=atoi(buf1);

	return (VCSUCCESS);
	} /* end of function Calc_save_listbox.... */

	/* ******************************************* */
	/* Function to reset variables for a newly calculated
	flight plan */
	VCCOUNT Calc_reset_variables() {
	/* reset these variables to zero for new trip */
	for(j = 0; j <= 8; j++) {
	legtime[j]=0; legfuel[j]=0; runningfueltotal[j]=0; leghours[j]=0;
	legminutes[j]=0; correction[j]=0;
	}

	/* replace string with blank spaces */
	strcpy(current_file,"                   ");
	/* set all of these variables to zero */
	temp_difference_takeoff = 0; temp_difference_cruise = 0;
	totaltime=0; totalfuel=0; totaldistance=0; totalhours=0;
	record_hp=0; record_normal=0; grdspeedavg = 0; totlmoment = 0;
	avspeedmoment = 0; totalminutes = 0; climbdefault = 0;
	d = 0; climb_distance=0; climb_average_speed = 0;
	milpermin_c = 0; totalfuel=0; climb_average_roc = 0;
	departure_power_settings_changed = OFF; retry_departure_settings_flag = OFF;
	retry_cruise_settings_flag = OFF, cruise_power_settings_changed = OFF;
	file_error_flag = OFF, no_mp_flag = OFF, no_airp_flag = OFF;
	nav_error = OFF, milage_bad_flag = OFF, altitude_error_flag = OFF;
    
    return (VCSUCCESS);
	}

	/* ******************************************* */
	/* Function to figure out the performance files used for the
	takeoff portion of the flight */
	VCCOUNT Calc_takeoff_set_files_used() {

	/* calculate the pressure and density altitudes */
	pressure_alt_takeoff = pressure_alt(AirportData.d_elevation, altimeter);
	density_alt(dtemps, pressure_alt_takeoff, AirportData.d_elevation,
	&takeoff_density_alt, &takeoff_stand_temp,
	&temp_difference_takeoff);

	/* format the elevation for file record number calculation */
	new_depart_elev = elevation(AirportData.d_elevation);
 

	/* depending on temperature and power setting selected
	* choose the performance file used */
	 choosefile( temp_difference_takeoff );
	
    /* save the filename used for the takeoff based on the chosen
	* performance file */
	strcpy(takeoffile,current_file);
    	
	/* choose method to calculate takeoff record to search */
	if (retry_departure_settings_flag == OFF) {
	 if(m_pressr) record_hp = get_hp_record(rpm_value, m_pressr, new_depart_elev);
	 if(!m_pressr) record_normal = get_normal_record(rpm_value, new_depart_elev); }
	
	if (retry_departure_settings_flag == SET) {
	 if(m_pressr) record_hp = get_hp_record(defaults.rpm, defaults.mp, new_depart_elev);
     if(!m_pressr) record_normal = get_normal_record(defaults.rpm, new_depart_elev); }
	return (VCSUCCESS);
	}

	/* ******************************************* */
	VCCOUNT Calc_Open_HIGHP_file_takeoff() {
	/* open a high performance data file for takeoff if there is a
	* manifold pressure setting other than zero. */
	if(m_pressr) {
	if ((fp = fopen(takeoffile,"rb"))== NULL) {
	vcStatSay("performance file may be missing",
	  vc.white|vc.bold|vc.blink|vc.blue*vc.bg);
	vcUpdateVIO();
	if(nav_error) return( VCSUCCESS );
	else  { file_error_flag = SET;
	return( VCSUCCESS ); }/* end else */
	} /* end if(m_pressr)...*/
	fseek(fp,(performance[record_hp]-1) * sizeof(struct fltdata),SEEK_SET);
	fread(&perform, sizeof(struct fltdata),1,fp);
	fclose(fp);
	} /* end if((fp...*/
	return (VCSUCCESS);
	} /* end Calc_Open_HIGHP...*/

	/* ******************************************* */
	VCCOUNT Calc_Open_NORMP_file_takeoff() {
	/* open a normal performance data file for takeoff if manifold
	* pressure setting was set to zero. */
	if(!m_pressr) {
	if ((fp = fopen(takeoffile,"rb"))== NULL) {
	vcStatSay("performance file may be missing",
	  vc.white|vc.bold|vc.blink|vc.blue*vc.bg);
	vcUpdateVIO();
	if(nav_error) return( VCSUCCESS );
	else { file_error_flag = SET;
	return( VCSUCCESS ); } /* end else */
	} /* end if ((fp... */
	fseek(fp,(record_normal-1) * sizeof(struct fltdata),SEEK_SET);
	fread(&perform, sizeof(struct fltdata),1,fp);
	fclose(fp);
	} /* end if (!m_pressr)...*/
	return (VCSUCCESS);
	} /* end Calc_Open_NORMP...*/

	/* ******************************************* */
	VCCOUNT Calc_Open_DEFLT_file_t_off() {
	/* if no data found for selected power setting in the file chosen
	* for takeoff then open the default file to get takeoff data. */
	if((fp = fopen(default_file,"rb")) == NULL) {
	vcStatSay("performance file may be missing",
	  vc.white|vc.bold|vc.blink|vc.blue*vc.bg);
	vcUpdateVIO();
	if(nav_error) return( VCSUCCESS );
	else  { file_error_flag = SET;
	return( VCSUCCESS ); } /* end else */
	} /* end if((fp...*/

	fseek(fp,(default_record(new_depart_elev) - 1) * sizeof(struct pwr_settings), SEEK_SET);
	fread(&defaults, sizeof(struct pwr_settings), 1, fp);
	fclose(fp);
	return (VCSUCCESS);
	}

	/* ****************************************** */
	VCCOUNT Calc_Save_DEPART_data() {
	/* save the departure rate of climb and
	** the departure climb speed use defaults if necessary */
	if (perform.tas > 50 ) {
	depart_rc = perform.rc;
	depart_cs = perform.cs;
	 if( departure_power_settings_changed == SET) climbdefault = OFF;
	return (VCSUCCESS);
	}
	else {
	depart_rc = defaults.rc;
	depart_cs = defaults.cs;
	if ( departure_power_settings_changed == SET ); {
	 perform.rpm = defaults.rpm;
     perform.mp = defaults.mp;
     climbdefault = OFF; }
    if ( departure_power_settings_changed == OFF ) climbdefault = SET; /* flag set to print flight log window message */
	}
	if( departure_power_settings_changed == OFF ) { retry_departure_settings_flag = SET; }
	climbdefault = SET;
	return (VCSUCCESS);
	}

	/* ****************************************** */
	VCCOUNT Calc_Cruise_set_files_used() {
	/* find the pressure altitude and density altitude for cruise */
	pressure_alt_cruise = pressure_alt(crz_alt, altimeter);

	density_alt(ctemps, pressure_alt_cruise, crz_alt,
	&cruise_density_alt, &cruise_stand_temp,
	&temp_difference_cruise);
    
    /* ----------------new updated program ----------------- */
    choosefile( temp_difference_cruise );
       
    /* ------------------------------------------------------------- */

    /* choose method to calculate cruise record to search */
	if (retry_cruise_settings_flag == OFF) { 
	 if(m_pressr) record_hp = get_hp_record(rpm_value, m_pressr, crz_alt);
	 if(!m_pressr) record_normal = get_normal_record(rpm_value, crz_alt); }
	if (retry_cruise_settings_flag == SET) { 
	 if(m_pressr) record_hp = get_hp_record(defaults.rpm, defaults.mp, crz_alt);
	 if(!m_pressr) record_normal = get_normal_record(defaults.rpm, crz_alt); }	
	
	return (VCSUCCESS);
	}

	/* ****************************************** */
	VCCOUNT Calc_Open_HIGHP_file_cruise() {
	/* open a high performance data file for cruise */
	if(m_pressr) {
	if ((fp = fopen(current_file,"rb"))== NULL) {
	vcStatSay("performance file may be missing",
	  vc.white|vc.bold|vc.blink|vc.blue*vc.bg);
	vcUpdateVIO();
	if(nav_error) return( VCSUCCESS );
	else { file_error_flag = SET;
	return( VCSUCCESS ); } /* end else */
	} /* if ((fp = .... */
	fseek(fp,(performance[record_hp]-1) * sizeof(struct fltdata),SEEK_SET);
	fread(&perform, sizeof(struct fltdata),1,fp);
	fclose(fp);
	} /* end if(m_pressr... */
	return (VCSUCCESS);
	}

	/* ****************************************** */
	VCCOUNT Calc_Open_NORMP_file_cruise() {
	/* open a normal performance data file for cruise */
	if(!m_pressr) {
	if ((fp = fopen(current_file,"rb"))== NULL) {
	vcStatSay("performance file may be missing",
	  vc.white|vc.bold|vc.blink|vc.blue*vc.bg);
	vcUpdateVIO();
	if(nav_error) return( VCSUCCESS );
	else { file_error_flag = SET;
	return( VCSUCCESS ); } /* end else */
	} /* end if((fp = ... */
	fseek(fp,(record_normal-1) * sizeof(struct fltdata),SEEK_SET);
	fread(&perform, sizeof(struct fltdata),1,fp);
	fclose(fp);
	} /* end if (!m_pressr) */
	return (VCSUCCESS);
	}

	/* ****************************************** */
	VCCOUNT Calc_Open_DEFLT_file_cruise() {
	/* open the default file if necessary */
	if((fp = fopen(default_file,"rb")) == NULL) {
	vcStatSay("performance file may be missing",
	  vc.white|vc.bold|vc.blink|vc.blue*vc.bg);
	vcUpdateVIO();
	if(nav_error) return( VCSUCCESS );
	else { file_error_flag = SET;
	return( VCSUCCESS ); } /* end else */
	} /* end if((fp = ... */

	fseek(fp,(default_record(crz_alt) - 1) * sizeof(struct pwr_settings), SEEK_SET);
	fread(&defaults, sizeof(struct pwr_settings), 1, fp);
	fclose(fp);			
	return (VCSUCCESS);  
	} 

	/* ****************************************** */
	VCCOUNT Calc_Save_CRUISE_data() {
	if (perform.tas > 50 ) {
	cruise_rc = perform.rc;
	cruise_cs = perform.cs;
	cruise_fc = perform.fc;
	cruise_tas = perform.tas;
	cruise_bhp = perform.bhp;
	  if (cruise_power_settings_changed == SET) d = OFF;
	return (VCSUCCESS);
	}
	else {
	cruise_rc = defaults.rc;
	cruise_cs = defaults.cs;
	cruise_fc = defaults.fc;
	cruise_tas = defaults.tas;
	cruise_bhp = defaults.bhp;
	if ( cruise_power_settings_changed == SET ); {
	 perform.rpm = defaults.rpm; 
     perform.mp = defaults.mp;   
     d = OFF; }
    if ( cruise_power_settings_changed == OFF ) d = SET;
    } /* end else */
   	if( cruise_power_settings_changed == OFF ) { retry_cruise_settings_flag = SET; }
	d = SET;
	return (VCSUCCESS);
	}

	/* ****************************************** */ 
	VCCOUNT Calc_Create_Nav_segment_pointers() {
	/* assign pointers to an array of structure variable: "segment" */
	/* this will allocate pointers for the 8 navigation segments */
	for(j = 0; j <= 8; j++) {
	ptr2nav[j] = &segment[j]; }
	return (VCSUCCESS);
	}	 

	/* ****************************************** */
		VCCOUNT Calc_Check_Nav_validity() {
	/* check for no input by user */
	if( (segment[0].distc == 0) &&
	(segment[0].magnetic_crs == 0) ) {
	nav_error=ERROR;
	return( VCSUCCESS );
	}	
	
	/* check for valid numbers after the zeros are found */
	for(number = 0; number <= 8;number++) {
	   if( (segment[number].distc !=0) ||
	     (segment[number].magnetic_crs != 0) )
	     if( (segment[number].distc <= 0) ||
		(segment[number].magnetic_crs <= 0) ) {
	         nav_error=ERROR;
	   return( VCSUCCESS ); } /* end if( ( segment[number]+1.distc != 0 ... */
	} /* end for(number = 0; ... */

	/* check for bad mileage entered */
	for(number = 0; number <= 8;number++) {
	if( (segment[number].distc <= 0) &&
	(segment[number].magnetic_crs > 0) ) {
	milage_bad_flag=ERROR;
	return( VCSUCCESS ); } /* end if( ( segment[number]... */
	} /* end for(number... */
	return (VCSUCCESS);
	}   	

	/* ****************************************** */
	VCCOUNT Calc_Calculate_all_segments() {
	/* calculate the segments that are filled out */
	for(number= 0;segment[number].distc > 0;number++)  {
	 if(number == 8 ) break;
    windmath(ptr2nav[number], cruise_tas, &groundspeed[number],
	&crosswind[number], &avspeedmoment);

	wind_correction(ptr2nav[number], crosswind[number],
	&course[number], groundspeed[number], &correction[number], &add_or_subtract[number] );

	fuel_time(ptr2nav[number],groundspeed[number],cruise_fc,
	&legtime[number], &legfuel[number], &runningfueltotal[number], &totalfuel, &totaltime,
	&totaldistance, &leghours[number],
	&legminutes[number], &totalhours, &totalminutes);

	/* total up the speed moments */
	totlmoment += avspeedmoment;
	
	  } /* end for(number... */
	return (VCSUCCESS);
	}

	/* ****************************************** */
	VCCOUNT Calc_TotalsAndRemainingFuelTimeDistance() {
	/* find average speed */
	grdspeedavg = totlmoment / (long)totaldistance;

	/* find distance to climb */
	if(segment[0].distc > 0) {
	depart_gs = Groundspeed4Climb(depart_cs, ptr2nav[0]);
	cruise_gs = Groundspeed4Climb(cruise_cs, ptr2nav[0]);
	climb_average_speed = (depart_gs + cruise_gs) / 2;
	climb_average_roc = (cruise_rc + depart_rc) /2;
	milpermin_c = (float)climb_average_speed/ 60;
	climb_distance = ((float)crz_alt - (float)AirportData.d_elevation) /
		  ((float)climb_average_roc / milpermin_c);
	climb_time=( (float)crz_alt - (float)AirportData.d_elevation) /
		  climb_average_roc;

	/* adjust leg one time for climb to time */
	legminutes[0] += climb_time;
	if ( legminutes[0] >= 60 ) {
	  leghours[0] += 1;
	  legminutes[0] -= 60;
	 }

	/* and adjust the total trip time */
	totalminutes += climb_time;
	if( totalminutes >= 60 ) {
	   totalhours += 1;
	   totalminutes -= 60;
	 } /* end if( totalminutes...*/
	} /* end if(segment[0].distc > 0 )...*/
	else {
	no_data();
	nav_error=ERROR; 
	return( VCSUCCESS );  } /* end else */

	/* find distance to descend */
	if(segment[number - 1].distc != 0) {
	rate = RD;
	milpermin_d = (float)groundspeed[number - 1] / 60;
	descent_distance = (crz_alt - AirportData.a_elevation) /
			(rate / milpermin_d); } /* end if ...*/
	else {
	no_data();
	nav_error=ERROR;
	return( VCSUCCESS ); } /* end else */

	/* adjust total fuel for climb */
	totalfuel += ( (climb_distance / milpermin_c) * ((cruise_fc * 1.3) / 60) );

	/* add climb fuel to first leg */
	legfuel[0] +=( (climb_distance / milpermin_c) * ((cruise_fc * 1.3) / 60) );

	/* adjust total fuel for start taxi and takeoff burn */
	totalfuel += stt_fc;

	/* adjust total fuel for reserve...flight log maker uses 1hr
	at normal cruise for the reserve */
	totalfuel += cruise_fc;
	
	/* check for error in selection of altitude */
	if(climb_distance + descent_distance > totaldistance)  {
	altitude_error_flag=SET;
	return( VCSUCCESS ); } /* end if...*/

	/* check for error in field elevations */
	if( (climb_distance < 0) || (descent_distance < 0) ) {
	ElevationError();
	nav_error=ERROR;
	return( VCSUCCESS ); } /* end if...*/

	/* find the remaining time and distance after each segment */
	rem_time = totaltime;
	rdistc = totaldistance;
	for(number=0;segment[number].distc > 0; number++)  {
	  rem_time -= legtime[number];
	  rdistc -= segment[number].distc;
	  rem_distc[number] = rdistc;
	  rem_hours[number] = rem_time / 60;
	  if(rem_hours[number] < 1) rem_hours[number] = 0;
	  rem_minutes[number] = (int)rem_time % 60;
	 }
	return (VCSUCCESS);
	} /* end Calc_TotalsAndRemainingFuelTimeDistance()...*/
   
    /* ****************************************** */
    VCCOUNT Calc_Rental_Costs () {
		/* convert minutes to tenths of an hour AND adds the hours */
		 Time_tenths = totalhours + (totalminutes/60);
		 
		Cost_fuel = totalfuel * RATE_fuelcost;
		Cost_wet = RATE_wet * Time_tenths;
        Cost_dry = RATE_dry * Time_tenths;
        DRY_total = Cost_dry + Cost_fuel;
       return (VCSUCCESS);
   }
	/* ****************************************** */
	VCCOUNT Calc_Print_results_to_Flightlog_page() {
	
	/* print the results to the flight log window */
    
    if(climbdefault) { vcAtSayX(1,23,"Default Climb Out Data Used!",
	  vc.blue|vc.blink|vc.bold+(vc.bg*vc.black),VCOF_SYSDFLT);
	vcAtSay(2,73,"FUEL"); }
	else vcAtSay(2,73,"FUEL");
	if(d) { vcAtSayX(2,25,"Default Cruise Data Used!",
	  vc.blue|vc.blink|vc.bold+(vc.bg*vc.black),VCOF_SYSDFLT);
	vcAtSay(2,73,"FUEL"); }
	else vcAtSay(2,73,"FUEL");
	vcAtSay(3,0," SEGMENT                      NM  RD  MC  WD WS  WC  MH  GS  ETE   ETR   REQD");
	vcAtSay(4,0,"--------------------------------------------------------------------------------");
	/* clear this previous warning if any */
	if( (temp_difference_takeoff >=30) || (temp_difference_takeoff <= -30) ||
	(temp_difference_cruise >=30) || (temp_difference_cruise <= -30) )
	vcAtSayX(4,22," WARNING: SEE BOTTOM OF THIS PAGE ",
	vc.red|vc.bold|vc.blink+(vc.bg*vc.black),VCOF_SYSDFLT);
	if( (takeoff_density_alt > 10000) || (cruise_density_alt > 13999) )
	vcAtSayX(4,22," WARNING: SEE BOTTOM OF THIS PAGE ",
	vc.red|vc.bold|vc.blink+(vc.bg*vc.black),VCOF_SYSDFLT);

	for(number = 0;segment[number].distc > 0;
		 number++)  {
	  if(number == 8) break;
	vcAtSayX(number+5, 0, segment[number].name,
		vc.white|vc.bold+(vc.bg*vc.black), VCOF_SYSDFLT);
	vcAtSayNumX(win,number+5,29, &segment[number].distc,
		"###",VCOF_INT,vc.green+(vc.bg*vc.black),VCOF_SYSDFLT);
	
	if(rem_distc[number] > 0)
	vcAtSayNumX(win,number+5,33, &rem_distc[number],
		"###",VCOF_INT,vc.green+(vc.bg*vc.black),VCOF_SYSDFLT);
	vcAtSayNumX(win,number+5,37, &segment[number].magnetic_crs,
		"###",VCOF_INT,vc.green+(vc.bg*vc.black),VCOF_SYSDFLT);
	vcAtSayNumX(win,number+5,41, &segment[number].wind_dir,
		"###",VCOF_INT,vc.blue|vc.bold+(vc.bg*vc.black),VCOF_SYSDFLT);
	vcAtSayNumX(win,number+5,45, &segment[number].wind_spd,
		"##",VCOF_INT,vc.blue|vc.bold+(vc.bg*vc.black),VCOF_SYSDFLT);

	/* choose color for the wind correction display */
	if(add_or_subtract[number] == '+') {
	vcAtSayX(number+5,48, "+",
		vc.green|vc.bold+(vc.bg*vc.black),VCOF_SYSDFLT);
	//vcAtSay(number+5,48, "+");
	vcAtSayNumX(win,number+5,49, &correction[number],
		"##",VCOF_FLOAT,vc.green|vc.bold+(vc.bg*vc.black),VCOF_SYSDFLT); }

	if(add_or_subtract[number] == '-') {
	vcAtSayX(number+5,48, "-",
		vc.red|vc.bold+(vc.bg*vc.black),VCOF_SYSDFLT);
	//vcAtSay(number+5,48, "-");
	vcAtSayNumX(win,number+5,49, &correction[number],
		"##",VCOF_FLOAT,vc.red|vc.bold+(vc.bg*vc.black),VCOF_SYSDFLT); }

	if((int)correction[number] == 0 ) vcAtSayNumX(win,number+5,49, &correction[number],
		"##",VCOF_FLOAT,vc.black|vc.bold+(vc.bg*vc.black),VCOF_SYSDFLT);
		 
	vcAtSayNumX(win,number+5,52, &course[number],
		"###",VCOF_INT,vc.green|vc.bold+(vc.bg*vc.black),VCOF_SYSDFLT);
		
	
	vcAtSayNumX(win,number+5,56, &groundspeed[number],
		"###",VCOF_INT,vc.green+(vc.bg*vc.black),VCOF_SYSDFLT);

	if(leghours[number] >= 1) {
	vcAtSayNumX(win,number+5,60, &leghours[number],
		"##",VCOF_FLOAT,vc.green+(vc.bg*vc.black),VCOF_SYSDFLT);
		}

	if(legminutes[number] < 10) {
	vcAtSayX(number+5,62,":0",vc.green+(vc.bg*vc.black), VCOF_SYSDFLT);
	vcAtSayNumX(win,number+5,64, &legminutes[number],
	"#",VCOF_FLOAT,vc.green+(vc.bg*vc.black),VCOF_SYSDFLT);
	}

	if (legminutes[number] >= 10) {
	   vcAtSayX(number+5,62,":",vc.green+(vc.bg*vc.black), VCOF_SYSDFLT);
	   vcAtSayNumX(win,number+5,63, &legminutes[number],
	   "##",VCOF_FLOAT,vc.green+(vc.bg*vc.black),VCOF_SYSDFLT);
		  }

	if(rem_hours[number] >= 1)
	vcAtSayNumX(win,number+5,66, &rem_hours[number],
		"##",VCOF_FLOAT,vc.green+(vc.bg*vc.black),VCOF_SYSDFLT);

	if(rem_minutes[number] < 10) {
	vcAtSayX(number+5,68,":0",vc.green+(vc.bg*vc.black),VCOF_SYSDFLT);
	vcAtSayNumX(win,number+5,70, &rem_minutes[number],
	"#",VCOF_FLOAT,vc.green+(vc.bg*vc.black),VCOF_SYSDFLT);
	}
	if(rem_minutes[number] >= 10) {
	   vcAtSayX(number+5,68,":",vc.green+(vc.bg*vc.black),VCOF_SYSDFLT);
	   vcAtSayNumX(win,number+5,69, &rem_minutes[number],
	   "##",VCOF_FLOAT,vc.green+(vc.bg*vc.black),VCOF_SYSDFLT);
		  }
// color coding to show when flight begins to use reserve fuel
 	if (FuelOnBoard-(runningfueltotal[number] + stt_fc + cruise_fc) >= cruise_fc) { 
	vcAtSayNumX(win,number+5,71, &legfuel[number],                   
		"###.##",VCOF_FLOAT,vc.green|vc.bold+(vc.bg*vc.black),
		 VCOF_SYSDFLT); }
	else {vcAtSayNumX(win,number+5,71, &legfuel[number],            
		"###.##",VCOF_FLOAT,vc.brown|vc.bold+(vc.bg*vc.black),
		 VCOF_SYSDFLT); }
    if (FuelOnBoard-(runningfueltotal[number] + stt_fc + cruise_fc) <= (cruise_fc/2)) {
    vcAtSayNumX(win,number+5,71, &legfuel[number],                             
		"###.##",VCOF_FLOAT,vc.red|vc.bold+(vc.bg*vc.black),
		 VCOF_SYSDFLT); }
 	
	} /* ---------------------end of print loop-------------------- */

	vcAtSay(number+5,0,"--------------------------------------------------------------------------------");
	vcAtSay(number+6,0,"                TOTALS ->>");
	vcAtSayNumX(win,number+6,29, &totaldistance,
		"###",VCOF_INT,vc.green|vc.bold+(vc.bg*vc.black),
		 VCOF_SYSDFLT);
	vcAtSayNumX(win,number+6,56, &grdspeedavg,
		"###",VCOF_LONG,vc.green|vc.bold+(vc.bg*vc.black),
		 VCOF_SYSDFLT);

	if(totalhours >=1)  {
	vcAtSayNumX(win,number+6,60, &totalhours,
		"##",VCOF_INT,vc.green|vc.bold+(vc.bg*vc.black),
		 VCOF_SYSDFLT);
		}
	if(totalminutes<10) {
	vcAtSayX(number+6,62,":0",vc.green|vc.bold+(vc.bg*vc.black), VCOF_SYSDFLT);
	vcAtSayNumX(win,number+6,64, &totalminutes,
	"#",VCOF_FLOAT,vc.green|vc.bold+(vc.bg*vc.black),VCOF_SYSDFLT);
	}
	 else {
	   vcAtSayX(number+6,62,":",vc.green|vc.bold+(vc.bg*vc.black), VCOF_SYSDFLT);
	   vcAtSayNumX(win,number+6,63, &totalminutes,
	   "##",VCOF_FLOAT,vc.green|vc.bold+(vc.bg*vc.black),VCOF_SYSDFLT);
		  } 
// total fuel with color adjustments depending on alert status	
		
	if ((FuelOnBoard-totalfuel) >= cruise_fc) {    
	vcAtSayNumX(win,number+6,71, &totalfuel,    
		"###.##",VCOF_FLOAT,vc.green|vc.bold+(vc.bg*vc.black),          
		 VCOF_SYSDFLT); } 
		 else {vcAtSayNumX(win,number+6,71, &totalfuel,
		"###.##",VCOF_FLOAT,vc.brown|vc.bold+(vc.bg*vc.black),
		 VCOF_SYSDFLT); }
    if ((FuelOnBoard-totalfuel) <= (cruise_fc/2)) {    
	vcAtSayNumX(win,number+6,71, &totalfuel,   
		"###.##",VCOF_FLOAT,vc.red|vc.bold+(vc.bg*vc.black),
		 VCOF_SYSDFLT); }
     
	/* clear old aircraft name */
	vcAtSayX(number+8, 1,"                                                         ",
		vc.cyan|vc.bold+(vc.bg*vc.black), VCOF_SYSDFLT);
	/* update aircraft name */
	vcAtSayX(number+8, 27,AircraftInfo.name,
		vc.cyan|vc.bold+(vc.bg*vc.black), VCOF_SYSDFLT);
 
	vcAtSay(number+8,1,"Aircraft for this flight:");
    
    // fuel alert status statements
    if ((FuelOnBoard-totalfuel) >= cruise_fc) {
	vcWinAtSayX(win,3,10, "Fuel Qauntity OK!",                    
	vc.green|vc.bold+(vc.bg*vc.black), VCOF_SYSDFLT); }
	else {vcWinAtSayX(win,3,12, "Fuel Caution!",                    
	vc.brown|vc.blink|vc.bold+(vc.bg*vc.black), VCOF_SYSDFLT); }
     if ((FuelOnBoard-totalfuel) <= (cruise_fc/2)) {
	vcWinAtSayX(win,3,12, "Fuel Warning!",
	vc.red|vc.blink|vc.bold+(vc.bg*vc.black), VCOF_SYSDFLT); }
	
	vcAtSay(number+10,8,"is standard temperature (celsius): for takeoff");

	/* color change in sentence */
	vcAtSay(number+11,8,"actual degrees      /      /      standard: for takeoff");
	vcWinAtSayX(win,number+11,23, "above",
	vc.brown|vc.bold+(vc.bg*vc.black), VCOF_SYSDFLT);
	vcWinAtSayX(win,number+11,29, "within",
	vc.green|vc.bold+(vc.bg*vc.black), VCOF_SYSDFLT);
	vcWinAtSayX(win,number+11,36, "below",
	vc.blue|vc.bold+(vc.bg*vc.black), VCOF_SYSDFLT);
	if(temp_difference_takeoff<=-30) {
	vcWinAtSayX(win,number+11,36, "below",
	vc.red|vc.bold|vc.blink+(vc.bg*vc.black), VCOF_SYSDFLT); }
	if(temp_difference_takeoff>=30) {
	vcWinAtSayX(win,number+11,23, "above",
	vc.red|vc.bold|vc.blink+(vc.bg*vc.black), VCOF_SYSDFLT); }
	vcAtSay(number+12,8,"density altitude: at departure airport");
	vcAtSay(number+13,8,"is standard temperature (celsius): for cruise");

	/* color change in sentence */
	vcAtSay(number+14,8,"actual degrees      /      /      standard: for cruise");
	vcWinAtSayX(win,number+14,23, "above",
	vc.brown|vc.bold+(vc.bg*vc.black), VCOF_SYSDFLT);
	vcWinAtSayX(win,number+14,29, "within",
	vc.green|vc.bold+(vc.bg*vc.black), VCOF_SYSDFLT);
	vcWinAtSayX(win,number+14,36, "below",
	vc.blue|vc.bold+(vc.bg*vc.black), VCOF_SYSDFLT);
	if(temp_difference_cruise<=-30) {
	vcWinAtSayX(win,number+14,36, "below",
	vc.red|vc.bold|vc.blink+(vc.bg*vc.black), VCOF_SYSDFLT); }
	if(temp_difference_cruise>=30) {
	vcWinAtSayX(win,number+14,23, "above",
	vc.red|vc.bold|vc.blink+(vc.bg*vc.black), VCOF_SYSDFLT); }

	vcAtSay(number+15,8,"density altitude: at cruise altitude of       feet MSL");
	vcAtSayNumX(win,number+15,48, &crz_alt,"#####",VCOF_INT,
		vc.cyan|vc.bold+(vc.bg*vc.black), VCOF_SYSDFLT);
	vcAtSay(number+17,8,"recommended departure climb speed");
	vcAtSay(number+18,8,"departure rate of climb");

	vcAtSay(number+20,8,"at cruise climb speed");
	vcAtSay(number+21,8,"at cruise rate of climb");
	vcAtSay(number+22,8,"at cruise true airspeed");
	vcAtSay(number+23,8,"at cruise fuel consumption");
	if(!m_pressr)
	vcAtSay(number+24,8,"at cruise Rpm");
	if(m_pressr)
	vcAtSay(number+24,8,"at cruise Rpm and Manifold pressure of    inches");
	vcAtSay(number+9,1,"ATMOSPHERIC DATA");

	/* draw data files color coded by temperature */
	vcWinAtSayX(win,number+9,1,"ATMOSPHERIC DATA:",
	vc.green|vc.bold+(vc.bg*vc.black), VCOF_SYSDFLT);
	
	vcAtSay(number+9,19,"Take off file:             ");
	
/* if no retry was used to get a power setting then
 * print takeoff performance file name this way */
	if(!climbdefault) {
	if(temp_difference_takeoff >= 19)
	vcWinAtSayX(win,number+9,34, takeoffile,
	vc.brown|vc.bold+(vc.bg*vc.black), VCOF_SYSDFLT);
	if(temp_difference_takeoff <= -19)
	vcWinAtSayX(win,number+9,34, takeoffile,
	vc.blue|vc.bold+(vc.bg*vc.black), VCOF_SYSDFLT);
	if((temp_difference_takeoff > -19) && (temp_difference_takeoff < 19))
	vcWinAtSayX(win,number+9,34, takeoffile,
	vc.green|vc.bold+(vc.bg*vc.black), VCOF_SYSDFLT);
	}
/* if a retry was used to get a power setting 
 * then print takeoff performance file name this way */	
	if ( departure_power_settings_changed == SET ) {
	if(!climbdefault) {
	if(temp_difference_takeoff >= 19)
	vcWinAtSayX(win,number+9,34, takeoffile,
	vc.brown|vc.bold|vc.blink+(vc.bg*vc.black), VCOF_SYSDFLT);
	if(temp_difference_takeoff <= -19)
	vcWinAtSayX(win,number+9,34, takeoffile,
	vc.blue|vc.bold|vc.blink+(vc.bg*vc.black), VCOF_SYSDFLT);
	if((temp_difference_takeoff > -19) && (temp_difference_takeoff < 19))
	vcWinAtSayX(win,number+9,34, takeoffile,
	vc.green|vc.bold|vc.blink+(vc.bg*vc.black), VCOF_SYSDFLT);
	} /* end if (climbdefault..... */
   } /* end if (departure_power..... */
	
	if(climbdefault)
	vcWinAtSayX(win,number+9,34, default_file,
	vc.red|vc.bold+(vc.bg*vc.black), VCOF_SYSDFLT);
    
    vcAtSay(number+9,47,"Cruise file:             ");

/* if no retry was used to get a power setting then
 * print cruise performance file name this way */
	if(!d) {
	if(temp_difference_cruise >= 19)
	vcWinAtSayX(win,number+9,60, current_file,
	vc.brown|vc.bold+(vc.bg*vc.black), VCOF_SYSDFLT);
	if(temp_difference_cruise <= -19)
	vcWinAtSayX(win,number+9,60, current_file,
	vc.blue|vc.bold+(vc.bg*vc.black), VCOF_SYSDFLT);
	if((temp_difference_cruise > -19) && (temp_difference_cruise < 19))
	vcWinAtSayX(win,number+9,60, current_file,
	vc.green|vc.bold+(vc.bg*vc.black), VCOF_SYSDFLT);
	}
/* if a retry was used to get a power setting 
 * then print cruise performance file name this way */	
	if (cruise_power_settings_changed == SET) {
	if(!d) {
	if(temp_difference_cruise >= 19)
	vcWinAtSayX(win,number+9,60, current_file,
	vc.brown|vc.bold|vc.blink+(vc.bg*vc.black), VCOF_SYSDFLT);
	if(temp_difference_cruise <= -19)
	vcWinAtSayX(win,number+9,60, current_file,
	vc.blue|vc.bold|vc.blink+(vc.bg*vc.black), VCOF_SYSDFLT);
	if((temp_difference_cruise > -19) && (temp_difference_cruise < 19))
	vcWinAtSayX(win,number+9,60, current_file,
	vc.green|vc.bold|vc.blink+(vc.bg*vc.black), VCOF_SYSDFLT);
	} /* end if (!d..... */
   } /* end if (cruise_power_..... */
	
	if(d)
	vcWinAtSayX(win,number+9,60, default_file,
	vc.red|vc.bold+(vc.bg*vc.black), VCOF_SYSDFLT);

	vcAtSayNum(number+10,1, &takeoff_stand_temp,
		"#####",VCOF_INT|VCOF_SYSDFLT);

	/* color change for atmospheric temp - takeoff*/
	vcAtSayNumX(win,number+11,1, &temp_difference_takeoff,
	"#####",VCOF_INT,vc.green|vc.bold+(vc.bg*vc.black),VCOF_SYSDFLT);
	if( (temp_difference_takeoff >= 19) ) {
	vcAtSayNumX(win,number+11,1, &temp_difference_takeoff,
	"#####",VCOF_INT,vc.brown|vc.bold+(vc.bg*vc.black),VCOF_SYSDFLT);
	}
	if( (temp_difference_takeoff <= -19) ) {
	vcAtSayNumX(win,number+11,1, &temp_difference_takeoff,
	"#####",VCOF_INT,vc.blue|vc.bold+(vc.bg*vc.black),VCOF_SYSDFLT);
	}
	if( (temp_difference_takeoff>=30) || (temp_difference_takeoff<=-30) ) {
	vcAtSayNumX(win,number+11,1, &temp_difference_takeoff,
	"#####",VCOF_INT,vc.red|vc.bold|vc.blink+(vc.bg*vc.black),VCOF_SYSDFLT);
	}

	vcAtSayNum(number+12,1, &takeoff_density_alt,
		"#####",VCOF_INT|VCOF_SYSDFLT);
	if( abs(takeoff_density_alt - AirportData.d_elevation) > 2000) {
	vcAtSayNumX(win,number+12,1, &takeoff_density_alt,
	"#####",VCOF_INT,vc.brown|vc.bold+(vc.bg*vc.black),VCOF_SYSDFLT);
	}
	if(takeoff_density_alt > 13999) {
	vcAtSayNumX(win,number+12,1, &takeoff_density_alt,
	"#####",VCOF_INT,vc.red|vc.bold+(vc.bg*vc.black),VCOF_SYSDFLT);
	}
	vcAtSayNum(number+13,1, &cruise_stand_temp,
		"#####",VCOF_INT|VCOF_SYSDFLT);

	/* color change for atmospheric temp - cruise*/
	vcAtSayNumX(win,number+14,1, &temp_difference_cruise,
	"#####",VCOF_INT,vc.green|vc.bold+(vc.bg*vc.black),VCOF_SYSDFLT);
	if( (temp_difference_cruise >= 19) ) {
	vcAtSayNumX(win,number+14,1, &temp_difference_cruise,
	"#####",VCOF_INT,vc.brown|vc.bold+(vc.bg*vc.black),VCOF_SYSDFLT);
	}
	if( (temp_difference_cruise <= -19) ) {
	vcAtSayNumX(win,number+14,1, &temp_difference_cruise,
	"#####",VCOF_INT,vc.blue|vc.bold+(vc.bg*vc.black),VCOF_SYSDFLT);
	}
	if( (temp_difference_cruise>=30) || (temp_difference_cruise<=-30) ) {
	vcAtSayNumX(win,number+14,1, &temp_difference_cruise,
	"#####",VCOF_INT,vc.red|vc.bold|vc.blink+(vc.bg*vc.black),VCOF_SYSDFLT);
	}

	vcAtSayNum(number+15,1, &cruise_density_alt,
		"#####",VCOF_INT|VCOF_SYSDFLT);
	if( abs(cruise_density_alt - crz_alt) > 2000) {
	vcAtSayNumX(win,number+15,1, &cruise_density_alt,
	"#####",VCOF_INT,vc.brown|vc.bold+(vc.bg*vc.black),VCOF_SYSDFLT);
	}
	if(cruise_density_alt > 13999) {
	vcAtSayNumX(win,number+15,1, &cruise_density_alt,
	"#####",VCOF_INT,vc.red|vc.bold+(vc.bg*vc.black),VCOF_SYSDFLT);
	}
	vcWinAtSayX(win,number+16,1,"---------------DEPART DATA---------------",
	vc.green|vc.bold+(vc.bg*vc.black), VCOF_SYSDFLT);
	vcAtSayNum(number+17,1, &depart_cs,
		"#####",VCOF_INT|VCOF_SYSDFLT);
	vcAtSayNum(number+18,1,&depart_rc,
		"#####",VCOF_INT|VCOF_SYSDFLT);
	vcWinAtSayX(win,number+19,1,"---------------CRUISE DATA---------------",
	vc.green|vc.bold+(vc.bg*vc.black), VCOF_SYSDFLT);
	vcAtSayNum(number+20,1,&cruise_cs,
		"#####",VCOF_INT|VCOF_SYSDFLT);
	vcAtSayNum(number+21,1, &cruise_rc,
		"#####",VCOF_INT|VCOF_SYSDFLT);
	vcAtSayNum(number+22,1,&cruise_tas,
		"#####",VCOF_INT|VCOF_SYSDFLT);
	vcAtSayNum(number+23,1,&cruise_fc,
		"###.#",VCOF_DOUBLE|VCOF_SYSDFLT);
/*  --------------------------------------------- */
	if(!d)
	  vcAtSayNum(number+24,1,&perform.rpm,
		 "#####",VCOF_INT|VCOF_SYSDFLT);
/* if a retry with new power setting used print this */
	if (cruise_power_settings_changed == SET) {
	  if(!d) vcAtSayNumX(win,number+24,1, &perform.rpm,
	    "#####",VCOF_INT,vc.green|vc.blink+(vc.bg*vc.black), VCOF_SYSDFLT); }

	if(d)
	vcAtSayNum(number+24,1,&defaults.rpm,
		 "#####",VCOF_INT|VCOF_SYSDFLT);
/* ---------------------------------------------- */	
	if( (!d) && (m_pressr) )
	  vcAtSayNum(number+24,47,&perform.mp,
		 "##",VCOF_INT|VCOF_SYSDFLT);
/* if a retry with a new power setting used print this */	
	if (cruise_power_settings_changed == SET) {
	  if( (!d) && (m_pressr) ) 
	    vcAtSayNumX(win,number+24,47, &perform.mp,
	     "##",VCOF_INT,vc.green|vc.blink+(vc.bg*vc.black), VCOF_SYSDFLT); }
	
	if( (d) && (m_pressr) )
	vcAtSayNum(number+24,47,&defaults.mp,
		 "##",VCOF_INT|VCOF_SYSDFLT);
/* ---------------------------------------------- */
	vcWinAtSayX(win,number+25,1,"--------------------CLIMB/DESCENT DATA---------------",
	vc.green|vc.bold+(vc.bg*vc.black), VCOF_SYSDFLT);

	vcAtSay(number+26,1,"Required climb distance ->");
	vcAtSayNum(number+26,28,&climb_distance,
		"###.#",VCOF_FLOAT|VCOF_SYSDFLT);
	vcAtSay(number+26,34,"NM using rate of climb average");
	vcAtSay(number+27,1,"Required descent distance ->");
	vcAtSayNum(number+27,30,&descent_distance,
		"###.#",VCOF_FLOAT|VCOF_SYSDFLT);
	vcAtSay(number+27,36,"NM using a descent rate of");
	vcAtSayNum(number+27,63,&RD,"####",VCOF_INT|VCOF_SYSDFLT);
	vcAtSay(number+27,68,"FPM");
	vcAtSayX(number +28,1,"Fuel includes a 1 hr reserve...",
	vc.white|vc.blink|+(vc.bg*vc.black),VCOF_SYSDFLT);
    
    /* print the rental and fuel costs */
    vcWinAtSayX(win,number+29,1,"--------------------ESTIMATED COSTS------------------",
	vc.green|vc.bold+(vc.bg*vc.black), VCOF_SYSDFLT);
    if (RATE_fuelcost != 0) { vcAtSay(number+30,1,"The fuel cost is estimated at  $");
    vcAtSayNum(number+30,33,&Cost_fuel,"####.##",VCOF_FLOAT|VCOF_SYSDFLT); }
    if (RATE_wet != 0) { vcAtSay(number+31,1,"Rental cost WET  $");
    vcAtSayNum(number+31,19,&Cost_wet,"####.##",VCOF_FLOAT|VCOF_SYSDFLT); }
    if (RATE_dry != 0) { vcAtSay(number+32,1,"Rental cost DRY  $");
    vcAtSayNum(number+32,19,&Cost_dry,"####.##",VCOF_FLOAT|VCOF_SYSDFLT); 
    vcAtSay(number+32,27,"with fuel $");
    vcAtSayNum(number+32,38,&DRY_total,"####.##",VCOF_FLOAT|VCOF_SYSDFLT); }
	
	
	/* clear the performance warning messages if previously on the screen */
	vcAtSayX(number+33,1,"                                               ",
	vc.black+(vc.bg*vc.black),VCOF_SYSDFLT);
	vcAtSayX(number+34,1,"                                                        ",
	vc.black+(vc.bg*vc.black),VCOF_SYSDFLT);
	vcAtSayX(number+35,1,"                                               ",
	vc.black+(vc.bg*vc.black),VCOF_SYSDFLT);
	vcAtSayX(number+36,1,"                                                   ",
	vc.black+(vc.bg*vc.black),VCOF_SYSDFLT);

	/* print warnings if applicable */
	if( (temp_difference_takeoff >=30) || (temp_difference_takeoff <= -30) ||
	(temp_difference_cruise >=30) || (temp_difference_cruise <= -30) ) {
	vcAtSayX(number+33,1,"WARNING: Performance Data WILL NOT be accurate!",
		vc.red|vc.bold+(vc.bg*vc.black),VCOF_SYSDFLT);
	vcAtSayX(number+34,1,"Due to Extreme Temperature, Flight is NOT recommended!!!",
		vc.red|vc.bold+(vc.bg*vc.black),VCOF_SYSDFLT);
	}
	if( (takeoff_density_alt > 13999) || (cruise_density_alt > 13999) ) {
	vcAtSayX(number+35,1,"WARNING: Performance Data WILL NOT be accurate!",
		vc.red|vc.bold+(vc.bg*vc.black),VCOF_SYSDFLT);
	vcAtSayX(number+36,1,"Density Altitude Exceeds Limits of Performance Data",
		vc.red|vc.bold+(vc.bg*vc.black),VCOF_SYSDFLT);
	}
        
	/* reset the window refresh to on and redraw screen*/
	vcWinOn(win);
	vcAtSayX(0,0," ",vc.white+(vc.bg*vc.black),VCOF_SYSDFLT);
	RedrawButtons();
	/* calc function counter prevents from printing or 
	filing unless something was calculated */
	calcounter = 1;
	return( VCSUCCESS );
	} /* end of Calc_Print_results_to_Flightlog_page() */

	/* ****************************************** */
	/* Function to clear all of the data on the navigation page
	before a new flight plan is calculated */
	VCCOUNT ClearTripArray()
	{
	VCCOUNT n;
	for(n = 0; n <= 8; n++) {
	vcEmpty(segment[n].name, 31);
	segment[n].distc=0;
	segment[n].magnetic_crs=0;
	segment[n].wind_dir=0;
	segment[n].wind_spd=0;  }
	AirportData.d_elevation=0; AirportData.a_elevation=0;
	AirportData.d_atis=0; AirportData.a_atis=0;
	AirportData.d_clrcdeliv=0; AirportData.a_clrcdeliv=0;
	AirportData.d_ground=0; AirportData.a_ground=0;
	AirportData.d_tower=0; AirportData.a_tower=0;
	AirportData.departcnt=0; AirportData.arrivalcnt=0;
	AirportData.d_fss=0; AirportData.a_fss=0;
	AirportData.d_unicom=0; AirportData.a_unicom=0;
	return(VCSUCCESS);
	}

	/* ******************************************** */ 
	/* Function for the "clear" button on the navigation page */
	VCCOUNT ClearWorkSheet()
	{
	VCWIN *clear;
	VCCOUNT n;
	VCCOUNT a = 0;
	/* Verify before clearing worksheet in no, then exit */
	a = VerifyClearWorksheet();
	if(!a) {
	 return( VCSUCCESS );
	 }

	
	
	for(n = 0; n <= 8; n++) {
	vcEmpty(segment[n].name, 31);
	segment[n].distc=0;
	segment[n].magnetic_crs=0;
	segment[n].wind_dir=0;
	segment[n].wind_spd=0;  }
	AirportData.d_elevation=0; AirportData.a_elevation=0;
	AirportData.d_atis=0; AirportData.a_atis=0;
	AirportData.d_clrcdeliv=0; AirportData.a_clrcdeliv=0;
	AirportData.d_ground=0; AirportData.a_ground=0;
	AirportData.d_tower=0; AirportData.a_tower=0;
	AirportData.departcnt=0; AirportData.arrivalcnt=0;
	AirportData.d_fss=0; AirportData.a_fss=0;
	AirportData.d_unicom=0; AirportData.a_unicom=0;
	FuelOnBoard = 0;
	clear = vcWinOpenX(9,20,14,65,"",VCWF_SHADOW,
		0,0,vcBorderFromID(1),vcColorFromID(3));
	vcAtSay(1,5,"Worksheet Cleared -Press any key");
	/* Empty save trip field and delete the trip text file */
	vcEmpty(Tfilename, 7);
	vcDelFile("trip.pln");
	get_a_key();
	vcWinClose(clear);
	UpdateNavForm();
	
	return(VCSUCCESS);
	}
    
    /* ********************************************* */
    /* Simular to Clear Worksheet but doesn't clear trip just loaded */
	VCCOUNT ResetForm()
	{
	VCWIN *clear;
	VCCOUNT n;
	for(n = 0; n <= 8; n++) {
	vcEmpty(segment[n].name, 31);
	segment[n].distc=0;
	segment[n].magnetic_crs=0;
	segment[n].wind_dir=0;
	segment[n].wind_spd=0;  }
	AirportData.d_elevation=0; AirportData.a_elevation=0;
	AirportData.d_atis=0; AirportData.a_atis=0;
	AirportData.d_clrcdeliv=0; AirportData.a_clrcdeliv=0;
	AirportData.d_ground=0; AirportData.a_ground=0;
	AirportData.d_tower=0; AirportData.a_tower=0;
	AirportData.departcnt=0; AirportData.arrivalcnt=0;
	AirportData.d_fss=0; AirportData.a_fss=0;
	AirportData.d_unicom=0; AirportData.a_unicom=0;
	FuelOnBoard = 0;
	clear = vcWinOpenX(9,8,13,55,"",VCWF_SHADOW,
		0,0,vcBorderFromID(1),vcColorFromID(3));
	vcAtSay(1,2,"Page reset...Press any key to get new trip");
	/* Empty save trip field and delete the trip text file */
	vcEmpty(Tfilename, 7);
	vcDelFile("trip.pln");
	get_a_key();
	vcWinClose(clear);
	UpdateNavForm();
	
	return(VCSUCCESS);
	}
	
	/* ********************************************* */
	/* Loads trip named in the trip.pln file */
	VCCOUNT GetTrip()  {
	struct stat statbuf;
	FILE *stream;

    VCWIN *get;
	VCCOUNT file_n,compare_strings;
	char datafile[] = "           ";
	char ext[] = ".ADA";
	char UpdateTime[26];
	char clear_UpdateTime[] = "                         ";
    
    /* clear out the old UpdateTime String */
    strcpy(UpdateTime, clear_UpdateTime);
    	
	/* copy whatever is in Path.fname to Tfilename
	** even if it is blank as is the case with errors */
	strcpy(Tfilename, Path.fname);
		
	/* open Trip Nav file */
	if((fp=fopen(Tfilename,"rb"))==NULL) {
	get = vcWinOpenX(9,10,14,62,"",VCWF_SHADOW,
		0,0,vcBorderFromID(1),vcColorFromID(9));
	vcAtSay(0,2,"Please Verify trip Name!");
	vcAtSay(1,2,"You can do this on the NAVIGATION page.");
	vcAtSay(2,2,"Type (2) 3 letter aiprort codes");
	vcAtSay(3,2,"in the field provided.");
	
	vcEmpty(Tfilename, 7);
	vcEmpty(Path.fname,7);
	calcounter = OFF;
	vcDelFile("trip.pln");
	get_a_key();
	vcWinClose(get);
	
	/* clean old data from array */
	ClearWorkSheet();
	UpdateNavForm();
	return( VCSUCCESS ); }

	for(seg = 0, file_n = 0; seg<=7; seg++, file_n++)
	{
	fseek(fp,(file_n) * sizeof(struct nav),SEEK_SET);
	fread(&segment[file_n], sizeof(struct nav),1,fp);
	}

	/* this reads the 8th structure item */
	fread(&segment[file_n], sizeof(struct nav),1,fp);
	fclose(fp);

	/* Create .ada file extension for Airport Data file */
	strcpy(datafile, Tfilename);
	strcat(datafile, ext);

	/* open Airport Data file */
	if((fp=fopen(datafile,"rb"))==NULL) {
	get = vcWinOpenX(9,10,14,52,"",VCWF_SHADOW,
		0,0,vcBorderFromID(1),vcColorFromID(9));
	vcWinErase(get,VCDEFAULT);
	vcAtSay(0,2,"Could not open Airport Data!");
	vcAtSay(1,2,"Verify you have the files in");
	vcAtSay(2,2,"the home directory");
	vcAtSay(3,2,"Then try and re-load.");
	strcpy(Tfilename,bad_name);
	strcpy(Path.fname,"       ");
	vcDelFile("trip.pln");
	get_a_key();
	vcWinClose(get);
	return( VCSUCCESS ); }

	/* file found - get data from file */
	fseek(fp,0 * sizeof(struct airports),SEEK_SET);
	fread(&AirportData, sizeof(struct airports),1,fp);
	fclose(fp);

	/* open window and print results */
	get = vcWinOpenX(9,8,13,55,"",VCWF_SHADOW,
		0,0,vcBorderFromID(1),vcColorFromID(2));
	vcAtSay(0,12,"Trip        is Loaded...");
	vcAtSay(1,1,"Press any key to write        to NAV page!");
	vcAtSayX(0,17,Tfilename,vc.brown|vc.bold+(vc.bg*vc.cyan), VCOF_SYSDFLT);
	vcAtSayX(1,24,Tfilename,vc.black+(vc.bg*vc.cyan), VCOF_SYSDFLT);
	
	/* get the last time file was edited and print to window */
	/* open a file for update */
	if ((stream = fopen(Tfilename, "r"))== NULL) {
	  vcAtSay(2,1,"Cannot open output file.\n");
	  get_a_key();
	  return(VCSUCCESS);
	}
	/* get date information about the file */
	fstat(fileno(stream), &statbuf);
	fclose(stream);	
	/* trim the last character of the string */
	strncpy(UpdateTime,ctime(&statbuf.st_ctime),24);
	 
    /* print file information to window showing flight plan
     * opened */    
	vcAtSay(2,4,"Last update:");
	vcAtSayX(2,17,UpdateTime,vc.black+(vc.bg*vc.cyan), VCOF_SYSDFLT);

	get_a_key();
	vcWinClose(get);
	
	UpdateNavForm();
	return( VCSUCCESS );
	}

	/* ********************************************************** */
	VCCOUNT UpdateNavForm()
	{
	int leg;
	for(leg=0;leg<=7;leg++) {
	vcPutFldBuf(obj1[leg], segment[leg].name);
	vcPostMsg(VCOBJDRAW, obj1[leg],0L, 0L, 0L);
	vcPutFldBuf(obj2[leg], &segment[leg].magnetic_crs);
	vcPostMsg(VCOBJDRAW, obj2[leg],0L, 0L, 0L);
	vcPutFldBuf(obj3[leg], &segment[leg].distc);
	vcPostMsg(VCOBJDRAW, obj3[leg],0L, 0L, 0L);
	vcPutFldBuf(obj4[leg], &segment[leg].wind_dir);
	vcPostMsg(VCOBJDRAW, obj4[leg],0L, 0L, 0L);
	vcPutFldBuf(obj5[leg], &segment[leg].wind_spd);
	vcPostMsg(VCOBJDRAW, obj5[leg],0L, 0L, 0L);
	}
	
	vcPutFldBuf(obj6, &AirportData.d_elevation);
	vcPostMsg(VCOBJDRAW, obj6,0L, 0L, 0L);
	vcPutFldBuf(obj7, &AirportData.a_elevation);
	vcPostMsg(VCOBJDRAW, obj7,0L, 0L, 0L);
	vcPutFldBuf(obj8, &AirportData.d_atis);
	vcPostMsg(VCOBJDRAW, obj8,0L, 0L, 0L);
	vcPutFldBuf(obj9, &AirportData.a_atis);
	vcPostMsg(VCOBJDRAW, obj9,0L, 0L, 0L);
	vcPutFldBuf(obj10, &AirportData.d_clrcdeliv);
	vcPostMsg(VCOBJDRAW, obj10,0L, 0L, 0L);
	vcPutFldBuf(obj11, &AirportData.a_clrcdeliv);
	vcPostMsg(VCOBJDRAW, obj11,0L, 0L, 0L);
	vcPutFldBuf(obj12, &AirportData.d_ground);
	vcPostMsg(VCOBJDRAW, obj12,0L, 0L, 0L);
	vcPutFldBuf(obj13, &AirportData.a_ground);
	vcPostMsg(VCOBJDRAW, obj13,0L, 0L, 0L);
	vcPutFldBuf(obj14, &AirportData.d_tower);
	vcPostMsg(VCOBJDRAW, obj14,0L, 0L, 0L);
	vcPutFldBuf(obj15, &AirportData.a_tower);
	vcPostMsg(VCOBJDRAW, obj15,0L, 0L, 0L);
	vcPutFldBuf(obj16, &AirportData.departcnt);
	vcPostMsg(VCOBJDRAW, obj16,0L, 0L, 0L);
	vcPutFldBuf(obj17, &AirportData.arrivalcnt);
	vcPostMsg(VCOBJDRAW, obj17,0L, 0L, 0L);
	vcPutFldBuf(obj18, &AirportData.d_fss);
	vcPostMsg(VCOBJDRAW, obj18,0L, 0L, 0L);
	vcPutFldBuf(obj19, &AirportData.a_fss);
	vcPostMsg(VCOBJDRAW, obj19,0L, 0L, 0L);
	vcPutFldBuf(obj20, &AirportData.d_unicom);
	vcPostMsg(VCOBJDRAW, obj20,0L, 0L, 0L);
	vcPutFldBuf(obj21, &AirportData.a_unicom);
	vcPostMsg(VCOBJDRAW, obj21,0L, 0L, 0L);
	vcPutFldBuf(obj22, &Tfilename);
	vcPostMsg(VCOBJDRAW, obj22,0L, 0L, 0L);
	vcPutFldBuf(obj23, &FuelOnBoard);
	vcPostMsg(VCOBJDRAW, obj23,0L, 0L, 0L);
	
	vcStatSay("Finished update", vc.brown|vc.bold|vc.blue*vc.bg);
	vcUpdateVIO();
	return( VCSUCCESS );
	}

	/* ********************************************************** */
	VCCOUNT ReadyDrive(int disk)
	{
	VCWIN *e;
	char name[5];
	char *drives[] = {"A","B"};
	e = vcWinOpenX(7,13,11,68," Notice ",
		 VCWF_SHADOW,0,0,vcBorderFromID(1),
		 vcColorFromID(0));
	strcpy(name,drives[disk]);
	vcAtSay(0,2,"Please intstall Flight Log Maker to your");
	vcAtSay(1,2,"hard disk drive. This program no longer supports");
	vcAtSay(2,2,"diskette verification before a Read or Write");
	vcUpdateVIO();
	get_a_key();
	vcWinClose(e);
	return(VCSUCCESS);
	}

	/* ******************************************************** */
	VCCOUNT ReadAorB()
	{
	/* for checking drive flt.exe was launched from */
	int floppy;
	unsigned disk;
	char rbuffer[512];

	/* what disk is the program being run  */
	_dos_getdrive(&disk);
	if((disk>=1) && (disk <=2)) {
	floppy = biosdisk(4,(disk-1),0,0,0,1,rbuffer);
	floppy &= 0x02;
	if(!( floppy ) ){
	ReadyDrive((int)disk-1);
	}
	vcEnd();
	clrscr();
	puts("Install all Flight Log Maker files to a Hardrive");
	exit(0);
	}
	return(VCSUCCESS);
	}

	/* ******************************************************** */
	VCCOUNT AltitudeError()
	{
	VCWIN *e;
	calcounter = OFF;
	vcCurHide(vccrt);
	ClearOldData();
	e = vcWinOpenX(7,4,13,74," Altitude error! ",
		 NULL,0,0,vcBorderFromID(5),
		 vcColorFromID(20));
	vcAtSay(0,2,"Please check the altitude selected for this flight.");
	vcAtSay(1,2,"My calculations show that the altitude is too high for the");
	vcAtSay(2,2,"distance to fly using the expected rate of climb and descent.");
	vcAtSay(4,2,"Press any key then select NEW to change setting.");
	vcStatSay("Error! - Press any key to reset then NEW to correct!"
		 ,vc.red|vc.bold|vc.blue*vc.bg);
	vcUpdateVIO();
	get_a_key();
	vcCurShow(vccrt);
	vcWinClose(e);
	RedrawButtons();
	return(VCSUCCESS);
	}

	/* ******************************************************** */
	VCCOUNT ElevationError()
	{
	VCWIN *e;
	calcounter = OFF;
	vcCurHide(vccrt);
	ClearOldData();
	e = vcWinOpenX(7,4,13,74," Cruise Altitude error! ",
		 NULL,0,0,vcBorderFromID(5),
		 vcColorFromID(20));
	vcAtSay(0,2,"Please check the cruise altitude selected for this flight.");
	vcAtSay(1,2,"Your cruise altitude is less than the field elevation(s)");
	vcAtSay(2,2,"of one or both airports.  Choose a higher altitude.");
	vcAtSay(4,2,"Press any key then select NEW to change setting.");
	vcStatSay("Error! - Press any key to reset then NEW to correct!"
		 ,vc.red|vc.bold|vc.blue*vc.bg);
	vcUpdateVIO();
	get_a_key();
	vcCurShow(vccrt);
	vcWinClose(e);
	RedrawButtons();
	return(VCSUCCESS);
	}

	/* ********************************************************** */
	VCCOUNT no_data()
	{
	VCWIN *e;
	calcounter = OFF;
	vcCurHide(vccrt);
	ClearOldData();
	e = vcWinOpenX(7,4,13,74," Data entry error! ",
		 NULL,0,0,vcBorderFromID(5),
		 vcColorFromID(20));
	vcAtSay(0,2,"Please check all segments of your trip.  A segment was");
	vcAtSay(1,2,"skipped or entered incorrectly.  Please go back and");
	vcAtSay(2,2,"fill out each line without skipping any data entry fields.");
	vcAtSay(4,2,"Press any key then select BACK to change setting.");
	vcStatSay("Error! - Press any key to reset then BACK to correct!"
		 ,vc.red|vc.bold|vc.blue*vc.bg);
	vcUpdateVIO();
	get_a_key();
	vcCurShow(vccrt);
	vcWinClose(e);
	RedrawButtons();
	return(VCSUCCESS);
	}

	/* ********************************************************* */
	VCCOUNT BadMilage()
	{
	VCWIN *e;
	calcounter = OFF;
	vcCurHide(vccrt);
	ClearOldData();
	e = vcWinOpenX(7,10,13,70," Flight plan segment error! ",
		 NULL,0,0,vcBorderFromID(5),
		 vcColorFromID(20));
	vcAtSay(0,2,"Please check the milage entered for each of segment.");
	vcAtSay(1,2,"You made a mistake in one of the milage data fields.");
	vcAtSay(2,2,"Do not use negative numbers please!");
	vcAtSay(4,2,"Press any key then select BACK to change setting.");
	vcStatSay("Error! - Press any key to reset then BACK to correct!"
		 ,vc.red|vc.bold|vc.blue*vc.bg);
	vcUpdateVIO();
	get_a_key();
	vcCurShow(vccrt);
	vcWinClose(e);
	RedrawButtons();
	return(VCSUCCESS);
	}

	/* ********************************************************* */
	VCCOUNT FuelError()
	{
	VCWIN *e;
	calcounter = OFF;
	vcCurHide(vccrt);
	ClearOldData();
	e = vcWinOpenX(7,10,14,70," Fueling error! ",
		 NULL,0,0,vcBorderFromID(5),
		 vcColorFromID(20));
    
    if(FuelOnBoard > AircraftInfo.ac_fuelcapacity) {
	vcAtSay(0,3,"Aircraft fuel input:       gallons");
	vcAtSayNumX(e,0,24, &FuelOnBoard,
		"###.#",VCOF_FLOAT,vc.black+(vc.bg*vc.cyan),
		 VCOF_SYSDFLT); }
    if( FuelOnBoard > AircraftInfo.ac_fuelcapacity) {
	vcAtSay(1,3,"Fuel capacity for this aircraft is       gallons");
	vcAtSayNumX(e,1,38, &AircraftInfo.ac_fuelcapacity,
		"###.#",VCOF_FLOAT,vc.black+(vc.bg*vc.cyan),
		 VCOF_SYSDFLT); }

	if(totalfuel > FuelOnBoard) {
	vcAtSay(0,3,"Trip fuel required:        gallons");
	vcAtSayNumX(e,0,23, &totalfuel,
		"###.##",VCOF_FLOAT,vc.black+(vc.bg*vc.cyan),
		 VCOF_SYSDFLT); }
    if( totalfuel > FuelOnBoard) {
	vcAtSay(1,3,"Aircraft fuel input:       gallons");
	vcAtSayNumX(e,1,24, &FuelOnBoard,
		"###.#",VCOF_FLOAT,vc.black+(vc.bg*vc.cyan),
		 VCOF_SYSDFLT); }
	
	vcAtSay(3,2,"        PLEASE ADJUST FUEL / PLAN FUEL STOP!");
	vcAtSay(5,2,"    Press any key then select BACK to change setting.");
	vcStatSay("Error! - Press any key to reset then BACK to correct!"
		 ,vc.red|vc.bold|vc.blue*vc.bg);
	
	vcUpdateVIO();
	get_a_key();
	vcCurShow(vccrt);
	vcWinClose(e);
	RedrawButtons();
	return(VCSUCCESS);
	}
	
	/* ********************************************************* */
	VCCOUNT AlreadyExists(char *savefile)
	{
	int a;
	char p;
	VCWIN *e;
	vcMouHide();
	e = vcWinOpenX(7,20,13,60," File write warning! ",
		 VCWF_CURSOR|VCWF_SHADOW,0,0,vcBorderFromID(1),
		 vcColorFromID(8));
	vcAtSay(0,10,"File Already Exists!");
	vcAtSayX(1,15,savefile,vc.green|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
	vcAtSay(2,7,"Do you wish to OVERWRITE ?");
	vcAtSay(4,13,"Press Y or N ! ");
	vcStatSay("The File you wish to save already exists!",
	  vc.white|vc.bold|vc.blink|vc.blue*vc.bg);
	vcUpdateVIO();
	p = getch();
	  switch (p)
	 {
	   case 'y' :
	   case 'Y' : a = 1;
			  break;
	   case 'n' :
	   case 'N' : a = 0;
			  break;
	   default  : a = 0;
			  break;
	 }
	vcMouShow();
	vcWinClose(e);
	return a;
	}

	/* ********************************************************** */
	VCCOUNT VerifyClearWorksheet()
	{
	int a;
	char p;
	VCWIN *e;
	vcMouHide();
	e = vcWinOpenX(10,8,18,60," Verify Operation! ",
		 VCWF_CURSOR|VCWF_SHADOW,0,0,vcBorderFromID(1),
		 vcColorFromID(8));
	vcAtSay(1,1,"You are about to clear the NAV page information!");
	vcAtSay(3,13,"To cancel, press the N key.");
	vcAtSay(5,10,"Clear anyway?  Press the Y key.");
	
	vcUpdateVIO();
	p = getch();
	  switch (p)
	 {
	   case 'y' :
	   case 'Y' : a = 1;
			  break;
	   case 'n' :
	   case 'N' : a = 0;
			  break;
	   default  : a = 0;
			  break;
	 }
	vcMouShow();
	vcWinClose(e);
	return a;
	}
	
	/* ******************************************************** */
	VCCOUNT file_error()
	{
	VCWIN *e;
	calcounter = OFF;
	vcCurHide(vccrt);
	ClearOldData();
	e = vcWinOpenX(4,3,14,75," Performance data files not found! ",
		 NULL,0,0,vcBorderFromID(5),
		 vcColorFromID(20));
	vcAtSay(0,9,"I cannot find the performance data files for that");
	vcAtSay(1,9,"aircraft!  Verify that all of the aircraft files");
	vcAtSay(2,9,"are in the flight log maker folder.  This can also");
	vcAtSay(3,9,"be caused by missmatched aircraft data on the ");
	vcAtSay(4,9,"PERFORMANCE page OR you may have to reload aircraft");
	vcAtSay(5,9,"selection.");
	vcAtSay(7,9,"                Press any key...");

	get_a_key();
	vcCurShow(vccrt);
	vcWinClose(e);
	RedrawButtons();
	vcUpdateVIO();
	return(VCSUCCESS);
	}
    /* ********************************************************** */
    VCCOUNT MissingData()
	{
	VCWIN *e;
	calcounter = OFF;
	vcCurHide(vccrt);
	ClearOldData();
	e = vcWinOpenX(7,4,13,74," File Error! ",
		 NULL,0,0,vcBorderFromID(5),
		 vcColorFromID(20));
	vcAtSay(0,2,"The Data for this Aircraft appears to be incomplete");
	vcAtSay(1,2,"or corrupt.  Could not find valid default data either.");
	vcStatSay("Error! - Press any key to reset!"
		 ,vc.red|vc.bold|vc.blue*vc.bg);
	vcUpdateVIO();
	get_a_key();
	vcCurShow(vccrt);
	vcWinClose(e);
	RedrawButtons();
	return(VCSUCCESS);
	}

	/* ********************************************************** */
	VCCOUNT ClearOldData()
	{
	/* clear output window */
	vcWinErase(win,VCDEFAULT);
	return( VCSUCCESS );
	}

	/* ********************************************************** */
	VCCOUNT RedrawButtons()
	{
	vcPostMsg(VCOBJDRAW,save_trip_button, 0L,0L,0L);
	vcPostMsg(VCOBJDRAW,save_log_button, 0L,0L,0L);
	vcPostMsg(VCOBJDRAW,exit_last_window, 0L,0L,0L);
	vcPostMsg(VCOBJDRAW,calculate_button, 0L,0L,0L);
	vcPostMsg(VCOBJDRAW,print_button, 0L,0L,0L);
	vcPostMsg(VCOBJDRAW,navff3_button, 0L,0L,0L);
	vcPostMsg(VCOBJDRAW,newff3_button, 0L,0L,0L);
	//vcPostMsg(VCOBJDRAW,wbff3_button,  0L,0L,0L); //commented out for now
	return( VCSUCCESS );
	}

	/* *********************************************************** */
	VCCOUNT Calc() {
	
	Calc_save_listbox_selections();
	Calc_reset_variables();
	Calc_takeoff_set_files_used();
/* these "flag set" routines eliminate multiple
 * error windows coming up in the program we just
 * set the flags and then call the error routines 
 * one time only */
	if( !strcmpi(AircraftInfo.name, bad_name)) {
      file_error();
 	  return (VCSUCCESS); }
 	if ( file_error_flag == SET ) { 
      file_error();
      return (VCSUCCESS); }
	if ( no_mp_flag == SET ) {
	  no_mp();
	  return (VCSUCCESS); }
	if ( no_airp_flag == SET ) {
	  no_airp();
	  return (VCSUCCESS); }	
	
	
	Calc_Open_HIGHP_file_takeoff();
	Calc_Open_NORMP_file_takeoff();
	Calc_Open_DEFLT_file_t_off();
	Calc_Save_DEPART_data();
    
    
    
/* if no valid settings found the first time, use the
 * default power settings, set the retry flag and 
 * run through the performance files again for valid 
 * data. */    	
    if( retry_departure_settings_flag == SET) {
      Calc_takeoff_set_files_used();
      Calc_Open_HIGHP_file_takeoff();
	  Calc_Open_NORMP_file_takeoff();
	  Calc_Open_DEFLT_file_t_off();
	  departure_power_settings_changed = SET;
	  retry_departure_settings_flag = OFF;
	 
	  Calc_Save_DEPART_data(); }

	Calc_Cruise_set_files_used();
/* these "flag set" routines eliminate multiple
 * error windows coming up in the program we just
 * set the flags and then call the error routines 
 * one time only */
 	if ( file_error_flag == SET ) { 
      file_error();
      return (VCSUCCESS); }	
	if ( no_mp_flag == SET ) {
	  no_mp();
	  return (VCSUCCESS); }
	if ( no_airp_flag == SET ) {
	  no_airp();
	  return (VCSUCCESS); }	
	  
	Calc_Open_HIGHP_file_cruise();
	Calc_Open_NORMP_file_cruise();
	Calc_Open_DEFLT_file_cruise();
	Calc_Save_CRUISE_data(); 
    
    if( retry_cruise_settings_flag == SET) {
      Calc_Cruise_set_files_used();
	  Calc_Open_HIGHP_file_cruise();
	  Calc_Open_NORMP_file_cruise();
	  Calc_Open_DEFLT_file_cruise();
	  cruise_power_settings_changed = SET;
	  retry_cruise_settings_flag = OFF;
	  Calc_Save_CRUISE_data(); }
	
	Calc_Create_Nav_segment_pointers();
	
	Calc_Check_Nav_validity();
	
	if ( nav_error == ERROR )  {
	  no_data(); 
	  return (VCSUCCESS); }
	
	if ( milage_bad_flag == ERROR ) {
	  BadMilage();
	  return (VCSUCCESS); }
	
	/* If data file doesn't contain anything show error */
	if((perform.rpm == 0) || (defaults.rpm == 0 )) {
	  MissingData(); 
	  return(VCSUCCESS); }
	
	  	
	if ( nav_error == OFF ) {
	Calc_Calculate_all_segments();
	Calc_TotalsAndRemainingFuelTimeDistance();  
 	Calc_Rental_Costs();
/* these "flag set" routines eliminate multiple
 * error windows coming up in the program. Altitude
 * error can only be called after calculations for the 
 * trip are made. */
	if ( altitude_error_flag == SET ) {
		AltitudeError();
	  return (VCSUCCESS); }  

/* 2 checks for fuel errors */
	if(FuelOnBoard > AircraftInfo.ac_fuelcapacity) {
	FuelError();
	return( VCSUCCESS ); }
	
	if(totalfuel > FuelOnBoard) {
	FuelError();
	return( VCSUCCESS ); } /* end if...*/
    
    
	
	/* Turn the window refresh off tempararily
	to prevent buttons from being possibly
	drawn on top of data */
	vcWinOff(win);

	/* Clear old screen */
	ClearOldData();
	Calc_Print_results_to_Flightlog_page();  } /* if nav_error == OFF */
	
	return (VCSUCCESS);
	} 

	/* ******************************************************** */
	VCCOUNT PrintLog()
	{
	int  a, abyte=0, status;
	int keypress;
	VCWIN *printbox;
	/* exit function if calc function has not run and
	** file command is given to overwrite */
	if(!calcounter) {
	vcStatSay("Nothing Calculated",vc.white|vc.bold|vc.blue*vc.bg);
	vcUpdateVIO();
	return( VCSUCCESS ); }

	/* get printer status for port selected */
	status = biosprint(STATUS, abyte, (port-1) );


	if( status & 0x28 ) {
	printbox = vcWinOpenX(3,18,5,38,"Print Error!",NULL,
		0,0 ,vcStdBorder(), vcStdColor(2));
	vcAtSay(1,1," Printer not ready");
	vcStatSay("Check printer and cables - press any key and try again",vc.white|vc.bold|vc.blue*vc.bg);
	vcUpdateVIO();
	get_a_key();
	vcWinClose(printbox);
	vcStatSay("",vc.white|vc.bold|vc.blue*vc.bg);
	vcUpdateVIO();
	return(VCSUCCESS);
	}

	if( status & 0x80 ) {
	vcStatSay("Printer IS READY! - press any key to begin printing or ESC to abort"
	,vc.white|vc.bold|vc.blink|vc.blue*vc.bg);
	vcUpdateVIO();
	keypress=get_a_key();

	if(keypress==27) {  // if ESC key pressed
	vcStatSay("Print is Aborted - press any key",vc.white|vc.bold|vc.blink|vc.blue*vc.bg);
	vcUpdateVIO();
	get_a_key();
	vcStatSay("",vc.white|vc.bold|vc.blue*vc.bg);
	vcUpdateVIO();
	return(VCSUCCESS); }
	}
	else { vcStatSay("Can't obtain Printer Status with selected port",vc.white|vc.bold|vc.blink|vc.blue*vc.bg);
	 vcUpdateVIO();
	 get_a_key();
	 vcStatSay("Select NEW and try adjusting the Printer Port",vc.white|vc.bold|vc.blue*vc.bg);
	 vcUpdateVIO();
	 return( VCSUCCESS ); }

	/* print a message to status line and send data to printer */
	if( calcounter ) {
	 
	vcUpdateVIO();
	if((media = fopen(device,"w")) == NULL) {
	 vcStatSay("Can't open file",vc.white|vc.bold|vc.blue*vc.bg);
	 return(VCSUCCESS);
	 }
	}
	SendData();
	return( VCSUCCESS );
	}

	/* ********************************************************* */
	/* Saves the log to a file */
	VCCOUNT SaveLog()
	{
	VCCOUNT  a;
	VCWIN *error;
	FILE *exist;
	VCTEXT logname[22];
	VCTEXT *extension = ".LOG";
	VCTEXT *othertext = " created...";
	
	/* exit function if calc function has not run and
	** file command is given to overwrite */
	if(!calcounter) {
	vcStatSay("Nothing Calculated",vc.white|vc.bold|vc.blue*vc.bg);
	vcUpdateVIO();
	return( VCSUCCESS ); }
    
    
	/* create a file name if Tfilename string not blank */
	if( ( strcmpi(Tfilename, bad_name)) || (strcmpi(Tfilename, bad_name2)) ) {
	strcpy(logname, Tfilename);
	strcat(logname, extension); }
    
    /* check that it isn't a blank name */
    /* if file name is blank return !strcmpi returns TRUE if */ 
    /* logname and bad_name are the same */
    if( ( !strcmpi(logname, bad_name)) || (!strcmpi(logname, bad_name2)) ) {
    vcStatSay("Must reload trip or Rename file to valid name",vc.white|vc.bold|vc.blue*vc.bg);
	vcUpdateVIO();
	return( VCSUCCESS ); }
    
    
	/* check for duplicate filename */
	if( ((exist = fopen(logname,"rb")) != NULL) ) {
	a = AlreadyExists((char *)&logname);
	fclose(exist);
	if(!a) {
	 return( VCSUCCESS );
	 }
	}

	/* Send data to file */
	if((media = fopen(logname,"wb")) == NULL) {  
	vcEmpty(Tfilename, 7);
	vcEmpty(Path.fname, 7);
	 
	vcDelFile("trip.pln");
	vcStatSay("Reload trip or go to first page and enter the (2) 3 letter airport codes",vc.white|vc.bold|vc.blue*vc.bg);
	vcUpdateVIO();
	
	vcWinClose(error);
	return(VCSUCCESS );
	}
	strcat(logname, othertext);
	vcStatSay(logname,vc.white|vc.bold|vc.blue*vc.bg);
	vcUpdateVIO();
	SendData();
	return(VCSUCCESS);
	}

	/* ********************************************************* */
	VCCOUNT SendData()
	{
	/* data to print */
	time(&t);
	
	/* print warnings to .LOG sheet if conditions require */
	if( (temp_difference_takeoff >=30) || (temp_difference_takeoff <= -30) ||
	(temp_difference_cruise >=30) || (temp_difference_cruise <= -30) )
	fprintf(media,"Flight is NOT recommended due to temperature extremes!\n");
	if( (takeoff_density_alt > 10000) || (cruise_density_alt > 13999) )
	fprintf(media,"Flight is NOT recommended due to HIGH desity altitude!\n");
    // fuel alert status statements
    if ((FuelOnBoard-totalfuel) > cruise_fc) {
	  fprintf(media,"Fuel Quantity OK! - more than 60 minutes usable fuel remain at end of trip\n"); }
	if ( FuelOnBoard-totalfuel <= cruise_fc && FuelOnBoard-totalfuel >= cruise_fc/2) {fprintf(media,"Fuel Caution! - LESS than 60 minutes usable fuel remain at end of trip\n"); }
    
    if ((FuelOnBoard-totalfuel) <= (cruise_fc/2)) {
	  fprintf(media,"Fuel Warning! - LESS than 30 minutes usable fuel remain at end of trip\n"); }
       
	fprintf(media,"\nFlight Log Maker Trip sheet    Time Off ____:____       %s\n",ctime(&t));
	fprintf(media,"Aircraft: %s \n",AircraftInfo.name);
	if(d) {
	fprintf(media,"Cruise TAS %3d Power: %2d%% RPM:%5d MP:%3d FOB: %3.1f\n",
	defaults.tas, defaults.bhp, defaults.rpm, defaults.mp, FuelOnBoard);
	}
	else  {
	fprintf(media,"Cruise TAS %3d Power: %2d%% RPM:%5d MP:%3d FOB: %3.1f\n",
	cruise_tas, perform.bhp, perform.rpm, perform.mp, FuelOnBoard);
	}
	fprintf(media,"Altitude: %5d Note: (altitude may be approximate)\n",crz_alt);
	fprintf(media,"Fuel: (Climb fuel and 1 hour reserve included in the total fuel required)   FUEL\n");
	fprintf(media,"Segment                         NM  RD  MC  WD  WS   WC  MH  GS  ETE   ETR  REQD\n");
	fprintf(media,"------------------------------------------------------------------------------\n");
	for(number = 0;segment[number].distc > 0; number++)  {
	
 	if( ((int)legminutes[number] < 10) && ((int)rem_minutes[number] >= 10)
	&& (legfuel[number] > 10 ) ) {
	fprintf(media,"%s %3d %3d %3d %3d %3d  %c%2d %3d %3d %2.d:0%d %2.d:%2.d %3.1f", segment[number].name, segment[number].distc,
	  rem_distc[number], segment[number].magnetic_crs,segment[number].wind_dir, segment[number].wind_spd,
	  add_or_subtract[number], (int)correction[number],course[number],groundspeed[number],(int)leghours[number],(int)legminutes[number],(int)rem_hours[number],
	  (int)rem_minutes[number],legfuel[number]);
	  fprintf(media,"\n");
	 }
	if( ((int)legminutes[number] < 10) && ((int)rem_minutes[number] >= 10)
	&& (legfuel[number] < 10 ) ) {
	fprintf(media,"%s %3d %3d %3d %3d %3d  %c%2d %3d %3d %2.d:0%d %2.d:%2.d  %3.1f", segment[number].name, segment[number].distc,
	  rem_distc[number], segment[number].magnetic_crs,segment[number].wind_dir, segment[number].wind_spd,
	  add_or_subtract[number], (int)correction[number],course[number],groundspeed[number],(int)leghours[number],(int)legminutes[number],(int)rem_hours[number],
	  (int)rem_minutes[number],legfuel[number]);
	  fprintf(media,"\n");
	 }

	if( ((int)legminutes[number] < 10) && ((int)rem_minutes[number] < 10)
	&& (legfuel[number] > 10 ) ) {
	fprintf(media,"%s %3d %3d %3d %3d %3d  %c%2d %3d %3d %2.d:0%d %2.d:0%d %3.1f", segment[number].name, segment[number].distc,
	  rem_distc[number], segment[number].magnetic_crs,segment[number].wind_dir, segment[number].wind_spd,
	  add_or_subtract[number], (int)correction[number],course[number],groundspeed[number],(int)leghours[number],(int)legminutes[number],(int)rem_hours[number],
	  (int)rem_minutes[number],legfuel[number]);
	  fprintf(media,"\n");
	 }
	if( ((int)legminutes[number] < 10) && ((int)rem_minutes[number] < 10)
	&& (legfuel[number] < 10 ) ) {
	fprintf(media,"%s %3d %3d %3d %3d %3d  %c%2d %3d %3d %2.d:0%d %2.d:0%d  %3.1f", segment[number].name, segment[number].distc,
	  rem_distc[number], segment[number].magnetic_crs,segment[number].wind_dir, segment[number].wind_spd,
	  add_or_subtract[number], (int)correction[number],course[number],groundspeed[number],(int)leghours[number],(int)legminutes[number],(int)rem_hours[number],
	  (int)rem_minutes[number],legfuel[number]);
	  fprintf(media,"\n");
	 }


	if( ((int)legminutes[number] >= 10) && ((int)rem_minutes[number] < 10)
	&& (legfuel[number] > 10 ) ) {
	fprintf(media,"%s %3d %3d %3d %3d %3d  %c%2d %3d %3d %2.d:%2d %2.d:0%d %3.1f", segment[number].name, segment[number].distc,
	  rem_distc[number], segment[number].magnetic_crs,segment[number].wind_dir, segment[number].wind_spd,
	  add_or_subtract[number], (int)correction[number],course[number],groundspeed[number],(int)leghours[number],(int)legminutes[number],(int)rem_hours[number],
	  (int)rem_minutes[number],legfuel[number]);
	  fprintf(media,"\n");
	 }
	if( ((int)legminutes[number] >= 10) && ((int)rem_minutes[number] < 10)
	&& (legfuel[number] < 10 ) ) {
	fprintf(media,"%s %3d %3d %3d %3d %3d  %c%2d %3d %3d %2.d:%2d %2.d:0%d  %3.1f", segment[number].name, segment[number].distc,
	  rem_distc[number], segment[number].magnetic_crs,segment[number].wind_dir, segment[number].wind_spd,
	  add_or_subtract[number], (int)correction[number],course[number],groundspeed[number],(int)leghours[number],(int)legminutes[number],(int)rem_hours[number],
	  (int)rem_minutes[number],legfuel[number]);
	  fprintf(media,"\n");
	 }



	if( ((int)legminutes[number] >=10) && ((int)rem_minutes[number] >= 10)
	&& (legfuel[number] > 10 ) ) {
	fprintf(media,"%s %3d %3d %3d %3d %3d  %c%2d %3d %3d %2.d:%2d %2.d:%2.d %3.1f", segment[number].name, segment[number].distc,
	  rem_distc[number], segment[number].magnetic_crs,segment[number].wind_dir, segment[number].wind_spd,
	  add_or_subtract[number], (int)correction[number],course[number],groundspeed[number],(int)leghours[number],(int)legminutes[number],(int)rem_hours[number],
	  (int)rem_minutes[number],legfuel[number]);
	  fprintf(media,"\n");
	 }
	if( ((int)legminutes[number] >=10) && ((int)rem_minutes[number] >= 10)
	&& (legfuel[number] < 10 ) ) {
	fprintf(media,"%s %3d %3d %3d %3d %3d  %c%2d %3d %3d %2.d:%2d %2.d:%2.d  %3.1f", segment[number].name, segment[number].distc,
	  rem_distc[number], segment[number].magnetic_crs,segment[number].wind_dir, segment[number].wind_spd,
	  add_or_subtract[number], (int)correction[number],course[number],groundspeed[number],(int)leghours[number],(int)legminutes[number],(int)rem_hours[number],
	  (int)rem_minutes[number],legfuel[number]);
	  fprintf(media,"\n");
	 }
	} /* end of print loop */
	
	fprintf(media,"------------------------------------------------------------------------------\n");
	fprintf(media,"Totals    ->>%21d",totaldistance);
	fprintf(media,"%29.ld",grdspeedavg);
	fprintf(media,"%3.d",totalhours);
	if(totalminutes < 10) {
	fprintf(media,":0%d",(int)totalminutes);
	fprintf(media,"%11.1f\n",totalfuel);
	}
	else {
	fprintf(media,":%2.d",(int)totalminutes);
	fprintf(media,"%11.1f\n",totalfuel);
	}
	fprintf(media,"------------------------------------------------------------------------------\n");

	/* print these notifications if required */
	if(climbdefault)
	fprintf(media,"Default Climb Data Used!\n");
	if(d)
	fprintf(media,"Default Cruise Data Used!\n");

	fprintf(media,"                                   Frequencies:   Departure          Arrival\n");


	if(( AirportData.d_unicom > 0 ) && ( AirportData.a_atis == 0 ))
	fprintf(media,"Atmospheric Conditions                           Unic %.3f        ATIS %.3f\n",AirportData.d_unicom, AirportData.a_atis);
	if(( AirportData.d_unicom == 0 ) && ( AirportData.a_atis > 0 ))
	fprintf(media,"Atmospheric Conditions                             Unic %.3f      ATIS %.3f\n",AirportData.d_unicom, AirportData.a_atis);
	if(( AirportData.d_unicom == 0 ) && ( AirportData.a_atis == 0 ))
	fprintf(media,"Atmospheric Conditions                             Unic %.3f        ATIS %.3f\n",AirportData.d_unicom, AirportData.a_atis);
	if(( AirportData.d_unicom > 0 ) && ( AirportData.a_atis > 0 ))
	fprintf(media,"Atmospheric Conditions                           Unic %.3f      ATIS %.3f\n",AirportData.d_unicom, AirportData.a_atis);

	if(( AirportData.d_atis > 0 ) && ( AirportData.arrivalcnt == 0 ))
	fprintf(media,"Standard Temperature (c):Takeoff   %6d        ATIS %.3f         App %.3f\n",takeoff_stand_temp, AirportData.d_atis, AirportData.arrivalcnt);
	if(( AirportData.d_atis == 0 ) && ( AirportData.arrivalcnt > 0 ))
	fprintf(media,"Standard Temperature (c):Takeoff   %6d          ATIS %.3f       App %.3f\n",takeoff_stand_temp, AirportData.d_atis, AirportData.arrivalcnt);
	if(( AirportData.d_atis == 0 ) && ( AirportData.arrivalcnt == 0 ))
	fprintf(media,"Standard Temperature (c):Takeoff   %6d          ATIS %.3f         App %.3f\n",takeoff_stand_temp, AirportData.d_atis, AirportData.arrivalcnt);
	if(( AirportData.d_atis > 0 ) && ( AirportData.arrivalcnt > 0 ))
	fprintf(media,"Standard Temperature (c):Takeoff   %6d        ATIS %.3f       App %.3f\n",takeoff_stand_temp, AirportData.d_atis, AirportData.arrivalcnt);

	if(( AirportData.d_ground > 0 ) && ( AirportData.a_tower == 0 ))
	fprintf(media,"Degrees +/- Standard: Takeoff      %6d         Grd %.3f        CTAF %.3f\n",temp_difference_takeoff, AirportData.d_ground, AirportData.a_tower);
	if(( AirportData.d_ground == 0 ) && ( AirportData.a_tower > 0 ))
	fprintf(media,"Degrees +/- Standard: Takeoff      %6d           Grd %.3f      CTAF %.3f\n",temp_difference_takeoff, AirportData.d_ground, AirportData.a_tower);
	if(( AirportData.d_ground == 0 ) && ( AirportData.a_tower == 0 ))
	fprintf(media,"Degrees +/- Standard: Takeoff      %6d           Grd %.3f        CTAF %.3f\n",temp_difference_takeoff, AirportData.d_ground, AirportData.a_tower);
	if(( AirportData.d_ground > 0 ) && ( AirportData.a_tower > 0 ))
	fprintf(media,"Degrees +/- Standard: Takeoff      %6d         Grd %.3f      CTAF %.3f\n",temp_difference_takeoff, AirportData.d_ground, AirportData.a_tower);


	if(( AirportData.d_tower > 0 ) && ( AirportData.a_ground == 0 ))
	fprintf(media,"Density Altitude: Takeoff          %6d        CTAF %.3f         Grd %.3f\n",takeoff_density_alt, AirportData.d_tower, AirportData.a_ground);
	if(( AirportData.d_tower == 0 ) && ( AirportData.a_ground > 0 ))
	fprintf(media,"Density Altitude: Takeoff          %6d          CTAF %.3f       Grd %.3f\n",takeoff_density_alt, AirportData.d_tower, AirportData.a_ground);
	if(( AirportData.d_tower == 0 ) && ( AirportData.a_ground == 0 ))
	fprintf(media,"Density Altitude: Takeoff          %6d          CTAF %.3f         Grd %.3f\n",takeoff_density_alt, AirportData.d_tower, AirportData.a_ground);
	if(( AirportData.d_tower > 0 ) && ( AirportData.a_ground > 0 ))
	fprintf(media,"Density Altitude: Takeoff          %6d        CTAF %.3f       Grd %.3f\n",takeoff_density_alt, AirportData.d_tower, AirportData.a_ground);


	if(( AirportData.departcnt > 0 ) && ( AirportData.a_fss == 0 ))
	fprintf(media,"Standard Temperature (c):Cruise    %6d         Dep %.3f         Fss %.3f\n",cruise_stand_temp, AirportData.departcnt, AirportData.a_fss);
	if(( AirportData.departcnt == 0 ) && ( AirportData.a_fss > 0 ))
	fprintf(media,"Standard Temperature (c):Cruise    %6d           Dep %.3f       Fss %.3f\n",cruise_stand_temp, AirportData.departcnt, AirportData.a_fss);
	if(( AirportData.departcnt == 0 ) && ( AirportData.a_fss == 0 ))
	fprintf(media,"Standard Temperature (c):Cruise    %6d           Dep %.3f         Fss %.3f\n",cruise_stand_temp, AirportData.departcnt, AirportData.a_fss);
	if(( AirportData.departcnt > 0 ) && ( AirportData.a_fss > 0 ))
	fprintf(media,"Standard Temperature (c):Cruise    %6d         Dep %.3f       Fss %.3f\n",cruise_stand_temp, AirportData.departcnt, AirportData.a_fss);


	if(( AirportData.d_fss > 0 ) && ( AirportData.a_unicom == 0 ))
	fprintf(media,"Degrees +/- Standard: Cruise       %6d         Fss %.3f        Unic %.3f\n",temp_difference_cruise, AirportData.d_fss, AirportData.a_unicom);
	if(( AirportData.d_fss == 0 ) && ( AirportData.a_unicom > 0 ))
	fprintf(media,"Degrees +/- Standard: Cruise       %6d           Fss %.3f      Unic %.3f\n",temp_difference_cruise, AirportData.d_fss, AirportData.a_unicom);
	if(( AirportData.d_fss == 0 ) && ( AirportData.a_unicom == 0 ))
	fprintf(media,"Degrees +/- Standard: Cruise       %6d           Fss %.3f        Unic %.3f\n",temp_difference_cruise, AirportData.d_fss, AirportData.a_unicom);
	if(( AirportData.d_fss > 0 ) && ( AirportData.a_unicom > 0 ))
	fprintf(media,"Degrees +/- Standard: Cruise       %6d         Fss %.3f      Unic %.3f\n",temp_difference_cruise, AirportData.d_fss, AirportData.a_unicom);

	fprintf(media,"Density Altitude: Cruise           %6d        ------------------------------\n\n",cruise_density_alt);
	fprintf(media,"                                Clearance Delivery:             %3.2f\n",AirportData.d_clrcdeliv);
	fprintf(media,"                                Flight Service:                 1-800-992-7433\n");
	fprintf(media,"Performance Information                               Departure/Arrival ATIS\n");
	fprintf(media,"(Vy) Speed for departure           %6d\n",depart_cs);
	fprintf(media,"At Departure Rate Of Climb         %6d   Information _______  _______\n",depart_rc);
	fprintf(media,"Distance Required For Climb        %6.1f   WdWs _______ /_____  _____ /_____\n",climb_distance);
	fprintf(media,"(Vy) Speed at%6d feet           %6d   Visibility ________  ________\n",crz_alt, cruise_cs);
	fprintf(media,"At Cruise Rate of Climb            %6d   Clouds ____________  ____________\n",cruise_rc);
	fprintf(media,"Distance Required For Descent      %6.1f   TmpDp  _____ /_____  _____ /_____\n",descent_distance);
	fprintf(media,"Cruise Fuel Consumption            %6.1f   Altimeter ________    _______\n",cruise_fc);
	if (RATE_fuelcost !=0) fprintf(media,"\nNotes:   FUEL COST IS $%4.2f\n", Cost_fuel);
    if (RATE_wet != 0) fprintf(media,"         Rental cost WET is $%4.2f\n", Cost_wet);
    if (RATE_dry != 0) fprintf(media,"         Rental cost DRY is $%4.2f with fuel $%4.2f\n", Cost_dry, (Cost_dry + Cost_fuel));
	
	
	fprintf(media,"\f");
	fclose(media);
	return(VCSUCCESS);
	}

 	/* ****************************************************** */
	VCCOUNT CheckForFindTrip()
	{
	/* see if findtrip executable exists */
	VCCOUNT stat_ft;
	FILE *exist;
	if((exist = fopen("fileget.exe","rb")) != NULL) {
	  stat_ft = 0;
	  fclose(exist);
	 }
	else
	 stat_ft = -1;
	return stat_ft;
	}

	/* ********************************************************* */
	VCCOUNT NoFM()
	{
	VCWIN *n;
	calcounter = OFF;
	n = vcWinOpenX(8,10,14,70," Program \"FM_NEW.EXE\" missing! ",VCWF_SHADOW,
	0,0,vcBorderFromID(1),vcColorFromID(9));
	vcAtSay(0, 1,"             Could not Find: FM_NEW.EXE");
	vcAtSay(1, 1,"      ...This program and all supporting files");
	vcAtSay(2, 1,"      Must be in Flight Log Maker's Directory! Use the");
	vcAtSay(3, 1,"   \"System\" Push Button to make changes. Then type Exit.");
	vcAtSay(4, 1,"           Press any keyboard key to continue...");
	vcStatSay("                                    Error", vc.white|vc.bold|vc.blink|vc.blue*vc.bg);
	vcUpdateVIO();
	get_a_key();
	vcWinClose(n);
	return( VCSUCCESS );
	}

	/* ****************************************************** */
	VCCOUNT No_WB()
	{
	VCWIN *n;
	calcounter = OFF;
	n = vcWinOpenX(8,10,14,70," Program \"WB.EXE\" missing! ",VCWF_SHADOW,
	0,0,vcBorderFromID(1),vcColorFromID(9));
	vcAtSay(0, 1,"             Could not Find: WB.EXE");
	vcAtSay(1, 1,"      ...This program and all supporting files");
	vcAtSay(2, 1,"      Must be in Flight Log Maker's Directory! Use the");
	vcAtSay(3, 1,"   \"System\" Push Button to make changes. Then type Exit.");
	vcAtSay(4, 1,"           Press any keyboard key to continue...");
	vcStatSay("                                    Error", vc.white|vc.bold|vc.blink|vc.blue*vc.bg);
	vcUpdateVIO();
	get_a_key();
	vcWinClose(n);
	return( VCSUCCESS );
	}

	/* ****************************************************** */
	VCCOUNT CheckForFM()
	{
	/* see if findtrip executable exists */
	VCCOUNT stat;
	FILE *exist;
	if((exist = fopen("fm_new.exe","rb")) != NULL) {
	  stat = 0;
	  fclose(exist);
	 }
	else
	 stat = -1;
	return stat;
	}

	/* ********************************************************* */
	VCCOUNT CheckForWB()
	{
	/* see if wb executable exists */
	VCCOUNT stat;
	FILE *exist;
	if((exist = fopen("wb.exe","rb")) != NULL) {
	  stat = 0;
	  fclose(exist);
	 }
	else
	 stat = -1;
	return stat;
	}

VCCOUNT CheckForUseair()
 {
  /* see if wb executable exists */
  VCCOUNT stat;
  FILE *exist;
       if((exist = fopen("fileget.exe","rb")) != NULL ) {
	      stat = 0;
	      fclose(exist);
	     }
	    else
	     stat = -1;
   return stat;
  }

VCCOUNT No_Fileget()
     {
       VCWIN *n;
       
	 n = vcWinOpenX(8,5,16,65," Program \"FILEGET.EXE\" missing!  ",VCWF_SHADOW,
	    0,0,vcBorderFromID(1),vcColorFromID(9));
	 vcAtSay(1, 1,"Could not Find: FILEGET.EXE");
	 vcAtSay(2, 1,"This program and all supporting files");
	 vcAtSay(3, 1,"Must be in Flight Log Maker's Directory!");
	 vcAtSay(5, 1,"Press any keyboard key to continue...");
	 vcStatSay("                                    Error", vc.white|vc.bold|vc.blink|vc.blue*vc.bg);
	 vcUpdateVIO();
	 get_a_key();
	 vcWinClose(n);
       return( VCSUCCESS );
    }

	/* ********************************************************* */
	/* Gets a trip filename and places it in trip.pln */
	VCCOUNT pbSystem ()  {

	union REGS regs;
	struct SREGS s;
	VCCOUNT stat, stat_ft;
	VCTEXT *savebuf;
	VCTEXT *comspec;
	VCCOORD r,c;

    /* clear NAVIGATION page...this is a fix to 
     * prevent program from saying nothing calculated */
	ResetForm();
		
	/* See how much memory we need to save  */
	regs.x.ax = 21;
	int86( 0x33, &regs, &regs );
	savebuf = (VCVOID *)vcAlloc( 1, regs.x.bx );

	comspec = getenv("COMSPEC");

	if( savebuf != (VCTEXT *)0 && comspec != (VCTEXT *)0 )
	{
	/* save mouse state */
	regs.x.ax = 22;
	regs.x.dx = FP_OFF( savebuf );
	s.es = FP_SEG( savebuf );
	int86x( 0x33, &regs, &regs, &s );

	/* reset mouse for a polite exit */
	regs.x.ax = 33;
	int86( 0x33, &regs, &regs );
	vc_WinPut( vccrt->rw );
	vcUpdateVIO();
	vcAt( 0, 0 );

	/* check for program to list trip files */
	stat_ft=CheckForFindTrip();
	if(stat_ft == 0)           {
	vcUpdateVIO();
	vcAt( 0, 0 );
	
	system("fileget.exe ??????");  }
	if(stat_ft < 0)                   
	No_Fileget(); 

	/* insert code to read file and retrieve the selected NAV file */
	/* then update the NAV field */

	if((fp=fopen("Trip.pln","r+"))!=NULL) {
	fseek(fp,0 * sizeof(struct name),SEEK_SET);
	fread(&Path, sizeof(struct name),1,fp);
	fclose(fp);
	}
	/* restore mouse state */
	regs.x.ax = 23;
	regs.x.dx = FP_OFF( savebuf );
	s.es = FP_SEG( savebuf );
	int86x( 0x33, &regs, &regs, &s );
	vcFree( savebuf );

	/* restore original Vitamin C display */
	vc_WinPut( vccrt->rw );
	vc_WinPutBranch( vccrt->rw );

	r = wcurrent->r;                               // stolen from vcCurUpd
	c = wcurrent->c;
	if( vccrt->cursor.hidden ||                    // if hidden
	(wcurrent->hidecnt)   ||                   // or hidecount
	!(wcurrent->flags & VCWF_CURSOR)  ||       // or cursorless
	vcObsPoint(wcurrent, &r, &c) == -1 )       // or obscured
	{
	vccrt->cursor.cswitch = VCOFF;
	vccrt->cursor.ctrans  = 1;
	}
	else
	{
	vccrt->cursor.cswitch = VCON;
	vccrt->cursor.ctrans  = 1;
	}
	if( vccrt->cursor.cfunc )
	(*vccrt->cursor.cfunc)(vccrt, r, c);
	vcMouSetPos(22,20);  // prevents hovering over button - pushing button twice
	vcUpdateVIO();
	}
   else
	vcBell();	 
	
 return( VCSUCCESS );
}

	/* ************************************************** */
	VCCOUNT ManageFM()
	{
	union REGS regs;
	struct SREGS s;
	VCCOUNT stat;
	VCTEXT *savebuf;
	VCTEXT *comspec;
	VCCOORD r,c;

	/* See how much memory we need to save  */
	regs.x.ax = 21;
	int86( 0x33, &regs, &regs );
	savebuf = (VCVOID *)vcAlloc( 1, regs.x.bx );

	comspec = getenv("COMSPEC");

	if( savebuf != (VCTEXT *)0 && comspec != (VCTEXT *)0 )
	{
	/* save mouse state */
	regs.x.ax = 22;
	regs.x.dx = FP_OFF( savebuf );
	s.es = FP_SEG( savebuf );
	int86x( 0x33, &regs, &regs, &s );

	/* reset mouse for a polite exit */
	regs.x.ax = 33;
	int86( 0x33, &regs, &regs );
	vc_WinPut( vccrt->rw );
	vcUpdateVIO();
	vcAt( 0, 0 );
	
	/* check for program to list trip files */
	stat=CheckForFM();
	if(stat == 0)  {
	vcUpdateVIO();
	vcAt( 0, 0 );
	system("fm_new.exe");  }  
	if(stat < 0)                  
	NoFM();                    
 
	/* restore mouse state */
	regs.x.ax = 23;
	regs.x.dx = FP_OFF( savebuf );
	s.es = FP_SEG( savebuf );
	int86x( 0x33, &regs, &regs, &s );
	vcFree( savebuf );

	/* restore original Vitamin C display */
	vc_WinPut( vccrt->rw );
	vc_WinPutBranch( vccrt->rw );

	r = wcurrent->r;
	c = wcurrent->c;
	if( vccrt->cursor.hidden ||                    // if hidden
	(wcurrent->hidecnt)   ||                   // or hidecount
	!(wcurrent->flags & VCWF_CURSOR)  ||       // or cursorless
	vcObsPoint(wcurrent, &r, &c) == -1 )       // or obscured
	{
	vccrt->cursor.cswitch = VCOFF;
	vccrt->cursor.ctrans  = 1;
	}
	else
	{
	vccrt->cursor.cswitch = VCON;
	vccrt->cursor.ctrans  = 1;
	}
	if( vccrt->cursor.cfunc )
	(*vccrt->cursor.cfunc)(vccrt, r, c);
	vcMouSetPos(22,20);                   // prevents pushing button twice
	vcUpdateVIO();
	}
	else
	vcBell(); 
	return( VCSUCCESS );
	}

	/* ******************************************** */
	VCCOUNT ManageWB()
	{
	union REGS regs;
	struct SREGS s;
	VCCOUNT stat;
	VCTEXT *savebuf;
	VCTEXT *comspec;
	VCCOORD r,c;

	/* See how much memory we need to save  */
	regs.x.ax = 21;
	int86( 0x33, &regs, &regs );
	savebuf = (VCVOID *)vcAlloc( 1, regs.x.bx );

	comspec = getenv("COMSPEC");

	if( savebuf != (VCTEXT *)0 && comspec != (VCTEXT *)0 )
	{
	/* save mouse state */
	regs.x.ax = 22;
	regs.x.dx = FP_OFF( savebuf );
	s.es = FP_SEG( savebuf );
	int86x( 0x33, &regs, &regs, &s );

	/* reset mouse for a polite exit */
	regs.x.ax = 33;
	int86( 0x33, &regs, &regs );
	vc_WinPut( vccrt->rw );
	vcUpdateVIO();
	vcAt( 0, 0 );
	/********** */
	/* check for program to list trip files */
	stat=CheckForWB();
	if(stat == 0)             {
	vcUpdateVIO();
	vcAt( 0, 0 );
	system("wb.exe");  }  /* change to wb front page when created */
	if(stat < 0)                   /* this is only a test for now */
	No_WB();

	/* restore mouse state */
	regs.x.ax = 23;
	regs.x.dx = FP_OFF( savebuf );
	s.es = FP_SEG( savebuf );
	int86x( 0x33, &regs, &regs, &s );
	vcFree( savebuf );

	/* restore original Vitamin C display */
	vc_WinPut( vccrt->rw );
	vc_WinPutBranch( vccrt->rw );

	r = wcurrent->r;
	c = wcurrent->c;
	if( vccrt->cursor.hidden ||                    // if hidden
	(wcurrent->hidecnt)   ||                   // or hidecount
	!(wcurrent->flags & VCWF_CURSOR)  ||       // or cursorless
	vcObsPoint(wcurrent, &r, &c) == -1 )       // or obscured
	{
	vccrt->cursor.cswitch = VCOFF;
	vccrt->cursor.ctrans  = 1;
	}
	else
	{
	vccrt->cursor.cswitch = VCON;
	vccrt->cursor.ctrans  = 1;
	}
	if( vccrt->cursor.cfunc )
	(*vccrt->cursor.cfunc)(vccrt, r, c);
	vcMouSetPos(22,20);                   // prevents pushing button twice
	vcUpdateVIO();
	}
	else
	vcBell(); 
	return( VCSUCCESS );
	}

/* ********************************************************* */

VCCOUNT ManageAirFile()
{
  union REGS regs;
  struct SREGS s;
  VCCOUNT stat;
  VCTEXT *savebuf;
  VCTEXT *comspec;
  VCCOORD r,c;

  
/* See how much memory we need to save  */
  regs.x.ax = 21;
  int86( 0x33, &regs, &regs );
  savebuf = (VCVOID *)vcAlloc( 1, regs.x.bx );

  comspec = getenv("COMSPEC");

  if( savebuf != (VCTEXT *)0 && comspec != (VCTEXT *)0 )
    {
    /* save mouse state */
    regs.x.ax = 22;
    regs.x.dx = FP_OFF( savebuf );
    s.es = FP_SEG( savebuf );
    int86x( 0x33, &regs, &regs, &s );

    /* reset mouse for a polite exit */
    regs.x.ax = 33;
    int86( 0x33, &regs, &regs );
     vc_WinPut( vccrt->rw );
     vcUpdateVIO();
     vcAt( 0, 0 );
    /********** */
    /* check for program to list trip files */
    stat=CheckForUseair();
    if(stat == 0)     {
       vcUpdateVIO();
       vcAt( 0, 0 );
       system("fileget.exe ????????.air");  }  /* change to wb front page when created */
    if(stat < 0)
      No_Fileget();

    /* restore mouse state */
    regs.x.ax = 23;
    regs.x.dx = FP_OFF( savebuf );
    s.es = FP_SEG( savebuf );
    int86x( 0x33, &regs, &regs, &s );
    vcFree( savebuf );

    /* restore original Vitamin C display */
    vc_WinPut( vccrt->rw );
    vc_WinPutBranch( vccrt->rw );

  r = wcurrent->r;
  c = wcurrent->c;
  if( vccrt->cursor.hidden ||                    // if hidden
      (wcurrent->hidecnt)   ||                   // or hidecount
      !(wcurrent->flags & VCWF_CURSOR)  ||       // or cursorless
      vcObsPoint(wcurrent, &r, &c) == -1 )       // or obscured
    {
    vccrt->cursor.cswitch = VCOFF;
    vccrt->cursor.ctrans  = 1;
    }
  else
    {
    vccrt->cursor.cswitch = VCON;
    vccrt->cursor.ctrans  = 1;
    }
  if( vccrt->cursor.cfunc )
    (*vccrt->cursor.cfunc)(vccrt, r, c);
     vcMouSetPos(8,18);                   // prevents pushing button twice
     vcUpdateVIO();
    }
   else
	vcBell();   
 return( VCSUCCESS );
}
 

	/* ********************************************************* */
	VCCOUNT cont3(VCOBJ *obj)
	{
	VCCOUNT number,cont4();
    VCCOUNT SaveNavForm();

	if( (win=vcWinFromID(NAVWINID))!=NULL) {
	 calcounter=0;
	win=vcWinFromID( NAVWINID );
	vcSendMsg( VCSTARTFORM,( VCVOID * )win, 0l,0l,0l); }

	else {
	win = vcCreateWin(win,1,0,23,79," Navigational Data Page",
	 VCWF_CURSOR,0,0,vcBorderFromID(1),
	 vcColorFromID(4), NAVWINID, winfilter);
	vcPushBtnX(win,0,13,"  Next --> ", cont4,
	   OBJGROUP|VCPB_EXECUP,NULL,
	   "Push NEXT when finished with this entry page",
	   NULL, vcColorFromID(14));
	vcPushBtnX(win,0,1," <-- Back  ", SaveData,
	   OBJGROUP|VCPB_EXECUP,NULL,
	   "Go back to first page",
	   NULL, vcColorFromID(14));
	vcPushBtnX(win, 0, 25," Help  ", HelpWindow2,
	   OBJGROUP|VCPB_EXECUP,NULL,
	   "Help with this worksheet",
	   NULL, vcColorFromID(14));
	vcPushBtnX(win,0,33," Clear ", ClearWorkSheet,
	  OBJGROUP|VCPB_EXECUP,NULL,
	   "Clear this worksheet",
	   NULL, vcColorFromID(14));
	vcPushBtnX(win, 20, 3," Get Trip ",pbSystem,
	   OBJGROUP|VCPB_EXECUP,NULL,
	   "Load a previously saved trip",
	   NULL, vcColorFromID(14));
	vcPushBtnX(win, 20, 14," Load Trip ", GetTrip,
	   OBJGROUP|VCPB_EXECUP,NULL,
	   "Puts the data loaded onto this page - Use GET First!",
	   NULL, vcColorFromID(14));
	vcPushBtnX(win, 20, 26," Save Trip ",SaveTrip,
	   OBJGROUP|VCPB_EXECUP,NULL,
	   "Save this trip now",
	   NULL, vcColorFromID(14));


	vcLine(win,51,1,20,0,0,vcBorderFromID(1),0,0,
	   vc.cyan|vc.bold|vc.blue*vc.bg,VCOF_SYSDFLT);


	for(count = 0, number = 0; number <= 7; number++, count++)
	 {
	  obj1[number]=vcEntryFldX(win, number+3+count,1, &segment[number].name,
	   "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
	  OBJGROUP|VCEF_STRING|VCEF_FLDBLANK,NULL,
	   "define what makes this segment - use a new segment when winds change",
	  NULL,NULL);
	  obj2[number]=vcEntryFldX(win, number+3+count,33, &segment[number].magnetic_crs,"999",
	  OBJGROUP|VCEF_INT|VCEF_FLDBLANK,NULL,
	   "enter the magnetic course for this segment - use 360 for zero degrees",
	  NULL,NULL);
	  obj3[number]=vcEntryFldX(win, number+3+count,38, &segment[number].distc,"999",
	  OBJGROUP|VCEF_INT|VCEF_FLDBLANK,NULL,
	   "enter the milage for this segment - all data base information is nautical",
	  NULL,NULL);
	  obj4[number]=vcEntryFldX(win, number+3+count,43, &segment[number].wind_dir, "999",
	  OBJGROUP|VCEF_INT|VCEF_FLDBLANK,NULL,
	   "enter the direction wind is from",
	  NULL,NULL);
	  obj5[number]=vcEntryFldX(win, number+3+count,48, &segment[number].wind_spd, "99",
	  OBJGROUP|VCEF_INT|VCEF_FLDBLANK,NULL,
	   "enter the speed of the wind",
	  NULL,NULL);
	}


	/* input field for fuel on board */
	obj23=vcEntryFldX(win, number+3+count,45, &FuelOnBoard, "999.9",
	  OBJGROUP|VCEF_FLOAT|VCEF_FLDBLANK,NULL,
	   "enter the total usable fuel on board..this value will not be saved!",
	  NULL,NULL);
	vcAtSayX(number+3+count,8,"Input the",
	vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
	vcAtSayX(number+3+count,18,"Usable",
	vc.green|vc.bold|vc.blink+(vc.bg*vc.blue), VCOF_SYSDFLT);
	vcAtSayX(number+3+count,25,"fuel on board ---->",
	vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);

    /* Show the trip name field */
    vcAtSayX(0,48,"<----------- Trip Name",
	vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);

    obj22=vcEntryFldX(win, 0, 41, Tfilename,"XXXXXX",
	OBJGROUP|VCEF_STRING|VCEF_FLDBLANK,NULL,
	"Displays currently loaded trip - To create a new trip enter name here",
	NULL,NULL);

	vcAtSayX(1,33,"Mag         Wind",
	vc.white|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
	vcAtSayX(2,8,"Segment Name             Crs   NM  Dir  Spd",
	vc.white|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
	vcAtSayX(1,53,"Departure       Arrival",
	vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
	vcAtSayX(3,60,"Elevation",
	vc.white|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
	vcAtSayX(5,59,"Frequencies",
	vc.brown|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
	vcAtSayX(6,63,"ATIS",
	vc.white|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
	vcAtSayX(7,63,"AWOS",
	vc.white|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
	vcAtSayX(9,62,"Ground",
	vc.white|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
	vcAtSayX(11,62,"CTAF",
	vc.white|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
	vcAtSayX(13,61,"Dep/App",
	vc.white|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
	vcAtSayX(15,61,"Clrc Del",
	vc.white|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
	vcAtSayX(17,63,"FSS",
	vc.white|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
	vcAtSayX(19,62,"Unicom",
	vc.white|vc.bold+(vc.bg*vc.blue), VCOF_SYSDFLT);
	
	/* draw all the departure airport data objects */
	obj6=vcEntryFldX(win,3, 53, &AirportData.d_elevation, "99999",OBJGROUP|VCEF_INT|VCEF_FLDBLANK,NULL,
	" enter the departure airport elevation",NULL,NULL);
	obj8=vcEntryFldX(win,7, 53, &AirportData.d_atis, "999.999",OBJGROUP|VCEF_DOUBLE|VCEF_FLDBLANK,NULL,
	" enter the departure airport ATIS/AWOS frequency",NULL,NULL);
	obj12=vcEntryFldX(win,9, 53, &AirportData.d_ground, "999.999",OBJGROUP|VCEF_DOUBLE|VCEF_FLDBLANK,NULL,
	" enter the departure airport ground control",NULL,NULL);
	obj14=vcEntryFldX(win,11, 53, &AirportData.d_tower, "999.999",OBJGROUP|VCEF_DOUBLE|VCEF_FLDBLANK,NULL,
	" enter the departure airport CTAF/Tower frequency",NULL,NULL);
	obj16=vcEntryFldX(win,13, 53, &AirportData.departcnt, "999.999",OBJGROUP|VCEF_DOUBLE|VCEF_FLDBLANK,NULL,
	" enter the departure airport departure control frequency",NULL,NULL);
	obj10=vcEntryFldX(win,15, 53, &AirportData.d_clrcdeliv, "999.999",OBJGROUP|VCEF_DOUBLE|VCEF_FLDBLANK,NULL,
	" enter the departure airport clearance delivery frequency",NULL,NULL);
	obj18=vcEntryFldX(win,17, 53, &AirportData.d_fss, "999.999",OBJGROUP|VCEF_DOUBLE|VCEF_FLDBLANK,NULL,
	" enter the departure airport FSS frequency",NULL,NULL);
	obj20=vcEntryFldX(win,19, 53, &AirportData.d_unicom, "999.999",OBJGROUP|VCEF_DOUBLE|VCEF_FLDBLANK,NULL,
	" enter the departure airport unicom frequency",NULL,NULL);
	obj7=vcEntryFldX(win,3, 70, &AirportData.a_elevation, "99999", OBJGROUP|VCEF_INT|VCEF_FLDBLANK, NULL,
	" enter the arrival airport elevation",NULL,NULL);
	/* draw all the arrival airport data objects */
	obj9=vcEntryFldX(win,7, 70, &AirportData.a_atis, "999.999", OBJGROUP|VCEF_DOUBLE|VCEF_FLDBLANK, NULL,
	" enter the arrival airport ATIS",NULL,NULL);
	obj13=vcEntryFldX(win,9, 70, &AirportData.a_ground, "999.999", OBJGROUP|VCEF_DOUBLE|VCEF_FLDBLANK, NULL,
	" enter the arrival airport ground control",NULL,NULL);
	obj15=vcEntryFldX(win,11, 70, &AirportData.a_tower, "999.999", OBJGROUP|VCEF_DOUBLE|VCEF_FLDBLANK, NULL,
	" enter the arrival airport CTAF/Tower frequency",NULL,NULL);
	obj17=vcEntryFldX(win,13, 70, &AirportData.arrivalcnt, "999.999", OBJGROUP|VCEF_DOUBLE|VCEF_FLDBLANK, NULL,
	" enter the arrival airport approach control frequency",NULL,NULL);
	obj11=vcEntryFldX(win,15, 70, &AirportData.a_clrcdeliv, "999.999", OBJGROUP|VCEF_DOUBLE|VCEF_FLDBLANK, NULL,
	" enter the arrival airport clearance delivery frequency",NULL,NULL);
	obj19=vcEntryFldX(win,17, 70, &AirportData.a_fss, "999.999", OBJGROUP|VCEF_DOUBLE|VCEF_FLDBLANK, NULL,
	" enter the arrival airport FSS frequency",NULL,NULL);
	obj21=vcEntryFldX(win,19, 70, &AirportData.a_unicom, "999.999", OBJGROUP|VCEF_DOUBLE|VCEF_FLDBLANK, NULL,
	" enter the arrival airport unicom frequency",NULL,NULL);
	}
	vcMouSetPos(22,10);
	calcounter=0;
	vcStartForm(win,NULL);
	vcEndForm(obj->win);
	return( VCSUCCESS );
	}

	/* ****************************************************** */
	VCCOUNT cont4(VCOBJ *obj)    /* define screen 4 */
	{
	VCCOUNT SaveData(VCOBJ *obj), SaveLog();
	if( (win=vcWinFromID(OUTPUTWINID))!=NULL)
	{
	win=vcWinFromID( OUTPUTWINID );
	vcSendMsg( VCSTARTFORM,( VCVOID * )win, 0l,0l,0l);
	vcWinRefresh(win);
	}
	else {
	 win = vcCreateWin(win,1,0,23,79," Flight Log Results Page",
	 VCWF_VERTSB|VCWF_HORIZSB,50,90,vcBorderFromID(1),
	 vcColorFromID(1), OUTPUTWINID, winfilter);
	 vcMouSetCapture(win,0);
	 vcMouSetPos(2,28);
	 calculate_button=vcPushBtnX(win, 0, 25,"    CALC    ", Calc,
	   OBJGROUP|VCPB_EXECUP,NULL,"Calculate the flight log",
	   NULL, vcColorFromID(11));
	 newff3_button=vcPushBtnX(win, 0, 1," << New ", SaveData,
	   OBJGROUP|VCPB_EXECUP,NULL,"Start from beginning",
	   NULL, vcColorFromID(14));
	 navff3_button=vcPushBtnX(win, 0, 9," < Back ", cont3,
	   OBJGROUP|VCPB_EXECUP,NULL,"Go back to previous page",
	   NULL, vcColorFromID(14));
	 print_button=vcPushBtnX(win, 0, 17," Print ", PrintLog,
	   OBJGROUP|VCPB_EXECUP,NULL,"Print flight log",
	   NULL, vcColorFromID(14));
	 save_log_button=vcPushBtnX(win, 0, 38," Save Log ", SaveLog,
	   OBJGROUP|VCPB_EXECUP,NULL,
	   "Save this log to a text file",
	   NULL, vcColorFromID(14));
	 save_trip_button=vcPushBtnX(win, 0, 48," Save Nav ", SaveTrip,
	   OBJGROUP|VCPB_EXECUP,NULL,
	   "Saving allows you to use the navigation and frequency info again ",
	   NULL, vcColorFromID(14));
	  //wbff3_button=vcPushBtnX(win, 0, 58," Wt.& Bal ", ManageWB,
	  // OBJGROUP|VCPB_EXECUP,NULL,
	  // "Do weight and balance calculations",
	  // NULL, vcColorFromID(14));
	 
	 exit_last_window=vcPushBtnX(win, 0, 69,"  Quit  ",myEnd,
	   OBJGROUP|VCPB_EXECUP,
	   NULL,"Quit program",
	   NULL, vcColorFromID(14));
	 vcWinRefresh(win);
	}
	vcMouSetPos(2,28);
	vcStartForm(win,NULL);
	vcEndForm(obj->win);
	return( VCSUCCESS );
	}

/* -----------------added for new program------------------------ */
VCCOUNT ReadAircraftFile( VCOBJ *obj ) {
FILE *fp;
VCWIN *win;

/* declare some constants that cannot be changed */
const TRUE = 1, FALSE = 0;

/* this step saves all of the objects in the form before reading */
    vcSendMsg( VCENDFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
	
	/* see if the filename exists, then open it if it does */
	/* use r+b for reading and writing rb for read only */
	if ((fp = fopen(AircraftInfo.ac_info_filename,"r+b")) != NULL)
	  {
	   fseek(fp, record_length, SEEK_SET);
	   fread(&AircraftInfo, sizeof(struct AircraftStructure),1,fp);
	   fclose(fp); }
	   else { not_found();  Clear_airStructfile();
	   	   
	   vcSendMsg( VCSTARTFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
	    
	    vcUpdateVIO(); /* just added */
	    return(VCSUCCESS); }

/* print the message */
    vcAtSayX(10,28, "                                        ",
	  vc.brown|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);
    vcAtSayX(10,28, "Loaded:",
	  vc.brown|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);
    vcAtSayX(10,36, AircraftInfo.name,
	  vc.brown|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);
    if(AircraftInfo.is_complex == TRUE) vcAtSayX(20,9, "This aircraft is complex.",
	  vc.brown|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);

    if(AircraftInfo.is_complex == FALSE) vcAtSayX(20,9, "This aircraft is regular.",
	  vc.brown|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);
   
    vcSendMsg( VCSTARTFORM,(VCVOID *)obj->win, 0L, 0L, 0L );
   return(VCSUCCESS);
  }

/* ****************************************************** */
VCCOUNT Clear_airStructfile()  {
 const FALSE = 0;
   *AircraftInfo.ac_info_filename = NULL;
   *AircraftInfo.name = NULL;
   *AircraftInfo.a_file = NULL;
   *AircraftInfo.b_file = NULL;
   *AircraftInfo.n_file = NULL;
   *AircraftInfo.d_file = NULL;
   *AircraftInfo.cgd_file = NULL;
   AircraftInfo.is_complex = FALSE; 
 return (VCSUCCESS);
}

/* error function: warns if file not found */
	VCCOUNT not_found()
	{
	VCWIN *e;
	VCWIN *win;
 	
	vcCurHide(vccrt);
	e = vcWinOpenX(7,10,13,70," Error with filename! ",
		 NULL,0,0,vcBorderFromID(5),
		 vcColorFromID(20));
	Clear_airStructfile();
	vcAtSay(1,15,"That file was not found.");
	vcAtSay(2,15,"Recheck the filename entered.");
	vcAtSay(3,15,"Aircraft Structure being cleared.");
	vcStatSay("Cannot find a file by the name used."
		 ,vc.brown|vc.bold|vc.blue*vc.bg);

	vcUpdateVIO();
	get_a_key();
	vcCurShow(vccrt);
	vcWinClose(e);
/* clear space in case previous message was here
 * because some messages take of different amounts of space */
    vcAtSayX(10,28, "No aircraft loaded yet                  ",
	  vc.brown|vc.blink|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);
    vcAtSayX(20,5, "                                 ",
	  vc.blue|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);

	return(VCSUCCESS);
	}

VCCOUNT UpdateAirInfoField()  {
    FILE *fp; /* temporary pointer to read ac tailnumber string from file */

 /* clear space in case previous message was here
  * because some messages take of different amounts of space */
    vcAtSayX(10,28, "No aircraft loaded yet                  ",
	  vc.brown|vc.bold|vc.blink|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);
    vcAtSayX(20,5, "                                        ",
	  vc.blue|vc.bold+(vc.bg*vc.blue),VCOF_SYSDFLT);

  ManageAirFile();

/* open a file to get the aircraft tail number string */
       if((fp=fopen("useplane","r"))!=NULL)  {
	 fseek(fp,0 * sizeof(struct info_name),SEEK_SET);
	 fread(&Info_Path,sizeof(struct info_name),1,fp);
	 fclose(fp); }
       strncpy(AircraftInfo.ac_info_filename, Info_Path.info_name, 13);
       AircraftInfo.ac_info_filename[13] = '\0';
       vcPutFldBuf(obj28, &AircraftInfo.ac_info_filename);
	  vcPostMsg(VCOBJDRAW, obj28,0L, 0L, 0L);
      vcUpdateVIO();

      return( VCSUCCESS );
     }

 VCCOUNT ManageCG()
{
  union REGS regs;
  struct SREGS s;
  VCCOUNT stat;
  VCTEXT *savebuf;
  VCTEXT *comspec;
  VCCOORD r,c;

  /* See how much memory we need to save  */
  regs.x.ax = 21;
  int86( 0x33, &regs, &regs );
  savebuf = (VCVOID *)vcAlloc( 1, regs.x.bx );

  comspec = getenv("COMSPEC");

  if( savebuf != (VCTEXT *)0 && comspec != (VCTEXT *)0 )
    {
    /* save mouse state */
    regs.x.ax = 22;
    regs.x.dx = FP_OFF( savebuf );
    s.es = FP_SEG( savebuf );
    int86x( 0x33, &regs, &regs, &s );

    /* reset mouse for a polite exit */
    regs.x.ax = 33;
    int86( 0x33, &regs, &regs );
     vc_WinPut( vccrt->rw );
     vcUpdateVIO();
     vcAt( 0, 0 );
    /********** */
    /* check for program to list trip files */
    stat=CheckForCGMAN();
    if(stat == 0)      {
       vcUpdateVIO();
       vcAt( 0, 0 );
       system("cgman.exe");  }  /* change to wb front page when created */
    if(stat < 0)                   /* this is only a test for now */
       No_CGMAN();

    /* restore mouse state */
    regs.x.ax = 23;
    regs.x.dx = FP_OFF( savebuf );
    s.es = FP_SEG( savebuf );
    int86x( 0x33, &regs, &regs, &s );
    vcFree( savebuf );

    /* restore original Vitamin C display */
    vc_WinPut( vccrt->rw );
    vc_WinPutBranch( vccrt->rw );

  r = wcurrent->r;
  c = wcurrent->c;
  if( vccrt->cursor.hidden ||                    // if hidden
      (wcurrent->hidecnt)   ||                   // or hidecount
      !(wcurrent->flags & VCWF_CURSOR)  ||       // or cursorless
      vcObsPoint(wcurrent, &r, &c) == -1 )       // or obscured
    {
    vccrt->cursor.cswitch = VCOFF;
    vccrt->cursor.ctrans  = 1;
    }
  else
    {
    vccrt->cursor.cswitch = VCON;
    vccrt->cursor.ctrans  = 1;
    }
  if( vccrt->cursor.cfunc )
    (*vccrt->cursor.cfunc)(vccrt, r, c);
     vcMouSetPos(16,35);                   // prevents pushing button twice
     vcUpdateVIO();
    }
   else
	vcBell();
  return( VCSUCCESS );
}

/* ********************************************************* */
VCCOUNT ManageNewAC()
{
  union REGS regs;
  struct SREGS s;
  VCCOUNT stat;
  VCTEXT *savebuf;
  VCTEXT *comspec;
  VCCOORD r,c;

  /* See how much memory we need to save  */
  regs.x.ax = 21;
  int86( 0x33, &regs, &regs );
  savebuf = (VCVOID *)vcAlloc( 1, regs.x.bx );

  comspec = getenv("COMSPEC");

  if( savebuf != (VCTEXT *)0 && comspec != (VCTEXT *)0 )
    {
    /* save mouse state */
    regs.x.ax = 22;
    regs.x.dx = FP_OFF( savebuf );
    s.es = FP_SEG( savebuf );
    int86x( 0x33, &regs, &regs, &s );

    /* reset mouse for a polite exit */
    regs.x.ax = 33;
    int86( 0x33, &regs, &regs );
     vc_WinPut( vccrt->rw );
     vcUpdateVIO();
     vcAt( 0, 0 );
    /********** */
    /* check for program */
    stat=CheckForNewAC();
    if(stat == 0)             {
       vcUpdateVIO();
       vcAt( 0, 0 );
       system("new_ac.exe");  }   
    if(stat < 0)                    
       No_NewAC();

    /* restore mouse state */
    regs.x.ax = 23;
    regs.x.dx = FP_OFF( savebuf );
    s.es = FP_SEG( savebuf );
    int86x( 0x33, &regs, &regs, &s );
    vcFree( savebuf );

    /* restore original Vitamin C display */
    vc_WinPut( vccrt->rw );
    vc_WinPutBranch( vccrt->rw );

  r = wcurrent->r;
  c = wcurrent->c;
  if( vccrt->cursor.hidden ||                    // if hidden
      (wcurrent->hidecnt)   ||                   // or hidecount
      !(wcurrent->flags & VCWF_CURSOR)  ||       // or cursorless
      vcObsPoint(wcurrent, &r, &c) == -1 )       // or obscured
    {
    vccrt->cursor.cswitch = VCOFF;
    vccrt->cursor.ctrans  = 1;
    }
  else
    {
    vccrt->cursor.cswitch = VCON;
    vccrt->cursor.ctrans  = 1;
    }
  if( vccrt->cursor.cfunc )
    (*vccrt->cursor.cfunc)(vccrt, r, c);
     vcMouSetPos(8,18);                   // prevents pushing button twice
     vcUpdateVIO();
    }
  else
	vcBell();
  return( VCSUCCESS );
}

VCCOUNT No_NewAC()
     {
       VCWIN *n;
       
	 n = vcWinOpenX(8,5,16,65," Program \"NEW_AC.EXE\" missing!  ",VCWF_SHADOW,
	    0,0,vcBorderFromID(1),vcColorFromID(9));
	 vcAtSay(1, 1,"Could not Find: NEW_AC.EXE");
	 vcAtSay(2, 1,"This program and all supporting files");
	 vcAtSay(3, 1,"Must be in Flight Log Maker's Directory!");
	 vcAtSay(5, 1,"Press any keyboard key to continue...");
	 vcStatSay("                                    Error", vc.white|vc.bold|vc.blink|vc.blue*vc.bg);
	 vcUpdateVIO();
	 get_a_key();
	 vcWinClose(n);
       return( VCSUCCESS );
    }
VCCOUNT CheckForNewAC()
 {
  /* see if wb executable exists */
  VCCOUNT stat;
  FILE *exist;
       if((exist = fopen("new_ac.exe","rb")) != NULL ) {
	      stat = 0;
	      fclose(exist);
	     }
	    else
	     stat = -1;
   return stat;
  }

VCCOUNT CheckForCGMAN()
 {
  /* see if wb executable exists */
  VCCOUNT stat;
  FILE *exist;
       if((exist = fopen("cgman.exe","rb")) != NULL ) {
	      stat = 0;
	      fclose(exist);
	     }
	    else
	     stat = -1;
   return stat;
  }

VCCOUNT No_CGMAN()
     {
       VCWIN *n;
       
	 n = vcWinOpenX(8,5,16,65," Program \"CGMAN.EXE\" missing!  ",VCWF_SHADOW,
	    0,0,vcBorderFromID(1),vcColorFromID(9));
	 vcAtSay(1, 1,"Could not Find: CGMAN.EXE");
	 vcAtSay(2, 1,"This program and all supporting files");
	 vcAtSay(3, 1,"Must be in Flight Log Maker's Directory!");
	 vcAtSay(5, 1,"Press any keyboard key to continue...");
	 vcStatSay("                                    Error", vc.white|vc.bold|vc.blink|vc.blue*vc.bg);
	 vcUpdateVIO();
	 get_a_key();
	 vcWinClose(n);
       return( VCSUCCESS );
    }

	/* -----------------------end of program--------------------------- */
